#!/bin/bash

. `dirname $0`/common.sh

cd $WDIR/src

$WDIR/scripts/monitor.sh &
MONPID=$!

DB=$1
MODE=$2
THREADS=10
ITER=`expr 31 \* 24 ` 
INTERVAL=`expr 60 \* 60`

if [ "$DB" != "griddb" ] && [ "$DB" != "mysql" ]; then 
	echo usage;
	exit
fi

if [ "$MODE" == "1" ]; then
	java MeterBenchmark/MeterBenchmark -db $DB -mode ingest -threads $THREADS -iterations $ITER -interval $INTERVAL -nowait
	java MeterBenchmark/MeterBenchmark -db $DB -mode extract
elif [ "$MODE" == "2" ]; then
	java MeterBenchmark/MeterBenchmark -db $DB -mode ingest -threads $THREADS -iterations $ITER -interval $INTERVAL
fi


kill -9 $MONPID
