package rdms;

import rdms.Extract;
import rdms.GridDBExtract;
import rdms.MySQLExtract;
import rdms.Ingest;
import rdms.GridDBIngest;
import rdms.MySQLIngest;
import rdms.Meter;
import rdms.MeterRead;

import java.sql.Connection;
import java.util.Date;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.RowSet;

public class RunnableThread implements Runnable {
	private Thread t;
	private String threadName;
	private Ingest ingest;
	private Extract extract;
	private boolean stopForTest = true;
	private int waitSeconds = 60;
	private int threadSeconds = waitSeconds * 1000;
	
	private int stopNum = 3;
	
	private GridStore server;
	private boolean isSet = false;
	
	private Connection serverSQL;
	private boolean isSet2 = false;
	
	int mins = 1;
	
	boolean hasMeter = false;
	boolean hasMeterRead = false;
	private Meter meter2;
	private MeterRead meterRead1;
	
	boolean isEnded = false;
	Date endTime;
	
	int option = 0;
	/*
	 * option
	 * 		2 -> gridDB
	 * 		1 -> mySQL
	 * 
	 */
	private Query<Meter> meterQuery;
	private RowSet<Meter> meterRows;
	private Collection<String,Meter> metersCol;
	public void setUp2(Collection<String,Meter> mcol, RowSet<Meter> mrows, Query<Meter> mquery) {
		this.metersCol = mcol;
		this.meterRows = mrows;
		this.meterQuery = mquery;
	}
	
	RunnableThread(String name, int option) { //option is for griddb or mysql. option = 1 for mysql, 2 for griddb. option1 = 1 for ingest, 2 for extract. option1 is for telling what to do. Typically good to stick with 1.
		threadName = name;
		System.out.println("Creating " + threadName);
		if(option == 2) {
			ingest = new GridDBIngest();
			extract = new GridDBExtract();
		} else if(option == 1) {
			ingest = new MySQLIngest();
			extract = new MySQLExtract();
		} 
	}
	public void setGridServer(GridStore s) {
		this.server = s;
		isSet = true;
	}
	public void setSQLServer(Connection s) {
		this.serverSQL = s;
		isSet2 = true;
	}
	public void setSeconds(int s) {waitSeconds = s;};
	public void setStopForTest(boolean b) {stopForTest = b;}
	public void setStopNum(int n) {stopNum = n;}
	public void run() {
		System.out.println("Running " + threadName + "-id-" + meter2.id);
		ingest.setOption(option);
		if(isSet) {
			ingest.connectToServer(server);
			ingest.setUp2(metersCol, meterRows, meterQuery);
		} else if(isSet2) {
			ingest.connectToServer(serverSQL);
		}
		ingest.setTimes(mins);
		ingest.setStopNum(stopNum);
		ingest.run();
		if(ingest.isEnded()) {
			isEnded = ingest.isEnded();
			endTime = ingest.getEndTime();
		}
		System.out.println("Thread " + threadName  + "-id-" + meter2.id + " exiting");
	}
	public Date getEndTime() {
		return endTime;
	}
	public boolean isEnded() {
		return isEnded;
	}
	
	public void setOption(int op) {
		option = op;
	}
	public int getOption() {
		return option;
	}
	public void setMins(int m) {
		mins = m;
	}
	private void setMeterN(Meter m) {
		meter2 = new Meter();
		meter2.address = m.address;
		meter2.city = m.city;
		meter2.contact_name = m.contact_name;
		meter2.description = m.description;
		meter2.email = m.description;
		meter2.last_reading = m.last_reading;
		meter2.latitude = m.latitude;
		meter2.longitude = m.longitude;
		meter2.id = m.id;
		meter2.phone_number = m.phone_number;
		meter2.state_province = m.state_province;
	}
	private void setMeterReadN(MeterRead mr) {
		meterRead1 = new MeterRead();
		meterRead1.all_time_usage = mr.all_time_usage;
		meterRead1.error_code_1 = mr.error_code_1;
		meterRead1.error_code_2 = mr.error_code_2;
		meterRead1.timestamp = mr.timestamp;
		meterRead1.usage_since_read = mr.usage_since_read;
		meterRead1.usage_this_day = mr.usage_this_day;
		meterRead1.usage_this_month = mr.usage_this_month;
		meterRead1.usage_this_week = mr.usage_this_week;
		meterRead1.usage_this_year = mr.usage_this_year;
	}
	public void setMeter(Meter m) {
		setMeterN(m);
		ingest.setMeter(meter2);
		hasMeter = true;
	}
	public void setMeterRead(MeterRead mr) {
		meterRead1 = mr;
		setMeterReadN(mr);
		ingest.setMeterRead(meterRead1);
		hasMeterRead = true;
	}
	public void start() {
		System.out.println("Starting " + threadName + "-id-" + meter2.id);
		if(t == null) {
			t = new Thread(this, threadName);
			t.start();
		}
	}
}