/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.IndexInfo;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.TimeSeriesProperties;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.RowMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ContainerInfo {
    private String name;
    private ContainerType type;
    private List<ColumnInfo> columnInfoList = Collections.emptyList();
    private List<Integer> rowKeyColumnList = Collections.emptyList();
    private List<IndexInfo> indexInfoList = Collections.emptyList();
    private TimeSeriesProperties timeSeriesProperties;
    private boolean columnOrderIgnorable;
    private List<TriggerInfo> triggerInfoList = Collections.emptyList();
    private String dataAffinity;

    public ContainerInfo(String name, ContainerType type, List<ColumnInfo> columnInfoList, boolean rowKeyAssigned) {
        GSErrorCode.checkNullParameter(columnInfoList, "columnInfoList", null);
        this.setName(name);
        this.setType(type);
        this.setColumnInfoList(columnInfoList);
        this.setRowKeyAssigned(rowKeyAssigned);
    }

    public ContainerInfo(String name, ContainerType type, List<ColumnInfo> columnInfoList, List<Integer> rowKeyColumnList) {
        GSErrorCode.checkNullParameter(columnInfoList, "columnInfoList", null);
        this.setName(name);
        this.setType(type);
        this.setColumnInfoList(columnInfoList);
        this.setRowKeyColumnList(rowKeyColumnList);
    }

    public ContainerInfo() {
    }

    public ContainerInfo(ContainerInfo containerInfo) {
        boolean sameClass;
        try {
            sameClass = containerInfo.getClass() == ContainerInfo.class;
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(containerInfo, "containerInfo", e);
        }
        if (sameClass) {
            this.name = containerInfo.name;
            this.type = containerInfo.type;
            this.columnInfoList = containerInfo.columnInfoList;
            this.indexInfoList = containerInfo.indexInfoList;
            this.rowKeyColumnList = containerInfo.rowKeyColumnList;
            this.setTimeSeriesProperties(containerInfo.timeSeriesProperties);
            this.columnOrderIgnorable = containerInfo.columnOrderIgnorable;
            this.triggerInfoList = containerInfo.triggerInfoList;
            this.dataAffinity = containerInfo.dataAffinity;
        } else {
            this.setName(containerInfo.getName());
            this.setType(containerInfo.getType());
            int columnCount = containerInfo.getColumnCount();
            if (columnCount > 0) {
                ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
                for (int i = 0; i < columnCount; ++i) {
                    columnInfoList.add(containerInfo.getColumnInfo(i));
                }
                this.setColumnInfoList(columnInfoList);
            }
            this.setRowKeyColumnList(this.getRowKeyColumnList());
            this.setIndexInfoList(containerInfo.getIndexInfoList());
            this.setTimeSeriesProperties(containerInfo.getTimeSeriesProperties());
            this.setTriggerInfoList(containerInfo.getTriggerInfoList());
            this.setDataAffinity(containerInfo.getDataAffinity());
        }
    }

    public String getName() {
        return this.name;
    }

    public ContainerType getType() {
        return this.type;
    }

    public int getColumnCount() {
        return this.columnInfoList.size();
    }

    public ColumnInfo getColumnInfo(int column) {
        try {
            return this.columnInfoList.get(column);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Column number out of range (column=" + column + ", reason=" + e.getMessage() + ")", e);
        }
    }

    public boolean isRowKeyAssigned() {
        int count = this.rowKeyColumnList.size();
        if (count > 0) {
            if (count > 1) {
                throw new IllegalStateException("This method cannot be used for composite row key");
            }
            return true;
        }
        return false;
    }

    public List<Integer> getRowKeyColumnList() {
        return this.rowKeyColumnList;
    }

    public boolean isColumnOrderIgnorable() {
        return this.columnOrderIgnorable;
    }

    public void setColumnOrderIgnorable(boolean ignorable) {
        this.columnOrderIgnorable = ignorable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(ContainerType type) {
        this.type = type;
    }

    public void setColumnInfoList(List<ColumnInfo> columnInfoList) {
        List destList;
        if (columnInfoList == null || columnInfoList.isEmpty()) {
            destList = Collections.emptyList();
        } else {
            destList = new ArrayList(columnInfoList.size());
            for (ColumnInfo columnInfo : columnInfoList) {
                GSErrorCode.checkNullParameter(columnInfo, "element of columnInfoList", null);
                destList.add(ColumnInfo.toImmutable(columnInfo));
            }
            destList = Collections.unmodifiableList(destList);
        }
        this.columnInfoList = destList;
    }

    public void setRowKeyAssigned(boolean assigned) {
        List<Integer> rowKeyColumnList = assigned ? Collections.singletonList(0) : Collections.emptyList();
        this.setRowKeyColumnList(rowKeyColumnList);
    }

    public void setRowKeyColumnList(List<Integer> rowKeyColumnList) {
        List<Object> dest = rowKeyColumnList == null || rowKeyColumnList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Integer>(rowKeyColumnList));
        if (dest.indexOf(null) >= 0) {
            GSErrorCode.checkNullParameter(null, "element of rowKeyColumnList", null);
        }
        this.rowKeyColumnList = dest;
    }

    public List<IndexInfo> getIndexInfoList() {
        return this.indexInfoList;
    }

    public void setIndexInfoList(List<IndexInfo> indexInfoList) {
        List destList;
        if (indexInfoList == null || indexInfoList.isEmpty()) {
            destList = Collections.emptyList();
        } else {
            destList = new ArrayList(indexInfoList.size());
            for (IndexInfo info : indexInfoList) {
                GSErrorCode.checkNullParameter(info, "element of indexInfoList", null);
                destList.add(IndexInfo.toImmutable(info));
            }
            destList = Collections.unmodifiableList(destList);
        }
        this.indexInfoList = destList;
    }

    public TimeSeriesProperties getTimeSeriesProperties() {
        return this.timeSeriesProperties;
    }

    public void setTimeSeriesProperties(TimeSeriesProperties props) {
        if (props == null) {
            this.timeSeriesProperties = null;
            return;
        }
        this.timeSeriesProperties = new TimeSeriesProperties(props);
    }

    @Deprecated
    public Set<IndexType> getIndexTypes(int column) {
        throw new Error("Not supported on any version except for V1.5 beta");
    }

    @Deprecated
    public void setIndexTypes(int column, Set<IndexType> indexTypes) {
        throw new Error("Not supported on any version except for V1.5 beta");
    }

    public List<TriggerInfo> getTriggerInfoList() {
        return this.triggerInfoList;
    }

    public void setTriggerInfoList(List<TriggerInfo> triggerInfoList) {
        List dest;
        if (triggerInfoList == null || triggerInfoList.isEmpty()) {
            dest = Collections.emptyList();
        } else {
            dest = new ArrayList(triggerInfoList.size());
            for (TriggerInfo info : triggerInfoList) {
                GSErrorCode.checkNullParameter(info, "element of triggerInfoList", null);
                dest.add(info);
            }
            dest = Collections.unmodifiableList(dest);
        }
        this.triggerInfoList = dest;
    }

    public String getDataAffinity() {
        return this.dataAffinity;
    }

    public void setDataAffinity(String dataAffinity) {
        if (dataAffinity != null) {
            try {
                RowMapper.checkSymbol(dataAffinity, "data affinity");
            }
            catch (GSException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.dataAffinity = dataAffinity;
    }
}

