/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.common.LoggingUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GridStoreLogger
extends LoggingUtils.BaseGridStoreLogger {
    private static int SUITABLE_LOGGER_MAJOR = 1;
    private static int SUITABLE_LOGGER_MINOR = 6;
    final Logger base;

    GridStoreLogger() {
        LoggerFactory.getLogger(GridStoreLogger.class);
        this.base = LoggerFactory.getLogger((String)this.getClass().getName().replace('$', '.'));
    }

    @Override
    public boolean isDebugEnabled() {
        return this.base.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.base.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.base.isWarnEnabled();
    }

    private static String fmt(String key) {
        return LoggingUtils.getFormatString(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkVersion(LoggingUtils.BaseGridStoreLogger logger) {
        BufferedReader reader = null;
        try {
            Pattern versionPattern = Pattern.compile("^Bundle-Version: (([0-9]+)\\.([0-9]+)\\.[0-9]+)");
            for (URL url : Collections.list(LoggerFactory.class.getClassLoader().getResources("META-INF/MANIFEST.MF"))) {
                String line;
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                boolean libraryFound = false;
                String version = null;
                boolean versionSuitable = false;
                while ((line = reader.readLine()) != null) {
                    if (line.equals("Bundle-SymbolicName: slf4j.api")) {
                        libraryFound = true;
                    } else {
                        Matcher matcher = versionPattern.matcher(line);
                        if (matcher.find()) {
                            version = matcher.group(1);
                            int major = Integer.parseInt(matcher.group(2));
                            int minor = Integer.parseInt(matcher.group(3));
                            if (major > SUITABLE_LOGGER_MAJOR || major == SUITABLE_LOGGER_MAJOR && minor >= SUITABLE_LOGGER_MINOR) {
                                versionSuitable = true;
                            }
                        }
                    }
                    if (!libraryFound || version == null) continue;
                }
                if (libraryFound && version != null && !versionSuitable) {
                    logger.warn("config.slf4jVersionNotSuitable", SUITABLE_LOGGER_MAJOR + "." + SUITABLE_LOGGER_MINOR + ".0", version);
                }
                reader.close();
                reader = null;
            }
        }
        catch (IOException e) {
            logger.warn("config.slf4jVersionCheckFailed", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class StatementExec
    extends GridStoreLogger {
        StatementExec() {
        }

        @Override
        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class StatementIO
    extends GridStoreLogger {
        StatementIO() {
        }

        @Override
        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Transaction
    extends GridStoreLogger {
        Transaction() {
        }

        @Override
        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Connection
    extends GridStoreLogger {
        Connection() {
        }

        @Override
        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Discovery
    extends GridStoreLogger {
        Discovery() {
        }

        @Override
        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Heartbeat
    extends GridStoreLogger {
        Heartbeat() {
        }

        @Override
        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }

    static class Config
    extends GridStoreLogger {
        Config() {
            GridStoreLogger.checkVersion(this);
        }

        @Override
        public void debug(String key, Object ... args) {
            this.base.debug(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void info(String key, Object ... args) {
            this.base.info(GridStoreLogger.fmt(key), args);
        }

        @Override
        public void warn(String key, Object ... args) {
            this.base.warn(GridStoreLogger.fmt(key), args);
        }
    }
}

