/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.common.GSErrorCode;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class TriggerInfo {
    private String name;
    private Type type;
    private URI uri;
    private Set<EventType> eventSet;
    private Set<String> columnNameSet;
    private String jmsDestinationType;
    private String jmsDestinationName;
    private String user;
    private String password;

    public TriggerInfo() {
        this.name = null;
        this.type = null;
        this.uri = null;
        this.eventSet = Collections.emptySet();
        this.columnNameSet = Collections.emptySet();
        this.jmsDestinationType = null;
        this.jmsDestinationName = null;
        this.user = null;
        this.password = null;
    }

    TriggerInfo(TriggerInfo info) {
        boolean sameClass;
        try {
            sameClass = info.getClass() == TriggerInfo.class;
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(info, "info", e);
        }
        if (sameClass) {
            this.name = info.name;
            this.type = info.type;
            this.uri = info.uri;
            this.eventSet = info.eventSet;
            this.columnNameSet = info.columnNameSet;
            this.jmsDestinationType = info.jmsDestinationType;
            this.jmsDestinationName = info.jmsDestinationName;
            this.user = info.user;
            this.password = info.password;
        } else {
            this.setName(this.getName());
            this.setType(this.getType());
            this.setURI(this.getURI());
            this.setTargetEvents(this.getTargetEvents());
            this.setTargetColumns(this.getTargetColumns());
            this.setJMSDestinationType(this.getJMSDestinationType());
            this.setJMSDestinationName(this.getJMSDestinationName());
            this.setUser(this.getUser());
            this.setPassword(this.getPassword());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public Set<EventType> getTargetEvents() {
        return this.eventSet;
    }

    public void setTargetEvents(Set<EventType> eventSet) {
        EnumSet<EventType> tmp = EnumSet.noneOf(EventType.class);
        tmp.addAll(eventSet);
        this.eventSet = Collections.unmodifiableSet(tmp);
    }

    public Set<String> getTargetColumns() {
        return this.columnNameSet;
    }

    public void setTargetColumns(Set<String> columnSet) {
        this.columnNameSet = Collections.unmodifiableSet(new HashSet<String>(columnSet));
    }

    public String getJMSDestinationType() {
        return this.jmsDestinationType;
    }

    public void setJMSDestinationType(String destinationType) {
        this.jmsDestinationType = destinationType;
    }

    public String getJMSDestinationName() {
        return this.jmsDestinationName;
    }

    public void setJMSDestinationName(String destinationName) {
        this.jmsDestinationName = destinationName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public String getJMSUser() {
        return this.getUser();
    }

    @Deprecated
    public void setJMSUser(String user) {
        this.setUser(user);
    }

    @Deprecated
    public String getJMSPassword() {
        return this.getPassword();
    }

    @Deprecated
    public void setJMSPassword(String password) {
        this.setPassword(password);
    }

    static TriggerInfo toImmutable(TriggerInfo base) {
        if (base instanceof Immutable) {
            return (Immutable)base;
        }
        return new Immutable(base);
    }

    private static class Immutable
    extends TriggerInfo {
        Immutable(TriggerInfo info) {
            super(info);
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setType(Type type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setURI(URI uri) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTargetEvents(Set<EventType> eventSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTargetColumns(Set<String> columnSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setJMSDestinationType(String destinationType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setJMSDestinationName(String destinationName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUser(String user) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPassword(String password) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setJMSUser(String user) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setJMSPassword(String password) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum EventType {
        PUT,
        DELETE;

    }

    public static enum Type {
        REST,
        JMS;

    }
}

