/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.UUID;

public class BasicBuffer {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final int HUGE_BUFFER_GROW_UNIT = 0x100000;
    private ByteBuffer base;

    private BasicBuffer(ByteBuffer base) {
        this.base = base;
    }

    public BasicBuffer(int initialSize) {
        this.base = ByteBuffer.allocate(initialSize);
        this.base.order(DEFAULT_BYTE_ORDER);
    }

    public ByteBuffer base() {
        return this.base;
    }

    public static BasicBuffer wrap(byte[] bytes) {
        return new BasicBuffer(BasicBuffer.wrapBase(bytes));
    }

    public static ByteBuffer wrapBase(byte[] bytes) {
        ByteBuffer base = ByteBuffer.wrap(bytes);
        base.order(DEFAULT_BYTE_ORDER);
        return base;
    }

    public void prepare(int size) {
        if (size <= this.base.remaining()) {
            return;
        }
        long requiredCapacity = (long)this.base.position() + (long)size;
        long newCapacity = Long.highestOneBit(requiredCapacity) << 1;
        if (newCapacity > Integer.MAX_VALUE) {
            if (requiredCapacity <= Integer.MAX_VALUE) {
                long unit = 0x100000L;
                newCapacity = Math.min(Integer.MAX_VALUE, (requiredCapacity + 0x100000L - 1L) / 0x100000L * 0x100000L);
            } else {
                throw new IllegalArgumentException("Too large size (size=" + size + ", requiredCapacity=" + requiredCapacity + ")");
            }
        }
        ByteBuffer newBuffer = ByteBuffer.allocate((int)newCapacity);
        newBuffer.order(this.base.order());
        this.base.flip();
        newBuffer.put(this.base);
        this.base = newBuffer;
    }

    public void putBoolean(boolean value) {
        this.prepare(1);
        this.base.put((byte)(value ? 1 : 0));
    }

    public void putBooleanPrepared(boolean value) {
        this.base.put((byte)(value ? 1 : 0));
    }

    public void put(byte value) {
        this.prepare(1);
        this.base.put(value);
    }

    public void putShort(short value) {
        this.prepare(2);
        this.base.putShort(value);
    }

    public void putInt(int value) {
        this.prepare(4);
        this.base.putInt(value);
    }

    public void putLong(long value) {
        this.prepare(8);
        this.base.putLong(value);
    }

    public void putFloat(float value) {
        this.prepare(4);
        this.base.putFloat(value);
    }

    public void putDouble(double value) {
        this.prepare(8);
        this.base.putDouble(value);
    }

    public void putChar(char value) {
        this.prepare(2);
        this.base.putChar(value);
    }

    public void putString(String value) {
        if (value.indexOf(0) >= 0) {
            throw BasicBuffer.errorNullCharacterRuntime();
        }
        byte[] buf = value.getBytes(DEFAULT_CHARSET);
        this.prepare(4 + buf.length);
        this.base.putInt(buf.length);
        this.base.put(buf);
    }

    public void putDate(Date value) {
        this.putLong(value.getTime());
    }

    public void putDatePrepared(Date value) {
        this.base.putLong(value.getTime());
    }

    public void putEnum(Enum<?> value) {
        this.prepare(4);
        this.base.putInt(value.ordinal());
    }

    public void putEnumPrepared(Enum<?> value) {
        this.base.putInt(value.ordinal());
    }

    public void putByteEnum(Enum<?> value) {
        this.prepare(1);
        this.base.put((byte)(value.ordinal() & 0xFF));
    }

    public void putByteEnumPrepared(Enum<?> value) {
        this.base.put((byte)(value.ordinal() & 0xFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putUUID(UUID uuid) {
        this.prepare(16);
        ByteOrder orgOrder = this.base.order();
        try {
            this.base.order(ByteOrder.BIG_ENDIAN);
            long mostSigBits = uuid.getMostSignificantBits();
            long leastSigBits = uuid.getLeastSignificantBits();
            this.base.putLong(mostSigBits);
            this.base.putLong(leastSigBits);
        }
        finally {
            this.base.order(orgOrder);
        }
    }

    public boolean getBoolean() {
        return this.base.get() != 0;
    }

    public String getString() {
        byte[] buf = new byte[this.base.getInt()];
        this.base().get(buf);
        return new String(buf, 0, buf.length, DEFAULT_CHARSET);
    }

    public Date getDate() {
        return new Date(this.base.getLong());
    }

    public <E extends Enum<E>> E getEnum(Class<E> type) {
        try {
            return (E)((Enum[])type.getEnumConstants())[this.base.getInt()];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e);
        }
    }

    public <E extends Enum<E>> E getByteEnum(Class<E> type) {
        try {
            return (E)((Enum[])type.getEnumConstants())[this.base.get() & 0xFF];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e);
        }
    }

    public <E extends Enum<E>> E getByteEnum(E[] enumConstants) {
        try {
            return enumConstants[this.base.get() & 0xFF];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID() {
        ByteOrder orgOrder = this.base.order();
        try {
            this.base.order(ByteOrder.BIG_ENDIAN);
            long mostSigBits = this.base.getLong();
            long leastSigBits = this.base.getLong();
            UUID uUID = new UUID(mostSigBits, leastSigBits);
            return uUID;
        }
        finally {
            this.base.order(orgOrder);
        }
    }

    public void clear() {
        this.base.clear();
    }

    public static IllegalArgumentException errorNullCharacterRuntime() {
        try {
            throw BasicBuffer.errorNullCharacter();
        }
        catch (GSException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static GSException errorNullCharacter() {
        return new GSException(145006, "Illegal '\\0' character found");
    }

    public static class BufferUtils {
        private BufferUtils() {
        }

        public static int getIntSize(ByteBuffer buf) throws GSException {
            int size = BufferUtils.getNonNegativeInt(buf);
            if (size > buf.remaining()) {
                throw BufferUtils.errorTooLargeSize(size, buf);
            }
            return size;
        }

        public static long getLongSize(ByteBuffer buf) throws GSException {
            long size = BufferUtils.getNonNegativeLong(buf);
            if (size > (long)buf.remaining()) {
                throw BufferUtils.errorTooLargeSize(size, buf);
            }
            return size;
        }

        public static int getNonNegativeInt(ByteBuffer buf) throws GSException {
            int value = buf.getInt();
            if (value < 0) {
                throw BufferUtils.errorNegativeValue(value);
            }
            return value;
        }

        public static long getNonNegativeLong(ByteBuffer buf) throws GSException {
            long value = buf.getLong();
            if (value < 0L) {
                throw BufferUtils.errorNegativeValue(value);
            }
            return value;
        }

        public static void skipForward(ByteBuffer buf, int size) throws GSException {
            buf.position(BufferUtils.getForwardPosition(buf, size));
        }

        public static int limitForward(ByteBuffer buf, int size) throws GSException {
            int orgLimit = buf.limit();
            buf.limit(BufferUtils.getForwardPosition(buf, size));
            return orgLimit;
        }

        public static void restoreLimit(ByteBuffer buf, int orgLimit) throws GSException {
            buf.position(buf.limit());
            buf.limit(orgLimit);
        }

        public static void restoreLimitExact(ByteBuffer buf, int orgLimit) throws GSException {
            if (buf.position() != buf.limit()) {
                throw BufferUtils.errorUnknownRemaining(buf);
            }
            buf.limit(orgLimit);
        }

        public static int getForwardPosition(ByteBuffer buf, int size) throws GSException {
            return buf.position() + BufferUtils.checkSize(buf, size);
        }

        public static int checkSize(ByteBuffer buf, int size) throws GSException {
            if (size < 0) {
                throw BufferUtils.errorNegativeValue(size);
            }
            if (size > buf.remaining()) {
                throw BufferUtils.errorTooLargeSize(size, buf);
            }
            return size;
        }

        public static GSException errorNegativeValue(long value) {
            return new GSConnectionException(145031, "Protocol error by negative value (value=" + value + ")");
        }

        public static GSException errorTooLargeSize(long size, ByteBuffer buf) {
            return new GSConnectionException(145031, "Protocol error by too large size value (size=" + size + ", remaining=" + buf.remaining() + ")");
        }

        public static GSException errorUnknownRemaining(ByteBuffer buf) {
            return new GSConnectionException(145031, "Protocol error by unknown remaining bytes (remaining=" + buf.remaining() + ")");
        }
    }
}

