/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.experimental;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.PartitionController;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerKeyPredicate;
import com.toshiba.mwcloud.gs.common.ContainerProperties;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.experimental.ContainerAttribute;
import com.toshiba.mwcloud.gs.experimental.ContainerCondition;
import com.toshiba.mwcloud.gs.experimental.DatabaseInfo;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.experimental.ExtendedContainerInfo;
import com.toshiba.mwcloud.gs.experimental.PrivilegeInfo;
import com.toshiba.mwcloud.gs.experimental.UserInfo;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class ExperimentalTool {
    private static final ContainerProperties.KeySet ALL_CONTAINER_PROP_KEYS;

    private ExperimentalTool() {
    }

    public static RowId getRowIdForUpdate(RowSet<?> rowSet) throws GSException {
        return new RowId(Experimentals.get(rowSet).getRowIdForUpdate());
    }

    public static <R> void updateRowById(Collection<?, R> container, RowId rowId, R rowObj) throws GSException {
        if (container != rowId.baseContainer) {
            throw new GSException("Unmatched container");
        }
        Experimentals.get(container).updateRowById(rowId.transactionId, rowId.baseId, rowObj);
    }

    public static void removeRowById(Collection<?, ?> container, RowId rowId) throws GSException {
        if (container != rowId.baseContainer) {
            throw new GSException("Unmatched container");
        }
        Experimentals.get(container).removeRowById(rowId.transactionId, rowId.baseId);
    }

    public static long getContainerCount(PartitionController partitionController, int partitionIndex, ContainerCondition cond) throws GSException {
        boolean internalMode = true;
        ContainerKeyPredicate pred = new ContainerKeyPredicate(cond);
        return Extensibles.get(partitionController).getContainerCount(partitionIndex, pred, true);
    }

    public static List<String> getContainerNames(PartitionController partitionController, int partitionIndex, ContainerCondition cond, long start, Long limit) throws GSException {
        boolean internalMode = true;
        ContainerKeyPredicate pred = new ContainerKeyPredicate(cond);
        return Extensibles.get(partitionController).getContainerNames(partitionIndex, start, limit, pred, true);
    }

    public static Container<Object, Row> putContainer(GridStore store, String name, ContainerInfo info, boolean modifiable) throws GSException {
        boolean internalMode = true;
        Extensibles.AsStore extStore = Extensibles.get(store);
        return extStore.putContainer(ExperimentalTool.parseContainerKey(name, extStore, true, true), RowMapper.BindingTool.createBindType(null, Row.class, Container.class), ExperimentalTool.toContainerProperties(info), modifiable, true);
    }

    public static void dropContainer(GridStore store, String name) throws GSException {
        boolean internalMode = true;
        Extensibles.AsStore extStore = Extensibles.get(store);
        extStore.dropContainer(ExperimentalTool.parseContainerKey(name, extStore, true, true), null, true);
    }

    public static Container<Object, Row> getContainer(GridStore store, String name) throws GSException {
        boolean internalMode = true;
        Extensibles.AsStore extStore = Extensibles.get(store);
        return extStore.getContainer(ExperimentalTool.parseContainerKey(name, extStore, true, false), RowMapper.BindingTool.createBindType(null, Row.class, Container.class), null, true);
    }

    public static ExtendedContainerInfo getExtendedContainerInfo(GridStore store, String name) throws GSException {
        boolean internalMode = true;
        Extensibles.AsStore extStore = Extensibles.get(store);
        ContainerProperties props = extStore.getContainerProperties(ExperimentalTool.parseContainerKey(name, extStore, true, false), ALL_CONTAINER_PROP_KEYS, null, true);
        return ExperimentalTool.toExtendedContainerInfo(props);
    }

    public static void putUser(GridStore store, String name, UserInfo info, boolean modifiable) throws GSException {
        Experimentals.get(store).putUser(name, info, modifiable, false);
    }

    public static void dropUser(GridStore store, String name) throws GSException {
        Experimentals.get(store).dropUser(name);
    }

    public static void putRole(GridStore store, String name) throws GSException {
        Experimentals.get(store).putUser(name, null, false, true);
    }

    public static void dropRole(GridStore store, String name) throws GSException {
        Experimentals.get(store).dropUser(name);
    }

    public static Map<String, UserInfo> getUsers(GridStore store) throws GSException {
        return Experimentals.get(store).getUsers();
    }

    public static UserInfo getCurrentUser(GridStore store) throws GSException {
        return Experimentals.get(store).getCurrentUser();
    }

    public static void putDatabase(GridStore store, String name, DatabaseInfo info, boolean modifiable) throws GSException {
        Experimentals.get(store).putDatabase(name, info, modifiable);
    }

    public static void dropDatabase(GridStore store, String name) throws GSException {
        Experimentals.get(store).dropDatabase(name);
    }

    public static Map<String, DatabaseInfo> getDatabases(GridStore store) throws GSException {
        return Experimentals.get(store).getDatabases();
    }

    public static DatabaseInfo getCurrentDatabase(GridStore store) throws GSException {
        return Experimentals.get(store).getCurrentDatabase();
    }

    public static void putPrivilege(GridStore store, String dbName, String userName, PrivilegeInfo info) throws GSException {
        Experimentals.get(store).putPrivilege(dbName, userName, info);
    }

    public static void dropPrivilege(GridStore store, String dbName, String userName, PrivilegeInfo info) throws GSException {
        Experimentals.get(store).dropPrivilege(dbName, userName, info);
    }

    private static ContainerProperties toContainerProperties(ContainerInfo info) {
        ContainerAttribute attribute;
        ContainerProperties props = new ContainerProperties();
        props.setInfo(info);
        if (info instanceof ExtendedContainerInfo && (attribute = ((ExtendedContainerInfo)info).getAttribute()) != null) {
            props.setAttribute(attribute.flag());
        }
        return props;
    }

    private static ExtendedContainerInfo toExtendedContainerInfo(ContainerProperties props) {
        ContainerInfo baseInfo = ContainerProperties.findInfo(props);
        if (baseInfo == null) {
            return null;
        }
        ExtendedContainerInfo info = new ExtendedContainerInfo(baseInfo);
        Integer attribute = props.getAttribute();
        if (attribute != null) {
            info.setAttribute(ContainerAttribute.getAttribute(attribute));
        }
        return info;
    }

    private static ContainerKeyConverter.ContainerKey parseContainerKey(String name, Extensibles.AsStore store, boolean internalMode, boolean forModification) throws GSException {
        return store.getContainerKeyConverter(internalMode, forModification).parse(name, false);
    }

    static {
        EnumSet<ContainerProperties.Key> set = EnumSet.allOf(ContainerProperties.Key.class);
        set.remove((Object)ContainerProperties.Key.INDEX_DETAIL);
        ALL_CONTAINER_PROP_KEYS = new ContainerProperties.KeySet(set, new Integer[0]);
    }

    public static class RowId {
        private final Container<?, ?> baseContainer;
        private final long transactionId;
        private final long baseId;

        public RowId(Container<?, ?> baseContainer, long transactionId, long baseId) {
            this.baseContainer = baseContainer;
            this.transactionId = transactionId;
            this.baseId = baseId;
        }

        RowId(Experimentals.RowId base) {
            this.baseContainer = base.baseContainer;
            this.transactionId = base.transactionId;
            this.baseId = base.baseId;
        }
    }
}

