/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.experimental;

import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.experimental.DatabaseInfo;
import com.toshiba.mwcloud.gs.experimental.PrivilegeInfo;
import com.toshiba.mwcloud.gs.experimental.UserInfo;
import java.util.Map;

public class Experimentals {
    private Experimentals() {
    }

    public static AsStore get(GridStore store) throws GSException {
        StoreProvider provider;
        try {
            provider = (StoreProvider)((Object)store);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
        return provider.getExperimentalStore();
    }

    public static <K, R> AsContainer<K, R> get(Container<K, R> container) {
        AsContainer extensible;
        try {
            extensible = (AsContainer)container;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
        return extensible;
    }

    public static <R> AsQuery<R> get(Query<R> query) {
        AsQuery extensible;
        try {
            extensible = (AsQuery)query;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
        return extensible;
    }

    public static <R> AsRowSet<R> get(RowSet<R> rowSet) {
        AsRowSet extensible;
        try {
            extensible = (AsRowSet)rowSet;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
        return extensible;
    }

    public static class RowId {
        final Container<?, ?> baseContainer;
        final long transactionId;
        final long baseId;

        public RowId(Container<?, ?> baseContainer, long transactionId, long baseId) {
            this.baseContainer = baseContainer;
            this.transactionId = transactionId;
            this.baseId = baseId;
        }
    }

    public static interface AsRowSet<R>
    extends RowSet<R> {
        public RowId getRowIdForUpdate() throws GSException;
    }

    public static interface AsQuery<R>
    extends Query<R> {
        public long getFetchLimit() throws GSException;
    }

    public static interface AsContainer<K, R>
    extends Container<K, R> {
        public void removeRowById(long var1, long var3) throws GSException;

        public void updateRowById(long var1, long var3, R var5) throws GSException;

        public RowSet<Row> getRowSet(Object[] var1, long var2) throws GSException;
    }

    public static interface AsStore {
        public void putUser(String var1, UserInfo var2, boolean var3, boolean var4) throws GSException;

        public void dropUser(String var1) throws GSException;

        public Map<String, UserInfo> getUsers() throws GSException;

        public UserInfo getCurrentUser() throws GSException;

        public void putDatabase(String var1, DatabaseInfo var2, boolean var3) throws GSException;

        public void dropDatabase(String var1) throws GSException;

        public Map<String, DatabaseInfo> getDatabases() throws GSException;

        public DatabaseInfo getCurrentDatabase() throws GSException;

        public void putPrivilege(String var1, String var2, PrivilegeInfo var3) throws GSException;

        public void dropPrivilege(String var1, String var2, PrivilegeInfo var3) throws GSException;
    }

    public static interface StoreProvider {
        public AsStore getExperimentalStore() throws GSException;
    }
}

