/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.partitioned;

import com.toshiba.mwcloud.gs.Aggregation;
import com.toshiba.mwcloud.gs.AggregationResult;
import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Geometry;
import com.toshiba.mwcloud.gs.GeometryOperator;
import com.toshiba.mwcloud.gs.IndexInfo;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.InterpolationMode;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.QueryOrder;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.TimeOperator;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerProperties;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.experimental.ContainerAttribute;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.partitioned.PartQuery;
import com.toshiba.mwcloud.gs.partitioned.PartStore;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import java.net.URL;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class PartContainer<K, R>
implements Container<K, R>,
Extensibles.AsContainer<K, R>,
Experimentals.AsContainer<K, R> {
    private PartStore store;
    private final ContainerKeyConverter.ContainerKey largeKey;
    private final long largeId;
    private PartStore.LargeInfo largeInfo;
    private final Class<R> rowType;
    private final Map<Long, Extensibles.AsContainer<K, R>> subMap;
    private List<Extensibles.AsContainer<K, R>> disabledSubList;

    protected PartContainer(PartStore store, ContainerKeyConverter.ContainerKey largeKey, PartStore.LargeInfo largeInfo, Container.BindType<K, R, ?> bindType) {
        this.store = store;
        this.largeKey = largeKey;
        this.largeId = largeInfo.containerId;
        this.largeInfo = largeInfo;
        this.rowType = bindType.getRowClass();
        this.subMap = new HashMap<Long, Extensibles.AsContainer<K, R>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean put(K key, R row) throws GSException {
        GSErrorCode.checkNullParameter(row, "row", null);
        SingleRowPartitioner<K, R> partitioner = this.createRowPartitioner();
        boolean succeeded = false;
        try {
            boolean ret;
            long subId = key == null ? partitioner.getSubId(row) : partitioner.getSubId(key, row);
            try {
                ret = this.getSub(subId, true).put(key, row);
            }
            catch (PartStore.ContainerExpirationException e) {
                boolean bl = false;
                this.disableCacheOnError(succeeded);
                return bl;
            }
            catch (GSException e) {
                if (!PartStore.isSubContainerExpirationError(e)) {
                    throw e;
                }
                boolean bl = false;
                this.disableCacheOnError(succeeded);
                return bl;
            }
            succeeded = true;
            boolean bl = ret;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.disableCacheOnError(succeeded);
        }
    }

    @Override
    public boolean put(R row) throws GSException {
        return this.put(null, row);
    }

    @Override
    public boolean put(java.util.Collection<R> rowCollection) throws GSException {
        GSErrorCode.checkNullParameter(rowCollection, "rowCollection", null);
        boolean succeeded = false;
        try {
            long subId;
            RowListPartitioner<R> partitioner = new RowListPartitioner<R>(this.createRowPartitioner());
            partitioner.add((PartStore.LargeInfo)null, rowCollection);
            boolean expired = false;
            while ((subId = partitioner.getNextId()) >= 0L) {
                List list = (List)partitioner.next();
                try {
                    this.getSub(subId, true).put(list);
                }
                catch (PartStore.ContainerExpirationException e) {
                    expired = true;
                }
                catch (GSException e) {
                    if (!PartStore.isSubContainerExpirationError(e)) {
                        throw e;
                    }
                    expired = true;
                }
            }
            succeeded = !expired;
        }
        catch (PartStore.ContainerPartitioningException e) {
            throw e.toGSException();
        }
        finally {
            this.disableCacheOnError(succeeded);
        }
        return false;
    }

    @Override
    public R get(K key) throws GSException {
        return this.get(key, false);
    }

    @Override
    public R get(K key, boolean forUpdate) throws GSException {
        if (forUpdate) {
            PartContainer.errorNotSupported();
        }
        GSErrorCode.checkNullParameter(key, "key", null);
        boolean succeeded = false;
        try {
            boolean expired = false;
            Object row = null;
            for (Long subId : this.subIdRangeByRowKey(key)) {
                Extensibles.AsContainer<K, R> sub;
                try {
                    sub = this.getSub(subId, false);
                }
                catch (PartStore.ContainerExpirationException e) {
                    expired = true;
                    continue;
                }
                if (sub == null) continue;
                try {
                    row = sub.get(key);
                }
                catch (GSException e) {
                    if (!PartStore.isSubContainerExpirationError(e)) {
                        throw e;
                    }
                    expired = true;
                    continue;
                }
                if (row == null) continue;
                break;
            }
            succeeded = !expired;
            Iterator<Long> iterator = row;
            return (R)iterator;
        }
        catch (PartStore.ContainerPartitioningException e) {
            throw e.toGSException();
        }
        finally {
            this.disableCacheOnError(succeeded);
        }
    }

    @Override
    public boolean remove(K key) throws GSException {
        GSErrorCode.checkNullParameter(key, "key", null);
        boolean succeeded = false;
        try {
            boolean expired = false;
            boolean ret = false;
            for (Long subId : this.subIdRangeByRowKey(key)) {
                Extensibles.AsContainer<K, R> sub;
                try {
                    sub = this.getSub(subId, false);
                }
                catch (PartStore.ContainerExpirationException e) {
                    expired = true;
                    continue;
                }
                if (sub == null) continue;
                try {
                    ret = sub.remove(key);
                }
                catch (GSException e) {
                    if (!PartStore.isSubContainerExpirationError(e)) {
                        throw e;
                    }
                    expired = true;
                    continue;
                }
                if (!ret) continue;
                break;
            }
            succeeded = !expired;
            boolean bl = ret;
            return bl;
        }
        catch (PartStore.ContainerPartitioningException e) {
            throw e.toGSException();
        }
        finally {
            this.disableCacheOnError(succeeded);
        }
    }

    @Override
    public Query<R> query(String tql) throws GSException {
        return this.query(tql, this.rowType);
    }

    @Override
    public <S> Extensibles.AsQuery<S> query(final String tql, final Class<S> rowType) throws GSException {
        GSErrorCode.checkNullParameter(tql, "tql", null);
        return new PartQuery(this, new SubQueryGenerator<S>(){

            @Override
            Extensibles.AsQuery<S> generate(long subId) throws GSException {
                Extensibles.AsContainer sub;
                try {
                    sub = PartContainer.this.getSub(subId, false);
                }
                catch (PartStore.ContainerExpirationException e) {
                    return null;
                }
                return sub == null ? null : sub.query(tql, rowType);
            }
        });
    }

    @Override
    public Blob createBlob() throws GSException {
        return this.getSubFixed().createBlob();
    }

    @Override
    public void commit() throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void abort() throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void setAutoCommit(boolean enabled) throws GSException {
        if (!enabled) {
            throw PartContainer.errorNotSupported();
        }
    }

    @Override
    public void createIndex(String columnName) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void createIndex(String columnName, IndexType type) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void createIndex(IndexInfo info) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void dropIndex(String columnName) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void dropIndex(String columnName, IndexType type) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void dropIndex(IndexInfo info) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void createEventNotification(URL url) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void dropEventNotification(URL url) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void createTrigger(TriggerInfo info) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void dropTrigger(String name) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws GSException {
        boolean succeeded = false;
        try {
            boolean expired = false;
            for (Long subId : this.getLargeInfo()) {
                Extensibles.AsContainer<K, R> sub;
                try {
                    sub = this.getSub(subId, false);
                }
                catch (PartStore.ContainerExpirationException e) {
                    expired = true;
                    continue;
                }
                if (sub == null) continue;
                try {
                    sub.flush();
                }
                catch (GSException e) {
                    if (!PartStore.isSubContainerExpirationError(e)) {
                        throw e;
                    }
                    expired = true;
                }
            }
            succeeded = !expired;
        }
        finally {
            this.disableCacheOnError(succeeded);
        }
    }

    @Override
    public void close() throws GSException {
        try {
            this.closeAllSub(false, false);
        }
        finally {
            this.store = null;
        }
    }

    @Override
    public ContainerType getType() throws GSException {
        if (this instanceof TimeSeries) {
            return ContainerType.TIME_SERIES;
        }
        return ContainerType.COLLECTION;
    }

    @Override
    public R createRow() throws GSException {
        return this.getSubFixed().createRow();
    }

    @Override
    public Container.BindType<K, R, ? extends Container<K, R>> getBindType() throws GSException {
        return this.getSubFixed().getBindType();
    }

    @Override
    public void updateRowById(long transactionId, long baseId, R rowObj) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void removeRowById(long transactionId, long baseId) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public RowSet<Row> getRowSet(Object[] position, long fetchLimit) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public Class<R> getRowType() {
        return this.rowType;
    }

    @Override
    public ContainerProperties getSchemaProperties() throws GSException {
        return this.getSubFixed().getSchemaProperties();
    }

    @Override
    public Object getRowValue(Object rowObj, int column) throws GSException {
        return this.getSubFixed().getRowValue(rowObj, column);
    }

    @Override
    public Object getRowKeyValue(Object keyObj, int keyColumn) throws GSException {
        return this.getSubFixed().getRowKeyValue(keyObj, keyColumn);
    }

    @Override
    public void createIndex(IndexInfo info, NodeConnection.OptionalRequestSource source) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void dropIndex(IndexInfo info, NodeConnection.OptionalRequestSource source) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public ContainerKeyConverter.ContainerKey getKey() {
        PartStore store = this.store;
        if (store == null || !store.isContainerMonitoring()) {
            return null;
        }
        return this.getLargeKey();
    }

    PartStore getStore() {
        return this.store;
    }

    ContainerKeyConverter.ContainerKey getLargeKey() {
        return this.largeKey;
    }

    PartStore.LargeInfo getLargeInfo() throws GSException {
        return this.getLargeInfo(false);
    }

    PartStore.LargeInfo getLargeInfo(boolean emptyAllowed) throws GSException {
        if (this.largeInfo == null || !this.largeInfo.isStable(emptyAllowed) || this.store.checkLargeInfoExpiration(this.largeInfo)) {
            ContainerKeyConverter keyConverter = this.store.getContainerKeyConverter(true, false);
            try {
                this.acceptLargeInfo(this.store.takeLargeInfo(this.largeKey, false, keyConverter));
            }
            catch (PartStore.ContainerPartitioningException e) {
                throw e.toGSException();
            }
            boolean unavailableOnly = true;
            this.closeAllSub(false, true);
        }
        return this.largeInfo;
    }

    private void acceptLargeInfo(PartStore.LargeInfo largeInfo) throws GSException {
        if (largeInfo.containerId != this.largeId) {
            throw new GSException(145003, "Partitioned container unexpectedly lost and another container with same name unexpectedly created (name=" + this.largeKey + ", expectedId=" + this.largeId + ", actualId=" + largeInfo.containerId + ")");
        }
        this.largeInfo = largeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllSub(boolean force, boolean unavailableOnly) throws GSException {
        if (unavailableOnly && this.largeInfo == null) {
            return;
        }
        boolean done = false;
        try {
            Iterator<Object> it = this.subMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Extensibles.AsContainer<K, R>> entry = it.next();
                Long subId = entry.getKey();
                Extensibles.AsContainer<K, R> sub = entry.getValue();
                if (sub == null || unavailableOnly && !this.largeInfo.isDisabled(subId)) continue;
                if (force) {
                    try {
                        this.disableOrCloseSub(sub, unavailableOnly);
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.disableOrCloseSub(sub, unavailableOnly);
                }
                it.remove();
            }
            if (!unavailableOnly && this.disabledSubList != null) {
                it = this.disabledSubList.iterator();
                while (it.hasNext()) {
                    Extensibles.AsContainer sub = (Extensibles.AsContainer)it.next();
                    if (force) {
                        try {
                            sub.close();
                        }
                        catch (Throwable throwable) {}
                    } else {
                        sub.close();
                    }
                    it.remove();
                }
            }
            done = true;
        }
        finally {
            if (!done && !force) {
                this.closeAllSub(true, unavailableOnly);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableOrCloseSub(Extensibles.AsContainer<K, R> sub, boolean disabling) throws GSException {
        boolean disabled = false;
        try {
            if (disabling) {
                if (this.disabledSubList == null) {
                    this.disabledSubList = new ArrayList<Extensibles.AsContainer<K, R>>();
                }
                this.disabledSubList.add(sub);
                disabled = true;
            }
        }
        finally {
            if (!disabled) {
                sub.close();
            }
        }
    }

    private void checkOpened() throws GSException {
        if (this.store == null) {
            throw new GSException(145038, "Already closed");
        }
    }

    void disableCache() throws GSException {
        this.disableCacheOnError(false);
    }

    private void disableCacheOnError(boolean succeeded) throws GSException {
        if (succeeded) {
            return;
        }
        try {
            ContainerKeyConverter.ContainerKey normalizedKey = this.largeKey.toCaseSensitive(false);
            this.store.removeLargeInfo(normalizedKey, this.largeInfo);
        }
        finally {
            this.largeInfo = null;
        }
    }

    private SingleRowPartitioner<K, R> createRowPartitioner() throws GSException {
        return new SingleRowPartitioner<K, R>(this.getLargeInfo(), this.getSubFixed());
    }

    private Extensibles.AsContainer<K, R> getSubFixed() throws GSException {
        try {
            return this.getSub(this.getLargeInfo(true).getFixedSubId(), true);
        }
        catch (PartStore.ContainerExpirationException e) {
            throw e.toGSException();
        }
    }

    private Extensibles.AsContainer<K, R> getSub(Long subId, boolean always) throws GSException, PartStore.ContainerExpirationException {
        Extensibles.AsContainer<K, R> sub = this.subMap.get(subId);
        if (sub == null) {
            this.checkOpened();
            boolean general = this.rowType == Row.class;
            PartStore.LargeInfo[] largeInfoRef = new PartStore.LargeInfo[]{this.getLargeInfo()};
            try {
                sub = this.store.getSubContainer(this.largeKey, largeInfoRef, subId, this.getBindType(), general, always, false);
            }
            catch (PartStore.ContainerPartitioningException e) {
                throw e.toGSException();
            }
            if (sub == null && subId.longValue() == largeInfoRef[0].getFixedSubId()) {
                throw new GSException(145003, "Partitioned container unexpectedly lost (name=" + this.largeKey + ")");
            }
            this.acceptLargeInfo(largeInfoRef[0]);
            this.setSub(subId, sub);
        }
        return sub;
    }

    void setSub(Long subId, Extensibles.AsContainer<K, R> sub) {
        this.subMap.put(subId, sub);
    }

    private Iterable<Long> subIdRangeByRowKey(K key) throws GSException, PartStore.ContainerPartitioningException {
        boolean decomposed;
        Object resolvedKey;
        int keyColumnCount = this.largeInfo.keyColumnMap.size();
        if (keyColumnCount > 1) {
            Object[] decomposedKey = new Object[keyColumnCount];
            for (int i = 0; i < decomposedKey.length; ++i) {
                decomposedKey[i] = this.getRowKeyValue(key, i);
            }
            resolvedKey = decomposedKey;
            decomposed = true;
        } else {
            resolvedKey = key;
            decomposed = false;
        }
        return this.getLargeInfo().subIdRangeByKey(resolvedKey, decomposed);
    }

    static GSException errorNotSupported() throws GSException {
        return new GSException(145003, "Not supported on partitioned container");
    }

    static abstract class SubQueryGenerator<S> {
        SubQueryGenerator() {
        }

        abstract Extensibles.AsQuery<S> generate(long var1) throws GSException;
    }

    private static class RowListPartitioner<R>
    extends PartStore.ListPartitioner<R> {
        private final SingleRowPartitioner<?, R> base;

        RowListPartitioner(SingleRowPartitioner<?, R> base) {
            this.base = base;
        }

        @Override
        protected long getSubId(PartStore.LargeInfo largeInfo, R elem) throws GSException {
            return this.base.getSubId(elem);
        }
    }

    private static class SingleRowPartitioner<K, R> {
        private final PartStore.LargeInfo largeInfo;
        private final Extensibles.AsContainer<K, R> subContainer;
        private final Object[] partitioningValues;

        SingleRowPartitioner(PartStore.LargeInfo largeInfo, Extensibles.AsContainer<K, R> subContainer) {
            this.largeInfo = largeInfo;
            this.subContainer = subContainer;
            this.partitioningValues = new Object[largeInfo.getPartitioningColumnCount()];
        }

        long getSubId(R rowObj) throws GSException {
            for (int i = 0; i < this.partitioningValues.length; ++i) {
                int column = this.largeInfo.getPartitioningColumn(i);
                this.partitioningValues[i] = this.getRowOrKeyField(null, rowObj, column);
            }
            try {
                return this.largeInfo.subIdFromValues(this.partitioningValues);
            }
            catch (PartStore.ContainerPartitioningException e) {
                throw e.toGSException();
            }
        }

        long getSubId(K key, R rowObj) throws GSException {
            for (int i = 0; i < this.partitioningValues.length; ++i) {
                int column = this.largeInfo.getPartitioningColumn(i);
                this.partitioningValues[i] = this.getRowOrKeyField(key, rowObj, column);
            }
            try {
                return this.largeInfo.subIdFromValues(this.partitioningValues);
            }
            catch (PartStore.ContainerPartitioningException e) {
                throw e.toGSException();
            }
        }

        private Object getRowOrKeyField(K keyObj, R rowObj, int column) throws GSException {
            Integer keyColumn;
            if (keyObj != null && (keyColumn = this.largeInfo.keyColumnMap.get(column)) != null) {
                return this.subContainer.getRowKeyValue(keyObj, keyColumn);
            }
            return this.subContainer.getRowValue(rowObj, column);
        }
    }

    public static class Attributes {
        public static final int LARGE = ContainerAttribute.LARGE.flag();
        public static final int SUB = ContainerAttribute.SUB.flag();

        private Attributes() {
        }
    }

    public static class PartTimeSeries<R>
    extends PartContainer<Date, R>
    implements TimeSeries<R> {
        protected PartTimeSeries(PartStore store, ContainerKeyConverter.ContainerKey largeKey, PartStore.LargeInfo largeInfo, Container.BindType<Date, R, ?> bindType) {
            super(store, largeKey, largeInfo, bindType);
        }

        @Override
        public boolean append(R row) throws GSException {
            throw PartTimeSeries.errorNotSupported();
        }

        @Override
        public R get(Date base, TimeOperator timeOp) throws GSException {
            throw PartTimeSeries.errorNotSupported();
        }

        @Override
        public R interpolate(Date base, String column) throws GSException {
            throw PartTimeSeries.errorNotSupported();
        }

        @Override
        public Query<R> query(Date start, Date end) throws GSException {
            throw PartTimeSeries.errorNotSupported();
        }

        @Override
        public Query<R> query(Date start, Date end, QueryOrder order) throws GSException {
            throw PartTimeSeries.errorNotSupported();
        }

        @Override
        public Query<R> query(Date start, Date end, Set<String> columnSet, InterpolationMode mode, int interval, TimeUnit intervalUnit) throws GSException {
            throw PartTimeSeries.errorNotSupported();
        }

        @Override
        public Query<R> query(Date start, Date end, Set<String> columnSet, int interval, TimeUnit intervalUnit) throws GSException {
            throw PartTimeSeries.errorNotSupported();
        }

        @Override
        public AggregationResult aggregate(Date start, Date end, String column, Aggregation aggregation) throws GSException {
            throw PartTimeSeries.errorNotSupported();
        }
    }

    public static class PartCollection<K, R>
    extends PartContainer<K, R>
    implements Collection<K, R> {
        public PartCollection(PartStore store, ContainerKeyConverter.ContainerKey largeKey, PartStore.LargeInfo largeInfo, Container.BindType<K, R, ?> bindType) {
            super(store, largeKey, largeInfo, bindType);
        }

        @Override
        public Query<R> query(String column, Geometry geometry, GeometryOperator geometryOp) throws GSException {
            throw PartCollection.errorNotSupported();
        }

        @Override
        public Query<R> query(String column, Geometry geometryIntersection, Geometry geometryDisjoint) throws GSException {
            throw PartCollection.errorNotSupported();
        }
    }
}

