/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.partitioned;

import com.toshiba.mwcloud.gs.FetchOption;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.partitioned.PartContainer;
import com.toshiba.mwcloud.gs.partitioned.PartRowSet;
import com.toshiba.mwcloud.gs.partitioned.PartStore;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import com.toshiba.mwcloud.gs.subnet.SubnetRowSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PartQuery<R>
implements Query<R>,
Extensibles.AsQuery<R>,
Experimentals.AsQuery<R> {
    static boolean distQueryOptionWithContainerKey = true;
    private final PartContainer<?, ?> container;
    private final PartContainer.SubQueryGenerator<R> generator;
    private final Extensibles.AsQuery<R> fixedSubQuery;
    private PartRowSet<R> lastRowSet;
    private boolean lastRowSetVisible;

    PartQuery(PartContainer<?, ?> container, PartContainer.SubQueryGenerator<R> generator) throws GSException {
        this.container = container;
        this.generator = generator;
        this.fixedSubQuery = generator.generate(container.getLargeInfo(true).getFixedSubId());
    }

    @Override
    public void setFetchOption(FetchOption option, Object value) throws GSException {
        GSErrorCode.checkNullParameter((Object)option, "option", null);
        switch (option) {
            case LIMIT: 
            case PARTIAL_EXECUTION: {
                break;
            }
            default: {
                throw new GSException(145003, "Not supported option on partitioned container (option=" + (Object)((Object)option) + ")");
            }
        }
        this.fixedSubQuery.setFetchOption(option, value);
    }

    @Override
    public RowSet<R> fetch() throws GSException {
        return this.fetch(false);
    }

    @Override
    public RowSet<R> fetch(boolean forUpdate) throws GSException {
        this.checkOpened();
        if (forUpdate) {
            throw new GSException(145003, "Not supported option on partitioned container (forUpdate=" + forUpdate + ")");
        }
        this.container.getStore().fetchAll(Collections.singletonList(this));
        this.lastRowSet.prepareFollowing();
        return this.lastRowSet;
    }

    @Override
    public void close() throws GSException {
        try {
            this.clearRowSet();
        }
        finally {
            this.fixedSubQuery.close();
        }
    }

    @Override
    public PartRowSet<R> getRowSet() throws GSException {
        this.checkOpened();
        if (!this.lastRowSetVisible) {
            return null;
        }
        this.lastRowSet.prepareFollowing();
        this.lastRowSetVisible = false;
        return this.lastRowSet;
    }

    @Override
    public long getFetchLimit() throws GSException {
        return Experimentals.get(this.fixedSubQuery).getFetchLimit();
    }

    @Override
    public void applyOptionsTo(Extensibles.AsQuery<?> dest) throws GSException {
        this.fixedSubQuery.applyOptionsTo(dest);
    }

    @Override
    public void setExtOption(int key, byte[] value, boolean followingInheritable) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void setAcceptableResultKeys(Set<Integer> keys) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void setContainerLostAcceptable(boolean acceptable) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public Extensibles.QueryInfo getInfo() {
        return this.fixedSubQuery.getInfo();
    }

    @Override
    public Query<R> getBaseQuery() {
        return this;
    }

    @Override
    public Extensibles.AsContainer<?, ?> getContainer() {
        return this.container;
    }

    void clearRowSet() throws GSException {
        PartRowSet<R> rowSet = this.lastRowSet;
        this.lastRowSet = null;
        this.lastRowSetVisible = false;
        if (rowSet == null) {
            return;
        }
        rowSet.close();
    }

    void replaceRowSet(PartRowSet<R> rowSet) {
        if (this.lastRowSet != null) {
            throw new IllegalStateException();
        }
        if (rowSet == null) {
            throw new NullPointerException();
        }
        this.lastRowSet = rowSet;
        this.lastRowSetVisible = false;
    }

    void setRowSetVisible() {
        this.lastRowSetVisible = true;
    }

    Extensibles.AsQuery<R> createSubQuery(long subId) throws GSException {
        this.checkOpened();
        Extensibles.AsQuery<R> subQuery = this.generator.generate(subId);
        if (subQuery == null) {
            return null;
        }
        this.fixedSubQuery.applyOptionsTo(subQuery);
        return subQuery;
    }

    PartRowSet<R> createEmptyRowSet() throws GSException {
        return new PartRowSet(this.container, this.getInfo());
    }

    static void setSubContainerVersion(Extensibles.AsQuery<?> query, long version) throws GSException {
        query.setExtOption(PartStore.ExtRequestOptionType.SUB_CONTAINER_VERSION.number(), PartStore.getSubContainerVersionFormatter(version).format(), false);
    }

    static void setSubContainerExpirable(Extensibles.AsQuery<?> query, final boolean expirable) throws GSException {
        query.setExtOption(PartStore.ExtRequestOptionType.SUB_CONTAINER_EXPIRABLE.number(), new NodeConnection.BytesRequestFormatter(){

            @Override
            public void format(BasicBuffer buf) throws GSException {
                buf.putBoolean(expirable);
            }
        }.format(), true);
    }

    static void setDistributed(Extensibles.AsQuery<?> query, Extensibles.AsStore store, boolean distributed, ContainerKeyConverter.ContainerKey largeContainerKey) throws GSException {
        query.setExtOption(PartStore.ExtRequestOptionType.DIST_QUERY.number(), SubnetQuery.getContainerKeyFormatter(distributed, store, largeContainerKey).format(), true);
    }

    static void setLargeInfo(Extensibles.AsQuery<?> query, final PartStore.LargeInfo largeInfo) throws GSException {
        query.setExtOption(PartStore.ExtRequestOptionType.LARGE_INFO.number(), new NodeConnection.BytesRequestFormatter(){

            @Override
            public void format(BasicBuffer buf) throws GSException {
                largeInfo.put(buf);
            }
        }.format(), false);
    }

    private void checkOpened() throws GSException {
        this.fixedSubQuery.getRowSet();
    }

    static class PartitionedMultiQueryContext
    implements Extensibles.MultiOperationContext<Integer, Query<?>, Query<?>> {
        final PartStore store;
        final List<? extends Query<?>> queryList;
        Map<Integer, PartQuery<?>> partitionedMap;
        boolean versionErrorOccurred;
        boolean allCacheDisabled;

        PartitionedMultiQueryContext(PartStore store, List<? extends Query<?>> queryList) {
            this.store = store;
            this.queryList = queryList;
        }

        @Override
        public void listTarget(Extensibles.MultiTargetConsumer<Integer, Query<?>> consumer) throws GSException {
            if (this.partitionedMap == null) {
                this.listTargetInitial(consumer);
            } else {
                this.listTargetUnresolved(consumer);
            }
        }

        @Override
        public boolean acceptException(GSException exception) throws GSException {
            if (PartStore.isSubContainerVersionError(exception) || PartStore.isSubContainerExpirationError(exception)) {
                this.versionErrorOccurred = true;
                return true;
            }
            return false;
        }

        @Override
        public void acceptCompletion(Integer key, Query<?> result) throws GSException {
        }

        @Override
        public boolean isRemaining() throws GSException {
            return this.partitionedMap == null || !this.partitionedMap.isEmpty();
        }

        private void listTargetInitial(Extensibles.MultiTargetConsumer<Integer, Query<?>> consumer) throws GSException {
            int count = this.queryList.size();
            for (int key = 0; key < count; ++key) {
                PartQuery advQuery;
                PartContainer container;
                Query<Object> baseQuery;
                Query<?> query = this.queryList.get(key);
                if (!(query instanceof PartQuery)) {
                    if (!(query instanceof Extensibles.AsQuery) || !((baseQuery = ((Extensibles.AsQuery)query).getBaseQuery()) instanceof PartQuery)) {
                        consumer.consume(key, query, null, null);
                        continue;
                    }
                } else {
                    baseQuery = query;
                }
                if ((container = (advQuery = (PartQuery)baseQuery).container).getStore() != this.store) {
                    throw new GSException(145002, "Derived GridStore instance not matched");
                }
                advQuery.clearRowSet();
                if (this.partitionedMap == null) {
                    this.partitionedMap = new HashMap();
                }
                this.partitionedMap.put(key, advQuery);
                long subId = container.getLargeInfo().getFeasibleSubId();
                PartitionedMultiQueryContext.consumeSub(consumer, key, advQuery, subId, true, true);
            }
            if (this.partitionedMap == null) {
                this.partitionedMap = Collections.emptyMap();
            }
        }

        private void listTargetUnresolved(Extensibles.MultiTargetConsumer<Integer, Query<?>> consumer) throws GSException {
            Iterator<Map.Entry<Integer, PartQuery<?>>> it = this.partitionedMap.entrySet().iterator();
            while (it.hasNext()) {
                Iterable<Long> nextIdSet;
                boolean checking;
                Map.Entry<Integer, PartQuery<?>> entry = it.next();
                Integer key = entry.getKey();
                PartQuery<?> query = entry.getValue();
                PartRowSet rowSet = ((PartQuery)query).lastRowSet;
                if (this.versionErrorOccurred) {
                    rowSet.removeUncheckedSub();
                }
                HashSet<Long> subIdSet = new HashSet<Long>(rowSet.getSubIdList());
                if (rowSet.checkSubContainerLost() || this.versionErrorOccurred) {
                    PartitionedMultiQueryContext.disableCache(query, rowSet);
                    rowSet.clearSubContainerLost();
                    checking = false;
                } else {
                    checking = !this.allCacheDisabled;
                }
                SubnetRowSet.DistributedQueryTarget target = rowSet.getTarget(true);
                boolean consumed = false;
                boolean found = false;
                if (target == null || target.targetList == null) {
                    long subId;
                    PartStore.LargeInfo largeInfo = ((PartQuery)query).container.getLargeInfo();
                    if (target == null && !subIdSet.contains(subId = largeInfo.getFixedSubId())) {
                        found = true;
                        consumed |= PartitionedMultiQueryContext.consumeSub(consumer, key, query, subId, true, checking);
                    }
                    nextIdSet = consumed ? Collections.emptySet() : largeInfo;
                } else {
                    nextIdSet = target.targetList;
                }
                for (Long subId : nextIdSet) {
                    if (subIdSet.contains(subId) || rowSet.isProblemSubId(subId)) continue;
                    found = true;
                    consumed |= PartitionedMultiQueryContext.consumeSub(consumer, key, query, subId, false, checking);
                }
                if (consumed) continue;
                if (found && checking) {
                    PartitionedMultiQueryContext.disableCache(query, rowSet);
                    continue;
                }
                ((PartQuery)query).lastRowSetVisible = true;
                it.remove();
            }
            this.allCacheDisabled = this.versionErrorOccurred;
            this.versionErrorOccurred = false;
        }

        private static boolean consumeSub(Extensibles.MultiTargetConsumer<Integer, Query<?>> consumer, Integer key, PartQuery<?> query, long subId, boolean resolving, boolean checking) throws GSException {
            Extensibles.AsQuery<?> subQuery = PartitionedMultiQueryContext.createSub(query, subId, checking);
            if (subQuery == null) {
                return false;
            }
            subQuery.setAcceptableResultKeys(resolving ? PartRowSet.ExtResultOptionType.TARGETED_OPTIONS : PartRowSet.ExtResultOptionType.DEFAULT_OPTIONS);
            if (resolving) {
                PartQuery.setLargeInfo(subQuery, ((PartQuery)query).container.getLargeInfo());
            }
            consumer.consume(key, subQuery, null, null);
            return true;
        }

        private static <R> Extensibles.AsQuery<R> createSub(PartQuery<R> query, long subId, boolean checking) throws GSException {
            Extensibles.AsQuery<R> subQuery;
            PartRowSet<R> rowSet = ((PartQuery)query).lastRowSet;
            if (rowSet == null) {
                rowSet = query.createEmptyRowSet();
                query.replaceRowSet(rowSet);
            }
            if ((subQuery = query.createSubQuery(subId)) == null) {
                rowSet.addProblemSubId(subId);
                return null;
            }
            PartContainer container = ((PartQuery)query).container;
            PartQuery.setDistributed(subQuery, container.getStore(), true, container.getLargeKey());
            PartStore.LargeInfo largeInfo = container.getLargeInfo();
            if (largeInfo.isOrdered()) {
                SubnetRowSet.DistributedQueryTarget target = rowSet.getTarget(false);
                if (checking && (target == null || target.uncovered)) {
                    PartQuery.setSubContainerVersion(subQuery, largeInfo.partitioningVersion);
                }
                PartQuery.setSubContainerExpirable(subQuery, true);
                subQuery.setContainerLostAcceptable(true);
            }
            rowSet.addSub(subId, subQuery);
            return subQuery;
        }

        private static void disableCache(PartQuery<?> query, PartRowSet<?> rowSet) throws GSException {
            ((PartQuery)query).container.disableCache();
            rowSet.clearTarget();
        }
    }
}

