/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.partitioned;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.IndexInfo;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowKeyPredicate;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimeSeriesProperties;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerKeyPredicate;
import com.toshiba.mwcloud.gs.common.ContainerProperties;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.partitioned.FNV1a;
import com.toshiba.mwcloud.gs.partitioned.PartContainer;
import com.toshiba.mwcloud.gs.partitioned.PartPartitionController;
import com.toshiba.mwcloud.gs.partitioned.PartQuery;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.NodeResolver;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

class PartStore
implements GridStore,
Extensibles.AsStore,
Experimentals.StoreProvider {
    private static final int CONTAINER_PROP_KEY_LARGE_INFO = 16;
    private static final int CONTAINER_NOT_FOUND_ERROR_CODE = 10016;
    private static final int ATTRIBUTE_UNMATCH_ERROR_CODE = 10093;
    private static final int SUB_CONTAINER_EXPIRATION_ERROR_CODE = 60161;
    private static final int SUB_CONTAINER_VERSION_ERROR_CODE = 270004;
    static final boolean LARGE_INFO_EXIPIRABLE_DEFAULT = true;
    static final boolean WORKAROUND_WRONG_API_TEST = false;
    static final boolean WORKAROUND_NORMALIZE = true;
    private static final ContainerProperties.KeySet CONTAINER_PROP_KEYS_MIN = new ContainerProperties.KeySet(Collections.<ContainerProperties.Key>emptySet(), new Integer[0]);
    private static final ContainerProperties.KeySet CONTAINER_PROP_KEYS_FULL = new ContainerProperties.KeySet(EnumSet.allOf(ContainerProperties.Key.class), 16);
    private static final ContainerProperties.KeySet CONTAINER_PROP_KEYS_LARGE = new ContainerProperties.KeySet(EnumSet.of(ContainerProperties.Key.ID, ContainerProperties.Key.SCHEMA, ContainerProperties.Key.ATTRIBUTE), 16);
    private final Extensibles.AsStore base;
    private final Extensibles.AsPartitionController partitionController;
    private final Config config;
    private final LargeInfoCache largeInfoCache;

    PartStore(Extensibles.AsStore base, Properties props) throws GSException {
        this.base = base;
        this.partitionController = base.getPartitionController();
        this.config = new Config();
        this.config.set(new PropertyUtils.WrappedProperties(props));
        this.largeInfoCache = new LargeInfoCache(this.config.largeInfoCacheSize, this.config.largeInfoExpirationMillis);
    }

    @Override
    public boolean put(String pathKey, Object rowObject) throws GSException {
        return this.base.put(pathKey, rowObject);
    }

    @Override
    public Object get(String pathKey) throws GSException {
        return this.base.get(pathKey);
    }

    @Override
    public <R> R get(String pathKey, Class<R> rowType) throws GSException {
        return this.base.get(pathKey, rowType);
    }

    @Override
    public boolean remove(String pathKey) throws GSException {
        return this.base.remove(pathKey);
    }

    @Override
    public ContainerInfo getContainerInfo(String name) throws GSException {
        GSErrorCode.checkNullParameter(name, "name", null);
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(true, false);
        ContainerKeyConverter.ContainerKey key = keyConverter.parse(name, false);
        return ContainerProperties.findInfo(this.getContainerProperties(key, keyConverter, null));
    }

    @Override
    public <K, R> Collection<K, R> putCollection(String name, Class<R> rowType) throws GSException {
        return this.base.putCollection(name, rowType);
    }

    @Override
    public <K, R> Collection<K, R> putCollection(String name, Class<R> rowType, boolean modifiable) throws GSException {
        return this.base.putCollection(name, rowType, modifiable);
    }

    @Override
    public <R> TimeSeries<R> putTimeSeries(String name, Class<R> rowType) throws GSException {
        return this.base.putTimeSeries(name, rowType);
    }

    @Override
    public <R> TimeSeries<R> putTimeSeries(String name, Class<R> rowType, TimeSeriesProperties props, boolean modifiable) throws GSException {
        return this.base.putTimeSeries(name, rowType, props, modifiable);
    }

    @Override
    public <K, R> Collection<K, R> getCollection(String name, Class<R> rowType) throws GSException {
        return this.getPartitionedContainer(name, RowMapper.BindingTool.createCollectionBindType(null, rowType), false);
    }

    @Override
    public <R> TimeSeries<R> getTimeSeries(String name, Class<R> rowType) throws GSException {
        return this.getPartitionedContainer(name, RowMapper.BindingTool.createTimeSeriesBindType(rowType), false);
    }

    @Override
    public void dropCollection(String name) throws GSException {
        this.base.dropCollection(name);
    }

    @Override
    public void dropTimeSeries(String name) throws GSException {
        this.base.dropTimeSeries(name);
    }

    @Override
    public void close() throws GSException {
        this.base.close();
    }

    @Override
    public <K> Container<K, Row> putContainer(String name, ContainerInfo info, boolean modifiable) throws GSException {
        return this.base.putContainer(name, info, modifiable);
    }

    @Override
    public <K> Container<K, Row> getContainer(String name) throws GSException {
        return this.getPartitionedContainer(name, RowMapper.BindingTool.createBindType(null, Row.class, Container.class), true);
    }

    @Override
    public <K> Collection<K, Row> putCollection(String name, ContainerInfo info, boolean modifiable) throws GSException {
        return this.base.putCollection(name, info, modifiable);
    }

    @Override
    public <K> Collection<K, Row> getCollection(String name) throws GSException {
        return this.getPartitionedContainer(name, RowMapper.BindingTool.createCollectionBindType(null, Row.class), true);
    }

    @Override
    public TimeSeries<Row> putTimeSeries(String name, ContainerInfo info, boolean modifiable) throws GSException {
        return this.base.putTimeSeries(name, info, modifiable);
    }

    @Override
    public TimeSeries<Row> getTimeSeries(String name) throws GSException {
        return this.getPartitionedContainer(name, RowMapper.BindingTool.createTimeSeriesBindType(Row.class), true);
    }

    @Override
    public void dropContainer(String name) throws GSException {
        this.base.dropContainer(name);
    }

    @Override
    public <K, R, C extends Container<K, R>> C getContainer(String name, Container.BindType<K, R, C> bindType) throws GSException {
        boolean general = bindType.getRowClass() == Row.class;
        return this.getPartitionedContainer(name, bindType, general);
    }

    @Override
    public <K, R, C extends Container<K, R>> C putContainer(String name, Container.BindType<K, R, C> bindType) throws GSException {
        return this.base.putContainer(name, bindType);
    }

    @Override
    public <K, R, C extends Container<K, R>> C putContainer(String name, Container.BindType<K, R, C> bindType, ContainerInfo info, boolean modifiable) throws GSException {
        return this.base.putContainer(name, bindType, info, modifiable);
    }

    @Override
    public Row createRow(ContainerInfo info) throws GSException {
        return this.base.createRow(info);
    }

    @Override
    public Row.Key createRowKey(ContainerInfo info) throws GSException {
        return this.base.createRowKey(info);
    }

    @Override
    public void fetchAll(List<? extends Query<?>> queryList) throws GSException {
        this.base.fetchAll(new PartQuery.PartitionedMultiQueryContext(this, queryList));
    }

    @Override
    public void multiPut(Map<String, List<Row>> containerRowsMap) throws GSException {
        boolean succeeded = false;
        try {
            this.base.multiPut(new PartitionedMultiOperationContext<List<Row>, Void>(new RowPartitioner(), containerRowsMap), true);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.disableCache(containerRowsMap, new GeneralKeyConverter.ForString(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Row>> multiGet(Map<String, ? extends RowKeyPredicate<?>> containerPredicateMap) throws GSException {
        boolean succeeded = false;
        try {
            ListingMultiOperationContext multiContext = new ListingMultiOperationContext(new PredicatePartitioner(), containerPredicateMap);
            this.base.multiGet(multiContext, true);
            succeeded = true;
            Map<String, List<Row>> map = multiContext.getResultMap();
            return map;
        }
        finally {
            if (!succeeded) {
                this.disableCache(containerPredicateMap, new GeneralKeyConverter.ForString(), true);
            }
        }
    }

    @Override
    public PartPartitionController getPartitionController() throws GSException {
        return new PartPartitionController(this.base.getPartitionController());
    }

    @Override
    public void executeStatement(Statement.GeneralStatement statement, int partitionIndex, Extensibles.StatementHandler handler) throws GSException {
        this.base.executeStatement(statement, partitionIndex, handler);
    }

    @Override
    public long getDatabaseId() throws GSException {
        return this.base.getDatabaseId();
    }

    @Override
    public ContainerKeyConverter getContainerKeyConverter(boolean internalMode, boolean forModification) throws GSException {
        return this.base.getContainerKeyConverter(internalMode, forModification);
    }

    @Override
    public <K, R> Container<K, R> putContainer(String name, Class<R> rowType, ContainerInfo info, boolean modifiable) throws GSException {
        return this.base.putContainer(name, rowType, info, modifiable);
    }

    @Override
    public ContainerProperties getContainerProperties(ContainerKeyConverter.ContainerKey key, ContainerProperties.KeySet propKeySet, Integer attribute, boolean internalMode) throws GSException {
        return this.base.getContainerProperties(key, propKeySet, attribute, internalMode);
    }

    @Override
    public List<ContainerProperties> getAllContainerProperties(List<ContainerKeyConverter.ContainerKey> keyList, ContainerProperties.KeySet propKeySet, Integer attribute, boolean internalMode) throws GSException {
        return this.base.getAllContainerProperties(keyList, propKeySet, attribute, internalMode);
    }

    @Override
    public <K, R> Extensibles.AsContainer<K, R> getContainer(ContainerKeyConverter.ContainerKey key, Container.BindType<K, R, ?> bindType, Integer attribute, boolean internalMode) throws GSException {
        return this.base.getContainer(key, bindType, attribute, internalMode);
    }

    @Override
    public <K, R> Container<K, R> putContainer(ContainerKeyConverter.ContainerKey key, Container.BindType<K, R, ?> bindType, ContainerProperties props, boolean modifiable, boolean internalMode) throws GSException {
        return this.base.putContainer(key, bindType, props, modifiable, internalMode);
    }

    @Override
    public void dropContainer(ContainerKeyConverter.ContainerKey key, ContainerType containerType, boolean internalMode) throws GSException {
        this.base.dropContainer(key, containerType, internalMode);
    }

    @Override
    public void removeContainerCache(ContainerKeyConverter.ContainerKey key, boolean internalMode) throws GSException {
        this.base.removeContainerCache(key, internalMode);
    }

    @Override
    public void fetchAll(Extensibles.MultiOperationContext<Integer, Query<?>, Query<?>> multiContext) throws GSException {
        this.base.fetchAll(multiContext);
    }

    @Override
    public void multiPut(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, List<Row>, Void> multiContext, boolean internalMode) throws GSException {
        this.base.multiPut(multiContext, internalMode);
    }

    @Override
    public void multiGet(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, ? extends RowKeyPredicate<?>, List<Row>> multiContext, boolean internalMode) throws GSException {
        this.base.multiGet(multiContext, internalMode);
    }

    @Override
    public void setContainerMonitoring(boolean monitoring) {
        this.base.setContainerMonitoring(monitoring);
    }

    @Override
    public boolean isContainerMonitoring() {
        return this.base.isContainerMonitoring();
    }

    @Override
    public Experimentals.AsStore getExperimentalStore() throws GSException {
        return Experimentals.get(this.base);
    }

    private <K> void disableCache(Map<K, ?> map, GeneralKeyConverter<K> converter, boolean silent) throws GSException {
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(true, false);
        for (K key : map.keySet()) {
            try {
                this.removeLargeInfo(converter.convert(key, keyConverter), null);
            }
            catch (GSException e) {
                if (silent) continue;
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private <K, R, C extends Container<K, R>> C getPartitionedContainer(String name, Container.BindType<K, R, C> bindType, boolean general) throws GSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, R, C extends Container<K, R>> C getPartitionedContainerInternal(ContainerKeyConverter.ContainerKey key, Container.BindType<K, R, C> bindType, boolean general, LargeInfo largeInfo, Extensibles.AsContainer<K, R> fixedSubContainer) throws GSException, ContainerPartitioningException, ContainerExpirationException {
        LargeInfo[] largeInfoRef = new LargeInfo[]{largeInfo};
        long subId = largeInfo.getFixedSubId();
        Extensibles.AsContainer<K, R> localSubContainer = null;
        try {
            Extensibles.AsContainer<K, R> subContainer;
            if (fixedSubContainer == null) {
                localSubContainer = this.getSubContainer(key, largeInfoRef, subId, bindType, general, false, false);
                if (localSubContainer == null) {
                    C c = null;
                    return c;
                }
                subContainer = localSubContainer;
            } else {
                subContainer = fixedSubContainer;
            }
            PartContainer container = subContainer.getType() == ContainerType.TIME_SERIES ? PartStore.disguiseTypedContainer(new PartContainer.PartTimeSeries<R>(this, key, largeInfoRef[0], RowMapper.BindingTool.rebindKey(Date.class, bindType))) : new PartContainer.PartCollection<K, R>(this, key, largeInfoRef[0], bindType);
            container.setSub(subId, subContainer);
            localSubContainer = null;
            C c = bindType.castContainer(container);
            return c;
        }
        finally {
            if (localSubContainer != null) {
                localSubContainer.close();
            }
        }
    }

    <K, R, C extends Container<K, R>> C getSingleContainer(ContainerKeyConverter.ContainerKey key, Container.BindType<K, R, C> bindType) throws GSException {
        Integer attribute = SubnetGridStore.isAttributeVerifiable() ? Integer.valueOf(ContainerKeyPredicate.ATTRIBUTE_SINGLE) : null;
        boolean internalMode = SubnetGridStore.isAttributeVerifiable();
        return bindType.castContainer(this.base.getContainer(key, bindType, attribute, internalMode));
    }

    <K, R> Extensibles.AsContainer<K, R> getSubContainer(ContainerKeyConverter.ContainerKey largeKey, LargeInfo[] largeInfoRef, long subId, Container.BindType<K, R, ?> bindType, boolean general, boolean always, boolean checkOnly) throws GSException, ContainerPartitioningException, ContainerExpirationException {
        int attribute = PartContainer.Attributes.SUB;
        boolean internalMode = true;
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(true, false);
        ContainerKeyConverter.ContainerKey subKey = largeInfoRef[0].generateSubKey(largeKey, keyConverter, subId);
        boolean revovered = false;
        int trialCount = 0;
        while (true) {
            LargeInfo nextInfo;
            block8: {
                Extensibles.AsContainer<K, R> container;
                block6: {
                    block7: {
                        if (general && bindType.getRowClass() != Row.class) {
                            throw new IllegalArgumentException();
                        }
                        container = this.base.getContainer(subKey, bindType, attribute, true);
                        if (container != null || !always) break block6;
                        if (trialCount != 0 && (!PartStore.isPartitionedContainerRecoverable() || revovered)) break block7;
                        if (trialCount > 0) {
                            if (!checkOnly) {
                                this.recoverSubContainer(largeKey, subId, largeInfoRef[0].containerId);
                            }
                            revovered = true;
                        }
                        if ((nextInfo = this.createSubContainer(largeKey, subId, largeInfoRef[0], checkOnly)) != null) break block8;
                    }
                    throw new GSException(145032, "Partitioned container is not available (name=" + largeKey + ", subName=" + subKey + ")");
                }
                return container;
            }
            largeInfoRef[0] = nextInfo;
            ++trialCount;
        }
    }

    private LargeInfo createSubContainer(ContainerKeyConverter.ContainerKey largeKey, long subId, LargeInfo info, boolean checkOnly) throws GSException, ContainerPartitioningException, ContainerExpirationException {
        this.removeLargeInfo(largeKey.toCaseSensitive(false), info);
        boolean internalMode = true;
        ContainerKeyConverter keyConverter = this.base.getContainerKeyConverter(true, true);
        LargeInfo[] infoRef = new LargeInfo[1];
        ContainerProperties props = this.getContainerProperties(largeKey, keyConverter, infoRef);
        LargeInfo nextInfo = infoRef[0];
        if (nextInfo == null || !nextInfo.isLarge()) {
            throw new ContainerPartitioningException(145003, "Partitioned container unexpectedly lost (name=" + largeKey + ")", null);
        }
        props.getInfo().setName(null);
        props.setIdInfo(null);
        props.setAttribute(PartContainer.Attributes.SUB);
        props.setSchemaOptions(null);
        PartStore.setSubContainerExpiration(nextInfo, subId, props);
        long intervalSubId = info.subIdFromInterval(info.intervalFromSubId(subId), 0);
        SubOperationStatus status = new SubOperationStatus(SubOperation.CREATE_END, intervalSubId, info);
        status.accept(nextInfo);
        if (checkOnly) {
            return nextInfo.isAvailable(subId) ? nextInfo : null;
        }
        while (true) {
            if (nextInfo.isExpired(subId)) {
                throw new ContainerExpirationException(145000, "", null);
            }
            Long nextSubId = status.getNextSubId();
            if (nextSubId == null) break;
            SubOperation nextOp = status.getNextOperation();
            this.putSubOperationState(largeKey, nextSubId, nextOp, nextInfo.containerId);
            switch (nextOp) {
                case CREATE_BEGIN: {
                    this.operateSubContainerDefinition(largeKey, nextSubId, nextInfo, keyConverter, props, true);
                    break;
                }
                case DROP_BEGIN: {
                    this.operateSubContainerDefinition(largeKey, nextSubId, nextInfo, keyConverter, props, false);
                    break;
                }
                case INDEX_CREATE_BEGIN: {
                    this.operateSubContainerIndex(largeKey, nextInfo, keyConverter, true);
                    break;
                }
                case INDEX_DROP_BEGIN: {
                    this.operateSubContainerIndex(largeKey, nextInfo, keyConverter, false);
                    break;
                }
            }
            this.removeLargeInfo(largeKey.toCaseSensitive(false), null);
            nextInfo = this.takeLargeInfo(largeKey, false, keyConverter);
            status.accept(nextInfo);
        }
        return nextInfo;
    }

    private void operateSubContainerDefinition(ContainerKeyConverter.ContainerKey largeKey, long subId, LargeInfo info, ContainerKeyConverter keyConverter, ContainerProperties props, boolean forCreation) throws GSException {
        boolean internalMode = true;
        long interval = info.intervalFromSubId(subId);
        int unit = info.getPartitioningUnit();
        for (int i = 0; i < unit; ++i) {
            ContainerKeyConverter.ContainerKey subKey = info.generateSubKey(largeKey, keyConverter, info.subIdFromInterval(interval, i));
            if (forCreation) {
                this.putContainerAndProperties(subKey, props, true);
                continue;
            }
            this.base.dropContainer(subKey, null, true);
        }
        if (forCreation) {
            long version = info.partitioningVersion + 1L;
            for (int i = 0; i < 2; ++i) {
                long neighborId = info.findNeighborSub(true, i == 0, subId);
                if (neighborId < 0L) continue;
                ContainerKeyConverter.ContainerKey neighborKey = info.generateSubKey(largeKey, keyConverter, neighborId);
                this.putSubContainerVersion(neighborKey, version);
            }
        }
    }

    private void operateSubContainerIndex(ContainerKeyConverter.ContainerKey largeKey, LargeInfo info, ContainerKeyConverter keyConverter, boolean forCreation) throws GSException {
        boolean internalMode = true;
        long version = info.partitioningVersion + 1L;
        NodeConnection.OptionalRequest optionalRequest = new NodeConnection.OptionalRequest();
        optionalRequest.putExt(ExtRequestOptionType.SUB_CONTAINER_VERSION.number(), PartStore.getSubContainerVersionFormatter(version).format());
        for (Long subId : info) {
            ContainerKeyConverter.ContainerKey subKey = info.generateSubKey(largeKey, keyConverter, subId);
            this.putSubContainerVersion(subKey, version);
            Extensibles.AsContainer sub = this.base.getContainer(subKey, Container.BindType.of(null, Row.class), PartContainer.Attributes.SUB, true);
            if (forCreation) {
                sub.createIndex(info.operatingIndex, optionalRequest);
                continue;
            }
            sub.dropIndex(info.operatingIndex, optionalRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putContainerAndProperties(ContainerKeyConverter.ContainerKey key, ContainerProperties props, boolean internalMode) throws GSException {
        Container container = this.base.putContainer(key, RowMapper.BindingTool.createBindType(null, Row.class, Container.class), props, false, internalMode);
        try {
            for (IndexInfo indexInfo : props.getInfo().getIndexInfoList()) {
                container.createIndex(indexInfo);
            }
        }
        finally {
            container.close();
        }
    }

    static boolean isSubContainerExpirationError(GSException exception) {
        return exception.getErrorCode() == 60161;
    }

    static boolean isSubContainerVersionError(GSException exception) {
        return exception.getErrorCode() == 270004;
    }

    static NodeConnection.BytesRequestFormatter getSubContainerVersionFormatter(final long version) {
        return new NodeConnection.BytesRequestFormatter(){

            @Override
            public void format(BasicBuffer buf) throws GSException {
                buf.putLong(version);
            }
        };
    }

    static NodeConnection.OptionalRequestSource getSubContainerVersionOptionSource(long version) throws GSException {
        final byte[] optionValue = PartStore.getSubContainerVersionFormatter(version).format();
        return new NodeConnection.OptionalRequestSource(){

            @Override
            public void putOptions(NodeConnection.OptionalRequest optionalRequest) {
                optionalRequest.putExt(ExtRequestOptionType.SUB_CONTAINER_VERSION.number(), optionValue);
            }

            @Override
            public boolean hasOptions() {
                return true;
            }
        };
    }

    private void putSubContainerVersion(ContainerKeyConverter.ContainerKey key, long version) throws GSException {
        NodeConnection.BytesRequestFormatter formatter = PartStore.getSubContainerVersionFormatter(version);
        this.alternateContainer(key, AlternationType.PUT_SUB_CONTAINER_VERSION, formatter);
    }

    private static void setSubContainerExpiration(LargeInfo info, long subId, ContainerProperties props) throws GSException {
        if (!info.isExpirable()) {
            return;
        }
        long[] range = info.intervalValueRangeFromSubId(subId);
        long start = range[0];
        long interval = range[1] - range[0] + 1L;
        long duration = info.expirationTimeMillis;
        PartStore.setContainerSchemaOption(props, ContainerSchemaOptionType.PARTITION_EXPIRATION, PartStore.getSubContainerExpirationFormatter(start, interval, duration));
    }

    private static NodeConnection.BytesRequestFormatter getSubContainerExpirationFormatter(final long start, final long interval, final long duration) {
        return new NodeConnection.BytesRequestFormatter(){

            @Override
            public void format(BasicBuffer buf) throws GSException {
                buf.putLong(start);
                buf.putLong(interval);
                buf.putLong(duration);
            }
        };
    }

    private static void setContainerSchemaOption(ContainerProperties props, ContainerSchemaOptionType type, NodeConnection.BytesRequestFormatter formatter) throws GSException {
        Map<Integer, byte[]> options = props.getSchemaOptions();
        if (options == null) {
            options = new HashMap<Integer, byte[]>();
            props.setSchemaOptions(options);
        }
        options.put(type.number(), formatter.format());
    }

    private void putSubOperationState(ContainerKeyConverter.ContainerKey key, final long subId, final SubOperation state, final long largeContainerId) throws GSException {
        NodeConnection.RequestFormatter formatter = new NodeConnection.RequestFormatter(){

            @Override
            public void format(BasicBuffer buf) {
                if (PartStore.isPartitionedContainerRecoverable()) {
                    buf.putLong(largeContainerId);
                }
                buf.putLong(subId);
                buf.putByteEnum(state);
            }
        };
        this.alternateContainer(key, AlternationType.PUT_SUB_STATE, formatter);
    }

    private void recoverSubContainer(ContainerKeyConverter.ContainerKey key, final long subId, final long largeContainerId) throws GSException {
        NodeConnection.RequestFormatter formatter = new NodeConnection.RequestFormatter(){

            @Override
            public void format(BasicBuffer buf) {
                buf.putLong(largeContainerId);
                buf.putLong(subId);
            }
        };
        this.alternateContainer(key, AlternationType.RECOVER_SUB_CONTAINER, formatter);
    }

    private void alternateContainer(final ContainerKeyConverter.ContainerKey key, final AlternationType alternationType, final NodeConnection.RequestFormatter formatter) throws GSException {
        int partitionIndex = this.partitionController.getPartitionIndexOfContainer(key, true);
        Extensibles.StatementHandler handler = new Extensibles.StatementHandler(){

            @Override
            public void makeRequest(BasicBuffer buf) throws GSException {
                NodeConnection.tryPutEmptyOptionalRequest(buf);
                long databaseId = PartStore.this.base.getDatabaseId();
                PartStore.this.getContainerKeyConverter(true, true).put(key, databaseId, buf);
                buf.putByteEnum(alternationType);
                int headPos = buf.base().position();
                buf.putInt(0);
                int bodyPos = buf.base().position();
                formatter.format(buf);
                int endPos = buf.base().position();
                buf.base().position(headPos);
                buf.putInt(endPos - bodyPos);
                buf.base().position(endPos);
            }

            @Override
            public void acceptResponse(BasicBuffer buf) throws GSException {
            }
        };
        this.base.executeStatement(PartitionedStatement.ALTER_CONTAINER_PROPERTIES.generalize(), partitionIndex, handler);
    }

    private ContainerProperties getContainerProperties(ContainerKeyConverter.ContainerKey key, ContainerKeyConverter keyConverter, LargeInfo[] largeInfoRef) throws GSException {
        boolean withLargeInfo = PartStore.isLargePropKeyEnabled();
        boolean internalMode = true;
        ContainerProperties props = this.base.getContainerProperties(key, withLargeInfo ? CONTAINER_PROP_KEYS_FULL : null, null, true);
        LargeInfoBuilder largeInfoBuilder = this.createLargeInfoBuilder(key, props);
        if (largeInfoBuilder == null) {
            return null;
        }
        if (largeInfoBuilder.isLarge()) {
            ContainerProperties subProps = this.base.getContainerProperties(largeInfoBuilder.getFixedSubKey(keyConverter), CONTAINER_PROP_KEYS_FULL, null, true);
            if (!largeInfoBuilder.setFixedSubProperties(subProps)) {
                return null;
            }
            props.setInfo(PartStore.mergeContainerInfo(subProps.getInfo(), props.getInfo()));
        }
        if (largeInfoRef != null) {
            largeInfoRef[0] = largeInfoBuilder.build();
        }
        return props;
    }

    boolean checkLargeInfoExpiration(LargeInfo largeInfo) throws GSException {
        return this.largeInfoCache.checkExpiration(largeInfo, this.largeInfoCache.currentNanosForExpiration());
    }

    LargeInfo takeLargeInfo(ContainerKeyConverter.ContainerKey key, boolean emptyAllowed, ContainerKeyConverter keyConverter) throws GSException, ContainerPartitioningException {
        LargeInfo largeInfo = this.getLargeInfo(key.toCaseSensitive(false), emptyAllowed, keyConverter);
        if (largeInfo == null) {
            throw new ContainerPartitioningException(145003, "Partitioned container unexpectedly lost (name=" + key + ")", null);
        }
        return largeInfo;
    }

    LargeInfo getLargeInfo(ContainerKeyConverter.ContainerKey normalizedKey, boolean emptyAllowed, ContainerKeyConverter keyConverter) throws GSException {
        return this.getLargeInfo(normalizedKey, emptyAllowed, keyConverter, null);
    }

    private LargeInfo getLargeInfo(ContainerKeyConverter.ContainerKey normalizedKey, boolean emptyAllowed, ContainerKeyConverter keyConverter, SchemaPropertiesResolver<?> resolver) throws GSException {
        LargeInfo largeInfo = this.largeInfoCache.find(normalizedKey, this.largeInfoCache.currentNanosForExpiration());
        if (largeInfo == null || !largeInfo.isStable(emptyAllowed)) {
            ContainerProperties props = this.base.getContainerProperties(normalizedKey, PartStore.getLargeInfoPropKeys(), null, true);
            LargeInfoBuilder largeInfoBuilder = this.createLargeInfoBuilder(normalizedKey, props);
            if (largeInfoBuilder != null && largeInfoBuilder.isLarge()) {
                SchemaPropertiesResolver<Object> localResolver;
                if (resolver == null) {
                    boolean internalMode = true;
                    localResolver = new SchemaPropertiesResolver<Object>(){

                        @Override
                        public ContainerProperties resolve(ContainerKeyConverter.ContainerKey key) throws GSException {
                            return PartStore.this.base.getContainerProperties(key, CONTAINER_PROP_KEYS_FULL, null, true);
                        }
                    };
                } else {
                    localResolver = resolver;
                }
                ContainerKeyConverter.ContainerKey subKey = largeInfoBuilder.getFixedSubKey(keyConverter);
                largeInfoBuilder.setFixedSubProperties(localResolver.resolve(subKey));
            }
            if (largeInfoBuilder != null) {
                largeInfo = largeInfoBuilder.build();
            }
            if (largeInfo != null && largeInfo.isStable(true)) {
                this.largeInfoCache.add(normalizedKey, largeInfo);
            }
        }
        return largeInfo;
    }

    Map<ContainerKeyConverter.ContainerKey, LargeInfo> getAllLargeInfo(java.util.Collection<ContainerKeyConverter.ContainerKey> normalizedKeyCollection, ContainerKeyConverter keyConverter) throws GSException {
        int i;
        HashMap<ContainerKeyConverter.ContainerKey, LargeInfo> infoMap = new HashMap<ContainerKeyConverter.ContainerKey, LargeInfo>();
        ArrayList<ContainerKeyConverter.ContainerKey> nonCachedKeys = new ArrayList<ContainerKeyConverter.ContainerKey>();
        for (ContainerKeyConverter.ContainerKey key : normalizedKeyCollection) {
            LargeInfo largeInfo = this.largeInfoCache.find(key, this.largeInfoCache.currentNanosForExpiration());
            if (largeInfo == null) {
                nonCachedKeys.add(key);
                continue;
            }
            infoMap.put(key, largeInfo);
        }
        boolean internalMode = true;
        ArrayList<LargeInfoBuilder> builderList = new ArrayList<LargeInfoBuilder>();
        ArrayList<ContainerKeyConverter.ContainerKey> subKeys = new ArrayList<ContainerKeyConverter.ContainerKey>();
        List<ContainerProperties> propsList = this.base.getAllContainerProperties(nonCachedKeys, PartStore.getLargeInfoPropKeys(), null, true);
        int propsCount = propsList.size();
        for (i = 0; i < propsCount; ++i) {
            ContainerKeyConverter.ContainerKey key = (ContainerKeyConverter.ContainerKey)nonCachedKeys.get(i);
            LargeInfoBuilder builder = this.createLargeInfoBuilder(key, propsList.get(i));
            if (builder == null) continue;
            if (builder.isLarge()) {
                builderList.add(builder);
                subKeys.add(builder.getFixedSubKey(keyConverter));
                continue;
            }
            infoMap.put(key, builder.build());
        }
        propsList = this.base.getAllContainerProperties(subKeys, CONTAINER_PROP_KEYS_FULL, null, true);
        propsCount = propsList.size();
        for (i = 0; i < propsCount; ++i) {
            LargeInfoBuilder builder = (LargeInfoBuilder)builderList.get(i);
            if (!builder.setFixedSubProperties(propsList.get(i))) continue;
            infoMap.put(builder.getLargeKey(), builder.build());
        }
        return infoMap;
    }

    void removeLargeInfo(ContainerKeyConverter.ContainerKey normalizedKey, LargeInfo largeInfo) throws GSException {
        LargeInfo foundInfo;
        if (largeInfo == null && (foundInfo = this.largeInfoCache.find(normalizedKey, this.largeInfoCache.currentNanosForExpiration())) != null) {
            this.removeLargeInfo(normalizedKey, foundInfo);
            return;
        }
        this.largeInfoCache.remove(normalizedKey);
        this.base.removeContainerCache(normalizedKey, true);
        if (largeInfo != null && largeInfo.isLarge()) {
            ContainerKeyConverter keyConverter = this.getContainerKeyConverter(true, false);
            for (long subId : largeInfo) {
                ContainerKeyConverter.ContainerKey subKey = largeInfo.generateSubKey(normalizedKey, keyConverter, subId);
                this.base.removeContainerCache(subKey, true);
            }
        }
    }

    private static ContainerProperties.KeySet getLargeInfoPropKeys() {
        if (PartStore.isLargePropKeyEnabled()) {
            return CONTAINER_PROP_KEYS_LARGE;
        }
        return CONTAINER_PROP_KEYS_MIN;
    }

    private LargeInfoBuilder createLargeInfoBuilder(ContainerKeyConverter.ContainerKey key, ContainerProperties props) throws GSException {
        return LargeInfoBuilder.getInstance(key, props, this.partitionController, this.largeInfoCache);
    }

    private static ContainerInfo mergeContainerInfo(ContainerInfo sub, ContainerInfo large) throws GSException {
        List<IndexInfo> largeIndexInfoList = large.getIndexInfoList();
        if (largeIndexInfoList.isEmpty()) {
            ContainerInfo retInfo = new ContainerInfo(sub);
            retInfo.setName(large.getName());
            return retInfo;
        }
        int columnCount = sub.getColumnCount();
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnInfoList.add(sub.getColumnInfo(i));
        }
        ArrayList<IndexInfo> destIndexInfoList = new ArrayList<IndexInfo>(largeIndexInfoList.size());
        for (IndexInfo srcIndexInfo : largeIndexInfoList) {
            IndexInfo destIndexInfo = new IndexInfo(srcIndexInfo);
            List<Integer> columnList = destIndexInfo.getColumnList();
            ArrayList<String> columnNameList = new ArrayList<String>();
            for (Integer column : columnList) {
                ColumnInfo columnInfo = (ColumnInfo)columnInfoList.get(column);
                columnNameList.add(columnInfo.getName());
                if (columnList.size() > 1) continue;
                EnumSet<IndexType> typeSet = EnumSet.of(srcIndexInfo.getType());
                if (columnInfo.getIndexTypes() != null) {
                    typeSet.addAll(columnInfo.getIndexTypes());
                }
                columnInfoList.set(column, new ColumnInfo(columnInfo.getName(), columnInfo.getType(), columnInfo.getNullable(), columnInfo.getDefaultValueNull(), typeSet));
            }
            destIndexInfo.setColumnNameList(columnNameList);
            destIndexInfoList.add(destIndexInfo);
        }
        ContainerInfo retInfo = new ContainerInfo(sub);
        retInfo.setName(large.getName());
        retInfo.setColumnInfoList(columnInfoList);
        retInfo.setIndexInfoList(destIndexInfoList);
        return retInfo;
    }

    private static <K, R> PartContainer<K, R> disguiseTypedContainer(PartContainer<?, R> container) {
        return container;
    }

    private static boolean isLargePropKeyEnabled() {
        return SubnetGridStore.isContainerAttributeUnified();
    }

    private static boolean isPartitionedContainerRecoverable() {
        return NodeConnection.getProtocolVersion() >= 15;
    }

    private static boolean isPartitioningIntervalUnified() {
        return false;
    }

    static enum ContainerSchemaOptionType {
        PARTITION_EXPIRATION(100);

        private final int number;

        private ContainerSchemaOptionType(int number) {
            this.number = number;
        }

        public int number() {
            return this.number;
        }
    }

    static enum ExtRequestOptionType {
        SUB_CONTAINER_VERSION(13001),
        SUB_CONTAINER_EXPIRABLE(13002),
        DIST_QUERY(13003),
        LARGE_INFO(13004);

        private final int number;

        private ExtRequestOptionType(int number) {
            this.number = number;
        }

        public int number() {
            return this.number;
        }
    }

    static enum PartitionedStatement {
        ALTER_CONTAINER_PROPERTIES;

        static final int ORDINAL_OFFSET = 201;
        private final Statement.GeneralStatement general = Statement.GeneralStatement.getInstance(this.name(), 201 + this.ordinal());

        Statement.GeneralStatement generalize() {
            return this.general;
        }
    }

    private class ListingMultiOperationContext<V, E>
    extends PartitionedMultiOperationContext<V, List<E>> {
        private final Map<String, List<E>> resultMap;

        public ListingMultiOperationContext(Partitioner<V> partitioner, Map<String, ? extends V> targetMap) throws GSException {
            super(partitioner, targetMap);
            this.resultMap = new HashMap<String, List<E>>();
        }

        @Override
        public void acceptCompletion(ContainerKeyConverter.ContainerKey containerKey, List<E> result) throws GSException {
            String nonSubName = this.toNonSubKey(containerKey).toString();
            List<E> list = this.resultMap.get(nonSubName);
            if (list == null) {
                list = new ArrayList();
                this.resultMap.put(nonSubName, list);
            }
            list.addAll(result);
            super.acceptCompletion(containerKey, result);
        }

        public Map<String, List<E>> getResultMap() {
            return this.resultMap;
        }

        @Override
        protected boolean isResultAcceptable() {
            return true;
        }

        @Override
        protected void clearResult(ContainerKeyConverter.ContainerKey containerKey) throws GSException {
            String nonSubName = this.toNonSubKey(containerKey).toString();
            this.resultMap.remove(nonSubName);
        }
    }

    private class PartitionedMultiOperationContext<V, R>
    implements Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, R> {
        private final Partitioner<V> partitioner;
        private final ContainerKeyConverter keyConverter;
        private Map<String, ? extends V> nameTargetMap;
        private Map<ContainerKeyConverter.ContainerKey, ? extends V> keyTargetMap;
        private Map<ContainerKeyConverter.ContainerKey, ContainerKeyConverter.ContainerKey> subToLargeNameMap;
        private Set<ContainerKeyConverter.ContainerKey> singleCompletedSet;
        private Set<ContainerKeyConverter.ContainerKey> subCompletedSet;
        private Set<ContainerKeyConverter.ContainerKey> subVisitedSet;
        private boolean firstListed;
        private boolean singleLost;
        private boolean subOrSingleLost;

        public PartitionedMultiOperationContext(Partitioner<V> partitioner, Map<String, ? extends V> targetMap) throws GSException {
            this.partitioner = partitioner;
            this.keyConverter = PartStore.this.getContainerKeyConverter(false, !this.isResultAcceptable());
            this.nameTargetMap = targetMap;
            this.keyTargetMap = Collections.emptyMap();
        }

        @Override
        public void listTarget(Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> consumer) throws GSException {
            if (this.subToLargeNameMap != null || this.singleCompletedSet != null) {
                this.updateTarget(this.keyConverter);
            }
            this.listTarget(consumer, this.nameTargetMap, new GeneralKeyConverter.ForString(), this.keyConverter);
            this.listTarget(consumer, this.keyTargetMap, new GeneralKeyConverter.ForKey(), this.keyConverter);
            this.firstListed = true;
            this.subOrSingleLost = false;
        }

        private <K> void listTarget(Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> consumer, Map<K, ? extends V> targetMap, GeneralKeyConverter<K> converter, ContainerKeyConverter keyConverter) throws GSException {
            ContainerKeyConverter.ContainerKey key;
            int entryCount = targetMap.size();
            ArrayList<ContainerKeyConverter.ContainerKey> keyList = new ArrayList<ContainerKeyConverter.ContainerKey>();
            ArrayList<V> valueList = new ArrayList<V>();
            for (Map.Entry<K, V> entry : targetMap.entrySet()) {
                key = converter.convert(entry.getKey(), keyConverter);
                keyList.add(key);
                valueList.add(entry.getValue());
            }
            Map<ContainerKeyConverter.ContainerKey, LargeInfo> largeInfoMap = PartStore.this.getAllLargeInfo(keyList, keyConverter);
            block3: for (int i = 0; i < entryCount; ++i) {
                key = (ContainerKeyConverter.ContainerKey)keyList.get(i);
                Object value = valueList.get(i);
                boolean refreshed = false;
                while (true) {
                    block9: {
                        LargeInfo largeInfo;
                        LargeInfo largeInfo2 = largeInfo = refreshed ? null : largeInfoMap.get(key);
                        if (refreshed) {
                            largeInfo = PartStore.this.getLargeInfo(key.toCaseSensitive(false), false, keyConverter);
                        }
                        if (largeInfo != null && largeInfo.isLarge()) {
                            this.partitioner.clear();
                            try {
                                this.partitioner.add(largeInfo, value);
                            }
                            catch (ContainerPartitioningException e) {
                                this.acceptContainerPartitioningException(e, refreshed, key, largeInfo);
                                break block9;
                            }
                            if (this.consumeLarge(consumer, largeInfo, key, keyConverter, refreshed)) continue block3;
                        } else {
                            if (largeInfo == null) {
                                this.singleLost = true;
                            }
                            consumer.consume(key, value, ContainerKeyPredicate.ATTRIBUTE_SINGLE, null);
                            continue block3;
                        }
                    }
                    refreshed = true;
                }
            }
        }

        private boolean consumeLarge(Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> consumer, LargeInfo largeInfo, ContainerKeyConverter.ContainerKey largeKey, ContainerKeyConverter keyConverter, boolean refreshed) throws GSException {
            long subId;
            V fullValue = this.partitioner.popFull();
            if (fullValue != null) {
                for (long subId2 : largeInfo) {
                    if (this.consumeLarge(consumer, largeInfo, largeKey, keyConverter, subId2, fullValue, refreshed)) continue;
                    return false;
                }
            }
            while ((subId = this.partitioner.getNextId()) >= 0L) {
                if (this.consumeLarge(consumer, largeInfo, largeKey, keyConverter, subId, this.partitioner.next(), refreshed)) continue;
                return false;
            }
            return true;
        }

        private boolean consumeLarge(Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> consumer, LargeInfo largeInfo, ContainerKeyConverter.ContainerKey largeKey, ContainerKeyConverter keyConverter, long subId, V value, boolean refreshed) throws GSException {
            ContainerKeyConverter.ContainerKey subKey = largeInfo.generateSubKey(largeKey, keyConverter, subId);
            ContainerKeyConverter.ContainerKey normalizedSubKey = subKey.toCaseSensitive(false);
            if (this.subCompletedSet != null && this.subCompletedSet.contains(normalizedSubKey)) {
                return true;
            }
            boolean expired = false;
            if (!this.isResultAcceptable() && largeInfo.isExpired(subId)) {
                expired = true;
            } else if (!(this.isResultAcceptable() || !this.subOrSingleLost && largeInfo.isAvailable(subId))) {
                Extensibles.AsContainer container;
                if (this.subVisitedSet == null) {
                    this.subVisitedSet = new HashSet<ContainerKeyConverter.ContainerKey>();
                }
                boolean always = true;
                boolean checkOnly = this.subVisitedSet.contains(normalizedSubKey);
                try {
                    container = PartStore.this.getSubContainer(largeKey, new LargeInfo[]{largeInfo}, subId, RowMapper.BindingTool.createBindType(null, Row.class, Container.class), true, true, checkOnly);
                }
                catch (ContainerPartitioningException e) {
                    this.acceptContainerPartitioningException(e, refreshed, largeKey, null);
                    return false;
                }
                catch (ContainerExpirationException e) {
                    PartStore.this.removeLargeInfo(largeKey.toCaseSensitive(false), largeInfo);
                    container = null;
                    expired = true;
                }
                if (container != null) {
                    container.close();
                }
                this.subVisitedSet.add(normalizedSubKey);
            }
            if (expired) {
                if (this.subCompletedSet == null) {
                    this.subCompletedSet = new HashSet<ContainerKeyConverter.ContainerKey>();
                }
                this.subCompletedSet.add(normalizedSubKey);
                return true;
            }
            NodeConnection.OptionalRequestSource source = null;
            if (!this.firstListed && this.partitioner.isUncovered()) {
                source = PartStore.getSubContainerVersionOptionSource(largeInfo.partitioningVersion);
            }
            consumer.consume(subKey, value, PartContainer.Attributes.SUB, source);
            if (this.subToLargeNameMap == null) {
                this.subToLargeNameMap = new HashMap<ContainerKeyConverter.ContainerKey, ContainerKeyConverter.ContainerKey>();
            }
            this.subToLargeNameMap.put(normalizedSubKey, largeKey);
            return true;
        }

        private void acceptContainerPartitioningException(ContainerPartitioningException exception, boolean refreshed, ContainerKeyConverter.ContainerKey key, LargeInfo largeInfo) throws GSException {
            PartStore.this.removeLargeInfo(key.toCaseSensitive(false), largeInfo);
            if (!refreshed) {
                return;
            }
            throw new GSException(exception.getErrorCode(), null, exception.getMessage() + " (containerName=" + key + ")", Collections.singletonMap("containerName", key.toString()), exception);
        }

        private void updateTarget(ContainerKeyConverter keyConverter) throws GSException {
            if (this.singleCompletedSet == null) {
                this.singleCompletedSet = Collections.emptySet();
            }
            if (this.subToLargeNameMap == null) {
                this.subToLargeNameMap = Collections.emptyMap();
            } else if (this.subCompletedSet != null) {
                this.subToLargeNameMap.keySet().removeAll(this.subCompletedSet);
            }
            HashSet<ContainerKeyConverter.ContainerKey> restLargeSet = new HashSet<ContainerKeyConverter.ContainerKey>();
            for (ContainerKeyConverter.ContainerKey key : this.subToLargeNameMap.values()) {
                ContainerKeyConverter.ContainerKey normalizedKey = key.toCaseSensitive(false);
                restLargeSet.add(normalizedKey);
            }
            HashMap<ContainerKeyConverter.ContainerKey, ? extends V> nextTargetMap = new HashMap<ContainerKeyConverter.ContainerKey, V>();
            this.makeNextTargetMap(new GeneralKeyConverter.ForString(), keyConverter, restLargeSet, this.nameTargetMap, nextTargetMap);
            this.makeNextTargetMap(new GeneralKeyConverter.ForKey(), keyConverter, restLargeSet, this.keyTargetMap, nextTargetMap);
            this.nameTargetMap = Collections.emptyMap();
            this.keyTargetMap = nextTargetMap;
            this.singleCompletedSet = null;
            this.subToLargeNameMap = null;
            if (this.isResultAcceptable()) {
                this.subCompletedSet = null;
            }
            PartStore.this.disableCache(this.keyTargetMap, new GeneralKeyConverter.ForKey(), true);
        }

        private <K> void makeNextTargetMap(GeneralKeyConverter<K> converter, ContainerKeyConverter keyConverter, Set<ContainerKeyConverter.ContainerKey> restLargeSet, Map<K, ? extends V> prevTargetMap, Map<ContainerKeyConverter.ContainerKey, V> nextTargetMap) throws GSException {
            for (Map.Entry<K, V> entry : prevTargetMap.entrySet()) {
                ContainerKeyConverter.ContainerKey key = converter.convert(entry.getKey(), keyConverter);
                ContainerKeyConverter.ContainerKey normalizedKey = key.toCaseSensitive(false);
                if (!restLargeSet.contains(normalizedKey) || this.singleCompletedSet.contains(normalizedKey)) continue;
                this.clearResult(normalizedKey);
                nextTargetMap.put(key, entry.getValue());
            }
        }

        @Override
        public boolean acceptException(GSException exception) throws GSException {
            PartStore.this.disableCache(this.nameTargetMap, new GeneralKeyConverter.ForString(), true);
            PartStore.this.disableCache(this.keyTargetMap, new GeneralKeyConverter.ForKey(), true);
            if (!(exception.getErrorCode() != 10016 || this.isResultAcceptable() || this.singleLost || this.subToLargeNameMap == null || this.subToLargeNameMap.isEmpty())) {
                this.subOrSingleLost = true;
                return true;
            }
            return exception.getErrorCode() == 10093 || PartStore.isSubContainerExpirationError(exception) || PartStore.isSubContainerVersionError(exception);
        }

        @Override
        public void acceptCompletion(ContainerKeyConverter.ContainerKey containerKey, R result) throws GSException {
            ContainerKeyConverter.ContainerKey normalizedKey = containerKey.toCaseSensitive(false);
            if (this.subToLargeNameMap == null || !this.subToLargeNameMap.containsKey(normalizedKey)) {
                if (this.singleCompletedSet == null) {
                    this.singleCompletedSet = new HashSet<ContainerKeyConverter.ContainerKey>();
                }
                this.singleCompletedSet.add(normalizedKey);
            } else {
                if (this.subCompletedSet == null) {
                    this.subCompletedSet = new HashSet<ContainerKeyConverter.ContainerKey>();
                }
                this.subCompletedSet.add(normalizedKey);
            }
        }

        @Override
        public boolean isRemaining() throws GSException {
            if (this.isResultAcceptable()) {
                return this.keyTargetMap.isEmpty() && this.subToLargeNameMap != null && !(this.subCompletedSet == null ? Collections.emptySet() : this.subCompletedSet).containsAll(this.subToLargeNameMap.keySet());
            }
            return false;
        }

        protected boolean isResultAcceptable() {
            return false;
        }

        protected void clearResult(ContainerKeyConverter.ContainerKey containerKey) throws GSException {
        }

        protected ContainerKeyConverter.ContainerKey toNonSubKey(ContainerKeyConverter.ContainerKey key) throws GSException {
            ContainerKeyConverter.ContainerKey largeKey;
            ContainerKeyConverter.ContainerKey normalizedKey = key.toCaseSensitive(false);
            ContainerKeyConverter.ContainerKey containerKey = largeKey = this.subToLargeNameMap == null ? null : this.subToLargeNameMap.get(normalizedKey);
            if (largeKey == null) {
                return key;
            }
            return SubContainerLocator.subKeyToLarge(key, largeKey, this.keyConverter);
        }
    }

    static abstract class GeneralKeyConverter<S> {
        GeneralKeyConverter() {
        }

        abstract ContainerKeyConverter.ContainerKey convert(S var1, ContainerKeyConverter var2) throws GSException;

        static class ForKey
        extends GeneralKeyConverter<ContainerKeyConverter.ContainerKey> {
            ForKey() {
            }

            @Override
            ContainerKeyConverter.ContainerKey convert(ContainerKeyConverter.ContainerKey src, ContainerKeyConverter keyConverter) throws GSException {
                return src;
            }
        }

        static class ForString
        extends GeneralKeyConverter<String> {
            ForString() {
            }

            @Override
            ContainerKeyConverter.ContainerKey convert(String src, ContainerKeyConverter keyConverter) throws GSException {
                return keyConverter.parse(src, false);
            }
        }
    }

    static class PredicatePartitioner
    extends Partitioner<RowKeyPredicate<?>> {
        PredicatePartitioner() {
        }

        @Override
        public void add(LargeInfo largeInfo, RowKeyPredicate<?> pred) throws GSException, ContainerPartitioningException {
            if (pred == null) {
                throw new GSException(145001, "Null predicate found");
            }
            boolean decomposed = false;
            java.util.Collection<?> distinctKeys = pred.getDistinctKeys();
            boolean keyPartitioned = largeInfo.isKeyPartitioned();
            if (!keyPartitioned || distinctKeys == null) {
                if (largeInfo.isOrdered()) {
                    this.setUncovered(true);
                }
                Object start = pred.getStart();
                Object finish = pred.getFinish();
                if (!keyPartitioned || largeInfo.isOrdered() || start == null && finish == null) {
                    this.putFull(pred);
                    return;
                }
                Long startId = start == null ? null : largeInfo.subIdFromKey(start, false, true);
                Long finishId = finish == null ? null : largeInfo.subIdFromKey(finish, false, false);
                for (Long subId : largeInfo.subIdRange(startId, finishId)) {
                    this.put(subId, pred);
                }
            } else {
                for (Object key : distinctKeys) {
                    boolean found = false;
                    for (Long subId : largeInfo.subIdRangeByKey(key, false)) {
                        this.put(subId, pred);
                        found = true;
                    }
                    if (found) continue;
                    this.setUncovered(true);
                }
            }
        }
    }

    static class RowPartitioner
    extends ListPartitioner<Row> {
        private final Object[] partitioningValues = new Object[2];

        RowPartitioner() {
        }

        @Override
        protected long getSubId(LargeInfo largeInfo, Row elem) throws GSException, ContainerPartitioningException {
            int count = largeInfo.getPartitioningColumnCount();
            for (int i = 0; i < count; ++i) {
                int column = largeInfo.getPartitioningColumn(i);
                this.partitioningValues[i] = elem.getValue(column);
            }
            return largeInfo.subIdFromValues(this.partitioningValues);
        }
    }

    static abstract class ListPartitioner<E>
    extends Partitioner<List<E>> {
        ListPartitioner() {
        }

        protected abstract long getSubId(LargeInfo var1, E var2) throws GSException, ContainerPartitioningException;

        public void addElement(LargeInfo largeInfo, E elem) throws GSException, ContainerPartitioningException {
            if (elem == null) {
                throw new GSException(145001, "Null row found");
            }
            long subId = this.getSubId(largeInfo, elem);
            ArrayList<E> list = (ArrayList<E>)this.get(subId);
            if (list == null) {
                list = new ArrayList<E>();
                this.put(subId, list);
            }
            list.add(elem);
        }

        @Override
        public void add(LargeInfo largeInfo, List<E> list) throws GSException, ContainerPartitioningException {
            this.add(largeInfo, (Iterable<E>)list);
        }

        @Override
        public void add(LargeInfo largeInfo, Iterable<E> iterable) throws GSException, ContainerPartitioningException {
            for (E row : iterable) {
                this.addElement(largeInfo, row);
            }
        }
    }

    static abstract class Partitioner<V> {
        private static final int LIST_THRESHOLD = 128;
        private final List<V> list = new ArrayList<V>();
        private final BitSet bits = new BitSet();
        private Map<Long, V> map;
        private Iterator<Map.Entry<Long, V>> mapIterator;
        private V fullValue;
        private int minIndex;
        private int maxIndex;
        private boolean uncovered;
        private Map.Entry<Long, V> nextMapEntry;

        Partitioner() {
            this.clearIndexRange();
        }

        private void clearIndexRange() {
            this.minIndex = Integer.MAX_VALUE;
            this.maxIndex = -1;
        }

        private long prepareMapEntry() {
            block4: {
                block5: {
                    if (this.map == null) break block4;
                    if (this.nextMapEntry != null) break block5;
                    if (this.mapIterator == null) {
                        this.mapIterator = this.map.entrySet().iterator();
                    }
                    if (!this.mapIterator.hasNext()) break block4;
                    this.nextMapEntry = this.mapIterator.next();
                }
                return this.nextMapEntry.getKey();
            }
            return -1L;
        }

        protected void put(long subId, V value) {
            if (subId >= 128L) {
                if (this.map == null) {
                    this.map = new HashMap<Long, V>();
                }
                this.map.put(subId, value);
                return;
            }
            int subIndex = (int)subId;
            while (subIndex >= this.list.size()) {
                this.list.add(null);
            }
            this.list.set(subIndex, value);
            this.bits.set(subIndex);
            if (subIndex < this.minIndex) {
                this.minIndex = subIndex;
            }
            if (subIndex > this.maxIndex) {
                this.maxIndex = subIndex;
            }
        }

        protected void putFull(V value) {
            this.fullValue = value;
        }

        protected V get(long subId) {
            if (subId >= (long)this.list.size()) {
                if (this.map == null) {
                    return null;
                }
                return this.map.get(subId);
            }
            int subIndex = (int)subId;
            return this.list.get(subIndex);
        }

        protected void setUncovered(boolean uncovered) {
            this.uncovered = uncovered;
        }

        public void clear() {
            this.fullValue = null;
            this.clearIndexRange();
            this.list.clear();
            this.bits.clear();
            if (this.map != null) {
                this.map.clear();
                this.mapIterator = null;
                this.nextMapEntry = null;
            }
            this.uncovered = false;
        }

        public abstract void add(LargeInfo var1, V var2) throws GSException, ContainerPartitioningException;

        public long getNextId() {
            if (this.minIndex > this.maxIndex) {
                return this.prepareMapEntry();
            }
            return this.minIndex;
        }

        public V next() {
            if (this.minIndex > this.maxIndex) {
                if (this.prepareMapEntry() < 0L) {
                    return null;
                }
                V value = this.nextMapEntry.getValue();
                this.nextMapEntry = null;
                return value;
            }
            int subIndex = this.minIndex;
            V value = this.list.get(subIndex);
            this.minIndex = this.bits.nextSetBit(subIndex + 1);
            if (this.minIndex < 0) {
                this.clearIndexRange();
            }
            return value;
        }

        public V popFull() {
            V value = this.fullValue;
            this.fullValue = null;
            return value;
        }

        public boolean isUncovered() {
            return this.uncovered;
        }
    }

    private static enum AlternationType {
        PUT_SUB_STATE,
        PUT_SUB_CONTAINER_VERSION,
        RECOVER_SUB_CONTAINER;

    }

    private static class SubOperationStatus {
        private final SubOperation goalOp;
        private final long goalSubId;
        private SubOperation nextOp;
        private Long nextSubId;
        private LargeInfo info;

        SubOperationStatus(SubOperation goalOp, long goalSubId, LargeInfo info) throws ContainerPartitioningException {
            this.goalOp = goalOp;
            this.goalSubId = goalSubId;
            this.accept(info);
        }

        void accept(LargeInfo info) throws ContainerPartitioningException {
            Long nextSubId;
            SubOperation nextOp;
            boolean reached;
            if (this.info != null && this.info.containerId != info.containerId) {
                throw new ContainerPartitioningException(145003, "Partitioned container unexpectedly changed", null);
            }
            switch (this.goalOp) {
                case CREATE_END: {
                    if (info.isDisabled(this.goalSubId)) {
                        throw SubOperationStatus.errorUnreachableOperation();
                    }
                    reached = info.isAvailable(this.goalSubId);
                    break;
                }
                case DROP_END: {
                    reached = info.isDisabled(this.goalSubId);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Long subId = info.operatingSubId;
            SubOperation op = info.operation;
            if (op != null && !op.isBegin()) {
                throw new IllegalArgumentException();
            }
            if (reached) {
                nextOp = null;
                nextSubId = null;
            } else if (op == null) {
                nextOp = this.goalOp.toBegin();
                nextSubId = this.goalSubId;
            } else if (op == this.nextOp && subId.equals(this.nextSubId)) {
                nextOp = op.toEnd();
                nextSubId = subId;
            } else {
                nextOp = op;
                nextSubId = subId;
            }
            this.nextSubId = nextSubId;
            this.nextOp = nextOp;
            this.info = info;
        }

        Long getNextSubId() {
            return this.nextSubId;
        }

        SubOperation getNextOperation() {
            return this.nextOp;
        }

        private static ContainerPartitioningException errorUnreachableOperation() {
            return new ContainerPartitioningException(145003, "Dropped container partition cannot create again", null);
        }
    }

    private static enum SubOperation {
        CREATE_BEGIN,
        CREATE_END,
        DROP_BEGIN,
        DROP_END,
        INDEX_CREATE_BEGIN,
        INDEX_CREATE_END,
        INDEX_DROP_BEGIN,
        INDEX_DROP_END;


        boolean isBegin() {
            switch (this) {
                case CREATE_BEGIN: 
                case DROP_BEGIN: 
                case INDEX_CREATE_BEGIN: 
                case INDEX_DROP_BEGIN: {
                    return true;
                }
            }
            return false;
        }

        SubOperation toBegin() {
            switch (this) {
                case CREATE_END: {
                    return CREATE_BEGIN;
                }
                case DROP_END: {
                    return DROP_BEGIN;
                }
                case INDEX_CREATE_END: {
                    return INDEX_CREATE_BEGIN;
                }
                case INDEX_DROP_END: {
                    return INDEX_DROP_BEGIN;
                }
            }
            return this;
        }

        SubOperation toEnd() {
            switch (this) {
                case CREATE_BEGIN: {
                    return CREATE_END;
                }
                case DROP_BEGIN: {
                    return DROP_END;
                }
                case INDEX_CREATE_BEGIN: {
                    return INDEX_CREATE_END;
                }
                case INDEX_DROP_BEGIN: {
                    return INDEX_DROP_END;
                }
            }
            return this;
        }
    }

    static class ValueHasher {
        ValueHasher() {
        }

        public static int hashAndMod(Object value, int count) throws GSException {
            return (int)(ValueHasher.hashAsUInt(value) % (long)count);
        }

        public static long hashAsUInt(Object value) throws GSException {
            return (long)ValueHasher.hash(value) & 0xFFFFFFFFL;
        }

        public static int hash(Object value) throws GSException {
            return ValueHasher.hash(FNV1a.init32(), value);
        }

        public static int hash(int base, Object value) throws GSException {
            if (value instanceof Number) {
                return ValueHasher.hashNumber(base, (Number)value);
            }
            if (value instanceof Date) {
                return ValueHasher.hashNumber(base, ((Date)value).getTime());
            }
            if (value instanceof String) {
                return ValueHasher.hashString(base, (String)value);
            }
            if (value instanceof Blob) {
                return ValueHasher.hashBlob(base, (Blob)value);
            }
            if (value instanceof Boolean) {
                return ValueHasher.hashNumber(base, (Boolean)value != false ? 1 : 0);
            }
            if (value == null) {
                return base;
            }
            throw new GSException(145002, "Illegal type for container partitioning key (class=" + value.getClass().getName() + ")");
        }

        public static int hashNumber(int base, Number value) {
            if (value instanceof Double || value instanceof Float) {
                return ValueHasher.hashDouble(base, value.doubleValue());
            }
            return ValueHasher.hashDouble(base, value.longValue());
        }

        private static int hashDouble(int base, double value) {
            if (Double.isNaN(value)) {
                return base;
            }
            long bits = Double.doubleToRawLongBits(value);
            int hash = base;
            hash = FNV1a.update(hash, (byte)bits);
            hash = FNV1a.update(hash, (byte)(bits >> 8));
            hash = FNV1a.update(hash, (byte)(bits >> 16));
            hash = FNV1a.update(hash, (byte)(bits >> 24));
            hash = FNV1a.update(hash, (byte)(bits >> 32));
            hash = FNV1a.update(hash, (byte)(bits >> 40));
            hash = FNV1a.update(hash, (byte)(bits >> 48));
            hash = FNV1a.update(hash, (byte)(bits >> 56));
            return hash;
        }

        private static int hashString(int base, String value) {
            byte[] bytes = value.getBytes(BasicBuffer.DEFAULT_CHARSET);
            return FNV1a.update(base, bytes, bytes.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int hashBlob(int base, Blob value) throws GSException {
            int n;
            InputStream in = value.getBinaryStream();
            try {
                n = ValueHasher.hashInputStream(base, in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new GSException(e);
                }
                catch (IOException e) {
                    throw new GSException(e);
                }
            }
            in.close();
            return n;
        }

        private static int hashInputStream(int base, InputStream in) throws IOException {
            int len;
            int hash = base;
            byte[] buf = new byte[8192];
            while ((len = in.read()) >= 0) {
                hash = FNV1a.update(hash, buf, len);
            }
            return hash;
        }
    }

    private static abstract class SchemaPropertiesResolver<S> {
        private S source;

        private SchemaPropertiesResolver() {
        }

        protected void setSource(S source) {
            this.source = source;
        }

        public S getSource() {
            return this.source;
        }

        public abstract ContainerProperties resolve(ContainerKeyConverter.ContainerKey var1) throws GSException;
    }

    static class SubContainerLocator {
        SubContainerLocator() {
        }

        public static ContainerKeyConverter.ContainerKey getSubContainerKey(ContainerKeyConverter.ContainerKey largeKey, ContainerKeyConverter keyConverter, long subId, int subCount, int clusterPartitionCount, long largeId, int mode) throws GSException {
            long affinityNum;
            ContainerKeyConverter.Components components = new ContainerKeyConverter.Components();
            keyConverter.decompose(largeKey, components);
            if (mode == 0) {
                if (subId < 0L || subId >= (long)subCount) {
                    throw new GSException(145000, "");
                }
                affinityNum = SubContainerLocator.getClusterPartitionIndex(components.base, components.affinityStr, components.affinityNum, (int)subId, subCount, clusterPartitionCount);
            } else {
                affinityNum = subId;
            }
            components.affinityStr = null;
            components.affinityNum = affinityNum;
            components.largeId = largeId;
            return keyConverter.compose(components, false);
        }

        private static int getClusterPartitionIndex(String baseName, String affinityStr, long affinityNum, int subIndex, int subCount, int clusterPartitionCount) throws GSException {
            if (subIndex == 0) {
                if (affinityStr == null && affinityNum < 0L) {
                    String normalizedBase = RowMapper.normalizeSymbolUnchecked(baseName);
                    return SubContainerLocator.hash(normalizedBase, clusterPartitionCount);
                }
                return SubContainerLocator.affinityToPartition(affinityStr, affinityNum, clusterPartitionCount);
            }
            int base = clusterPartitionCount / subCount;
            int mod = clusterPartitionCount % subCount;
            int largePartition = SubContainerLocator.getClusterPartitionIndex(baseName, affinityStr, affinityNum, 0, subCount, clusterPartitionCount);
            int baseIndex = SubContainerLocator.groupIndex(largePartition, base, mod);
            int rawIndex = (baseIndex + subIndex) % subCount;
            if (subCount > clusterPartitionCount) {
                return rawIndex % clusterPartitionCount;
            }
            int offset = SubContainerLocator.groupOffset(rawIndex, base, mod);
            int range = SubContainerLocator.groupRange(rawIndex, base, mod);
            String hashingStr = RowMapper.normalizeSymbolUnchecked(baseName) + "/" + rawIndex;
            return offset + SubContainerLocator.hash(hashingStr, range);
        }

        private static int groupOffset(int index, int base, int mod) {
            return base * index + Math.min(mod, index);
        }

        private static int groupRange(int index, int base, int mod) {
            return base + (index < mod ? 1 : 0);
        }

        private static int groupIndex(int offset, int base, int mod) {
            if (offset < (base + 1) * mod) {
                return offset / (base + 1);
            }
            return (offset - mod) / base;
        }

        private static int affinityToPartition(String affinityStr, long affinityNum, int clusterPartitionCount) throws GSException {
            if (affinityNum >= 0L) {
                return (int)((affinityNum & 0xFFFFFFFFL) % (long)clusterPartitionCount);
            }
            String normalizedStr = RowMapper.normalizeSymbolUnchecked(affinityStr);
            return SubContainerLocator.hash(normalizedStr, clusterPartitionCount);
        }

        private static int hash(String normalizedStr, int count) throws GSException {
            return GridStoreChannel.calculatePartitionId(normalizedStr, NodeResolver.ContainerHashMode.COMPATIBLE1, count);
        }

        public static ContainerKeyConverter.ContainerKey subKeyToLarge(ContainerKeyConverter.ContainerKey subKey, ContainerKeyConverter.ContainerKey baseLargeKey, ContainerKeyConverter keyConverter) throws GSException {
            ContainerKeyConverter.Components subComponents = new ContainerKeyConverter.Components();
            ContainerKeyConverter.Components largeComponents = new ContainerKeyConverter.Components();
            keyConverter.decompose(subKey, subComponents);
            keyConverter.decompose(baseLargeKey, largeComponents);
            largeComponents.base = subComponents.base;
            return keyConverter.compose(largeComponents, false);
        }
    }

    static class LargeInfoCache {
        private final int limit;
        private final int expirationMillis;
        private long lastCheckNanos;
        private Map<ContainerKeyConverter.ContainerKey, LargeInfo> map = new LinkedHashMap<ContainerKeyConverter.ContainerKey, LargeInfo>();

        public LargeInfoCache(int limit, int expirationMillis) {
            this.limit = limit;
            this.expirationMillis = expirationMillis;
            this.lastCheckNanos = this.currentNanosForExpiration();
        }

        public long currentNanosForExpiration() {
            return this.isExpirable() ? System.nanoTime() : 0L;
        }

        public boolean isExpirable() {
            return this.expirationMillis >= 0;
        }

        public boolean checkExpiration(LargeInfo largeInfo, long curNanos) {
            if (!this.isExpirable() || largeInfo.partitioningType == null) {
                return false;
            }
            if (LargeInfoCache.isTimeRotated(this.lastCheckNanos, curNanos)) {
                this.map.clear();
                return true;
            }
            return LargeInfoCache.isTimeExpired(largeInfo.cachedNanos, curNanos, this.expirationMillis);
        }

        public LargeInfo find(ContainerKeyConverter.ContainerKey normalizedKey, long curNanos) {
            LargeInfo largeInfo = this.map.get(normalizedKey);
            if (largeInfo != null && this.checkExpiration(largeInfo, curNanos)) {
                this.remove(normalizedKey);
                return null;
            }
            return largeInfo;
        }

        public void add(ContainerKeyConverter.ContainerKey normalizedKey, LargeInfo largeInfo) {
            if (this.map.put(normalizedKey, largeInfo) == null) {
                this.adjust();
            }
        }

        public void remove(ContainerKeyConverter.ContainerKey normalizedKey) {
            this.map.remove(normalizedKey);
        }

        private void adjust() {
            int extra = this.map.size() - this.limit;
            if (extra <= 0) {
                return;
            }
            Iterator<ContainerKeyConverter.ContainerKey> it = this.map.keySet().iterator();
            while (it.hasNext()) {
                this.remove(it.next());
                if (--extra > 0) continue;
                break;
            }
        }

        private static boolean isTimeExpired(long nanos1, long nanos2, int expirationMillis) {
            if (LargeInfoCache.isTimeRotated(nanos1, nanos2)) {
                return true;
            }
            return (nanos2 - nanos1) / 1000L / 1000L >= (long)expirationMillis;
        }

        private static boolean isTimeRotated(long nanos1, long nanos2) {
            return nanos1 < 0L != nanos2 < 0L;
        }
    }

    private static class SubIdIterator
    implements Iterator<Long> {
        final LargeInfo largeInfo;
        final long[] intervalList;
        final long[] countList;
        final int finishIndex;
        final long finishOffset;
        final int unit;
        int nextIndex;
        long nextOffset;
        int nextUnitOffset;

        SubIdIterator(LargeInfo largeInfo, long[] intervalList, long[] countList, int startIndex, long startOffset, int finishIndex, long finishOffset) {
            this.largeInfo = largeInfo;
            this.intervalList = intervalList;
            this.countList = countList;
            this.nextIndex = startIndex;
            this.nextOffset = startOffset;
            this.finishIndex = finishIndex;
            this.finishOffset = finishOffset;
            this.unit = largeInfo.getPartitioningUnit();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex <= this.finishIndex;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long subId = this.largeInfo.subIdFromRawInterval(this.intervalList[this.nextIndex] + this.nextOffset, this.nextUnitOffset);
            if (++this.nextUnitOffset >= this.unit) {
                if (this.nextIndex >= this.finishIndex) {
                    if (++this.nextOffset > this.finishOffset) {
                        ++this.nextIndex;
                    }
                } else if (++this.nextOffset >= this.countList[this.nextIndex]) {
                    ++this.nextIndex;
                    this.nextOffset = 0L;
                }
                this.nextUnitOffset = 0;
            }
            return subId;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static enum PartitioningType {
        NONE,
        HASH,
        INTERVAL,
        INTERVAL_HASH;

    }

    static class ContainerExpirationException
    extends Exception {
        private static final long serialVersionUID = -1850729080452420370L;
        private final int errorCode;

        ContainerExpirationException(int errorCode, String message, Throwable cause) {
            super(message, cause);
            this.errorCode = errorCode;
        }

        int getErrorCode() {
            return this.errorCode;
        }

        GSException toGSException() {
            return new GSException(this.errorCode, this.getMessage(), this);
        }
    }

    static class ContainerPartitioningException
    extends Exception {
        private static final long serialVersionUID = 1090617685025081585L;
        private final int errorCode;

        ContainerPartitioningException(int errorCode, String message, Throwable cause) {
            super(message, cause);
            this.errorCode = errorCode;
        }

        int getErrorCode() {
            return this.errorCode;
        }

        GSException toGSException() {
            return new GSException(this.errorCode, this.getMessage(), this);
        }
    }

    private static class LargeInfoBuilder {
        private static final LargeInfoBuilder NOT_LARGE = new LargeInfoBuilder(LargeInfo.NOT_LARGE);
        private final ContainerKeyConverter.ContainerKey largeKey;
        private LargeInfo largeInfo;

        private LargeInfoBuilder(ContainerKeyConverter.ContainerKey largeKey, ContainerProperties props, Extensibles.AsPartitionController partitionController, LargeInfoCache largeInfoCache) throws GSException {
            byte[] infoBytes = props.getRawEntries().get(16);
            if (infoBytes == null) {
                throw new GSException(145031, "Protocol error by empty large info");
            }
            BasicBuffer buf = new BasicBuffer(infoBytes.length);
            buf.base().put(infoBytes);
            buf.base().flip();
            int clusterPartitionCount = partitionController.getPartitionCount();
            int partitionId = partitionController.getPartitionIndexOfContainer(largeKey, true);
            this.largeKey = largeKey;
            this.largeInfo = new LargeInfo(buf, props.getIdInfo(), clusterPartitionCount, partitionId, largeInfoCache.currentNanosForExpiration());
        }

        private LargeInfoBuilder(LargeInfo largeInfo) {
            this.largeKey = null;
            this.largeInfo = largeInfo;
        }

        public static LargeInfoBuilder getInstance(ContainerKeyConverter.ContainerKey key, ContainerProperties props, Extensibles.AsPartitionController partitionController, LargeInfoCache largeInfoCache) throws GSException {
            if (props == null) {
                return null;
            }
            int attribute = props.getAttribute();
            if (attribute == PartContainer.Attributes.LARGE) {
                if (!PartStore.isLargePropKeyEnabled()) {
                    return NOT_LARGE;
                }
                return new LargeInfoBuilder(key, props, partitionController, largeInfoCache);
            }
            if (attribute == ContainerKeyPredicate.ATTRIBUTE_BASE || attribute == ContainerKeyPredicate.ATTRIBUTE_SINGLE) {
                return NOT_LARGE;
            }
            return null;
        }

        public boolean isLarge() {
            if (this.largeInfo == null) {
                throw new Error();
            }
            return this.largeInfo.isLarge();
        }

        public ContainerKeyConverter.ContainerKey getLargeKey() {
            return this.largeKey;
        }

        public ContainerKeyConverter.ContainerKey getFixedSubKey(ContainerKeyConverter keyConverter) throws GSException {
            if (this.largeInfo == null || !this.largeInfo.isLarge()) {
                throw new Error();
            }
            long subId = this.largeInfo.getFixedSubId();
            return this.largeInfo.generateSubKey(this.largeKey, keyConverter, subId);
        }

        public boolean setFixedSubProperties(ContainerProperties props) {
            Integer attribute;
            if (this.largeInfo == null || !this.largeInfo.isLarge() || this.largeInfo.keyColumnMap != null) {
                throw new Error();
            }
            if (props == null || (attribute = props.getAttribute()) != null && attribute != PartContainer.Attributes.SUB) {
                this.largeInfo = null;
                return false;
            }
            this.largeInfo.keyColumnMap = LargeInfo.makeKeyColumnMap(props.getInfo());
            return true;
        }

        public LargeInfo build() {
            if (this.largeInfo != null && this.largeInfo.isLarge() && this.largeInfo.keyColumnMap == null) {
                throw new Error();
            }
            return this.largeInfo;
        }
    }

    static class LargeInfo
    implements Iterable<Long> {
        static final LargeInfo NOT_LARGE = new LargeInfo();
        static final int MAX_PARTITIONING_COLUMN_COUNT = 2;
        private static final PartitioningType[] PARTITIONING_TYPE_VALUES = PartitioningType.values();
        private static final NodeResolver.ContainerHashMode[] PARTITIONING_MODE_VALUES = NodeResolver.ContainerHashMode.values();
        private static final SubOperation[] SUB_OPERATION_VALUES = SubOperation.values();
        private static final GSType[] COLUMN_TYPE_VALUES = GSType.values();
        private static final long MAX_NODE_AFFINITY_NUM = 0x3FFFFFFFFFFFFFFFL;
        private static final int MAX_AVAILABLE_SUB_COUNT = 10000;
        private static final Map<Integer, Integer> SINGLE_KEY_COLUMN_MAP = Collections.unmodifiableMap(Collections.singletonMap(0, 0));
        int locationMode;
        PartitioningType partitioningType;
        NodeResolver.ContainerHashMode partitioningMode;
        int partitioningCount;
        GSType intervalType;
        long intervalValue;
        int intervalUnit;
        long partitioningVersion;
        long[] nodeAffinityList;
        int[] nodeAffinityRevList;
        int[] partitioningColumns1;
        int[] partitioningColumns2;
        long[] availableIntervalList;
        long[] availableCountList;
        long[] disabledIntervalList;
        long[] disabledCountList;
        SubOperation operation;
        Long operatingSubId;
        IndexInfo operatingIndex;
        int clusterPartitionCount;
        long remoteTimeMillis;
        long expirationTimeMillis;
        TimeUnit expirationTimeUnit;
        int partitionId;
        long containerId;
        Map<Integer, Integer> keyColumnMap;
        long cachedNanos;

        LargeInfo() {
        }

        LargeInfo(BasicBuffer in, ContainerProperties.ContainerIdInfo idInfo, int clusterPartitionCount, int partitionId, long cachedNanos) throws GSException {
            this.locationMode = LargeInfo.getLocationMode(in);
            this.partitioningType = LargeInfo.getPartitioningType(in, this.locationMode);
            this.partitioningMode = LargeInfo.getPartitioningMode(in, this.locationMode);
            this.partitioningCount = LargeInfo.getPartitioningCount(in, this.partitioningType);
            LargeInfo.getIntervalInfo(in, this.partitioningType, this);
            this.partitioningVersion = LargeInfo.getPartitioningVersion(in, this.locationMode);
            this.nodeAffinityList = LargeInfo.getNodeAffinityList(in, this.locationMode, this.partitioningType, this.partitioningCount, clusterPartitionCount);
            this.partitioningColumns1 = LargeInfo.getColumnList(in, this.locationMode, this.partitioningType, true);
            this.partitioningColumns2 = LargeInfo.getColumnList(in, this.locationMode, this.partitioningType, false);
            long[][] list = LargeInfo.getIntervalList(in, this.locationMode, true, this.partitioningType);
            this.availableIntervalList = list[0];
            this.availableCountList = list[1];
            list = LargeInfo.getIntervalList(in, this.locationMode, false, this.partitioningType);
            this.disabledIntervalList = list[0];
            this.disabledCountList = list[1];
            LargeInfo.getOperationStatus(in, this);
            LargeInfo.getExpirationInfo(in, this);
            this.clusterPartitionCount = clusterPartitionCount;
            this.partitionId = partitionId;
            this.containerId = idInfo.containerId;
            this.cachedNanos = cachedNanos;
        }

        void put(BasicBuffer out) {
            out.putInt(this.locationMode);
            out.putInt(this.partitioningType.ordinal());
            out.putInt(this.partitioningMode.ordinal());
            LargeInfo.putPartitioningCount(out, this.partitioningType, this.partitioningCount);
            LargeInfo.putIntervalInfo(out, this.partitioningType, this);
            LargeInfo.putPartitioningVersion(out, this.locationMode, this.partitioningVersion);
            LargeInfo.putNodeAffinityList(out, this.locationMode, this.nodeAffinityList);
            LargeInfo.putColumnList(out, this.locationMode, this.partitioningColumns1, this.partitioningType, true);
            LargeInfo.putColumnList(out, this.locationMode, this.partitioningColumns2, this.partitioningType, false);
            LargeInfo.putIntervalList(out, this.locationMode, this.availableIntervalList, this.availableCountList);
            LargeInfo.putIntervalList(out, this.locationMode, this.disabledIntervalList, this.disabledCountList);
            LargeInfo.putOperationStatus(out, this);
            LargeInfo.putExpirationInfo(out, this);
        }

        @Override
        public Iterator<Long> iterator() {
            int finishIndex = this.availableIntervalList.length - 1;
            if (finishIndex < 0) {
                return Collections.emptyList().iterator();
            }
            return new SubIdIterator(this, this.availableIntervalList, this.availableCountList, 0, 0L, finishIndex, this.availableCountList[finishIndex] - 1L);
        }

        boolean isLarge() {
            return this.partitioningType != null;
        }

        boolean isStable(boolean emptyAllowed) {
            return !this.isLarge() || !this.isOrdered() || this.operation == null && (emptyAllowed || this.availableIntervalList.length > 0);
        }

        boolean isExpirable() {
            return this.expirationTimeMillis > 0L;
        }

        boolean isKeyPartitioned() {
            if (this.keyColumnMap.isEmpty()) {
                return false;
            }
            return this.keyColumnMap.containsKey(this.partitioningColumns1[0]);
        }

        int getPartitioningColumnCount() {
            return this.partitioningType == PartitioningType.INTERVAL_HASH ? 2 : 1;
        }

        int getPartitioningColumn(int index) {
            return index == 0 ? this.partitioningColumns1[0] : this.partitioningColumns2[0];
        }

        static Map<Integer, Integer> makeKeyColumnMap(ContainerInfo info) {
            int columnCount = info.getColumnCount();
            if (columnCount <= 0) {
                throw new Error();
            }
            List<Integer> keyList = info.getRowKeyColumnList();
            if (keyList.isEmpty()) {
                return Collections.emptyMap();
            }
            if (keyList.size() == 1 && keyList.get(0) == 0) {
                return SINGLE_KEY_COLUMN_MAP;
            }
            LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
            for (Integer column : keyList) {
                int keyColumn = map.size();
                map.put(column, keyColumn);
            }
            return Collections.unmodifiableMap(map);
        }

        long getFixedSubId() {
            if (this.locationMode == 0) {
                return 0L;
            }
            return this.partitionId;
        }

        long getFeasibleSubId() {
            if (this.locationMode == 0) {
                return 0L;
            }
            long interval = this.getTailInterval(true);
            if (interval < 0L) {
                return this.getFixedSubId();
            }
            return this.subIdFromInterval(interval, 0);
        }

        boolean isOrdered() {
            return this.partitioningType != PartitioningType.HASH;
        }

        int getPartitioningUnit() {
            if (this.partitioningType == PartitioningType.INTERVAL) {
                return 1;
            }
            return this.partitioningCount;
        }

        ContainerKeyConverter.ContainerKey generateSubKey(ContainerKeyConverter.ContainerKey largeKey, ContainerKeyConverter keyConverter, long subId) throws GSException {
            return SubContainerLocator.getSubContainerKey(largeKey, keyConverter, subId, this.partitioningCount, this.clusterPartitionCount, this.containerId, this.locationMode);
        }

        private Object singleKeyToPartitioningValue(Object key) throws ContainerPartitioningException {
            if (this.keyColumnMap.size() != 1) {
                throw new ContainerPartitioningException(145023, "Single key expected", null);
            }
            if (!this.isKeyPartitioned()) {
                return null;
            }
            return key;
        }

        private Object[] composedKeyToPartitioningValues(Object[] key) throws ContainerPartitioningException {
            Integer keyColumn;
            Object[] values = new Object[this.getPartitioningColumnCount()];
            for (int i = 0; i < values.length && (keyColumn = this.keyColumnMap.get(this.getPartitioningColumn(i))) != null; ++i) {
                Object srcElem;
                try {
                    srcElem = key[keyColumn];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ContainerPartitioningException(145023, null, e);
                }
                values[i] = srcElem;
            }
            return values;
        }

        private Object[] composedKeyToPartitioningValues(Row.Key key) throws ContainerPartitioningException {
            Integer keyColumn;
            Object[] values = new Object[this.getPartitioningColumnCount()];
            for (int i = 0; i < values.length && (keyColumn = this.keyColumnMap.get(this.getPartitioningColumn(i))) != null; ++i) {
                Object srcElem;
                try {
                    srcElem = key.getValue(keyColumn);
                }
                catch (GSException e) {
                    throw new ContainerPartitioningException(145023, null, e);
                }
                values[i] = srcElem;
            }
            return values;
        }

        /*
         * Unable to fully structure code
         */
        Long subIdFromKey(Object key, boolean decomposed, boolean start) throws GSException, ContainerPartitioningException {
            block12: {
                block10: {
                    block11: {
                        if (!decomposed) break block10;
                        if (key instanceof Object[]) break block11;
                        value1 = this.singleKeyToPartitioningValue(key);
                        value2 = null;
                        break block12;
                    }
                    composedValues = this.composedKeyToPartitioningValues((Object[])key);
                    ** GOTO lbl15
                }
                if (!(key instanceof Row.Key)) {
                    value1 = this.singleKeyToPartitioningValue(key);
                    value2 = null;
                } else {
                    composedValues = this.composedKeyToPartitioningValues((Row.Key)key);
lbl15:
                    // 2 sources

                    if (composedValues == null || composedValues[0] == null) {
                        return null;
                    }
                    value1 = composedValues[0];
                    if (composedValues.length <= 1) {
                        if (composedValues.length < 1) {
                            throw new Error();
                        }
                        value2 = null;
                    } else {
                        value2 = composedValues[1];
                        if (composedValues.length > 2) {
                            throw new Error();
                        }
                    }
                }
            }
            if (value1 == null) {
                return null;
            }
            if (value2 == null) {
                if (this.partitioningType == PartitioningType.INTERVAL_HASH) {
                    interval = this.intervalFromValue(value1);
                    hash = start != false ? 0 : this.partitioningCount - 1;
                    return this.subIdFromInterval(interval, hash);
                }
                return this.subIdFromValues(new Object[]{value1});
            }
            return this.subIdFromValues(new Object[]{value1, value2});
        }

        long subIdFromValues(Object ... values) throws GSException, ContainerPartitioningException {
            if (this.locationMode == 0) {
                return ValueHasher.hashAndMod(values[0], this.partitioningCount);
            }
            int count = this.clusterPartitionCount;
            switch (this.partitioningType) {
                case HASH: {
                    int hash = ValueHasher.hashAndMod(values[0], this.partitioningCount);
                    return (long)(hash / count * count) + this.nodeAffinityList[hash % count] + (long)count;
                }
                case INTERVAL: {
                    long interval = this.intervalFromValue(values[0]);
                    return interval / (long)(count * 2) * (long)(count * 2) + this.nodeAffinityList[(int)((interval >> 1) % (long)count)] + (long)((interval & 1L) == 0L ? 0 : count) + (long)count;
                }
                case INTERVAL_HASH: {
                    long interval = this.intervalFromValue(values[0]);
                    int unit = this.partitioningCount;
                    int hash = ValueHasher.hashAndMod(values[1], unit);
                    return interval / (long)(count * 2) * (long)(count * 2) * (long)unit + this.nodeAffinityList[(int)((interval >> 1) % (long)count)] + (long)((interval & 1L) == 0L ? 0 : count * unit) + (long)hash + (long)count;
                }
            }
            throw new Error();
        }

        long subIdFromInterval(long interval, int hash) {
            if (this.locationMode == 0) {
                return hash;
            }
            int count = this.clusterPartitionCount;
            switch (this.partitioningType) {
                case HASH: {
                    return (long)(hash / count * count) + this.nodeAffinityList[hash % count] + (long)count;
                }
                case INTERVAL: {
                    return interval / (long)(count * 2) * (long)(count * 2) + this.nodeAffinityList[(int)((interval >> 1) % (long)count)] + (long)((interval & 1L) == 0L ? 0 : count) + (long)count;
                }
                case INTERVAL_HASH: {
                    int unit = this.partitioningCount;
                    return interval / (long)(count * 2) * (long)(count * 2) * (long)unit + this.nodeAffinityList[(int)((interval >> 1) % (long)count)] + (long)((interval & 1L) == 0L ? 0 : count * unit) + (long)hash + (long)count;
                }
            }
            throw new Error();
        }

        long subIdFromRawInterval(long rawInterval, int hash) {
            return this.subIdFromInterval(LargeInfo.intervalFromRaw(rawInterval), hash);
        }

        long[] intervalValueRangeFromSubId(long subId) {
            long upper;
            long lower;
            long rawInterval = LargeInfo.toRawInterval(this.intervalFromSubId(subId));
            long unit = this.intervalValue;
            long min = Long.MIN_VALUE;
            long max = Long.MAX_VALUE;
            if (rawInterval >= 0L) {
                long cur = rawInterval;
                if (cur > Long.MAX_VALUE / unit) {
                    throw new IllegalArgumentException();
                }
                long begin = cur * unit;
                long offset = unit - 1L;
                lower = begin;
                upper = begin > Long.MAX_VALUE - offset ? Long.MAX_VALUE : begin + offset;
            } else {
                long next = rawInterval + 1L;
                if (next < Long.MIN_VALUE / unit) {
                    throw new IllegalArgumentException();
                }
                long end = next * unit;
                lower = end < Long.MIN_VALUE + unit ? Long.MIN_VALUE : end - unit;
                upper = end - 1L;
            }
            return new long[]{lower, upper};
        }

        long intervalFromSubId(long subId) {
            int count = this.clusterPartitionCount;
            if (subId < (long)count) {
                throw new IllegalArgumentException();
            }
            if (this.partitioningType == PartitioningType.HASH) {
                return 0L;
            }
            long base = (subId - (long)count) / (long)this.getPartitioningUnit();
            int[] revList = this.getNodeAffinityRevList();
            return base / (long)(count * 2) * (long)(count * 2) + ((long)revList[(int)(base % (long)count)] << 1 | (long)(base / (long)count % 2L == 0L ? 0 : 1));
        }

        private long intervalFromValue(Object value) throws ContainerPartitioningException {
            long longValue;
            try {
                longValue = this.intervalType == GSType.TIMESTAMP ? ((Date)value).getTime() : ((Number)value).longValue();
            }
            catch (NullPointerException e) {
                throw new ContainerPartitioningException(145023, "Null is not allowed for interval partitioning key (partitioningKeyType=" + (Object)((Object)this.intervalType) + ")", e);
            }
            catch (ClassCastException e) {
                throw new ContainerPartitioningException(145023, "Unmatched type for interval partitioning key (valueClass=" + value.getClass().getName() + ", partitioningKeyType=" + (Object)((Object)this.intervalType) + ")", e);
            }
            long rawInterval = longValue >= 0L ? longValue / this.intervalValue : (longValue + 1L) / this.intervalValue - 1L;
            return LargeInfo.intervalFromRaw(rawInterval);
        }

        private static long intervalFromRaw(long rawInterval) {
            if (rawInterval < 0L) {
                return -(rawInterval + 1L) << 1 | 1L;
            }
            return rawInterval << 1;
        }

        private static long toRawInterval(long interval) {
            if ((interval & 1L) == 1L) {
                return -(interval >>> 1) - 1L;
            }
            return interval >>> 1;
        }

        private int[] getNodeAffinityRevList() {
            if (this.nodeAffinityRevList != null) {
                return this.nodeAffinityRevList;
            }
            switch (this.partitioningType) {
                case INTERVAL: {
                    long unit = 1L;
                    break;
                }
                case INTERVAL_HASH: {
                    long unit = this.partitioningCount;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            int[] list = new int[this.nodeAffinityList.length];
            for (int i = 0; i < list.length; ++i) {
                list[(int)(this.nodeAffinityList[i] / unit)] = i;
            }
            this.nodeAffinityRevList = list;
            return list;
        }

        boolean isAvailable(long subId) {
            if (subId == this.getFixedSubId()) {
                return true;
            }
            return this.containsSub(true, subId);
        }

        boolean isDisabled(long subId) {
            if (subId == this.getFixedSubId()) {
                return false;
            }
            return this.containsSub(false, subId);
        }

        boolean isExpired(long subId) {
            long duration;
            if (!this.isExpirable() || subId == this.getFixedSubId()) {
                return false;
            }
            long[] range = this.intervalValueRangeFromSubId(subId);
            long maxAvailableTime = range[1] > Long.MAX_VALUE - (duration = this.expirationTimeMillis) ? Long.MAX_VALUE : range[1] + duration;
            return maxAvailableTime < this.remoteTimeMillis;
        }

        boolean containsSub(boolean forAvailable, long subId) {
            return this.findNeighbor(forAvailable, this.intervalFromSubId(subId), false, true, true) >= 0L;
        }

        long findNeighborSub(boolean forAvailable, boolean upper, long subId) {
            long interval = this.findNeighbor(forAvailable, this.intervalFromSubId(subId), upper, false, false);
            if (interval < 0L) {
                return -1L;
            }
            return this.subIdFromInterval(interval, 0);
        }

        private int findIntervalIndex(boolean forAvailable, long interval) {
            long rawInterval;
            long[] intervalList = this.getIntervalList(forAvailable);
            int index = Arrays.binarySearch(intervalList, rawInterval = LargeInfo.toRawInterval(interval));
            if (index >= 0) {
                return index;
            }
            if (index == -1) {
                return -1;
            }
            return -(index + 1) - 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long findNeighbor(boolean forAvailable, long interval, boolean upper, boolean inclusive, boolean exact) {
            long ret;
            long[] intervalList = this.getIntervalList(forAvailable);
            long[] countList = this.getIntervalCountList(forAvailable);
            long rawInterval = LargeInfo.toRawInterval(interval) + (long)(inclusive ? 0 : (upper ? 1 : -1));
            int index = Arrays.binarySearch(intervalList, rawInterval);
            if (index >= 0) {
                ret = rawInterval;
                return LargeInfo.intervalFromRaw(ret);
            } else if ((index = -(index + 1)) == 0) {
                if (!upper || exact || intervalList.length <= 0) return -1L;
                ret = intervalList[0];
                return LargeInfo.intervalFromRaw(ret);
            } else {
                long end = intervalList[index - 1] + countList[index - 1];
                if (rawInterval < end) {
                    ret = rawInterval;
                    return LargeInfo.intervalFromRaw(ret);
                } else {
                    if (upper || exact) return -1L;
                    ret = end - 1L;
                }
            }
            return LargeInfo.intervalFromRaw(ret);
        }

        Iterable<Long> subIdRangeByKey(Object key, boolean decomposed) throws GSException, ContainerPartitioningException {
            Long startSubId = this.subIdFromKey(key, decomposed, true);
            Long finishSubId = this.subIdFromKey(key, decomposed, false);
            return this.subIdRange(startSubId, finishSubId);
        }

        Iterable<Long> subIdRange(Long startSubId, Long finishSubId) {
            long finishRawInterval;
            long finishInterval;
            long startInterval = startSubId == null ? this.getBeginInterval(true) : this.findNeighbor(true, this.intervalFromSubId(startSubId), true, true, false);
            long l = finishInterval = startSubId == null ? this.getTailInterval(true) : this.findNeighbor(true, this.intervalFromSubId(startSubId), false, true, false);
            if (startInterval < 0L || finishInterval < 0L) {
                return Collections.emptySet();
            }
            long startRawInterval = LargeInfo.toRawInterval(startInterval);
            if (startRawInterval > (finishRawInterval = LargeInfo.toRawInterval(finishInterval))) {
                return Collections.emptySet();
            }
            final int startIndex = this.findIntervalIndex(true, startInterval);
            final int finishIndex = this.findIntervalIndex(true, finishInterval);
            final long[] intervalList = this.getIntervalList(true);
            final long[] countList = this.getIntervalCountList(true);
            final long startOffset = startRawInterval - intervalList[startIndex];
            final long finishOffset = finishRawInterval - intervalList[finishIndex];
            return new Iterable<Long>(){

                @Override
                public Iterator<Long> iterator() {
                    return new SubIdIterator(LargeInfo.this, intervalList, countList, startIndex, startOffset, finishIndex, finishOffset);
                }
            };
        }

        private long getBeginInterval(boolean forAvailable) {
            long[] intervalList = this.getIntervalList(forAvailable);
            if (intervalList.length <= 0) {
                return -1L;
            }
            return LargeInfo.intervalFromRaw(intervalList[0]);
        }

        private long getTailInterval(boolean forAvailable) {
            long[] intervalList = this.getIntervalList(forAvailable);
            long[] countList = this.getIntervalCountList(forAvailable);
            int index = intervalList.length - 1;
            if (index < 0) {
                return -1L;
            }
            return LargeInfo.intervalFromRaw(intervalList[index] + countList[index] - 1L);
        }

        private long[] getIntervalList(boolean forAvailable) {
            return forAvailable ? this.availableIntervalList : this.disabledIntervalList;
        }

        private long[] getIntervalCountList(boolean forAvailable) {
            return forAvailable ? this.availableCountList : this.disabledCountList;
        }

        private static int getLocationMode(BasicBuffer in) throws GSException {
            int locationMode = in.base().getInt();
            switch (locationMode) {
                case 0: 
                case 1: 
                case 2: {
                    return locationMode;
                }
            }
            throw new GSException(145031, "Protocol error by unknown location mode (mode=" + locationMode + ")");
        }

        private static PartitioningType getPartitioningType(BasicBuffer in, int locationMode) throws GSException {
            int typeValue = in.base().getInt();
            if (locationMode == 0) {
                if (typeValue == 1) {
                    return PartitioningType.HASH;
                }
            } else if (typeValue >= 0 && typeValue < PARTITIONING_TYPE_VALUES.length) {
                return PARTITIONING_TYPE_VALUES[typeValue];
            }
            throw new GSException(145031, "Protocol error by unknown container partitioning type");
        }

        private static NodeResolver.ContainerHashMode getPartitioningMode(BasicBuffer in, int locationMode) throws GSException {
            int modeValue = in.base().getInt();
            if (locationMode == 0) {
                if (modeValue == 0) {
                    return NodeResolver.ContainerHashMode.COMPATIBLE1;
                }
            } else if (modeValue >= 0 && modeValue < PARTITIONING_MODE_VALUES.length) {
                return PARTITIONING_MODE_VALUES[modeValue];
            }
            throw new GSException(145031, "Protocol error by unknown container partitioning mode");
        }

        private static int getPartitioningCount(BasicBuffer in, PartitioningType type) throws GSException {
            switch (type) {
                case HASH: 
                case INTERVAL_HASH: {
                    break;
                }
                default: {
                    return 0;
                }
            }
            int count = in.base().getInt();
            if (count <= 0) {
                throw new GSException(145031, "Protocol error by too small container partitioning count");
            }
            return count;
        }

        private static void putPartitioningCount(BasicBuffer out, PartitioningType type, int partitioningCount) {
            switch (type) {
                case HASH: 
                case INTERVAL_HASH: {
                    break;
                }
                default: {
                    return;
                }
            }
            out.putInt(partitioningCount);
        }

        private static void getIntervalInfo(BasicBuffer in, PartitioningType partitioningType, LargeInfo info) throws GSException {
            long value;
            switch (partitioningType) {
                case INTERVAL: 
                case INTERVAL_HASH: {
                    break;
                }
                default: {
                    return;
                }
            }
            GSType type = LargeInfo.getIntervalColumnType(in);
            switch (type) {
                case BYTE: {
                    value = in.base().get();
                    break;
                }
                case SHORT: {
                    value = in.base().getShort();
                    break;
                }
                case INTEGER: {
                    value = in.base().getInt();
                    break;
                }
                case LONG: {
                    value = in.base().getLong();
                    break;
                }
                case TIMESTAMP: {
                    value = in.base().getLong();
                    break;
                }
                default: {
                    throw new GSException(145031, "Protocol error by illegal interval column type");
                }
            }
            info.intervalType = type;
            info.intervalValue = value;
            info.intervalUnit = LargeInfo.getIntervalUnitType(in, type);
        }

        private static void putIntervalInfo(BasicBuffer out, PartitioningType partitioningType, LargeInfo info) {
            switch (partitioningType) {
                case INTERVAL: 
                case INTERVAL_HASH: {
                    break;
                }
                default: {
                    return;
                }
            }
            out.put((byte)info.intervalType.ordinal());
            switch (info.intervalType) {
                case BYTE: {
                    out.put((byte)info.intervalValue);
                    break;
                }
                case SHORT: {
                    out.putShort((short)info.intervalValue);
                    break;
                }
                case INTEGER: {
                    out.putInt((int)info.intervalValue);
                    break;
                }
                case LONG: {
                    out.putLong(info.intervalValue);
                    break;
                }
                case TIMESTAMP: {
                    out.putLong(info.intervalValue);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            out.put((byte)info.intervalUnit);
        }

        private static GSType getIntervalColumnType(BasicBuffer in) throws GSException {
            byte typeValue = in.base().get();
            if (typeValue < 0 || typeValue >= COLUMN_TYPE_VALUES.length) {
                throw new GSException(145031, "Protocol error by illegal column type");
            }
            return COLUMN_TYPE_VALUES[typeValue];
        }

        private static int getIntervalUnitType(BasicBuffer in, GSType intervalType) throws GSException {
            byte typeValue = in.base().get();
            if (intervalType == GSType.TIMESTAMP ? typeValue == TimeUnit.DAY.ordinal() : typeValue == -1) {
                return typeValue;
            }
            throw new GSException(145031, "Protocol error by illegal interval unit type");
        }

        private static long getPartitioningVersion(BasicBuffer in, int locationMode) throws GSException {
            if (locationMode <= 0) {
                return 0L;
            }
            long version = in.base().getLong();
            if (version < 0L) {
                throw new GSException(145031, "Protocol error by illegal partitioning version");
            }
            return version;
        }

        private static void putPartitioningVersion(BasicBuffer out, int locationMode, long version) {
            if (locationMode <= 0) {
                return;
            }
            out.putLong(version);
        }

        private static long[] getNodeAffinityList(BasicBuffer in, int locationMode, PartitioningType type, int partitioningCount, int clusterPartitionCount) throws GSException {
            int unit;
            int expectedCount;
            if (locationMode <= 0) {
                return null;
            }
            switch (type) {
                case INTERVAL: {
                    expectedCount = clusterPartitionCount;
                    unit = 1;
                    break;
                }
                case INTERVAL_HASH: {
                    expectedCount = clusterPartitionCount;
                    unit = partitioningCount;
                    break;
                }
                default: {
                    expectedCount = clusterPartitionCount < partitioningCount ? clusterPartitionCount : partitioningCount;
                    unit = 1;
                }
            }
            int count = BasicBuffer.BufferUtils.getIntSize(in.base());
            if (count <= 0 || count != expectedCount || (long)count > 0x3FFFFFFFFFFFFFFFL) {
                throw new GSException(145031, "Protocol error by illegal node affinity count (expected=" + expectedCount + ", actual=" + count + ")");
            }
            long[] list = new long[count];
            for (int i = 0; i < count; ++i) {
                long affinity = in.base().getLong();
                if (affinity < 0L || affinity >= (long)(clusterPartitionCount * unit) || affinity % (long)unit != 0L) {
                    throw new GSException(145031, "Protocol error by illegal node affinity value (value=" + affinity + ")");
                }
                list[i] = affinity;
            }
            return list;
        }

        private static void putNodeAffinityList(BasicBuffer out, int locationMode, long[] list) {
            if (locationMode <= 0) {
                return;
            }
            out.putInt(list.length);
            for (long value : list) {
                out.putLong(value);
            }
        }

        private static int[] getColumnList(BasicBuffer in, int locationMode, PartitioningType type, boolean primary) throws GSException {
            if (locationMode <= 0) {
                if (!primary) {
                    return new int[0];
                }
                int column = in.base().getInt();
                if (column < 0) {
                    throw new GSException(145031, "Protocol error by illegal partitioning column");
                }
                return new int[]{column};
            }
            if (!primary && type != PartitioningType.INTERVAL_HASH) {
                return new int[0];
            }
            int count = BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
            if (count != 1) {
                throw new GSException(145031, "Protocol error by illegal partitioning column count");
            }
            int[] list = new int[count];
            for (int i = 0; i < count; ++i) {
                int column = in.base().getInt();
                if (column < 0) {
                    throw new GSException(145031, "Protocol error by illegal partitioning column");
                }
                list[i] = column;
            }
            return list;
        }

        private static void putColumnList(BasicBuffer out, int locationMode, int[] list, PartitioningType type, boolean primary) {
            if (locationMode <= 0) {
                if (!primary) {
                    return;
                }
                out.putInt(list[0]);
                return;
            }
            if (!primary && type != PartitioningType.INTERVAL_HASH) {
                return;
            }
            out.putInt(list.length);
            for (int value : list) {
                out.putInt(value);
            }
        }

        private static long[][] getIntervalList(BasicBuffer in, int locationMode, boolean forAvailable, PartitioningType partitioningType) throws GSException {
            if (locationMode <= 0) {
                if (!forAvailable) {
                    return new long[][]{new long[0], new long[0]};
                }
                return new long[][]{{0L}, {1L}};
            }
            int count = BasicBuffer.BufferUtils.getIntSize(in.base());
            if (partitioningType == PartitioningType.HASH) {
                if (count != 0) {
                    throw new GSException(145031, "Protocol error by illegal interval list size");
                }
                return LargeInfo.getIntervalList(null, 0, forAvailable, null);
            }
            if (count < 0 || forAvailable && count > 10000) {
                throw new GSException(145031, "Protocol error by illegal interval list size");
            }
            long[] intervalList1 = new long[count];
            long[] intervalList2 = new long[count];
            long[] countList1 = new long[count];
            long[] countList2 = new long[count];
            int pos1 = 0;
            int pos2 = 0;
            long prevRawInterval = Long.MIN_VALUE;
            long totalIntervalCount = 0L;
            for (int i = 0; i < count; ++i) {
                long interval = in.base().getLong();
                long intervalCount = in.base().getLong();
                if (intervalCount < 1L || intervalCount > 10000L || intervalCount > Long.MAX_VALUE - totalIntervalCount) {
                    throw new GSException(145031, "Protocol error by illegal interval count");
                }
                if (forAvailable && (totalIntervalCount += intervalCount) > 10000L) {
                    throw new GSException(145031, "Protocol error by illegal total interval count");
                }
                long rawInterval = LargeInfo.importRawInterval(LargeInfo.toRawInterval(interval));
                if (rawInterval < 0L) {
                    intervalList1[pos1] = rawInterval;
                    countList1[pos1] = intervalCount;
                    ++pos1;
                } else {
                    intervalList2[pos2] = rawInterval;
                    countList2[pos2] = intervalCount;
                    ++pos2;
                }
                if (i > 0 && rawInterval <= prevRawInterval) {
                    throw new GSException(145031, "Protocol error by illegal interval");
                }
                prevRawInterval = rawInterval + intervalCount;
            }
            System.arraycopy(intervalList2, 0, intervalList1, pos1, pos2);
            System.arraycopy(countList2, 0, countList1, pos1, pos2);
            return new long[][]{intervalList1, countList1};
        }

        private static void putIntervalList(BasicBuffer out, int locationMode, long[] idList, long[] countList) {
            if (locationMode <= 0) {
                return;
            }
            out.putInt(idList.length);
            for (int i = 0; i < idList.length; ++i) {
                long rawInterval = idList[i];
                long intervalCount = countList[i];
                out.putLong(LargeInfo.intervalFromRaw(LargeInfo.exportRawInterval(rawInterval)));
                out.putLong(intervalCount);
            }
        }

        private static long importRawInterval(long src) throws GSException {
            if (!PartStore.isPartitioningIntervalUnified()) {
                if (src == -1L) {
                    throw new GSException(145031, "Protocol error by illegal negative interval");
                }
                return src + (long)(src < 0L ? 1 : 0);
            }
            return src;
        }

        private static long exportRawInterval(long src) {
            if (!PartStore.isPartitioningIntervalUnified()) {
                return src - (long)(src < 0L ? 1 : 0);
            }
            return src;
        }

        private static void getOperationStatus(BasicBuffer in, LargeInfo info) throws GSException {
            if (info.locationMode <= 0) {
                return;
            }
            byte operationValue = in.base().get();
            if (operationValue >= 0 && operationValue < SUB_OPERATION_VALUES.length) {
                info.operation = SUB_OPERATION_VALUES[operationValue];
                if (!info.operation.isBegin()) {
                    throw new GSException(145031, "Protocol error by illegal sub operation type");
                }
            } else {
                if (operationValue != -1) {
                    throw new GSException(145031, "Protocol error by illegal sub operation");
                }
                return;
            }
            switch (info.operation) {
                case CREATE_BEGIN: 
                case DROP_BEGIN: {
                    long subId = in.base().getLong();
                    if (subId < 0L || subId > 0x3FFFFFFFFFFFFFFFL) {
                        throw new GSException(145031, "Protocol error by illegal operating sub ID");
                    }
                    info.operatingSubId = subId;
                    break;
                }
                case INDEX_CREATE_BEGIN: 
                case INDEX_DROP_BEGIN: {
                    info.operatingIndex = new IndexInfo();
                    SubnetGridStore.importIndexInfo(in, info.operatingIndex, true, true);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (info.operatingSubId == null != (info.operation == null)) {
                throw new GSException(145031, "Protocol error by illegal sub operation");
            }
        }

        private static void putOperationStatus(BasicBuffer out, LargeInfo info) {
            if (info.locationMode <= 0) {
                return;
            }
            if (info.operation == null) {
                out.put((byte)-1);
                return;
            }
            out.putByteEnum(info.operation);
            switch (info.operation) {
                case CREATE_BEGIN: 
                case DROP_BEGIN: {
                    out.putLong(info.operatingSubId);
                    break;
                }
                case INDEX_CREATE_BEGIN: 
                case INDEX_DROP_BEGIN: {
                    SubnetGridStore.exportIndexInfo(out, info.operatingIndex, true);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        private static void getExpirationInfo(BasicBuffer in, LargeInfo info) throws GSException {
            if (info.locationMode < 2) {
                return;
            }
            long remoteTimeMillis = in.base().getLong();
            if (remoteTimeMillis < 0L) {
                throw new GSException(145031, "Protocol error by negative remote time");
            }
            int time = in.base().getInt();
            TimeUnit timeUnit = in.getByteEnum(TimeUnit.class);
            long timeMillis = LargeInfo.expirationTimeToMillis(time, timeUnit);
            if (time > 0 && (info.intervalType != GSType.TIMESTAMP || info.partitioningType != PartitioningType.INTERVAL && info.partitioningType != PartitioningType.INTERVAL_HASH)) {
                throw new GSException(145031, "Protocol error by unexpected expiration info");
            }
            info.remoteTimeMillis = remoteTimeMillis;
            info.expirationTimeMillis = timeMillis;
            info.expirationTimeUnit = timeUnit;
        }

        private static void putExpirationInfo(BasicBuffer out, LargeInfo info) {
            if (info.locationMode < 2) {
                return;
            }
            out.putLong(info.remoteTimeMillis);
            out.putInt(LargeInfo.expirationTimeFromMillis(info.expirationTimeMillis, info.expirationTimeUnit));
            out.putByteEnum(info.expirationTimeUnit == null ? TimeUnit.DAY : info.expirationTimeUnit);
        }

        private static long expirationTimeToMillis(int srcTime, TimeUnit timeUnit) throws GSException {
            if (srcTime < 0) {
                if (srcTime < -1) {
                    throw new GSException(145031, "Protocol error by illegal expiration time");
                }
                return -1L;
            }
            try {
                return (long)srcTime * LargeInfo.getTimeUnitBase(timeUnit);
            }
            catch (IllegalArgumentException e) {
                throw new GSException(145031, "Protocol error by unsupported time unit", e);
            }
        }

        private static int expirationTimeFromMillis(long srcMillis, TimeUnit timeUnit) {
            if (srcMillis < 0L) {
                return -1;
            }
            long time = srcMillis / LargeInfo.getTimeUnitBase(timeUnit);
            if (time > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            return (int)time;
        }

        private static long getTimeUnitBase(TimeUnit timeUnit) {
            switch (timeUnit) {
                case MILLISECOND: {
                    return 1L;
                }
                case SECOND: {
                    return 1000L;
                }
                case MINUTE: {
                    return 60000L;
                }
                case HOUR: {
                    return 3600000L;
                }
                case DAY: {
                    return 86400000L;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    static class Config {
        int largeInfoCacheSize = 10000;
        int largeInfoExpirationMillis = 600000;

        public void set(PropertyUtils.WrappedProperties props) throws GSException {
            Integer largeInfoExpirationMillis;
            Integer largeInfoCacheSize = props.getIntProperty(ConfigKey.getKey("largeContainerCacheSize"), false);
            if (largeInfoCacheSize != null) {
                this.largeInfoCacheSize = largeInfoCacheSize;
            }
            if ((largeInfoExpirationMillis = props.getIntProperty(ConfigKey.getKey("largeContainerCacheExpirationMillis"), false)) != null) {
                this.largeInfoExpirationMillis = largeInfoExpirationMillis;
            }
        }
    }

    static class ConfigKey {
        static final String PREFIX = "internal.advance.";
        static final String LARGE_INFO_CACHE_SIZE_KEY = "largeContainerCacheSize";
        static final String LARGE_INFO_EXPIRATION_KEY = "largeContainerCacheExpirationMillis";
        private static final String[] ALL_BASE_KEYS = new String[]{"largeContainerCacheSize", "largeContainerCacheExpirationMillis"};

        ConfigKey() {
        }

        public static String getKey(String baseKey) {
            return PREFIX + baseKey;
        }

        public static void filter(Properties src, Properties acceptable, Properties other) {
            other.putAll((Map<?, ?>)src);
            for (String baseKey : ALL_BASE_KEYS) {
                String key = ConfigKey.getKey(baseKey);
                if (!other.containsKey(key)) continue;
                acceptable.put(key, other.remove(key));
            }
        }
    }
}

