/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.jcraft.eclipse.jsch.core;

/**
 * This interface provides access to the specific portions of
 * the repository location string for use by connection methods
 * and the user authenticator.
 * 
 * It is not intended to implemented by clients.
 * 
 * @see IUserAuthenticator
 * @see IConnectionMethod
 */
public interface IJSchLocation{

  /**
   * port value which indicates to a connection method to use the default port
   */
  public static int USE_DEFAULT_PORT=0;

  /**
   * Returns the host where the repository is located
   */
  public String getHost();

  /**
   * Returns the port to connect to or USE_DEFAULT_PORT if
   * the connection method is to use its default port.
   */
  public int getPort();

  /**
   * Returns the string representing the receiver. This string
   * should contain enough information to recreate the receiver.
   */
  public String getLocation(boolean forDisplay);

  /**
   * Return the connection timeout value in seconds.
   * A value of 0 means there is no timeout value.
   */
  //public int getTimeout();

  /**
   * Return the username 
   */
  public String getUsername();
  
  /**
   * Return the password 
   */
  public String getPassword();

  /**
   * Return the comment 
   */
  public String getComment();
  
  /**
   * Returns the user information for the location.
   */
  //public IUserInfo getUserInfo(boolean allowModificationOfUsername);

  /**
   * Flush any cahced user information related to the repository location
   */
  public void flushUserInfo();

  /**
   * Validate that the receiver can be used to connect to a repository.
   * An exception is thrown if connection fails
   * 
   * @param monitor the progress monitor used while validating
   */
 // public void validateConnection(IProgressMonitor monitor) throws CVSException;

  /**
   * Set the option to allow the user settings to be cached between sessions.
   * @since 3.0
   */
  public void setAllowCaching(boolean allowCaching);

  /**
   * Returns if the user info for this location is cached
   */
  public boolean getUserInfoCached();

  /**
   * Sets the user information used for this location
   */
  public void setUsername(String username);

  /**
   * Sets the user information used for this location
   */
  public void setPassword(String password);

}
