package com.jcraft.eclipse.jsch.core;

//import org.eclipse.core.runtime.Plugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;

import org.eclipse.jsch.core.IJSchService;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class JSchCorePlugin extends Plugin{
  public static String ID="com.jcraft.eclipse.jsch.core"; //$NON-NLS-1$

  // communication timeout with the server
  public static final int DEFAULT_TIMEOUT=60;
  private int communicationsTimeout = DEFAULT_TIMEOUT;
  
  private static final String INFO_PROXY_USER="org.eclipse.team.cvs.core.proxy.user"; //$NON-NLS-1$ 
  private static final String INFO_PROXY_PASS="org.eclipse.team.cvs.core.proxy.pass"; //$NON-NLS-1$ 

  private static final URL FAKE_URL;
  static{
    URL temp=null;
    try{
      temp=new URL("http://org.eclipse.team.cvs.proxy.auth");//$NON-NLS-1$ 
    }
    catch(MalformedURLException e){
      // Should never fail
    }
    FAKE_URL=temp;
  }

  public static final String PT_AUTHENTICATOR="authenticator"; //$NON-NLS-1$
  
  private static JSchCorePlugin plugin;
  /*
  static String SSH_HOME_DEFAULT=null;
  static{
    String ssh_dir_name=".ssh"; //$NON-NLS-1$

    // Windows doesn't like files or directories starting with a dot.
    if(Platform.getOS().equals(Platform.OS_WIN32)){
      ssh_dir_name="ssh"; //$NON-NLS-1$
    }
    SSH_HOME_DEFAULT=System.getProperty("user.home"); //$NON-NLS-1$
    if(SSH_HOME_DEFAULT!=null){
      SSH_HOME_DEFAULT=SSH_HOME_DEFAULT+java.io.File.separator+ssh_dir_name;
    }
    else{

    }
  }
  */

  public JSchCorePlugin(){
    plugin=this;
  }

  public static JSchCorePlugin getPlugin(){
    return plugin;
  }

  private ServiceTracker tracker;

  public IJSchService getJSchService() {
      return (IJSchService)tracker.getService();
  }
  
  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
   */
  public void start(BundleContext context) throws Exception {
    super.start(context);
    tracker = new ServiceTracker(getBundle().getBundleContext(), IJSchService.class.getName(), null);
      tracker.open();
  }

  /*
   * (non-Javadoc)
   * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
   */
  public void stop(BundleContext context) throws Exception {
    plugin = null;
    super.stop(context);
  }
  
  /**
   * Convenience method for logging CoreExceptions to the plugin log
   */
  public static void log(CoreException e){
    log(e.getStatus().getSeverity(), e.getMessage(), e);
  }

  /**
   * Log the given status. Do not use this method for the IStatus from a CoreException.
   * Use<code>log(CoreException)</code> instead so the stack trace is not lost.
   */
  public static void log(IStatus status){
    getPlugin().getLog().log(status);
  }

  public static void log(int severity, String message, Throwable e){
    log(new Status(severity, ID, 0, message, e));
  }
 
  static IUserAuthenticator getPluggedInAuthenticator(){
    IExtension[] extensions=Platform.getExtensionRegistry().getExtensionPoint(
        ID, PT_AUTHENTICATOR).getExtensions();
    if(extensions.length==0)
      return null;
    IExtension extension=extensions[0];
    IConfigurationElement[] configs=extension.getConfigurationElements();
    if(configs.length==0){
      JSchCorePlugin
          .log(
              IStatus.ERROR,
              NLS
                  .bind(
                      "User autheticator {0} is missing required fields", (new Object[] {extension.getUniqueIdentifier()})), null);//$NON-NLS-1$ 
      return null;
    }
    try{
      IConfigurationElement config=configs[0];
      return (IUserAuthenticator)config.createExecutableExtension("run");//$NON-NLS-1$ 
    }
    catch(CoreException ex){
      JSchCorePlugin
          .log(
              IStatus.ERROR,
              NLS
                  .bind(
                      "Unable to instantiate user authenticator {0}", (new Object[] {extension.getUniqueIdentifier()})), ex);//$NON-NLS-1$ 
      return null;
    }
  }
  
  /**
   * Get the communications timeout value in seconds
   */
  public int getTimeout() {
    return communicationsTimeout;
  }
  
  /**
   * Set the timeout value for communications to a value in seconds.
   * The value must be greater than or equal 0. If is it 0, there is no timeout.
   */
  public void setTimeout(int timeout) {
    this.communicationsTimeout = Math.max(0, timeout);
  }
  
  /**
   * Return the preferences node in the instance scope
   */
  IEclipsePreferences getInstancePreferences() {
    return new InstanceScope().getNode(ID);
  }
  
  private static IEclipsePreferences[] proxyPreferences;
  static IEclipsePreferences[] getProxyPreferenceStore() {
      if (proxyPreferences == null) {
        proxyPreferences=new IEclipsePreferences[]{
            new InstanceScope().getNode("org.eclipse.team.cvs.ui"), //$NON-NLS-1$
            new DefaultScope().getNode("org.eclipse.team.cvs.ui") //$NON-NLS-1$
        };
      }
      return proxyPreferences;
  }

}
