/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ColumnInfo {
    private final String name;
    private final GSType type;
    private final Boolean nullable;
    private final Boolean defaultValueNull;
    private final Set<IndexType> indexTypes;

    ColumnInfo(ColumnInfo info) {
        boolean sameClass;
        try {
            sameClass = info.getClass() == ColumnInfo.class;
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(info, "info", e);
        }
        if (sameClass) {
            this.name = info.name;
            this.type = info.type;
            this.nullable = info.nullable;
            this.defaultValueNull = info.defaultValueNull;
            this.indexTypes = info.indexTypes;
        } else {
            this.name = info.getName();
            this.type = info.getType();
            this.nullable = info.getNullable();
            this.defaultValueNull = info.getDefaultValueNull();
            this.indexTypes = ColumnInfo.getImmutableIndexTypes(info.getIndexTypes());
        }
    }

    public ColumnInfo(String name, GSType type) {
        this(name, type, null);
    }

    public ColumnInfo(String name, GSType type, Set<IndexType> indexTypes) {
        this(name, type, null, indexTypes);
    }

    public ColumnInfo(String name, GSType type, Boolean nullable, Set<IndexType> indexTypes) {
        this(name, type, nullable, null, indexTypes);
    }

    public ColumnInfo(String name, GSType type, Boolean nullable, Boolean defaultValueNull, Set<IndexType> indexTypes) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.defaultValueNull = defaultValueNull;
        this.indexTypes = ColumnInfo.getImmutableIndexTypes(indexTypes);
    }

    public String getName() {
        return this.name;
    }

    public GSType getType() {
        return this.type;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public Boolean getDefaultValueNull() {
        return this.defaultValueNull;
    }

    public Set<IndexType> getIndexTypes() {
        return this.indexTypes;
    }

    private static Set<IndexType> getImmutableIndexTypes(Set<IndexType> src) {
        if (src == null) {
            return null;
        }
        if (src.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(src));
    }

    static Immutable toImmutable(ColumnInfo base) {
        if (base instanceof Immutable) {
            return (Immutable)base;
        }
        return new Immutable(base);
    }

    private static class Immutable
    extends ColumnInfo {
        Immutable(ColumnInfo base) {
            super(base);
        }
    }
}

