/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.IndexInfo;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.RowMapper;
import java.io.Closeable;
import java.net.URL;
import java.sql.Blob;
import java.util.Collection;

public interface Container<K, R>
extends Closeable {
    public boolean put(K var1, R var2) throws GSException;

    public boolean put(R var1) throws GSException;

    public boolean put(Collection<R> var1) throws GSException;

    public R get(K var1) throws GSException;

    public R get(K var1, boolean var2) throws GSException;

    public boolean remove(K var1) throws GSException;

    public Query<R> query(String var1) throws GSException;

    public <S> Query<S> query(String var1, Class<S> var2) throws GSException;

    public Blob createBlob() throws GSException;

    public void commit() throws GSException;

    public void abort() throws GSException;

    public void setAutoCommit(boolean var1) throws GSException;

    public void createIndex(String var1) throws GSException;

    public void createIndex(String var1, IndexType var2) throws GSException;

    public void createIndex(IndexInfo var1) throws GSException;

    public void dropIndex(String var1) throws GSException;

    public void dropIndex(String var1, IndexType var2) throws GSException;

    public void dropIndex(IndexInfo var1) throws GSException;

    @Deprecated
    public void createEventNotification(URL var1) throws GSException;

    @Deprecated
    public void dropEventNotification(URL var1) throws GSException;

    public void createTrigger(TriggerInfo var1) throws GSException;

    public void dropTrigger(String var1) throws GSException;

    public void flush() throws GSException;

    @Override
    public void close() throws GSException;

    public ContainerType getType() throws GSException;

    public R createRow() throws GSException;

    public BindType<K, R, ? extends Container<K, R>> getBindType() throws GSException;

    public static class BindType<K, R, C extends Container<K, R>> {
        private final Class<K> keyClass;
        private final Class<R> rowClass;
        private final Class<? extends Container<?, ?>> containerClass;

        <D extends Container<?, ?>> BindType(Class<K> keyClass, Class<R> rowClass, Class<D> containerClass) throws GSException {
            this.keyClass = keyClass;
            this.rowClass = rowClass;
            this.containerClass = containerClass;
        }

        private static RowMapper.BindingTypeFactory createFactory() {
            return new RowMapper.BindingTypeFactory(){

                @Override
                public <K, R, C extends Container<K, R>, D extends Container<?, ?>> BindType<K, R, C> create(Class<K> keyType, Class<R> rowType, Class<D> containerType) throws GSException {
                    return new BindType(keyType, rowType, containerType);
                }
            };
        }

        public static <K, R extends Row.WithKey<K>> BindType<K, R, ? extends Container<K, R>> of(Class<R> rowClass) throws GSException {
            return BindType.of(RowMapper.BindingTool.resolveKeyClass(rowClass), rowClass);
        }

        public static <K, R> BindType<K, R, ? extends Container<K, R>> of(Class<K> keyClass, Class<R> rowClass) throws GSException {
            return new BindType(RowMapper.BindingTool.checkKeyClass(keyClass, rowClass), rowClass, Container.class);
        }

        public static <R> BindType<Void, R, ? extends Container<Void, R>> noKeyOf(Class<R> rowClass) throws GSException {
            return BindType.of(Void.class, rowClass);
        }

        public Class<K> getKeyClass() {
            return this.keyClass;
        }

        public Class<R> getRowClass() {
            return this.rowClass;
        }

        public Class<? extends Container<?, ?>> getContainerClass() {
            return this.containerClass;
        }

        public K castKey(Object obj) {
            return this.keyClass.cast(obj);
        }

        public R castRow(Object obj) {
            return this.rowClass.cast(obj);
        }

        public C castContainer(Container<?, ?> container) throws GSException {
            if (container == null) {
                return null;
            }
            BindType<?, ?, Container<?, ?>> anotherType = container.getBindType();
            if (this.keyClass != null && this.keyClass != anotherType.keyClass) {
                throw new GSException(145002, "Can not cast container because of different key class (expected=" + this.keyClass.getName() + ", specified=" + anotherType.keyClass.getName() + ")");
            }
            if (this.rowClass != null && this.rowClass != anotherType.rowClass) {
                throw new GSException(145002, "Can not cast container because of different row class (expected=" + this.rowClass.getName() + ", specified=" + anotherType.rowClass.getName() + ")");
            }
            Container<?, ?> typedContainer = this.containerClass.cast(container);
            return (C)typedContainer;
        }

        static {
            RowMapper.BindingTool.setFactory(BindType.createFactory());
        }
    }
}

