/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.GridStoreFactory;
import com.toshiba.mwcloud.gs.PartitionController;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSInterceptorProvider;
import com.toshiba.mwcloud.gs.common.GridStoreFactoryProvider;
import com.toshiba.mwcloud.gs.common.ServiceProviderUtils;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class GSInterceptorFactory
extends GridStoreFactory {
    private static final Class<?>[] BASIC_TYPE_LIST = new Class[]{GridStore.class, Container.class, Collection.class, TimeSeries.class, Query.class, RowSet.class, PartitionController.class};
    private static final Class<?>[][] EXTRA_TYPE_LIST = new Class[][]{{Extensibles.AsStore.class}, {Extensibles.AsContainer.class}, {Extensibles.AsQuery.class}, {Extensibles.AsRowSet.class}, {Extensibles.AsPartitionController.class}, {Experimentals.StoreProvider.class, GridStore.class}, {Experimentals.AsContainer.class}, {Experimentals.AsQuery.class}, {Experimentals.AsRowSet.class}};
    private final Map<Class<?>, Class<?>> basicTypeMap = GSInterceptorFactory.makeBasicTypeMap();
    private final Map<Class<?>, List<Class<?>>> subTypeMap = GSInterceptorFactory.makeSubTypeMap(this.basicTypeMap);
    private final Map<Class<?>, Constructor<?>> proxyConstructorMap = GSInterceptorFactory.makeProxyConstructorMap(this.basicTypeMap, this.subTypeMap);
    private final GridStoreFactory base;
    private final List<GSInterceptorProvider> providerList;

    private GSInterceptorFactory(GridStoreFactory base, List<GSInterceptorProvider> providerList) {
        this.base = base;
        this.providerList = providerList;
    }

    public static GridStoreFactory getInterceptorInstance(Set<Class<?>> chainProviderClasses, Set<Class<?>> visitedProviderClasses) {
        Class<GSInterceptorFactory> loaderClass = GSInterceptorFactory.class;
        List<GSInterceptorProvider> providerList = GSInterceptorFactory.loadProviderList(ServiceProviderUtils.listClassLoaders(loaderClass));
        GridStoreFactoryProvider.ChainProvidable factoryProvidable = GridStoreFactoryProvider.getProvider(GridStoreFactoryProvider.ChainProvidable.class, loaderClass, chainProviderClasses);
        GridStoreFactory base = factoryProvidable.getFactory(chainProviderClasses, visitedProviderClasses);
        if (providerList.isEmpty()) {
            return base;
        }
        return new GSInterceptorFactory(base, providerList);
    }

    private static Map<Class<?>, Class<?>> makeBasicTypeMap() {
        LinkedHashMap map = new LinkedHashMap();
        for (Class<?> clazz : BASIC_TYPE_LIST) {
            map.put(clazz, clazz);
        }
        for (Class<?> clazz : EXTRA_TYPE_LIST) {
            Class<?> interfaceType;
            Class basicType;
            Class<?> type = clazz[0];
            if (((Class<?>)clazz).length > 1) {
                basicType = clazz[1];
                if (map.get(basicType) == null) {
                    throw new IllegalStateException();
                }
                map.put(type, basicType);
                continue;
            }
            basicType = null;
            Class<?>[] classArray = type.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (basicType = (Class)map.get(interfaceType = classArray[i])) == null; ++i) {
            }
            if (basicType == null) {
                throw new IllegalStateException();
            }
            map.put(type, basicType);
        }
        return map;
    }

    private static Map<Class<?>, List<Class<?>>> makeSubTypeMap(Map<Class<?>, Class<?>> basicTypeMap) {
        HashMap map = new HashMap();
        for (Class<?> type : basicTypeMap.keySet()) {
            if (basicTypeMap.get(type) != type) continue;
            for (Class<?> interfaceType : type.getInterfaces()) {
                Class<?> basicType = basicTypeMap.get(interfaceType);
                if (basicType == null || basicType != interfaceType) continue;
                ArrayList list = (ArrayList)map.get(basicType);
                if (list == null) {
                    list = new ArrayList();
                    map.put(basicType, list);
                }
                list.add(type);
            }
        }
        return map;
    }

    private static Map<Class<?>, Constructor<?>> makeProxyConstructorMap(Map<Class<?>, Class<?>> basicTypeMap, Map<Class<?>, List<Class<?>>> subTypeMap) {
        HashMap baseMap = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : basicTypeMap.entrySet()) {
            Class<?> basicType = entry.getValue();
            ArrayList list = (ArrayList)baseMap.get(basicType);
            if (list == null) {
                list = new ArrayList();
                baseMap.put(basicType, list);
            }
            list.add(entry.getKey());
        }
        for (Map.Entry<Class<?>, Object> entry : subTypeMap.entrySet()) {
            for (Class subType : (List)entry.getValue()) {
                ((List)baseMap.get(subType)).addAll((java.util.Collection)baseMap.get(entry.getKey()));
            }
        }
        HashMap map = new HashMap();
        for (Map.Entry entry : baseMap.entrySet()) {
            Constructor<?> constructor;
            Class type = (Class)entry.getKey();
            List list = (List)entry.getValue();
            Class<?> proxyType = Proxy.getProxyClass(type.getClassLoader(), list.toArray(new Class[list.size()]));
            try {
                constructor = proxyType.getConstructor(InvocationHandler.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            map.put(type, constructor);
        }
        return map;
    }

    private static List<GSInterceptorProvider> loadProviderList(List<ClassLoader> classLoaderList) {
        List<GSInterceptorProvider> baseList = ServiceProviderUtils.load(GSInterceptorProvider.class, GSInterceptorProvider.class, classLoaderList, Collections.<Class<?>>emptySet());
        HashMap providerMap = new HashMap();
        for (GSInterceptorProvider provider : baseList) {
            providerMap.put(provider.getClass(), provider);
        }
        return new ArrayList<GSInterceptorProvider>(providerMap.values());
    }

    @Override
    public GridStore getGridStore(Properties properties) throws GSException {
        return (GridStore)this.createInterceptiveInstance(GridStore.class, this.base.getGridStore(properties));
    }

    @Override
    public void setProperties(Properties properties) throws GSException {
        this.base.setProperties(properties);
    }

    @Override
    public void close() throws GSException {
        this.base.close();
    }

    private Object createInterceptiveInstance(Class<?> targetType, Object target) {
        EmptyChain emptyChain;
        Class<?> basicType = targetType;
        List<Class<?>> subList = this.subTypeMap.get(basicType);
        if (subList != null) {
            for (Class<?> subType : subList) {
                if (!subType.isInstance(target)) continue;
                basicType = subType;
                break;
            }
        }
        GSInterceptorProvider.Chain totalChain = emptyChain = EmptyChain.getInstance();
        for (GSInterceptorProvider provider : this.providerList) {
            GSInterceptorProvider.Chain chain = provider.tryCreateChain(totalChain, targetType, target);
            if (chain == null) continue;
            totalChain = chain;
        }
        if (totalChain == emptyChain) {
            return target;
        }
        Constructor<?> constructor = this.proxyConstructorMap.get(basicType);
        if (constructor == null) {
            throw new IllegalStateException();
        }
        try {
            return constructor.newInstance(new Handler(totalChain, basicType, target));
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class EmptyChain
    extends GSInterceptorProvider.Chain {
        private static final EmptyChain INSTANCE = new EmptyChain();

        private EmptyChain() {
            super(null);
        }

        static EmptyChain getInstance() {
            return INSTANCE;
        }

        @Override
        public Object invoke(Class<?> targetType, Object target, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            return method.invoke(target, args);
        }
    }

    private class Handler
    implements InvocationHandler {
        private final GSInterceptorProvider.Chain chain;
        private final Class<?> targetType;
        private final Object target;

        private Handler(GSInterceptorProvider.Chain chain, Class<?> targetType, Object target) {
            this.chain = chain;
            this.targetType = targetType;
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object returnObject;
            Class<?> methodType = method.getDeclaringClass();
            boolean tageted = GSInterceptorFactory.this.basicTypeMap.get(methodType) == methodType;
            try {
                returnObject = tageted ? this.chain.invoke(this.targetType, this.target, method, args) : method.invoke(this.target, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    throw e;
                }
                throw cause;
            }
            if (returnObject != null && tageted) {
                Class<?> returnType = method.getReturnType();
                Class targetType = (Class)GSInterceptorFactory.this.basicTypeMap.get(returnType);
                if (targetType != null) {
                    return GSInterceptorFactory.this.createInterceptiveInstance(targetType, returnObject);
                }
            }
            return returnObject;
        }
    }
}

