/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.GSWrongNodeException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.common.StatementResult;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class NodeConnection
implements Closeable {
    public static final int EE_MAGIC_NUMBER = 65021048;
    private static final int DEFAULT_PROTOCOL_VERSION = 15;
    private static final int STATEMENT_TYPE_NUMBER_V2_OFFSET = 100;
    private static final int SPECIAL_PARTITION_ID = 0;
    private static final StatementResult[] STATEMENT_RESULT_CONSTANTS = StatementResult.values();
    private static volatile boolean detailErrorMessageEnabled = false;
    private static volatile int protocolVersion = 15;
    private static volatile int firstStatementTypeNumber = NodeConnection.statementToNumber(Statement.CONNECT.generalize());
    private static boolean tcpNoDelayEnabled = true;
    private static final LoggingUtils.BaseGridStoreLogger HEARTBEAT_LOGGER = LoggingUtils.getLogger("Heartbeat");
    private static final LoggingUtils.BaseGridStoreLogger IO_LOGGER = LoggingUtils.getLogger("StatementIO");
    private static final Statement[] STATEMENT_LIST = Statement.values();
    private static final String ERROR_PARAM_ADDRESS = "address";
    private static final String ERROR_PARAM_PARTITION_ID = "partitionId";
    private final long statementTimeoutMillis;
    private final long heartbeatTimeoutMillis;
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    private final Integer alternativeVersion;
    private final boolean ipv6Enabled;
    private Set<SocketType> acceptableSocketTypes;
    private Map<SocketType, SocketFactory> socketFactories;
    private AuthMode authMode = Challenge.getDefaultMode();
    private int remoteProtocolVersion;
    private AuthType authType = AuthType.INTERNAL;
    private ConnectionRoute connectionRoute = ConnectionRoute.DEFAULT;
    private boolean responseUnacceptable;
    private long statementId = 0L;
    private long heartbeatReceiveCount;
    private byte[] pendingResp;

    public NodeConnection(InetSocketAddress address, Config config) throws GSException {
        this.statementTimeoutMillis = config.statementTimeoutEnabled ? config.statementTimeoutMillis : Long.MAX_VALUE;
        this.heartbeatTimeoutMillis = config.heartbeatTimeoutMillis;
        try {
            this.socket = NodeConnection.createSocket(config.socketFactories, SocketType.PLAIN, null);
            if (tcpNoDelayEnabled) {
                this.socket.setTcpNoDelay(true);
            }
            this.socket.connect(address, PropertyUtils.timeoutPropertyToIntMillis(config.connectTimeoutMillis));
            this.socket.setSoTimeout(PropertyUtils.timeoutPropertyToIntMillis(Math.min(this.statementTimeoutMillis, this.heartbeatTimeoutMillis)));
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new GSConnectionException(145028, "Failed to connect (address=" + address + ", reason=" + e.getMessage() + ")", e);
        }
        this.alternativeVersion = config.alternativeVersion;
        this.ipv6Enabled = address.getAddress() instanceof Inet6Address;
        this.acceptableSocketTypes = config.acceptableSocketTypes;
        this.socketFactories = config.socketFactories;
    }

    public static void setDetailErrorMessageEnabled(boolean detailErrorMessageEnabled) {
        NodeConnection.detailErrorMessageEnabled = detailErrorMessageEnabled;
    }

    public static int getProtocolVersion() {
        return protocolVersion;
    }

    public int getRemoteProtocolVersion() {
        return this.remoteProtocolVersion;
    }

    public static boolean isSupportedProtocolVersion(int protocolVersion) {
        switch (protocolVersion) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static void setProtocolVersion(int protocolVersion) throws GSException {
        if (!NodeConnection.isSupportedProtocolVersion(protocolVersion)) {
            throw new GSException(145002, "Wrong protocol version (version=" + protocolVersion + ")");
        }
        NodeConnection.protocolVersion = protocolVersion;
        firstStatementTypeNumber = NodeConnection.statementToNumber(Statement.CONNECT.generalize());
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    private static int getEEHeadLength(boolean ipv6Enabled) {
        if (ipv6Enabled) {
            return 32;
        }
        return 20;
    }

    public static int getRequestHeadLength(boolean ipv6Enabled) {
        return NodeConnection.getRequestHeadLength(ipv6Enabled, false);
    }

    public static int getRequestHeadLength(boolean ipv6Enabled, boolean firstStatement) {
        int statementIdSize = NodeConnection.isStatementIdLarge(firstStatement) ? 8 : 4;
        return NodeConnection.getEEHeadLength(ipv6Enabled) + 8 + statementIdSize;
    }

    public static void fillRequestHead(boolean ipv6Enabled, BasicBuffer req) {
        NodeConnection.fillRequestHead(ipv6Enabled, req, false);
    }

    public static void fillRequestHead(boolean ipv6Enabled, BasicBuffer req, boolean firstStatement) {
        req.clear();
        req.prepare(NodeConnection.getRequestHeadLength(ipv6Enabled, firstStatement));
        req.base().putInt(65021048);
        if (ipv6Enabled) {
            req.base().putLong(0L);
            req.base().putLong(0L);
        } else {
            req.base().putInt(0);
        }
        req.base().putInt(0);
        req.base().putInt(-1);
        req.base().putInt(0);
        req.base().putInt(0);
        req.base().putInt(0);
        NodeConnection.putStatementId(req, 0L, firstStatement);
    }

    public static boolean isStatementIdLarge(boolean firstStatement) {
        return !firstStatement && protocolVersion >= 3;
    }

    public static void putStatementId(BasicBuffer req, long statementId) {
        NodeConnection.putStatementId(req, statementId, false);
    }

    public static void putStatementId(BasicBuffer req, long statementId, boolean firstStatement) {
        if (NodeConnection.isStatementIdLarge(firstStatement)) {
            req.putLong(statementId);
        } else {
            req.putInt((int)statementId);
        }
    }

    public static long getStatementId(BasicBuffer resp, boolean firstStatement) {
        if (NodeConnection.isStatementIdLarge(firstStatement)) {
            return resp.base().getLong();
        }
        return resp.base().getInt();
    }

    public static boolean isOptionalRequestEnabled() {
        return protocolVersion >= 3;
    }

    public static boolean isClientIdOnLoginEnabled() {
        return protocolVersion >= 13;
    }

    public static boolean isDatabaseIdEnabled() {
        return protocolVersion >= 14;
    }

    public static void tryPutEmptyOptionalRequest(BasicBuffer req) {
        if (NodeConnection.isOptionalRequestEnabled()) {
            req.putInt(0);
        }
    }

    public void executeStatement(Statement statement, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp) throws GSException {
        this.executeStatement(statement.generalize(), partitionId, statementId, req, resp);
    }

    public void executeStatement(Statement.GeneralStatement statement, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp) throws GSException {
        this.executeStatementDirect(NodeConnection.statementToNumber(statement), partitionId, statementId, req, resp, null);
    }

    public void executeStatementDirect(int statementTypeNumber, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp, Heartbeat heartbeat) throws GSException {
        boolean statementIdMatched;
        int readLength;
        long reqStatementId;
        if (partitionId < 0) {
            throw new GSException(145000, "Internal error by illegal partition ID (partitionId=" + partitionId + ", address=" + this.getRemoteSocketAddress() + ")");
        }
        boolean firstStatement = statementTypeNumber == firstStatementTypeNumber;
        int reqHeadLength = NodeConnection.getRequestHeadLength(this.ipv6Enabled, firstStatement);
        int eeHeadLength = NodeConnection.getEEHeadLength(this.ipv6Enabled);
        int reqLength = req.base().position();
        if (statementId == 0L) {
            while (++this.statementId == 0L) {
            }
            reqStatementId = this.statementId;
        } else {
            reqStatementId = statementId;
        }
        if (IO_LOGGER.isDebugEnabled()) {
            int n = statementTypeNumber - NodeConnection.getStatementNumberOffset();
            String statementName = 0 <= n && n < STATEMENT_LIST.length ? STATEMENT_LIST[n].toString() : "(" + n + ")";
            IO_LOGGER.debug("statementIO.started", statementName, this.getRemoteSocketAddress(), partitionId, reqStatementId);
        }
        req.base().position(eeHeadLength - 4);
        req.base().putInt(reqLength - eeHeadLength);
        req.base().putInt(statementTypeNumber);
        req.base().putInt(partitionId);
        NodeConnection.putStatementId(req, reqStatementId, firstStatement);
        try {
            this.output.write(req.base().array(), 0, reqLength);
        }
        catch (IOException e) {
            throw new GSConnectionException(145028, "Failed to send message (address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
        }
        req.base().clear();
        req.base().position(reqHeadLength);
        if (resp == null) {
            return;
        }
        resp.clear();
        resp.prepare(eeHeadLength);
        resp.base().limit(eeHeadLength);
        try {
            readLength = this.readFully(resp.base().array(), 0, eeHeadLength, resp.base().capacity());
        }
        catch (GSException e) {
            if (this.responseUnacceptable || heartbeat != null || firstStatement) {
                throw e;
            }
            heartbeat = new Heartbeat();
            heartbeat.orgStatementTypeNumber = statementTypeNumber;
            heartbeat.orgStatementId = reqStatementId;
            heartbeat.orgStatementFound = false;
            resp = this.processHeartbeat(partitionId, resp, heartbeat);
            readLength = eeHeadLength;
        }
        if (resp.base().getInt() != 65021048) {
            throw new GSConnectionException(145031, "Protocol error by illegal magic number (address=" + this.getRemoteSocketAddress() + ")");
        }
        resp.base().position(eeHeadLength - 4);
        int respBodyLength = resp.base().getInt();
        int respTotalLength = eeHeadLength + respBodyLength;
        if (readLength > respTotalLength) {
            int orgPendingLength;
            int extraLength = readLength - respTotalLength;
            if (this.pendingResp == null) {
                orgPendingLength = 0;
                this.pendingResp = new byte[extraLength];
            } else {
                orgPendingLength = this.pendingResp.length;
                byte[] orgPendingResp = this.pendingResp;
                this.pendingResp = new byte[orgPendingLength + extraLength];
                System.arraycopy(orgPendingResp, 0, this.pendingResp, 0, orgPendingResp.length);
            }
            System.arraycopy(resp.base().array(), respTotalLength, this.pendingResp, orgPendingLength, extraLength);
        } else if (readLength < respTotalLength) {
            int length = respTotalLength - readLength;
            resp.base().limit(readLength);
            resp.base().position(readLength);
            resp.prepare(length);
            resp.base().position(eeHeadLength);
            this.readFully(resp.base().array(), readLength, length, length);
        }
        resp.base().limit(respTotalLength);
        int respStatementTypeNumber = resp.base().getInt();
        if (respStatementTypeNumber != statementTypeNumber) {
            if (heartbeat == null || respStatementTypeNumber != heartbeat.orgStatementTypeNumber) {
                throw new GSConnectionException(145031, "Protocol error by illegal statement type (address=" + this.getRemoteSocketAddress() + ")");
            }
            heartbeat.orgStatementFound = true;
            boolean orgFirstStatement = heartbeat.orgStatementTypeNumber == firstStatementTypeNumber;
            statementIdMatched = NodeConnection.getStatementId(resp, orgFirstStatement) == heartbeat.orgStatementId;
        } else {
            boolean bl = statementIdMatched = NodeConnection.getStatementId(resp, firstStatement) == reqStatementId;
        }
        if (!statementIdMatched) {
            throw new GSConnectionException(145031, "Protocol error by illegal statement ID (address=" + this.getRemoteSocketAddress() + ")");
        }
        StatementResult result = (StatementResult)resp.getByteEnum(STATEMENT_RESULT_CONSTANTS);
        if (result != StatementResult.SUCCESS) {
            GSException remoteException;
            try {
                remoteException = this.readRemoteException(result, resp, partitionId);
            }
            catch (BufferUnderflowException e) {
                throw new GSConnectionException(145031, "Protocol error by invalid remote error message (result=" + (Object)((Object)result) + ", address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
            }
            remoteException.fillInStackTrace();
            if (heartbeat != null && respStatementTypeNumber == firstStatementTypeNumber) {
                throw new GSConnectionException(145028, "Connection problem occurred by invalid heartbeat response (result=" + (Object)((Object)result) + ", address=" + this.getRemoteSocketAddress() + ", reason=" + remoteException.getMessage() + ")", remoteException);
            }
            throw remoteException;
        }
        if (heartbeat != null && heartbeat.orgException != null) {
            throw heartbeat.orgException;
        }
    }

    private int readFully(byte[] value, int offset, int length, int maxLength) throws GSException {
        int pos = offset;
        if (this.pendingResp != null) {
            int consumed = Math.min(this.pendingResp.length, maxLength);
            System.arraycopy(this.pendingResp, 0, value, pos, consumed);
            pos += consumed;
            this.pendingResp = (byte[])(this.pendingResp.length == consumed ? null : Arrays.copyOfRange(this.pendingResp, consumed, this.pendingResp.length));
        }
        int endPos = offset + length;
        int maxEndPos = offset + maxLength;
        try {
            int last;
            do {
                if ((last = this.input.read(value, pos, maxEndPos - pos)) >= 0) continue;
                throw new GSConnectionException(145028, "Connection unexpectedly terminated (address=" + this.getRemoteSocketAddress() + ")");
            } while ((pos += last) < endPos);
            return pos - offset;
        }
        catch (GSConnectionException e) {
            throw e;
        }
        catch (IOException e) {
            boolean timeoutOccurred = e instanceof SocketTimeoutException;
            if (!timeoutOccurred || pos != offset) {
                this.responseUnacceptable = true;
            }
            if (timeoutOccurred) {
                throw new GSConnectionException(145029, "Connection timed out on receiving (receivedSize=" + (pos - offset) + ", totalSize=" + length + ", address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
            }
            throw new GSConnectionException(145028, "Connection problem occurred on receiving (receivedSize=" + (pos - offset) + ", totalSize=" + length + ", address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
        }
    }

    private BasicBuffer processHeartbeat(int partitionId, BasicBuffer resp, Heartbeat heartbeat) throws GSException {
        BasicBuffer heartbeatBuf = this.createRequestBuffer();
        int eeHeadLength = NodeConnection.getEEHeadLength(this.ipv6Enabled);
        long startTime = System.currentTimeMillis();
        long initialMillis = Math.min(this.statementTimeoutMillis, this.heartbeatTimeoutMillis);
        while (true) {
            long elapsedMillis;
            if ((elapsedMillis = System.currentTimeMillis() - startTime + initialMillis) >= this.statementTimeoutMillis) {
                throw new GSConnectionException(145029, "Connection timed out by statement timeout (elapsedMillis=" + elapsedMillis + ", statementTimeoutMillis=" + this.statementTimeoutMillis + ", address=" + this.getRemoteSocketAddress() + ")");
            }
            if (HEARTBEAT_LOGGER.isInfoEnabled()) {
                int n = heartbeat.orgStatementTypeNumber - NodeConnection.getStatementNumberOffset();
                String statementName = 0 <= n && n < STATEMENT_LIST.length ? STATEMENT_LIST[n].toString() : "(" + n + ")";
                HEARTBEAT_LOGGER.info("heartbeat.started", statementName, this.getRemoteSocketAddress(), partitionId, heartbeat.orgStatementId, elapsedMillis);
            }
            while (++this.statementId == 0L) {
            }
            long lastHeartbeatId = this.statementId;
            BasicBuffer heartbeatReq = heartbeatBuf;
            this.putConnectRequest(heartbeatReq);
            try {
                this.executeStatementDirect(firstStatementTypeNumber, 0, lastHeartbeatId, heartbeatReq, resp, heartbeat);
            }
            catch (GSStatementException e) {
                heartbeat.orgException = e;
            }
            ++this.heartbeatReceiveCount;
            if (heartbeat.orgStatementFound) {
                resp = heartbeatBuf;
                resp.clear();
                resp.prepare(eeHeadLength);
                resp.base().limit(eeHeadLength);
                this.readFully(resp.base().array(), 0, eeHeadLength, eeHeadLength);
                heartbeat.orgStatementTypeNumber = firstStatementTypeNumber;
                heartbeat.orgStatementId = lastHeartbeatId;
                return resp;
            }
            resp.clear();
            resp.prepare(eeHeadLength);
            resp.base().limit(eeHeadLength);
            try {
                this.readFully(resp.base().array(), 0, eeHeadLength, eeHeadLength);
                return resp;
            }
            catch (GSException e) {
                if (!this.responseUnacceptable) continue;
                throw new GSConnectionException(145028, "Connection problem occurred after heartbeat (elapsedMillis=" + elapsedMillis + ", address=" + this.getRemoteSocketAddress() + ", reason=" + e.getMessage() + ")", e);
            }
            break;
        }
    }

    private GSException readRemoteException(StatementResult result, BasicBuffer resp, int partitionId) throws BufferUnderflowException {
        int count = resp.base().getInt();
        int topCode = 0;
        String topMessage = null;
        int majorCode = 0;
        String majorMessage = null;
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            int code = resp.base().getInt();
            String message = resp.getString();
            String typeName = resp.getString();
            String fileName = resp.getString();
            String functionName = resp.getString();
            int line = resp.base().getInt();
            if (i == 0) {
                topCode = code;
                topMessage = message;
            }
            boolean majorCodeUpdated = false;
            if (code != 0 && !typeName.endsWith("PlatformException")) {
                majorCodeUpdated = true;
                majorCode = code;
            }
            if (!detailErrorMessageEnabled) {
                if (message.isEmpty()) continue;
                if (majorCodeUpdated) {
                    majorMessage = message;
                    continue;
                }
                if (majorCode != 0) continue;
                majorMessage = "minorCode=" + code + " : " + message;
                continue;
            }
            if (i > 0) {
                messageBuilder.append(" by ");
            }
            if (typeName.isEmpty()) {
                messageBuilder.append("(Unknown exception)");
            } else {
                messageBuilder.append(typeName);
            }
            if (!fileName.isEmpty()) {
                messageBuilder.append(" ").append(fileName);
            }
            if (!functionName.isEmpty()) {
                messageBuilder.append(" ").append(functionName);
            }
            if (line > 0) {
                messageBuilder.append(" line=").append(line);
            }
            if (code != 0) {
                messageBuilder.append(" code=").append(code);
            }
            if (message.isEmpty()) continue;
            messageBuilder.append(" : ").append(message);
        }
        String errorName = null;
        if (resp.base().remaining() > 0) {
            errorName = resp.getString();
            if (errorName.isEmpty()) {
                errorName = null;
            } else {
                majorCode = topCode;
                majorMessage = topMessage;
            }
        }
        Map<String, String> paremeters = GSErrorCode.newParameters();
        if (resp.base().remaining() > 0) {
            int paramCount = resp.base().getInt();
            for (int i = 0; i < paramCount; ++i) {
                String name = resp.getString();
                String value = resp.getString();
                paremeters.put(name, value);
            }
        }
        if (!detailErrorMessageEnabled && majorMessage != null) {
            messageBuilder.append(majorMessage);
        }
        if (messageBuilder.length() > 0) {
            messageBuilder.append(" ");
        }
        messageBuilder.append("(");
        GSErrorCode.addParameter(messageBuilder, paremeters, ERROR_PARAM_ADDRESS, NodeConnection.socketAddressToString(this.getRemoteSocketAddress()), true);
        GSErrorCode.addParameter(messageBuilder, paremeters, ERROR_PARAM_PARTITION_ID, Integer.toString(partitionId), false);
        messageBuilder.append(")");
        switch (result) {
            case STATEMENT_ERROR: {
                return new GSStatementException(majorCode == 0 ? 145027 : majorCode, errorName, messageBuilder.toString(), paremeters, null);
            }
            case DENY: {
                return new GSWrongNodeException(majorCode == 0 ? 145030 : majorCode, errorName, messageBuilder.toString(), paremeters, null);
            }
        }
        return new GSConnectionException(majorCode == 0 ? 145028 : majorCode, errorName, messageBuilder.toString(), paremeters, null);
    }

    private void putConnectRequest(BasicBuffer req) {
        req.base().position(NodeConnection.getRequestHeadLength(this.ipv6Enabled, true));
        req.putInt(this.alternativeVersion == null ? protocolVersion : this.alternativeVersion);
        this.putControlInfo(req);
    }

    private void acceptConnectResponse(BasicBuffer resp) throws GSException {
        this.authMode = Challenge.getMode(resp);
        if (resp.base().remaining() > 0) {
            int version = resp.base().getInt();
            if (version == 0 || this.remoteProtocolVersion != 0 && version != this.remoteProtocolVersion) {
                throw new GSConnectionException(145031, "Protocol error by illegal remote version (version=" + version + ")");
            }
            this.remoteProtocolVersion = version;
        }
        if (resp.base().remaining() > 0) {
            this.authType = resp.getByteEnum(AuthType.class);
        }
        this.acceptControlInfo(resp);
    }

    private void putControlInfo(BasicBuffer req) {
        int headPos = req.base().position();
        req.putInt(0);
        int bodyPos = req.base().position();
        req.putBoolean(this.acceptableSocketTypes.contains((Object)SocketType.PLAIN));
        req.putBoolean(this.acceptableSocketTypes.contains((Object)SocketType.SECURE));
        int endPos = req.base().position();
        req.base().position(headPos);
        int bodySize = endPos - bodyPos;
        req.putInt(bodySize);
        req.base().position(endPos);
    }

    private void acceptControlInfo(BasicBuffer resp) throws GSException {
        EnumSet<SocketType> respTypes = EnumSet.noneOf(SocketType.class);
        if (resp.base().remaining() <= 0) {
            respTypes.add(SocketType.PLAIN);
        } else {
            int bodySize = BasicBuffer.BufferUtils.getIntSize(resp.base());
            int limit = BasicBuffer.BufferUtils.limitForward(resp.base(), bodySize);
            if (resp.getBoolean()) {
                respTypes.add(SocketType.PLAIN);
            }
            if (resp.getBoolean()) {
                respTypes.add(SocketType.SECURE);
            }
            BasicBuffer.BufferUtils.restoreLimit(resp.base(), limit);
        }
        EnumSet<SocketType> nextTypes = EnumSet.copyOf(this.acceptableSocketTypes);
        nextTypes.retainAll(respTypes);
        if (nextTypes.isEmpty()) {
            throw new GSException(145044, "Requested security options not supported (requested={plain:" + this.acceptableSocketTypes.contains((Object)SocketType.PLAIN) + ", secure:" + this.acceptableSocketTypes.contains((Object)SocketType.SECURE) + "}, supported={plain:" + respTypes.contains((Object)SocketType.PLAIN) + ", secure:" + respTypes.contains((Object)SocketType.SECURE) + "})");
        }
        if (!this.socketFactories.isEmpty()) {
            this.changeTransportMethod(nextTypes);
        }
    }

    private void changeTransportMethod(Set<SocketType> nextTypes) throws GSException {
        Map<SocketType, SocketFactory> socketFactories = this.socketFactories;
        this.socketFactories = Collections.emptyMap();
        if (!nextTypes.contains((Object)SocketType.SECURE)) {
            this.acceptableSocketTypes = EnumSet.of(SocketType.PLAIN);
            return;
        }
        this.acceptableSocketTypes = EnumSet.of(SocketType.SECURE);
        this.socket = NodeConnection.createSocket(socketFactories, SocketType.SECURE, this.socket);
        try {
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
        }
        catch (IOException e) {
            throw new GSConnectionException(e);
        }
    }

    public void connect(BasicBuffer req, BasicBuffer resp) throws GSException {
        req = req == null ? this.createRequestBuffer() : req;
        resp = resp == null ? this.createOutput() : resp;
        this.putConnectRequest(req);
        this.executeStatement(Statement.CONNECT.generalize(), 0, 0L, req, resp);
        this.acceptConnectResponse(resp);
    }

    public void disconnect(BasicBuffer req, BasicBuffer resp) throws GSException {
        req = req == null ? this.createRequestBuffer() : req;
        req.base().position(NodeConnection.getRequestHeadLength(this.ipv6Enabled, false));
        NodeConnection.tryPutEmptyOptionalRequest(req);
        this.executeStatement(Statement.DISCONNECT.generalize(), 0, 0L, req, null);
        this.closeImmediately();
    }

    public void login(BasicBuffer req, BasicBuffer resp, LoginInfo loginInfo, long[] databaseId) throws GSException {
        long respDatabaseId;
        Challenge challenge = this.loginInternal(req = req == null ? this.createRequestBuffer() : req, resp = resp == null ? this.createOutput() : resp, loginInfo, null);
        if (challenge != null) {
            this.loginInternal(req, resp, loginInfo, challenge);
        }
        if (resp.base().remaining() > 0) {
            respDatabaseId = resp.base().getLong();
        } else {
            if (NodeConnection.isDatabaseIdEnabled()) {
                throw new GSConnectionException(145031, "Protocol error by lack of database ID");
            }
            respDatabaseId = ContainerKeyConverter.getPublicDatabaseId();
        }
        if (databaseId != null) {
            databaseId[0] = respDatabaseId;
        }
    }

    private Challenge loginInternal(BasicBuffer req, BasicBuffer resp, LoginInfo loginInfo, Challenge lastChallenge) throws GSException {
        req.base().position(NodeConnection.getRequestHeadLength(this.ipv6Enabled, false));
        AuthType authType = this.resolveAuthType(loginInfo.authType, loginInfo.user);
        if (NodeConnection.isOptionalRequestEnabled()) {
            OptionalRequest request = new OptionalRequest();
            if (loginInfo.transactionTimeoutSecs >= 0) {
                request.put(OptionalRequestType.TRANSACTION_TIMEOUT, loginInfo.transactionTimeoutSecs);
            }
            if (loginInfo.database != null) {
                request.put(OptionalRequestType.DB_NAME, loginInfo.database);
            }
            if (loginInfo.clientId != null && NodeConnection.isClientIdOnLoginEnabled()) {
                request.put(OptionalRequestType.CLIENT_ID, loginInfo.clientId);
            }
            if (loginInfo.applicationName != null) {
                request.put(OptionalRequestType.APPLICATION_NAME, loginInfo.applicationName);
            }
            if (loginInfo.storeMemoryAgingSwapRate >= 0.0) {
                request.put(OptionalRequestType.STORE_MEMORY_AGING_SWAP_RATE, loginInfo.storeMemoryAgingSwapRate);
            }
            if (loginInfo.timeZoneOffset != null) {
                request.put(OptionalRequestType.TIME_ZONE_OFFSET, loginInfo.timeZoneOffset.getRawOffset());
            }
            if (authType != AuthType.INTERNAL) {
                request.put(OptionalRequestType.AUTHENTICATION_TYPE, (byte)authType.ordinal());
            }
            if (loginInfo.isPublicConnection()) {
                request.put(OptionalRequestType.CONNECTION_ROUTE, (byte)loginInfo.getConnectionRoute().ordinal());
            }
            request.format(req);
        }
        req.putString(loginInfo.user);
        req.putString(Challenge.build(this.authMode, lastChallenge, loginInfo.passwordDigest, authType));
        req.putInt(PropertyUtils.timeoutPropertyToIntSeconds(this.statementTimeoutMillis));
        req.putBoolean(loginInfo.ownerMode);
        req.putString(loginInfo.clusterName == null ? "" : loginInfo.clusterName);
        Challenge.putRequest(req, this.authMode, lastChallenge);
        this.executeStatement(Statement.LOGIN.generalize(), 0, 0L, req, resp);
        AuthMode[] resultMode = new AuthMode[]{this.authMode};
        Challenge respChallenge = Challenge.getResponse(resp, resultMode, lastChallenge);
        this.authMode = resultMode[0];
        return respChallenge;
    }

    private AuthType resolveAuthType(AuthType specifiedType, String user) throws GSException {
        boolean nonInternalSpecified = specifiedType != null && specifiedType != AuthType.INTERNAL;
        AuthType type = this.authType;
        if (type == AuthType.INTERNAL || specifiedType == AuthType.INTERNAL) {
            if (nonInternalSpecified) {
                throw new GSException(145044, "Unavailable authentication type for target node (authentication=" + specifiedType.toPropertyString() + ", user=" + user + ", address=" + this.getRemoteSocketAddress() + ")");
            }
            return AuthType.INTERNAL;
        }
        if (UserTypeUtils.checkAdmin(user)) {
            if (nonInternalSpecified) {
                throw new GSException(145005, "Illegal authentication type for admin user (authentication=" + specifiedType.toPropertyString() + ", user=" + user + ")");
            }
            return AuthType.INTERNAL;
        }
        return type;
    }

    public void reuse(BasicBuffer req, BasicBuffer resp, LoginInfo loginInfo, long[] databaseId) throws GSException {
        this.login(req, resp, loginInfo, databaseId);
    }

    public void logout(BasicBuffer req, BasicBuffer resp) throws GSException {
        req = req == null ? this.createRequestBuffer() : req;
        resp = resp == null ? this.createOutput() : resp;
        req.base().position(NodeConnection.getRequestHeadLength(this.ipv6Enabled, false));
        NodeConnection.tryPutEmptyOptionalRequest(req);
        this.executeStatement(Statement.LOGOUT.generalize(), 0, 0L, req, resp);
    }

    public long getHeartbeatReceiveCount() {
        return this.heartbeatReceiveCount;
    }

    public static String getDigest(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(password.getBytes(BasicBuffer.DEFAULT_CHARSET));
            StringBuilder builder = new StringBuilder();
            for (byte b : md.digest()) {
                builder.append(String.format("%02x", b));
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Internal error while calculating digest", e);
        }
    }

    public static int statementToNumber(Statement statement) {
        return NodeConnection.statementToNumber(statement.generalize());
    }

    public static int statementToNumber(Statement.GeneralStatement statement) {
        return statement.ordinal() + NodeConnection.getStatementNumberOffset();
    }

    public static int getStatementNumberOffset() {
        if (protocolVersion < 2) {
            return 0;
        }
        return 100;
    }

    public static String socketAddressToString(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            return socketAddress.toString();
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress address = inetSocketAddress.getAddress();
        int port = inetSocketAddress.getPort();
        StringBuilder builder = new StringBuilder();
        if (address instanceof Inet6Address) {
            builder.append("[");
            builder.append(address.getHostAddress());
            builder.append("]");
        } else if (address != null) {
            builder.append(address.getHostAddress());
        }
        builder.append(":");
        builder.append(port);
        return builder.toString();
    }

    private BasicBuffer createRequestBuffer() {
        BasicBuffer req = new BasicBuffer(64);
        NodeConnection.fillRequestHead(this.ipv6Enabled, req, false);
        return req;
    }

    private BasicBuffer createOutput() {
        return new BasicBuffer(64);
    }

    public void closeImmediately() throws GSException {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            throw new GSException(145028, "Connection problem occurred on closing (reason=" + e.getMessage() + ")", e);
        }
    }

    @Override
    public void close() throws GSException {
        try {
            if (!this.socket.isClosed()) {
                this.disconnect(null, null);
            }
        }
        finally {
            this.closeImmediately();
        }
    }

    private static Socket createSocket(Map<SocketType, SocketFactory> factoryMap, SocketType type, Socket base) throws GSException {
        SocketFactory factory = factoryMap.get((Object)type);
        if (factory == null) {
            throw new GSException(145000, "");
        }
        try {
            if (base != null) {
                InetSocketAddress address = (InetSocketAddress)base.getRemoteSocketAddress();
                return ((SSLSocketFactory)factory).createSocket(base, address.getHostName(), address.getPort(), true);
            }
            return factory.createSocket();
        }
        catch (IOException e) {
            throw new GSException(e);
        }
    }

    public static abstract class BytesRequestFormatter
    implements RequestFormatter {
        @Override
        public abstract void format(BasicBuffer var1) throws GSException;

        public byte[] format() throws GSException {
            return BytesRequestFormatter.toBytes(this);
        }

        public static byte[] toBytes(RequestFormatter formatter) throws GSException {
            BasicBuffer buf = new BasicBuffer(0);
            formatter.format(buf);
            buf.base().flip();
            byte[] bytes = new byte[buf.base().remaining()];
            buf.base().get(bytes);
            return bytes;
        }
    }

    public static interface RequestFormatter {
        public void format(BasicBuffer var1) throws GSException;
    }

    public static class OptionalRequest
    implements OptionalRequestSource {
        private static final int RANGE_SIZE = 1000;
        private static final int RANGE_START_ID = 11000;
        private final Map<OptionalRequestType, Object> requestMap = new EnumMap<OptionalRequestType, Object>(OptionalRequestType.class);
        private SortedMap<Integer, byte[]> extRequestMap;

        @Override
        public boolean hasOptions() {
            return !this.requestMap.isEmpty() || this.extRequestMap == null || !this.extRequestMap.isEmpty();
        }

        @Override
        public void putOptions(OptionalRequest optionalRequest) {
            optionalRequest.requestMap.putAll(this.requestMap);
            if (this.extRequestMap != null) {
                optionalRequest.putExtAll(this.extRequestMap);
            }
        }

        public void clear() {
            this.requestMap.clear();
            this.extRequestMap = null;
        }

        public void putFeatureVersion(FeatureVersion version) {
            this.put(OptionalRequestType.LEGACY_VERSION_BLOCK, (byte)1);
            this.put(OptionalRequestType.FEATURE_VERSION, version.ordinal());
        }

        public void putAcceptableFeatureVersion(FeatureVersion version) {
            this.put(OptionalRequestType.ACCEPTABLE_FEATURE_VERSION, version.ordinal());
        }

        public void put(OptionalRequestType type, Object value) {
            this.requestMap.put(type, type.valueType().cast(value));
        }

        public void putExt(int type, byte[] value) {
            if (this.extRequestMap == null) {
                this.extRequestMap = new TreeMap<Integer, byte[]>();
            }
            if (type <= 11000 || type >= Short.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.extRequestMap.put(type, value);
        }

        public void putExtAll(SortedMap<Integer, byte[]> src) {
            if (this.extRequestMap == null) {
                this.extRequestMap = new TreeMap<Integer, byte[]>();
            }
            this.extRequestMap.putAll(src);
        }

        public void format(BasicBuffer req) {
            Object value;
            if (!this.hasOptions()) {
                req.putInt(0);
                return;
            }
            int lastRangeId = 0;
            int rangeHeadPos = -1;
            int rangeBodyPos = -1;
            int headPos = req.base().position();
            req.putInt(0);
            int bodyPos = req.base().position();
            OptionalRequestIterator iterator = new OptionalRequestIterator(this.requestMap, this.extRequestMap);
            while ((value = iterator.next()) != null) {
                int rangeId;
                int id = iterator.getId();
                if (id >= 11000 && (rangeId = id / 1000) != lastRangeId) {
                    if (lastRangeId != 0) {
                        OptionalRequest.putBodySize(req, rangeHeadPos, rangeBodyPos);
                    }
                    req.putShort((short)(rangeId * 1000));
                    rangeHeadPos = req.base().position();
                    req.putInt(0);
                    rangeBodyPos = req.base().position();
                    lastRangeId = rangeId;
                }
                req.putShort((short)id);
                Class<?> valueType = iterator.getValueType();
                if (valueType == Integer.class) {
                    req.putInt((Integer)value);
                    continue;
                }
                if (valueType == Long.class) {
                    req.putLong((Long)value);
                    continue;
                }
                if (valueType == Boolean.class) {
                    req.putBoolean((Boolean)value);
                    continue;
                }
                if (valueType == String.class) {
                    req.putString((String)value);
                    continue;
                }
                if (valueType == Byte.class) {
                    req.put((Byte)value);
                    continue;
                }
                if (valueType == Double.class) {
                    req.putDouble((Double)value);
                    continue;
                }
                if (valueType == ClientId.class) {
                    ClientId clientId = (ClientId)value;
                    req.putLong(clientId.getSessionId());
                    req.putUUID(clientId.getUUID());
                    continue;
                }
                if (valueType == byte[].class) {
                    byte[] bytes = (byte[])value;
                    req.prepare(bytes.length);
                    req.base().put(bytes);
                    continue;
                }
                throw new Error("Internal error by illegal value type");
            }
            if (lastRangeId != 0) {
                OptionalRequest.putBodySize(req, rangeHeadPos, rangeBodyPos);
            }
            OptionalRequest.putBodySize(req, headPos, bodyPos);
        }

        private static void putBodySize(BasicBuffer req, int headPos, int bodyPos) {
            int endPos = req.base().position();
            req.base().position(headPos);
            req.putInt(endPos - bodyPos);
            req.base().position(endPos);
        }
    }

    public static interface OptionalRequestSource {
        public boolean hasOptions();

        public void putOptions(OptionalRequest var1);
    }

    private static class OptionalRequestIterator {
        private Iterator<Map.Entry<OptionalRequestType, Object>> base;
        private Iterator<Map.Entry<Integer, byte[]>> ext;
        private Integer id;
        private Class<?> valueType;

        OptionalRequestIterator(Map<OptionalRequestType, Object> requestMap, SortedMap<Integer, byte[]> extRequestMap) {
            if (!requestMap.isEmpty()) {
                this.base = requestMap.entrySet().iterator();
            }
            if (extRequestMap != null && !extRequestMap.isEmpty()) {
                this.ext = extRequestMap.entrySet().iterator();
            }
        }

        Object next() {
            Object nextValue;
            if (this.base != null) {
                Map.Entry<OptionalRequestType, Object> entry = this.base.next();
                nextValue = entry.getValue();
                this.id = entry.getKey().id();
                this.valueType = entry.getKey().valueType();
                if (!this.base.hasNext()) {
                    this.base = null;
                }
            } else if (this.ext != null) {
                Map.Entry<Integer, byte[]> entry = this.ext.next();
                nextValue = entry.getValue();
                this.id = entry.getKey();
                this.valueType = byte[].class;
                if (!this.ext.hasNext()) {
                    this.ext = null;
                }
            } else {
                nextValue = null;
                this.id = null;
                this.valueType = null;
            }
            return nextValue;
        }

        public int getId() {
            if (this.id == null) {
                throw new IllegalStateException();
            }
            return this.id;
        }

        public Class<?> getValueType() {
            if (this.valueType == null) {
                throw new IllegalStateException();
            }
            return this.valueType;
        }
    }

    public static enum OptionalRequestType {
        LEGACY_VERSION_BLOCK(0, Byte.class),
        TRANSACTION_TIMEOUT(1, Integer.class),
        FOR_UPDATE(2, Boolean.class),
        CONTAINER_LOCK_REQUIRED(3, Boolean.class),
        SYSTEM_MODE(4, Boolean.class),
        DB_NAME(5, String.class),
        CONTAINER_ATTRIBUTE(6, Integer.class),
        ROW_INSERT_UPDATE(7, Integer.class),
        REQUEST_MODULE_TYPE(8, Byte.class),
        STATEMENT_TIMEOUT(10001, Integer.class),
        FETCH_LIMIT(10002, Long.class),
        FETCH_SIZE(10003, Long.class),
        CLIENT_ID(11001, ClientId.class),
        FETCH_BYTES_SIZE(11002, Integer.class),
        META_CONTAINER_ID(11003, Long.class),
        FEATURE_VERSION(11004, Integer.class),
        ACCEPTABLE_FEATURE_VERSION(11005, Integer.class),
        CONTAINER_VISIBILITY(11006, Integer.class),
        META_NAMING_TYPE(11007, Byte.class),
        QUERY_CONTAINER_KEY(11008, byte[].class),
        APPLICATION_NAME(11009, String.class),
        STORE_MEMORY_AGING_SWAP_RATE(11010, Double.class),
        TIME_ZONE_OFFSET(11011, Long.class),
        AUTHENTICATION_TYPE(11012, Byte.class),
        CONNECTION_ROUTE(11013, Byte.class);

        private final int id;
        private final Class<?> valueType;

        private OptionalRequestType(int id, Class<?> valueType) {
            this.id = id;
            this.valueType = valueType;
        }

        public int id() {
            return this.id;
        }

        public Class<?> valueType() {
            return this.valueType;
        }
    }

    public static class MessageDigestFactory {
        public static final MessageDigestFactory SHA256 = new MessageDigestFactory("SHA-256");
        public static final MessageDigestFactory MD5 = new MessageDigestFactory("MD5");
        private final String algorithm;
        private final MessageDigest md;
        private final boolean cloneable;

        private MessageDigestFactory(String algorithm) {
            this.algorithm = algorithm;
            this.md = MessageDigestFactory.create(algorithm);
            boolean cloneable = false;
            try {
                cloneable = this.md.clone() instanceof MessageDigest;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            this.cloneable = cloneable;
        }

        private static MessageDigest create(String algorithm) {
            try {
                return MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("Internal error while calculating digest", e);
            }
        }

        public MessageDigest create() {
            if (this.cloneable) {
                try {
                    return (MessageDigest)this.md.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return MessageDigestFactory.create(this.algorithm);
        }
    }

    public static enum FeatureVersion {
        V4_0,
        V4_1,
        V4_2,
        V4_3,
        V4_5;

    }

    public static class PasswordDigest {
        private final String basicSecret;
        private final String cryptBase;
        private final String challengeBase;
        private final transient String password;

        public PasswordDigest(String basicSecret, String cryptSecret, String challengeBase, String password) {
            this.basicSecret = basicSecret;
            this.cryptBase = cryptSecret;
            this.challengeBase = challengeBase;
            this.password = password;
        }

        public String getBasicSecret() {
            return this.basicSecret;
        }
    }

    public static class UserTypeUtils {
        private static final String ADMIN_USER = "admin";
        private static final String SYSTEM_USER = "system";
        private static final String SPECIAL_USER_SYMBOL = "#";

        public static boolean checkAdmin(String userName) {
            return userName.equals(ADMIN_USER) || userName.equals(SYSTEM_USER) || userName.contains(SPECIAL_USER_SYMBOL);
        }
    }

    public static class Challenge {
        private static final AuthMode DEFAULT_MODE = AuthMode.CHALLENGE;
        private static final String DEFAULT_METHOD = "POST";
        private static final String DEFAULT_REALM = "DB_Auth";
        private static final String DEFAULT_URI = "/";
        private static final String DEFAULT_QOP = "auth";
        private static final Random RANDOM = new SecureRandom();
        private static boolean challengeEnabled = false;
        private final boolean challenging;
        private final String nonce;
        private final String nc;
        private final String opaque;
        private final String baseSalt;
        private String cnonce;

        public Challenge() {
            this.challenging = false;
            this.nonce = null;
            this.nc = null;
            this.opaque = null;
            this.baseSalt = null;
        }

        public Challenge(String nonce, String nc, String opaque, String baseSalt) {
            this.challenging = true;
            this.nonce = nonce;
            this.nc = nc;
            this.opaque = opaque;
            this.baseSalt = baseSalt;
        }

        public static boolean isChallenging(Challenge challenge) {
            return challenge != null && challenge.challenging;
        }

        public static PasswordDigest makeDigest(String user, String password) {
            return new PasswordDigest(Challenge.sha256Hash(password), Challenge.sha256Hash(user + ":" + password), Challenge.md5Hash(user + ":" + DEFAULT_REALM + ":" + password), password);
        }

        public static void putRequest(BasicBuffer out, AuthMode mode, Challenge lastChallenge) throws GSException {
            if (mode == AuthMode.NONE) {
                out.putByteEnum(mode);
                return;
            }
            out.putByteEnum(mode);
            boolean challenged = Challenge.isChallenging(lastChallenge);
            out.putBoolean(challenged);
            if (challenged) {
                out.putString(lastChallenge.opaque);
                out.putString(lastChallenge.cnonce);
            }
        }

        public static Challenge getResponse(BasicBuffer in, AuthMode[] mode, Challenge lastChallenge) throws GSException {
            AuthMode respMode = Challenge.getMode(in);
            if (respMode != AuthMode.NONE && !challengeEnabled) {
                throw new GSConnectionException(145031, "");
            }
            if (respMode != mode[0]) {
                if (respMode == AuthMode.BASIC) {
                    mode[0] = respMode;
                    return new Challenge();
                }
                throw new GSConnectionException(145031, "");
            }
            if (respMode == AuthMode.NONE) {
                return null;
            }
            boolean respChallenging = in.getBoolean();
            boolean challenging = Challenge.isChallenging(lastChallenge);
            if (respMode != AuthMode.BASIC && !(respChallenging ^ challenging)) {
                throw new GSConnectionException(145031, "");
            }
            if (respChallenging) {
                String nonce = in.getString();
                String nc = in.getString();
                String opaque = in.getString();
                String baseSalt = in.getString();
                return new Challenge(nonce, nc, opaque, baseSalt);
            }
            return null;
        }

        public static String build(AuthMode mode, Challenge challenge, PasswordDigest digest, AuthType type) {
            if (type == AuthType.EXTERNAL_LDAP) {
                return digest.password;
            }
            if (!Challenge.isChallenging(challenge)) {
                if (mode == AuthMode.CHALLENGE) {
                    return "";
                }
                return digest.basicSecret;
            }
            return challenge.build(digest);
        }

        public String getOpaque() {
            return this.opaque;
        }

        public String getLastCNonce() {
            return this.cnonce;
        }

        public static String generateCNonce() {
            return Challenge.randomHexString(4);
        }

        public String build(PasswordDigest digest) {
            String cnonce = Challenge.generateCNonce();
            String result = this.build(digest, cnonce);
            this.cnonce = cnonce;
            return result;
        }

        public String build(PasswordDigest digest, String cnonce) {
            return "#1#" + this.getChallengeDigest(digest, cnonce) + "#" + this.getCryptSecret(digest);
        }

        public String getChallengeDigest(PasswordDigest digest, String cnonce) {
            String ha1 = Challenge.md5Hash(digest.challengeBase + ":" + this.nonce + ":" + cnonce);
            String ha2 = Challenge.md5Hash("POST:/");
            return Challenge.md5Hash(ha1 + ":" + this.nonce + ":" + this.nc + ":" + cnonce + ":" + DEFAULT_QOP + ":" + ha2);
        }

        public String getCryptSecret(PasswordDigest digest) {
            return Challenge.sha256Hash(this.baseSalt + ":" + digest.cryptBase);
        }

        public static String sha256Hash(String value) {
            return Challenge.hash(value, MessageDigestFactory.SHA256);
        }

        public static String md5Hash(String value) {
            return Challenge.hash(value, MessageDigestFactory.MD5);
        }

        public static String hash(String value, MessageDigestFactory factory) {
            MessageDigest md = factory.create();
            md.update(value.getBytes(BasicBuffer.DEFAULT_CHARSET));
            return Challenge.bytesToHex(md.digest());
        }

        public static String randomHexString(int bytesSize) {
            byte[] bytes = new byte[bytesSize];
            Challenge.getRandom().nextBytes(bytes);
            return Challenge.bytesToHex(bytes);
        }

        public static String bytesToHex(byte[] bytes) {
            Formatter formatter = new Formatter(new StringBuilder(), Locale.US);
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            return formatter.toString();
        }

        public static Random getRandom() {
            return RANDOM;
        }

        public static AuthMode getDefaultMode() {
            if (challengeEnabled) {
                return DEFAULT_MODE;
            }
            return AuthMode.NONE;
        }

        public static AuthMode getMode(BasicBuffer in) throws GSException {
            if (in.base().remaining() > 0) {
                return in.getByteEnum(AuthMode.class);
            }
            return AuthMode.NONE;
        }
    }

    public static enum AuthMode {
        NONE,
        BASIC,
        CHALLENGE;

    }

    public static enum ConnectionRoute {
        DEFAULT(""),
        PUBLIC("PUBLIC");

        private final String propertyString;

        private ConnectionRoute(String propertyString) {
            this.propertyString = propertyString;
        }

        public String toPropertyString() {
            return this.propertyString;
        }
    }

    public static enum AuthType {
        INTERNAL("INTERNAL"),
        EXTERNAL_LDAP("LDAP");

        private final String propertyString;

        private AuthType(String propertyString) {
            this.propertyString = propertyString;
        }

        public String toPropertyString() {
            return this.propertyString;
        }
    }

    public static class LoginInfo {
        private static Map<String, AuthType> AUTH_TYPE_MAP = LoginInfo.makeAuthTypeMap();
        private static Map<String, ConnectionRoute> CONNECTION_ROUTE_MAP = LoginInfo.makeConnectionRouteMap();
        private String user;
        private PasswordDigest passwordDigest;
        private String database;
        private boolean ownerMode;
        private String clusterName;
        private int transactionTimeoutSecs;
        private ClientId clientId;
        private String applicationName;
        private double storeMemoryAgingSwapRate;
        private SimpleTimeZone timeZoneOffset;
        private AuthType authType;
        private ConnectionRoute connectionRoute;

        public LoginInfo(String user, String password, boolean ownerMode, String database, String clusterName, long transactionTimeoutMillis, String applicationName, double storeMemoryAgingSwapRate, SimpleTimeZone timeZoneOffset, AuthType authType, ConnectionRoute connectionRoute) {
            ClientId clientId = null;
            this.set(user, Challenge.makeDigest(user, password), database, ownerMode, clusterName, PropertyUtils.timeoutPropertyToIntSeconds(transactionTimeoutMillis), clientId, applicationName, storeMemoryAgingSwapRate, timeZoneOffset, authType, connectionRoute);
        }

        public LoginInfo(LoginInfo loginInfo) {
            this.set(loginInfo);
        }

        public void set(LoginInfo loginInfo) {
            this.set(loginInfo.user, loginInfo.passwordDigest, loginInfo.database, loginInfo.ownerMode, loginInfo.clusterName, loginInfo.transactionTimeoutSecs, loginInfo.clientId, loginInfo.applicationName, loginInfo.storeMemoryAgingSwapRate, loginInfo.timeZoneOffset, loginInfo.authType, loginInfo.connectionRoute);
        }

        private void set(String user, PasswordDigest passwordDigest, String database, boolean ownerMode, String clusterName, int transactionTimeoutSecs, ClientId clientId, String applicationName, double storeMemoryAgingSwapRate, SimpleTimeZone timeZoneOffset, AuthType authType, ConnectionRoute connectionRoute) {
            this.user = user;
            this.passwordDigest = passwordDigest;
            this.database = database;
            this.ownerMode = ownerMode;
            this.clusterName = clusterName;
            this.transactionTimeoutSecs = transactionTimeoutSecs;
            this.clientId = clientId;
            this.applicationName = applicationName;
            this.storeMemoryAgingSwapRate = storeMemoryAgingSwapRate;
            this.timeZoneOffset = timeZoneOffset;
            this.authType = authType;
            this.connectionRoute = connectionRoute;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.passwordDigest = Challenge.makeDigest(this.user, password);
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public void setOwnerMode(boolean ownerMode) {
            this.ownerMode = ownerMode;
        }

        public void setClientId(ClientId clientId) {
            this.clientId = clientId;
        }

        public boolean isOwnerMode() {
            return this.ownerMode;
        }

        public String getUser() {
            return this.user;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getDatabase() {
            return this.database;
        }

        public ClientId getClientId() {
            return this.clientId;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public double getStoreMemoryAgingSwapRate() {
            return this.storeMemoryAgingSwapRate;
        }

        public SimpleTimeZone getTimeZoneOffset() {
            return this.timeZoneOffset;
        }

        public AuthType getAuthType() {
            return this.authType;
        }

        public static AuthType parseAuthType(String typeStr) throws GSException {
            AuthType type = AUTH_TYPE_MAP.get(typeStr);
            if (type == null) {
                throw new GSException(145005, "Unknown authenthcation type (value=" + typeStr + ")");
            }
            return type;
        }

        private static final Map<String, AuthType> makeAuthTypeMap() {
            HashMap<String, AuthType> map = new HashMap<String, AuthType>();
            for (AuthType type : AuthType.values()) {
                map.put(type.toPropertyString(), type);
            }
            return map;
        }

        public ConnectionRoute getConnectionRoute() {
            return this.connectionRoute;
        }

        public boolean isPublicConnection() {
            return this.connectionRoute == ConnectionRoute.PUBLIC;
        }

        public static ConnectionRoute parseConnectionRoute(String routeStr) throws GSException {
            ConnectionRoute route = CONNECTION_ROUTE_MAP.get(routeStr);
            if (route == null) {
                throw new GSException(145005, "Unknown connection route (value=" + routeStr + ")");
            }
            return route;
        }

        private static final Map<String, ConnectionRoute> makeConnectionRouteMap() {
            HashMap<String, ConnectionRoute> map = new HashMap<String, ConnectionRoute>();
            for (ConnectionRoute route : ConnectionRoute.values()) {
                if (route.toPropertyString().isEmpty()) continue;
                map.put(route.toPropertyString(), route);
            }
            return map;
        }

        public void putConnectionOption(BasicBuffer req) {
            if (this.connectionRoute == ConnectionRoute.PUBLIC) {
                OptionalRequest optionalRequest = new OptionalRequest();
                optionalRequest.put(OptionalRequestType.CONNECTION_ROUTE, (byte)this.connectionRoute.ordinal());
                optionalRequest.format(req);
            } else {
                NodeConnection.tryPutEmptyOptionalRequest(req);
            }
        }
    }

    static enum SocketType {
        PLAIN,
        SECURE;

    }

    public static class Config {
        private static final long CONNECT_TIMEOUT_DEFAULT = 10000L;
        private static final long STATEMENT_TIMEOUT_DEFAULT = 15000L;
        private static final long HEARTBEAT_TIMEOUT_DEFAULT = 10000L;
        private long connectTimeoutMillis = 10000L;
        private long statementTimeoutMillis = 15000L;
        private long heartbeatTimeoutMillis = 10000L;
        private boolean statementTimeoutEnabled = false;
        private Integer alternativeVersion;
        private Set<SocketType> acceptableSocketTypes = Collections.emptySet();
        private Map<SocketType, SocketFactory> socketFactories = Collections.emptyMap();

        public void set(Config config, boolean withSocketConfig) {
            this.connectTimeoutMillis = config.connectTimeoutMillis;
            this.statementTimeoutMillis = config.statementTimeoutMillis;
            this.heartbeatTimeoutMillis = config.heartbeatTimeoutMillis;
            this.statementTimeoutEnabled = config.statementTimeoutEnabled;
            this.alternativeVersion = config.alternativeVersion;
            if (withSocketConfig) {
                this.acceptableSocketTypes = config.acceptableSocketTypes;
                this.socketFactories = config.socketFactories;
            }
        }

        public boolean set(PropertyUtils.WrappedProperties props) throws GSException {
            long connectTimeoutMillis = props.getTimeoutProperty("connectTimeout", this.connectTimeoutMillis, true);
            long statementTimeoutMillis = props.getTimeoutProperty("statementTimeout", this.statementTimeoutMillis, true);
            long heartbeatTimeoutMillis = props.getTimeoutProperty("heartbeatTimeout", this.heartbeatTimeoutMillis, true);
            boolean statementTimeoutEnabled = props.getBooleanProperty("statementTimeoutEnabled", this.statementTimeoutEnabled, true);
            if (connectTimeoutMillis < 0L || statementTimeoutMillis < 0L) {
                throw new GSException(145005, "Negative timeout properties (connectTimeoutMillis=" + connectTimeoutMillis + ", statementTimeoutMillis=" + statementTimeoutMillis + ", heartbeatTimeoutMillis=" + heartbeatTimeoutMillis + ")");
            }
            if (connectTimeoutMillis != this.connectTimeoutMillis || statementTimeoutMillis != this.statementTimeoutMillis || heartbeatTimeoutMillis != this.heartbeatTimeoutMillis || statementTimeoutEnabled != this.statementTimeoutEnabled) {
                this.connectTimeoutMillis = connectTimeoutMillis;
                this.statementTimeoutMillis = statementTimeoutMillis;
                this.heartbeatTimeoutMillis = heartbeatTimeoutMillis;
                this.statementTimeoutEnabled = statementTimeoutEnabled;
                return true;
            }
            return false;
        }

        public long getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public long getStatementTimeoutMillis() {
            return this.statementTimeoutMillis;
        }

        public void setAlternativeVersion(Integer alternativeVersion) {
            this.alternativeVersion = alternativeVersion;
        }

        public void setSocketConfig(Set<SocketType> acceptableSocketTypes, Map<SocketType, SocketFactory> socketFactories) {
            this.acceptableSocketTypes = acceptableSocketTypes;
            this.socketFactories = socketFactories;
        }

        public Map<SocketType, SocketFactory> getSocketFactories() {
            return this.socketFactories;
        }
    }

    public static class ClientId {
        private final UUID uuid;
        private final long sessionId;

        public ClientId(UUID uuid, long sessionId) {
            this.uuid = uuid;
            this.sessionId = sessionId;
        }

        public static ClientId generate(long sessionId) {
            return new ClientId(UUID.randomUUID(), sessionId);
        }

        public long getSessionId() {
            return this.sessionId;
        }

        public UUID getUUID() {
            return this.uuid;
        }
    }

    static class Heartbeat {
        int orgStatementTypeNumber;
        long orgStatementId;
        boolean orgStatementFound;
        GSStatementException orgException;

        Heartbeat() {
        }
    }
}

