/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.Aggregation;
import com.toshiba.mwcloud.gs.AggregationResult;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.InterpolationMode;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.QueryOrder;
import com.toshiba.mwcloud.gs.TimeOperator;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TimestampUtils;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import java.util.Date;
import java.util.Set;

public class SubnetTimeSeries<R>
extends SubnetContainer<Date, R>
implements TimeSeries<R> {
    private static final Date EMPTY_TIMESTAMP = new Date(0L);
    private static final Date UNDEF_TIMESTAMP = new Date(Long.MAX_VALUE);

    public SubnetTimeSeries(SubnetGridStore store, GridStoreChannel channel, GridStoreChannel.Context context, Container.BindType<Date, R, ? extends Container<?, ?>> bindType, RowMapper mapper, int schemaVerId, int partitionId, long containerId, ContainerKeyConverter.ContainerKey normalizedContainerKey, ContainerKeyConverter.ContainerKey remoteContainerKey) throws GSException {
        super(store, channel, context, bindType, mapper, schemaVerId, partitionId, containerId, normalizedContainerKey, remoteContainerKey);
    }

    @Override
    public boolean append(R row) throws GSException {
        SubnetContainer.StatementFamily family = this.prepareSession(SubnetContainer.StatementFamily.POST);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, null, null);
        this.mapper.encode(req, SubnetTimeSeries.getRowMappingMode(), (Object)EMPTY_TIMESTAMP, row);
        this.executeStatement(Statement.APPEND_TIME_SERIES_ROW, req, resp, family);
        boolean found = resp.getBoolean();
        this.clearBlob(false);
        return found;
    }

    @Override
    public R get(Date base, TimeOperator timeOp) throws GSException {
        SubnetContainer.StatementFamily family = this.prepareSession(SubnetContainer.StatementFamily.QUERY);
        this.clearBlob(false);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, SubnetContainer.TransactionInfoType.SKIP_COMMIT_MODE, null);
        try {
            req.putDate(base);
            req.putByteEnum(timeOp);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(base, "base", e);
            GSErrorCode.checkNullParameter((Object)timeOp, "timeOp", e);
            throw e;
        }
        this.executeStatement(Statement.GET_TIME_SERIES_ROW_RELATED, req, resp, family);
        return resp.getBoolean() ? (R)this.rowType.cast(this.mapper.decode(resp, SubnetTimeSeries.getRowMappingMode(), this)) : null;
    }

    @Override
    public R interpolate(Date base, String column) throws GSException {
        SubnetContainer.StatementFamily family = this.prepareSession(SubnetContainer.StatementFamily.QUERY);
        this.clearBlob(false);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, SubnetContainer.TransactionInfoType.SKIP_COMMIT_MODE, null);
        try {
            req.putDate(base);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(base, "base", e);
        }
        GSErrorCode.checkNullParameter(column, "column", null);
        req.putInt(this.mapper.resolveColumnId(column));
        this.executeStatement(Statement.INTERPOLATE_TIME_SERIES_ROW, req, resp, family);
        return resp.getBoolean() ? (R)this.rowType.cast(this.mapper.decode(resp, SubnetTimeSeries.getRowMappingMode(), this)) : null;
    }

    @Override
    public Query<R> query(Date start, Date end) throws GSException {
        return this.query(start, end, QueryOrder.ASCENDING);
    }

    @Override
    public Query<R> query(final Date start, final Date end, final QueryOrder order) throws GSException {
        this.checkOpened();
        return new SubnetQuery(this, this.rowType, this.mapper, new SubnetContainer.QueryFormatter(Statement.QUERY_TIME_SERIES_RANGE){

            @Override
            public void format(BasicBuffer inBuf) throws GSException {
                inBuf.putDate(SubnetTimeSeries.wrapOptionalTimestamp(start));
                inBuf.putDate(SubnetTimeSeries.wrapOptionalTimestamp(end));
                try {
                    inBuf.putByteEnum(order);
                }
                catch (NullPointerException e) {
                    throw GSErrorCode.checkNullParameter((Object)order, "order", e);
                }
            }

            @Override
            public String getQueryString() {
                return "{start=" + SubnetTimeSeries.getOptionalTimestampString(start) + ", end=" + SubnetTimeSeries.getOptionalTimestampString(end) + ", order=" + (Object)((Object)order) + "}";
            }
        });
    }

    private static Date wrapOptionalTimestamp(Date timestamp) throws GSException {
        if (timestamp == null) {
            return UNDEF_TIMESTAMP;
        }
        if (timestamp.getTime() == UNDEF_TIMESTAMP.getTime()) {
            throw new GSException(145002, "Timestamp out of range (value=" + timestamp + ")");
        }
        return timestamp;
    }

    private static String getOptionalTimestampString(Date timestamp) {
        if (timestamp == null) {
            return "(Not bounded)";
        }
        return TimestampUtils.format(timestamp);
    }

    @Override
    public Query<R> query(final Date start, final Date end, final Set<String> columnSet, final InterpolationMode mode, final int interval, final TimeUnit intervalUnit) throws GSException {
        int[] columnIds;
        this.checkOpened();
        if (columnSet == null) {
            columnIds = null;
        } else {
            columnIds = new int[columnSet.size()];
            int index = 0;
            for (String column : columnSet) {
                columnIds[index++] = this.mapper.resolveColumnId(column);
            }
        }
        return new SubnetQuery(this, this.rowType, this.mapper, new SubnetContainer.QueryFormatter(Statement.QUERY_TIME_SERIES_SAMPLING){

            @Override
            public void format(BasicBuffer inBuf) {
                try {
                    inBuf.putDate(start);
                    inBuf.putDate(end);
                    if (columnIds == null) {
                        inBuf.putInt(0);
                    } else {
                        inBuf.putInt(columnIds.length);
                        for (int id : columnIds) {
                            inBuf.putInt(id);
                        }
                    }
                    inBuf.putInt(interval);
                    inBuf.putByteEnum(intervalUnit);
                    inBuf.putByteEnum(mode);
                }
                catch (NullPointerException e) {
                    GSErrorCode.checkNullParameter(start, "start", e);
                    GSErrorCode.checkNullParameter(end, "end", e);
                    GSErrorCode.checkNullParameter((Object)intervalUnit, "intervalUnit", e);
                    GSErrorCode.checkNullParameter((Object)mode, "mode", e);
                    throw e;
                }
            }

            @Override
            public String getQueryString() {
                return "{start=" + SubnetTimeSeries.getOptionalTimestampString(start) + ", end=" + SubnetTimeSeries.getOptionalTimestampString(end) + ", columnSet=" + columnSet + ", mode=" + (Object)((Object)mode) + ", interval=" + interval + ", intervalUnit=" + (Object)((Object)intervalUnit) + "}";
            }
        });
    }

    @Override
    @Deprecated
    public Query<R> query(Date start, Date end, Set<String> columnSet, int interval, TimeUnit intervalUnit) throws GSException {
        return this.query(start, end, columnSet, InterpolationMode.LINEAR_OR_PREVIOUS, interval, intervalUnit);
    }

    @Override
    public AggregationResult aggregate(Date start, Date end, String column, Aggregation aggregation) throws GSException {
        SubnetContainer.StatementFamily family = this.prepareSession(SubnetContainer.StatementFamily.QUERY);
        this.clearBlob(false);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        req.putLong(this.getContainerId());
        this.putTransactionInfo(req, family, SubnetContainer.TransactionInfoType.SKIP_COMMIT_MODE, null);
        try {
            req.putDate(start);
            req.putDate(end);
            req.putInt(column == null ? -1 : this.mapper.resolveColumnId(column));
            req.putByteEnum(aggregation);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(start, "start", e);
            GSErrorCode.checkNullParameter(end, "end", e);
            GSErrorCode.checkNullParameter((Object)aggregation, "aggregation", e);
            throw e;
        }
        this.executeStatement(Statement.AGGREGATE_TIME_SERIES, req, resp, family);
        return resp.getBoolean() ? (AggregationResult)RowMapper.getAggregationResultMapper().decode(resp, RowMapper.MappingMode.AGGREGATED, this) : null;
    }
}

