/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GeometryUtils;
import java.util.Arrays;

public class Geometry {
    private final byte[] bytesData;

    private Geometry(byte[] bytesData) {
        this.bytesData = bytesData;
    }

    public static Geometry valueOf(String value) throws IllegalArgumentException {
        try {
            return new Geometry(GeometryUtils.encodeGeometry(value));
        }
        catch (GSException e) {
            throw new IllegalArgumentException("Illegal geometry format (value=\"" + value + "\", reason=" + e.getMessage() + ")", e);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(value, "value", e);
        }
    }

    public String toString() {
        try {
            return GeometryUtils.decodeGeometry(this.bytesData);
        }
        catch (GSException e) {
            throw new Error("Internal error or decode error of remote data (reason=" + e.getMessage() + ")", e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytesData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Geometry other = (Geometry)obj;
        return Arrays.equals(this.bytesData, other.bytesData);
    }

    static {
        GeometryUtils.setDirectAccessor(new GeometryUtils.DirectAccessor(){

            @Override
            public int getBytesLength(Geometry geometry) {
                return geometry.bytesData.length;
            }

            @Override
            public void putGeometry(BasicBuffer out, Geometry geometry) {
                out.prepare(geometry.bytesData.length);
                out.base().put(geometry.bytesData);
            }

            @Override
            public Geometry getGeometry(BasicBuffer in, int size) {
                byte[] bytesData = new byte[size];
                in.base().get(bytesData);
                return new Geometry(bytesData);
            }
        });
    }
}

