/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.RowMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RowKeyPredicate<K> {
    private static final RowMapper.Config KEY_MAPPER_CONFIG = new RowMapper.Config(true, true, true, true);
    private static final Map<GSType, RowMapper> SINGLE_MAPPER_MAP = RowKeyPredicate.makeSingleMapperMap();
    private static final Map<GSType, Class<?>> SINGLE_CLASS_MAP = RowKeyPredicate.makeSingleClassMap();
    private static final Map<Class<?>, GSType> SINGLE_TYPE_MAP = RowKeyPredicate.makeSingleTypeMap(SINGLE_CLASS_MAP);
    private static boolean stringRangeRestricted = false;
    private final Class<K> bindingClass;
    private final Class<?> keyClass;
    private final RowMapper mapper;
    private final boolean rangeAcceptable;
    private K start;
    private K finish;
    private Set<K> distinctKeys;

    private RowKeyPredicate(Class<K> bindingClass, Class<?> keyClass, RowMapper mapper) throws GSException {
        RowKeyPredicate.checkMapper(mapper);
        this.bindingClass = bindingClass;
        this.keyClass = keyClass;
        this.mapper = mapper;
        this.rangeAcceptable = RowKeyPredicate.isRangeKeyAcceptable(keyClass, mapper);
    }

    public static RowKeyPredicate<Object> create(GSType keyType) throws GSException {
        Class<?> keyClass = SINGLE_CLASS_MAP.get((Object)keyType);
        if (keyClass == null) {
            GSErrorCode.checkNullParameter((Object)keyType, "keyType", null);
            throw new GSException(145009, "Unsupported key type (type=" + (Object)((Object)keyType) + ")");
        }
        try {
            RowMapper mapper = RowKeyPredicate.getSingleMapper(keyType);
            if (keyType == GSType.TIMESTAMP) {
                return new TimestampPredicate<Object>(Object.class, keyClass, mapper);
            }
            return new DefaultPredicate<Object>(Object.class, keyClass, mapper);
        }
        catch (GSException e) {
            throw new Error(e);
        }
    }

    public static <K> RowKeyPredicate<K> create(Class<K> keyType) throws GSException {
        GSType gsKeyType = SINGLE_TYPE_MAP.get(keyType);
        if (gsKeyType == null) {
            GSErrorCode.checkNullParameter(keyType, "keyType", null);
            throw new GSException(145009, "Unsupported key type (type=" + keyType + ")");
        }
        try {
            RowMapper mapper = RowKeyPredicate.getSingleMapper(gsKeyType);
            if (gsKeyType == GSType.TIMESTAMP) {
                return new TimestampPredicate<K>(keyType, keyType, mapper);
            }
            return new DefaultPredicate<K>(keyType, keyType, mapper);
        }
        catch (GSException e) {
            throw new Error(e);
        }
    }

    public static RowKeyPredicate<Row.Key> create(ContainerInfo info) throws GSException {
        GSErrorCode.checkNullParameter(info, "info", null);
        RowMapper mapper = RowMapper.getInstance(info.getType(), info, KEY_MAPPER_CONFIG);
        return new GeneralPredicate(mapper);
    }

    public void setStart(K startKey) throws GSException {
        if (this.distinctKeys != null) {
            throw new GSException(145002, "Distinct key has already been specified");
        }
        this.checkRangeKey(startKey);
        K checkedKey = this.checkKeyType(startKey);
        this.start = this.duplicateKey(checkedKey, false);
    }

    public void setFinish(K finishKey) throws GSException {
        if (this.distinctKeys != null) {
            throw new GSException(145002, "Distinct key has already been specified");
        }
        this.checkRangeKey(finishKey);
        K checkedKey = this.checkKeyType(finishKey);
        this.finish = this.duplicateKey(checkedKey, false);
    }

    public void add(K key) throws GSException {
        if (this.start != null || this.finish != null) {
            throw new GSException(145002, "Start or finish key has already been specified");
        }
        GSErrorCode.checkNullParameter(key, "key", null);
        K checkedKey = this.checkKeyType(key);
        Set<K> distinctKeys = this.distinctKeys;
        if (distinctKeys == null) {
            distinctKeys = new HashSet<K>();
        }
        distinctKeys.add(this.duplicateKey(checkedKey, true));
        this.distinctKeys = distinctKeys;
    }

    public GSType getKeyType() {
        if (this.mapper.getKeyCategory() != RowMapper.KeyCategory.SINGLE) {
            throw new IllegalStateException("This method cannot be used for composite row key");
        }
        GSType keyType = SINGLE_TYPE_MAP.get(this.keyClass);
        if (keyType == null) {
            throw new Error();
        }
        return keyType;
    }

    public ContainerInfo getKeySchema() {
        try {
            return this.mapper.resolveKeyContainerInfo();
        }
        catch (GSException e) {
            throw new Error(e);
        }
    }

    public K getStart() {
        return this.duplicateKey(this.start, false);
    }

    public K getFinish() {
        return this.duplicateKey(this.finish, false);
    }

    public Collection<K> getDistinctKeys() {
        Collection<K> baseKeys;
        if (this.distinctKeys == null) {
            return null;
        }
        if (this.isImmutableKey()) {
            baseKeys = this.distinctKeys;
        } else {
            ArrayList<K> keys = new ArrayList<K>(this.distinctKeys.size());
            for (K key : this.distinctKeys) {
                keys.add(this.duplicateKey(key, false));
            }
            baseKeys = keys;
        }
        return Collections.unmodifiableCollection(baseKeys);
    }

    Class<K> getBindingClass() {
        return this.bindingClass;
    }

    RowMapper getRowMapper() {
        return this.mapper;
    }

    K duplicateKey(K src, boolean identical) {
        if (src == null) {
            return null;
        }
        return this.duplicateKeyNoNull(src, identical);
    }

    K duplicateKeyNoNull(K src, boolean identical) {
        return src;
    }

    boolean isImmutableKey() {
        return true;
    }

    private void checkRangeKey(Object obj) throws GSException {
        if (obj == null) {
            return;
        }
        if (!this.rangeAcceptable) {
            throw new GSException(145003, "String range is not supported");
        }
    }

    private K checkKeyType(K obj) throws GSException {
        if (obj == null) {
            return null;
        }
        if (this.bindingClass == Object.class) {
            if (obj instanceof Row.Key) {
                Row.Key generalKey = (Row.Key)obj;
                Object elemObj = generalKey.getValue(0);
                this.checkKeyType(elemObj, generalKey);
                return this.bindingClass.cast(elemObj);
            }
        } else if (this.bindingClass == Row.Key.class) {
            this.checkKeyType(obj, obj);
            return obj;
        }
        this.checkKeyType(obj, null);
        return obj;
    }

    private void checkKeyType(Object obj, Object generalObj) throws GSException {
        try {
            this.keyClass.cast(obj);
        }
        catch (ClassCastException cause) {
            ClassCastException e = new ClassCastException("Row key class unmatched");
            e.initCause(cause);
            throw e;
        }
        if (generalObj != null) {
            RowMapper objMapper;
            try {
                objMapper = RowMapper.getInstance((Row)generalObj, KEY_MAPPER_CONFIG);
            }
            catch (GSException e) {
                throw new IllegalArgumentException(e);
            }
            try {
                objMapper.checkKeySchemaMatched(this.mapper);
            }
            catch (GSException e) {
                throw new GSException("Row key schema unmatched", (Throwable)e);
            }
        }
    }

    private static RowMapper getSingleMapper(GSType keyType) {
        RowMapper mapper = SINGLE_MAPPER_MAP.get((Object)keyType);
        if (mapper == null) {
            throw new Error();
        }
        return mapper;
    }

    private static Map<GSType, RowMapper> makeSingleMapperMap() {
        EnumMap<GSType, RowMapper> map = new EnumMap<GSType, RowMapper>(GSType.class);
        for (GSType type : new GSType[]{GSType.STRING, GSType.INTEGER, GSType.LONG, GSType.TIMESTAMP}) {
            RowMapper mapper;
            boolean rowKeyAssigned = true;
            ContainerInfo info = new ContainerInfo(null, null, Arrays.asList(new ColumnInfo(null, type)), true);
            try {
                mapper = RowMapper.getInstance(null, info, KEY_MAPPER_CONFIG);
            }
            catch (GSException e) {
                throw new Error(e);
            }
            map.put(type, mapper);
        }
        return map;
    }

    private static Map<GSType, Class<?>> makeSingleClassMap() {
        EnumMap map = new EnumMap(GSType.class);
        map.put(GSType.STRING, String.class);
        map.put(GSType.INTEGER, Integer.class);
        map.put(GSType.LONG, Long.class);
        map.put(GSType.TIMESTAMP, Date.class);
        return map;
    }

    private static Map<Class<?>, GSType> makeSingleTypeMap(Map<GSType, Class<?>> src) {
        HashMap map = new HashMap();
        for (Map.Entry<GSType, Class<?>> entry : src.entrySet()) {
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    private static void checkMapper(RowMapper mapper) throws GSException {
        if (!mapper.hasKey()) {
            throw new GSException(145024, "Row key does not exist on predicate for row key");
        }
    }

    private static boolean isRangeKeyAcceptable(Class<?> keyClass, RowMapper mapper) throws GSException {
        if (!stringRangeRestricted) {
            return true;
        }
        if (keyClass != Row.Key.class) {
            return keyClass != String.class;
        }
        ContainerInfo info = mapper.resolveKeyContainerInfo();
        int columnCount = info.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (info.getColumnInfo(i).getType() != GSType.STRING) continue;
            return false;
        }
        return true;
    }

    private static class TimestampPredicate<K>
    extends DefaultPredicate<K> {
        TimestampPredicate(Class<K> bindingClass, Class<?> keyClass, RowMapper mapper) throws GSException {
            super(bindingClass, keyClass, mapper);
        }

        @Override
        K duplicateKeyNoNull(K src, boolean identical) {
            return this.getBindingClass().cast(new Date(((Date)src).getTime()));
        }

        @Override
        boolean isImmutableKey() {
            return false;
        }
    }

    private static class GeneralPredicate
    extends DefaultPredicate<Row.Key> {
        GeneralPredicate(RowMapper mapper) throws GSException {
            super(Row.Key.class, Row.Key.class, mapper);
        }

        @Override
        Row.Key duplicateKeyNoNull(Row.Key src, boolean identical) {
            try {
                if (identical) {
                    return RowMapper.createIdenticalRowKey(src);
                }
                return src.createKey();
            }
            catch (GSException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        boolean isImmutableKey() {
            return false;
        }
    }

    private static class DefaultPredicate<K>
    extends RowKeyPredicate<K>
    implements RowMapper.Provider {
        DefaultPredicate(Class<K> bindingClass, Class<?> keyClass, RowMapper mapper) throws GSException {
            super(bindingClass, keyClass, mapper);
        }

        @Override
        public RowMapper getRowMapper() {
            return super.getRowMapper();
        }
    }
}

