/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;

public class TimestampUtils {
    private static final boolean TRIM_MILLISECONDS = false;

    @Deprecated
    public TimestampUtils() {
    }

    public static Date current() {
        return TimestampUtils.currentCalendar().getTime();
    }

    public static Calendar currentCalendar() {
        Calendar calendar = Calendar.getInstance(PropertyUtils.createTimeZoneOffset(0), Locale.ROOT);
        return calendar;
    }

    public static Date add(Date timestamp, int amount, TimeUnit timeUnit) {
        return TimestampUtils.add(timestamp, amount, timeUnit, PropertyUtils.createTimeZoneOffset(0));
    }

    public static Date add(Date timestamp, int amount, TimeUnit timeUnit, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone, Locale.ROOT);
        try {
            calendar.setTime(timestamp);
            calendar.add(TimestampUtils.toCalendarField(timeUnit), amount);
        }
        catch (NullPointerException e) {
            GSErrorCode.checkNullParameter(timestamp, "timestamp", e);
            GSErrorCode.checkNullParameter((Object)timeUnit, "timeUnit", e);
            throw e;
        }
        return calendar.getTime();
    }

    private static int toCalendarField(TimeUnit timeUnit) {
        switch (timeUnit) {
            case YEAR: {
                return 1;
            }
            case MONTH: {
                return 2;
            }
            case DAY: {
                return 5;
            }
            case HOUR: {
                return 10;
            }
            case MINUTE: {
                return 12;
            }
            case SECOND: {
                return 13;
            }
            case MILLISECOND: {
                return 14;
            }
        }
        throw new Error("Internal error by unknown time unit (timeUnit=" + (Object)((Object)timeUnit) + ")");
    }

    public static String format(Date timestamp) {
        return TimestampUtils.format(timestamp, PropertyUtils.createTimeZoneOffset(0));
    }

    public static String format(Date timestamp, TimeZone zone) {
        DateFormat format = TimestampUtils.getFormat(zone);
        try {
            return format.format(timestamp);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(timestamp, "timestamp", e);
        }
    }

    public static Date parse(String source) throws ParseException {
        try {
            return TimestampUtils.getFormat().parse(source);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(source, "source", e);
        }
    }

    public static DateFormat getFormat() {
        return TimestampUtils.getFormat(PropertyUtils.createTimeZoneOffset(0));
    }

    public static DateFormat getFormat(TimeZone zone) {
        try {
            return new CustomDateFormat(zone);
        }
        catch (NullPointerException e) {
            throw GSErrorCode.checkNullParameter(zone, "zone", e);
        }
    }

    private static class CustomDateFormat
    extends DateFormat {
        private static final long serialVersionUID = -5296445605735800942L;
        private static final int MILLIS_DOT_MIN_POSITION = 19;
        private final TimeZone zone;
        private DateFormat secondsFormat;
        private DateFormat millisFormat;

        CustomDateFormat(TimeZone zone) {
            if (zone.useDaylightTime()) {
                throw new IllegalArgumentException("Daylight time is currently not supported (timeZone=" + zone.getDisplayName(Locale.ROOT) + ")");
            }
            this.zone = (TimeZone)zone.clone();
        }

        private DateFormat getSecondsFormat(TimeZone zone) {
            DateFormat format = this.secondsFormat;
            if (format == null || !zone.equals(format.getTimeZone())) {
                format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ROOT);
                format.setLenient(false);
                format.setTimeZone(zone);
                this.secondsFormat = format;
            }
            return format;
        }

        private DateFormat getMillisFormat(TimeZone zone) {
            DateFormat format = this.millisFormat;
            if (format == null || !zone.equals(format.getTimeZone())) {
                format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.ROOT);
                format.setLenient(false);
                format.setTimeZone(zone);
                this.millisFormat = format;
            }
            return format;
        }

        private DateFormat getBaseFormat(String source, TimeZone zone) {
            DateFormat format = source.length() > 19 && source.indexOf(46, 19) >= 0 ? this.getMillisFormat(zone) : this.getSecondsFormat(zone);
            if (!format.getTimeZone().equals(zone)) {
                format = (DateFormat)format.clone();
                format.setTimeZone(zone);
            }
            return format;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            StringBuffer sb = this.getMillisFormat(this.zone).format(date, toAppendTo, fieldPosition);
            sb.append(PropertyUtils.formatTimeZoneOffset(this.zone.getRawOffset(), false));
            return sb;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            SimpleTimeZone zone;
            String[] elems = CustomDateFormat.splitZonePart(source);
            if (elems == null) {
                return null;
            }
            try {
                zone = PropertyUtils.parseTimeZoneOffset(elems[1], false);
            }
            catch (GSException e) {
                return null;
            }
            DateFormat baseFormat = this.getBaseFormat(source, zone);
            return this.parseStrict(baseFormat, elems[0], pos);
        }

        @Override
        public void setCalendar(Calendar newCalendar) {
            throw new UnsupportedOperationException("Modification is currently not supported");
        }

        @Override
        public void setNumberFormat(NumberFormat newNumberFormat) {
            throw new UnsupportedOperationException("Modification is currently not supported");
        }

        @Override
        public void setTimeZone(TimeZone zone) {
            throw new UnsupportedOperationException("Modification is currently not supported");
        }

        @Override
        public void setLenient(boolean lenient) {
            throw new UnsupportedOperationException("Modification is currently not supported");
        }

        @Override
        public TimeZone getTimeZone() {
            return (TimeZone)this.zone.clone();
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(new int[]{CustomDateFormat.class.hashCode(), super.hashCode()});
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof CustomDateFormat)) {
                return false;
            }
            CustomDateFormat another = (CustomDateFormat)obj;
            if (!this.zone.equals(another.zone)) {
                return false;
            }
            return super.equals(obj);
        }

        private static String[] splitZonePart(String str) {
            String zonePart;
            String mainPart;
            Matcher matcher = PropertyUtils.getTimeZoneOffsetPattern().matcher(str);
            if (matcher.find() && matcher.end() == str.length()) {
                mainPart = str.substring(0, matcher.start());
                zonePart = matcher.group();
            } else {
                String utcZone = "Z";
                if (!str.endsWith("Z")) {
                    return null;
                }
                mainPart = str.substring(0, str.length() - "Z".length());
                zonePart = "Z";
            }
            return new String[]{mainPart, zonePart};
        }

        private Date parseStrict(DateFormat format, String source, ParsePosition pos) {
            Date parsed = format.parse(source, pos);
            if (parsed == null) {
                return null;
            }
            String reformatted = format.format(parsed);
            if (!reformatted.equals(source)) {
                pos.setIndex(0);
                pos.setErrorIndex(0);
                return null;
            }
            return parsed;
        }
    }
}

