/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.experimental.ContainerAttribute;
import com.toshiba.mwcloud.gs.experimental.ContainerCondition;
import java.util.Set;

public class ContainerKeyPredicate {
    public static final int ATTRIBUTE_BASE = ContainerAttribute.BASE.flag();
    public static final int ATTRIBUTE_SINGLE = ContainerAttribute.SINGLE.flag();
    private static final int[] EMPTY_ATTRIBUTES = new int[0];
    private int[] attributes;

    public ContainerKeyPredicate() {
        this((int[])null);
    }

    public ContainerKeyPredicate(int[] attributes) {
        this.setAttributes(attributes);
    }

    public ContainerKeyPredicate(Set<ContainerAttribute> attributes) {
        this(ContainerKeyPredicate.toAttributes(attributes));
    }

    public ContainerKeyPredicate(ContainerCondition cond) {
        this(ContainerKeyPredicate.toAttributes(cond.getAttributes()));
    }

    public static int[] toAttributes(Set<ContainerAttribute> src) {
        if (src == null) {
            return EMPTY_ATTRIBUTES;
        }
        int[] dest = new int[src.size()];
        int i = 0;
        for (ContainerAttribute attr : src) {
            dest[i] = attr.flag();
            ++i;
        }
        return dest;
    }

    public int[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(int[] attributes) {
        this.attributes = attributes == null ? EMPTY_ATTRIBUTES : attributes;
    }

    public static ContainerKeyPredicate ofDefaultAttributes(boolean unified) {
        ContainerKeyPredicate pred = new ContainerKeyPredicate();
        pred.setAttributes(new int[]{unified ? ATTRIBUTE_SINGLE : ATTRIBUTE_BASE});
        return pred;
    }
}

