/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ContainerProperties {
    private static final Key[] BUILTIN_KEYS = Key.values();
    private ContainerInfo info;
    private ContainerIdInfo idInfo;
    private Integer attribute;
    private Long reservedValue;
    private Map<Integer, byte[]> rawEntries;
    private Map<Integer, byte[]> schemaOptions;

    public ContainerProperties() {
    }

    public ContainerProperties(ContainerInfo info) {
        this.info = info;
    }

    public ContainerInfo getInfo() {
        return this.info;
    }

    public void setInfo(ContainerInfo info) {
        this.info = info;
    }

    public ContainerIdInfo getIdInfo() {
        return this.idInfo;
    }

    public void setIdInfo(ContainerIdInfo idInfo) {
        this.idInfo = idInfo;
    }

    public Integer getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Integer attribute) {
        this.attribute = attribute;
    }

    public Long getReservedValue() {
        return this.reservedValue;
    }

    public void setReservedValue(Long reservedValue) {
        this.reservedValue = reservedValue;
    }

    public Map<Integer, byte[]> getRawEntries() {
        return this.rawEntries;
    }

    public void setRawEntries(Map<Integer, byte[]> rawEntries) {
        this.rawEntries = rawEntries;
    }

    public Map<Integer, byte[]> getSchemaOptions() {
        return this.schemaOptions;
    }

    public void setSchemaOptions(Map<Integer, byte[]> schemaOptions) {
        this.schemaOptions = schemaOptions;
    }

    public static Key tryResolveKey(int rawkey) {
        if (rawkey < BUILTIN_KEYS.length) {
            return BUILTIN_KEYS[rawkey];
        }
        return null;
    }

    public static ContainerInfo findInfo(ContainerProperties props) {
        if (props == null) {
            return null;
        }
        return props.getInfo();
    }

    public static enum ContainerVisibility {
        META,
        INTERNAL_META,
        SYSTEM_TOOL;

    }

    public static enum MetaNamingType {
        NEUTRAL,
        CONTAINER,
        TABLE;

    }

    public static enum MetaDistributionType {
        NONE,
        FULL,
        NODE;

    }

    public static class KeySet {
        private final Integer[] rawKeys;

        public KeySet(Set<Key> keys, Integer ... rawKeys) {
            TreeSet<Integer> allKeys = new TreeSet<Integer>();
            for (Key key : keys) {
                allKeys.add(key.ordinal());
            }
            if (rawKeys != null) {
                List<Integer> rawKeyList = Arrays.asList(rawKeys);
                allKeys.removeAll(rawKeyList);
                allKeys.addAll(rawKeyList);
            }
            this.rawKeys = allKeys.toArray(new Integer[allKeys.size()]);
        }

        public Integer[] getRawKeys() {
            return this.rawKeys;
        }
    }

    public static enum Key {
        ID,
        SCHEMA,
        INDEX,
        EVENT_NOTIFICATION,
        TRIGGER,
        ATTRIBUTE,
        INDEX_DETAIL;

    }

    public static class ContainerIdInfo {
        public final int versionId;
        public final long containerId;
        public final ContainerKeyConverter.ContainerKey remoteKey;
        public final MetaDistributionType metaDistType;
        public final long metaContainerId;
        public final MetaNamingType metaNamingType;

        public ContainerIdInfo(int versionId, long containerId, ContainerKeyConverter.ContainerKey remoteKey, MetaDistributionType metaDistType, long metaContainerId, MetaNamingType metaNamingType) {
            this.versionId = versionId;
            this.containerId = containerId;
            this.remoteKey = remoteKey;
            this.metaDistType = metaDistType;
            this.metaContainerId = metaContainerId;
            this.metaNamingType = metaNamingType;
        }
    }
}

