/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import com.toshiba.mwcloud.gs.GridStoreFactory;
import com.toshiba.mwcloud.gs.common.ServiceProviderUtils;
import java.util.List;
import java.util.Set;

public abstract class GridStoreFactoryProvider {
    private static final String BUILTIN_CLASS_NAME = "com.toshiba.mwcloud.gs.partitioned.PartFactoryProvider";

    public abstract GridStoreFactory getFactory();

    public static <P> P getProvider(Class<P> providerClassSpec, Class<?> loaderBaseClass, Set<Class<?>> exclusiveClasses) {
        P provider;
        List<P> providerList = ServiceProviderUtils.load(GridStoreFactoryProvider.class, providerClassSpec, ServiceProviderUtils.listClassLoaders(loaderBaseClass), exclusiveClasses);
        if (providerList.isEmpty()) {
            GridStoreFactoryProvider builtinProvider = GridStoreFactoryProvider.getBuiltinProvider();
            try {
                provider = providerClassSpec.cast(builtinProvider);
            }
            catch (ClassCastException e) {
                throw new Error(e);
            }
        } else {
            provider = providerList.get(0);
        }
        return provider;
    }

    public static GridStoreFactoryProvider getBuiltinProvider() {
        try {
            return (GridStoreFactoryProvider)Class.forName(BUILTIN_CLASS_NAME).newInstance();
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
    }

    public static interface ChainProvidable {
        public GridStoreFactory getFactory(Set<Class<?>> var1, Set<Class<?>> var2);
    }
}

