/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;

public class ServiceProviderUtils {
    public static <S> List<S> load(Class<S> providerClass, List<ClassLoader> classLoaderList, Set<Class<?>> exclusiveClasses) {
        return ServiceProviderUtils.load(providerClass, providerClass, classLoaderList, exclusiveClasses);
    }

    public static <S> List<S> load(Class<?> providerClass, Class<S> providerClassSpec, List<ClassLoader> classLoaderList, Set<Class<?>> exclusiveClasses) {
        ArrayList<S> providerList = new ArrayList<S>();
        for (ClassLoader cl : classLoaderList) {
            for (Object provider : ServiceLoader.load(providerClass, cl)) {
                if (!providerClassSpec.isInstance(provider) || exclusiveClasses.contains(provider.getClass())) continue;
                providerList.add(providerClassSpec.cast(provider));
            }
        }
        return providerList;
    }

    public static List<ClassLoader> listClassLoaders(Class<?> baseClass) {
        return Arrays.asList(baseClass.getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader());
    }

    public static Set<Class<?>> mergeChainClasses(Set<Class<?>> lastChainClasses, Class<?> chainClass) {
        HashSet nextChainClasses = new HashSet();
        nextChainClasses.addAll(lastChainClasses);
        nextChainClasses.add(chainClass);
        return nextChainClasses;
    }
}

