/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.partitioned;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.PartitionController;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerKeyPredicate;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.partitioned.PartContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class PartPartitionController
implements PartitionController,
Extensibles.AsPartitionController {
    private static final ContainerKeyPredicate DEFAULT_PREDICATE = PartPartitionController.createContainerKeyPredicate(true);
    private static final ContainerKeyPredicate COMPATIBLE_PREDICATE = PartPartitionController.createContainerKeyPredicate(false);
    private final Extensibles.AsPartitionController base;

    public PartPartitionController(Extensibles.AsPartitionController base) {
        this.base = base;
    }

    @Override
    public int getPartitionCount() throws GSException {
        return this.base.getPartitionCount();
    }

    @Override
    public long getContainerCount(int partitionIndex) throws GSException {
        ContainerKeyPredicate pred = PartPartitionController.getContainerKeyPredicate();
        boolean internalMode = true;
        return this.base.getContainerCount(partitionIndex, pred, true);
    }

    @Override
    public List<String> getContainerNames(int partitionIndex, long start, Long limit) throws GSException {
        ContainerKeyPredicate pred = PartPartitionController.getContainerKeyPredicate();
        boolean internalMode = true;
        return this.base.getContainerNames(partitionIndex, start, limit, pred, true);
    }

    @Override
    public List<InetAddress> getHosts(int partitionIndex) throws GSException {
        return this.base.getHosts(partitionIndex);
    }

    @Override
    public InetAddress getOwnerHost(int partitionIndex) throws GSException {
        return this.base.getOwnerHost(partitionIndex);
    }

    @Override
    public List<InetAddress> getBackupHosts(int partitionIndex) throws GSException {
        return this.base.getBackupHosts(partitionIndex);
    }

    @Override
    public void assignPreferableHost(int partitionIndex, InetAddress host) throws GSException {
        this.base.assignPreferableHost(partitionIndex, host);
    }

    @Override
    public int getPartitionIndexOfContainer(String containerName) throws GSException {
        boolean internalMode = false;
        return this.base.getPartitionIndexOfContainer(containerName, false);
    }

    @Override
    public void close() throws GSException {
        this.base.close();
    }

    @Override
    public long getContainerCount(int partitionIndex, ContainerKeyPredicate pred, boolean internalMode) throws GSException {
        return this.base.getContainerCount(partitionIndex, pred, internalMode);
    }

    @Override
    public List<String> getContainerNames(int partitionIndex, long start, Long limit, ContainerKeyPredicate pred, boolean internalMode) throws GSException {
        return this.base.getContainerNames(partitionIndex, start, limit, pred, internalMode);
    }

    @Override
    public int getPartitionIndexOfContainer(String containerName, boolean internalMode) throws GSException {
        return this.base.getPartitionIndexOfContainer(containerName, internalMode);
    }

    @Override
    public int getPartitionIndexOfContainer(ContainerKeyConverter.ContainerKey containerKey, boolean internalMode) throws GSException {
        return this.base.getPartitionIndexOfContainer(containerKey, internalMode);
    }

    private static ContainerKeyPredicate createContainerKeyPredicate(boolean unified) {
        HashSet<Integer> attributeSet = new HashSet<Integer>();
        for (int attribute : ContainerKeyPredicate.ofDefaultAttributes(unified).getAttributes()) {
            attributeSet.add(attribute);
        }
        attributeSet.add(PartContainer.Attributes.LARGE);
        int[] attributeList = new int[attributeSet.size()];
        int i = 0;
        Iterator iterator = attributeSet.iterator();
        while (iterator.hasNext()) {
            int attribute;
            attributeList[i] = attribute = ((Integer)iterator.next()).intValue();
            ++i;
        }
        return new ContainerKeyPredicate(attributeList);
    }

    private static ContainerKeyPredicate getContainerKeyPredicate() {
        if (SubnetGridStore.isContainerAttributeUnified()) {
            return DEFAULT_PREDICATE;
        }
        return COMPATIBLE_PREDICATE;
    }
}

