/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.partitioned;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.QueryAnalysisEntry;
import com.toshiba.mwcloud.gs.RowSet;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.partitioned.PartContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetRowSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;

class PartRowSet<R>
implements RowSet<R>,
Extensibles.AsRowSet<R>,
Experimentals.AsRowSet<R> {
    private final PartContainer<?, ?> container;
    private final List<Extensibles.AsQuery<R>> subQueryList = new ArrayList<Extensibles.AsQuery<R>>();
    private final List<Extensibles.AsRowSet<R>> subList = new ArrayList<Extensibles.AsRowSet<R>>();
    private final List<Long> subIdList = new ArrayList<Long>();
    private final Extensibles.QueryInfo queryInfo;
    private Set<Long> problemSubIdSet;
    private Extensibles.AsRowSet<R> lastSub;
    private int nextSubIndex;
    private int rowCount = -1;
    private boolean subContainerLost;
    private Throwable lastProblem;
    private Filter filter;
    private SubnetRowSet.DistributedQueryTarget target;

    PartRowSet(PartContainer<?, ?> container, Extensibles.QueryInfo queryInfo) {
        this.container = container;
        this.queryInfo = queryInfo;
    }

    @Override
    public boolean hasNext() throws GSException {
        return this.filter.hasNext(this);
    }

    @Override
    public R next() throws GSException {
        return this.filter.next(this);
    }

    @Override
    public void remove() throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public void update(R rowObj) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public int size() {
        if (this.rowCount < 0) {
            try {
                try {
                    this.prepareSubList(this.subQueryList.size());
                }
                catch (Throwable t) {
                    throw this.closeByProblem(t);
                }
                this.rowCount = PartRowSet.calculateRowCount(this.subList);
            }
            catch (GSException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.rowCount;
    }

    @Override
    public void close() throws GSException {
        this.nextSubIndex = -1;
        this.closeAllSub(true);
    }

    @Override
    public Class<?> getMappingRowType() throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public Set<Integer> getExtOptionKeys() throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public byte[] getExtOption(int key) throws GSException {
        throw PartContainer.errorNotSupported();
    }

    @Override
    public Extensibles.QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public Extensibles.AsContainer<?, ?> getContainer() {
        return this.container;
    }

    @Override
    public Experimentals.RowId getRowIdForUpdate() throws GSException {
        throw PartContainer.errorNotSupported();
    }

    void addSub(long subId, Extensibles.AsQuery<R> sub) throws GSException {
        this.checkOpened();
        this.rowCount = -1;
        this.subQueryList.add(sub);
        this.subIdList.add(subId);
    }

    void removeUncheckedSub() throws GSException {
        int subCount = this.subList.size();
        for (Extensibles.AsQuery<R> sub : this.subQueryList.subList(subCount, this.subQueryList.size())) {
            sub.close();
        }
        while (this.subQueryList.size() > subCount) {
            this.subQueryList.remove(subCount);
        }
        while (this.subIdList.size() > subCount) {
            this.subIdList.remove(subCount);
        }
    }

    List<Long> getSubIdList() {
        return this.subIdList;
    }

    boolean isProblemSubId(Long subId) {
        return this.problemSubIdSet != null && this.problemSubIdSet.contains(subId);
    }

    void addProblemSubId(Long subId) {
        if (this.problemSubIdSet == null) {
            this.problemSubIdSet = new HashSet<Long>();
        }
        this.problemSubIdSet.add(subId);
    }

    SubnetRowSet.DistributedQueryTarget getTarget(boolean resolving) throws GSException {
        if (resolving) {
            this.prepareSubList(this.subQueryList.size());
        }
        return this.target;
    }

    void clearTarget() throws GSException {
        this.target = null;
    }

    boolean checkSubContainerLost() throws GSException {
        this.prepareSubList(this.subQueryList.size());
        return this.subContainerLost;
    }

    void clearSubContainerLost() {
        this.subContainerLost = false;
    }

    void prepareFollowing() throws GSException {
        this.checkOpened();
        try {
            this.prepareFilterAndRowType();
            this.filter.prepareFollowing(this);
        }
        catch (Throwable t) {
            throw this.closeByProblem(t);
        }
    }

    void prepareFollowingUnfiltered() throws GSException {
        Extensibles.AsRowSet<R> sub = this.lastSub;
        while (true) {
            if (sub != null) {
                if (sub.hasNext()) break;
                sub.close();
            }
            if (this.nextSubIndex >= this.subQueryList.size()) {
                sub = null;
                break;
            }
            this.prepareSubList(this.nextSubIndex + 1);
            sub = this.subList.get(this.nextSubIndex);
            ++this.nextSubIndex;
        }
        this.lastSub = sub;
    }

    boolean hasNextUnfiltered() throws GSException {
        return this.lastSub != null;
    }

    R nextUnfiltered() throws GSException {
        Object rowObj;
        try {
            rowObj = this.lastSub.next();
        }
        catch (NullPointerException e) {
            this.checkOpened();
            throw new GSException(145037, "No more rows were found", e);
        }
        if (!this.lastSub.hasNext()) {
            this.prepareFollowingUnfiltered();
        }
        return rowObj;
    }

    int findLastSubIndex() {
        if (this.lastSub != null && this.nextSubIndex >= 0) {
            ListIterator<Extensibles.AsRowSet<R>> it = this.subList.listIterator(this.nextSubIndex);
            while (it.hasPrevious()) {
                if (it.previous() != this.lastSub) continue;
                return it.nextIndex();
            }
        }
        return -1;
    }

    static long[] getDistLimits(Extensibles.AsRowSet<?> rowSet) throws GSException {
        byte[] bytes = rowSet.getExtOption(ExtResultOptionType.DIST_LIMIT.number());
        if (bytes == null) {
            return null;
        }
        BasicBuffer buf = BasicBuffer.wrap(bytes);
        long limit = buf.base().getLong();
        long offset = buf.base().getLong();
        return new long[]{limit, offset};
    }

    private void checkOpened() throws GSException {
        if (this.nextSubIndex < 0) {
            Throwable lastProblem = this.lastProblem;
            if (lastProblem != null) {
                throw new GSException("Row set already closed by other problem (reason=" + lastProblem.getMessage() + ")", lastProblem);
            }
            throw new GSException(145040, "Already closed");
        }
    }

    private GSException closeByProblem(Throwable cause) {
        try {
            this.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.lastProblem = cause;
        }
        if (cause instanceof GSException) {
            return (GSException)cause;
        }
        return new GSException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllSub(boolean silent) throws GSException {
        boolean succeeded = false;
        try {
            int subCount = this.subQueryList.size();
            for (int i = 0; i < subCount; ++i) {
                Query sub = this.subQueryList.get(i);
                if (sub == null) continue;
                if (silent) {
                    try {
                        sub.close();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                sub.close();
            }
            succeeded = true;
        }
        finally {
            this.lastSub = null;
            if (!succeeded && !silent) {
                this.closeAllSub(true);
            }
        }
    }

    private void prepareFilterAndRowType() throws GSException {
        if (this.filter != null) {
            return;
        }
        Extensibles.AsRowSet<R> sub = this.resolveSubAny(true);
        Class<?> containerRowType = this.container.getRowType();
        Class<?> rowType = sub.getMappingRowType();
        Filter filter = Filter.DEFAULT_INSTANCE;
        long[] limits = PartRowSet.getDistLimits(sub);
        if (limits != null) {
            filter = new LimitFilter(filter, limits[0], limits[1]);
        }
        if (rowType == QueryAnalysisEntry.class) {
            filter = new AnalysisFilter(filter);
        } else if (rowType != containerRowType) {
            throw new GSException(145031, "Protocol error by unexpected row set type (container=" + this.container.getLargeKey() + ", expected=" + containerRowType + ", actual=" + rowType + ")");
        }
        this.filter = filter;
    }

    private void prepareSubList(int endIndex) throws GSException {
        for (int i = this.subList.size(); i < endIndex; ++i) {
            this.subList.add(null);
            this.subList.remove(i);
            Extensibles.AsQuery<R> subQuery = this.subQueryList.get(i);
            Extensibles.AsRowSet<R> sub = subQuery.getRowSet();
            if (sub == null) {
                this.subContainerLost = true;
            }
            this.subList.add(sub);
            if (sub == null || this.target != null) continue;
            this.target = SubnetRowSet.getDistTarget(sub);
        }
    }

    private Extensibles.AsRowSet<R> resolveSubAny(boolean force) throws GSException {
        Extensibles.AsRowSet<R> sub = null;
        int subCount = this.subQueryList.size();
        for (int i = this.nextSubIndex; i < subCount; ++i) {
            this.prepareSubList(i + 1);
            sub = this.subList.get(i);
            if (sub != null) break;
        }
        if (sub == null && force) {
            throw new GSException(145031, "Protocol error by no available partitioned containers (container=" + this.container.getLargeKey() + ")");
        }
        return sub;
    }

    private static int calculateRowCount(List<? extends RowSet<?>> subList) throws GSException {
        long value = 0L;
        for (RowSet<?> sub : subList) {
            if (sub == null || (value += (long)sub.size()) <= Integer.MAX_VALUE) continue;
            throw new GSException(145003, "Row count exceeds max value of Integer");
        }
        return (int)value;
    }

    static class AnalysisFilter
    extends ChainFilter {
        private AnalysisFilter(Filter base) {
            super(base);
        }

        @Override
        <R> R next(PartRowSet<R> rowSet) throws GSException {
            super.prepareFollowing(rowSet);
            int subIndex = rowSet.findLastSubIndex();
            R rowObj = super.next(rowSet);
            this.addSubName(rowSet, (QueryAnalysisEntry)rowObj, subIndex);
            return rowObj;
        }

        private void addSubName(PartRowSet<?> rowSet, QueryAnalysisEntry entry, int subIndex) {
            StringBuilder builder = new StringBuilder();
            AnalysisFilter.formatSubName(builder, rowSet, subIndex);
            String stmt = entry.getStatement();
            if (!stmt.isEmpty()) {
                builder.append(':');
                builder.append(stmt);
            }
            entry.setStatement(builder.toString());
        }

        private static void formatSubName(StringBuilder builder, PartRowSet<?> rowSet, int subIndex) {
            if (subIndex < 0) {
                throw new IllegalStateException();
            }
            builder.append('#');
            builder.append(((PartRowSet)rowSet).subIdList.get(subIndex));
        }
    }

    static class LimitFilter
    extends ChainFilter {
        private long restLimit;
        private long restOffset;

        private LimitFilter(Filter base, long limit, long offset) {
            super(base);
            this.restLimit = limit;
            this.restOffset = offset;
        }

        @Override
        <R> void prepareFollowing(PartRowSet<R> rowSet) throws GSException {
            super.prepareFollowing(rowSet);
            if (this.restOffset > 0L) {
                super.step(rowSet, this.restOffset);
                this.restOffset = 0L;
            }
            if (this.restLimit <= 0L) {
                super.step(rowSet, -1L);
            }
        }

        @Override
        <R> R next(PartRowSet<R> rowSet) throws GSException {
            R rowObj = super.next(rowSet);
            if (--this.restLimit <= 0L) {
                super.step(rowSet, -1L);
            }
            return rowObj;
        }
    }

    static abstract class ChainFilter
    extends Filter {
        private final Filter base;

        ChainFilter(Filter base) {
            this.base = base;
        }

        @Override
        <R> void prepareFollowing(PartRowSet<R> rowSet) throws GSException {
            this.base.prepareFollowing(rowSet);
        }

        @Override
        <R> boolean hasNext(PartRowSet<R> rowSet) throws GSException {
            return this.base.hasNext(rowSet);
        }

        @Override
        <R> R next(PartRowSet<R> rowSet) throws GSException {
            return this.base.next(rowSet);
        }

        @Override
        <R> void step(PartRowSet<R> rowSet, long count) throws GSException {
            this.base.step(rowSet, count);
        }
    }

    static class Filter {
        private static final Filter DEFAULT_INSTANCE = new Filter();

        Filter() {
        }

        <R> void prepareFollowing(PartRowSet<R> rowSet) throws GSException {
            rowSet.prepareFollowingUnfiltered();
        }

        <R> boolean hasNext(PartRowSet<R> rowSet) throws GSException {
            return rowSet.hasNextUnfiltered();
        }

        <R> R next(PartRowSet<R> rowSet) throws GSException {
            return rowSet.nextUnfiltered();
        }

        <R> void step(PartRowSet<R> rowSet, long count) throws GSException {
            long i = count;
            while (i != 0L && this.hasNext(rowSet)) {
                this.next(rowSet);
                if (i <= 0L) continue;
                --i;
            }
        }
    }

    static enum ExtResultOptionType {
        DIST_TARGET(32),
        DIST_LIMIT(33);

        static final Set<Integer> DEFAULT_OPTIONS;
        static final Set<Integer> TARGETED_OPTIONS;
        private final int number;

        private ExtResultOptionType(int number) {
            this.number = number;
        }

        public int number() {
            return this.number;
        }

        static {
            TreeSet<Object> set = new TreeSet<Integer>();
            set.add(DIST_LIMIT.number());
            DEFAULT_OPTIONS = Collections.unmodifiableSet(set);
            set = new TreeSet<Integer>(DEFAULT_OPTIONS);
            set.add(DIST_TARGET.number());
            TARGETED_OPTIONS = Collections.unmodifiableSet(set);
        }
    }
}

