/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSTimeoutException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerProperties;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.GSWrongNodeException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.ServiceAddressResolver;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.NodeConnectionPool;
import com.toshiba.mwcloud.gs.subnet.NodeResolver;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class GridStoreChannel
implements Closeable {
    public static Boolean v1ProtocolCompatible = null;
    public static boolean v1ProtocolCompatible_1_1_103x = false;
    public static boolean v10ResourceCompatible = false;
    public static boolean v15TSPropsCompatible = false;
    public static boolean v15DDLCompatible = true;
    public static boolean v20AffinityCompatible = false;
    public static boolean v21StatementIdCompatible = false;
    public static boolean v40QueryCompatible = false;
    public static boolean v40ContainerHashCompatible = true;
    public static boolean v40SchemaCompatible = false;
    private static int FAILOVER_TIMEOUT_DEFAULT = 120000;
    private static int FAILOVER_RETRY_INTERVAL = 1000;
    public static int INITIAL_BUFFER_SIZE = 256;
    public static int MAPPER_CACHE_SIZE = 32;
    private static int MAX_REF_SCAN_COUNT = 15;
    private static final LoggingUtils.BaseGridStoreLogger LOGGER = LoggingUtils.getLogger("Connection");
    private static final LoggingUtils.BaseGridStoreLogger STATEMENT_LOGGER = LoggingUtils.getLogger("StatementExec");
    private final Config config = new Config();
    private final NodeConnection.Config connectionConfig;
    private int statementRetryMode;
    private final NodeConnectionPool pool;
    private final NodeResolver nodeResolver;
    private final int requestHeadLength;
    private final Key key;
    private final Set<ContextReference> contextRefSet = new LinkedHashSet<ContextReference>();

    public GridStoreChannel(Config config, Source source) throws GSException {
        this.connectionConfig = config.createConnectionConfig(source.key.transProps);
        this.pool = new NodeConnectionPool();
        this.key = source.key;
        this.nodeResolver = new NodeResolver(this.pool, this.key.passive, this.key.address, this.connectionConfig, this.key.sarConfig, this.key.memberList, null, this.key.notificationInterfaceAddress, source.loginInfo.isPublicConnection());
        this.requestHeadLength = NodeConnection.getRequestHeadLength(this.key.isIPV6Enabled());
        this.apply(config);
    }

    public NodeConnectionPool getConnectionPool() {
        return this.pool;
    }

    public void apply(Config config) {
        this.config.set(config);
        this.nodeResolver.setConnectionConfig(this.connectionConfig);
        this.nodeResolver.setNotificationReceiveTimeoutMillis(config.getNotificationReceiveTimeoutMillis());
        this.nodeResolver.setPreferableConnectionPoolSize(config.getMaxConnectionPoolSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextReference registerContext(Context context, Object target) throws GSException {
        Set<ContextReference> set = this.contextRefSet;
        synchronized (set) {
            ArrayList<ContextReference> pendingList = new ArrayList<ContextReference>(MAX_REF_SCAN_COUNT);
            try {
                Iterator<ContextReference> it = this.contextRefSet.iterator();
                while (it.hasNext()) {
                    ContextReference ref = it.next();
                    if (ref.get() == null) {
                        this.closeContext(ref.context);
                    } else {
                        pendingList.add(ref);
                    }
                    it.remove();
                    if (pendingList.size() < MAX_REF_SCAN_COUNT) continue;
                    break;
                }
            }
            finally {
                if (pendingList != null) {
                    this.contextRefSet.addAll(pendingList);
                }
            }
            ContextReference newRef = new ContextReference(target, context);
            this.contextRefSet.add(newRef);
            return newRef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterContext(ContextReference ref) {
        Set<ContextReference> set = this.contextRefSet;
        synchronized (set) {
            this.contextRefSet.remove(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllContext(boolean silent) throws GSException {
        Set<ContextReference> set = this.contextRefSet;
        synchronized (set) {
            boolean succeeded = false;
            try {
                Iterator<ContextReference> it = this.contextRefSet.iterator();
                while (it.hasNext()) {
                    Context context = it.next().context;
                    it.remove();
                    Context context2 = context;
                    synchronized (context2) {
                        if (!context.closed) {
                            if (silent) {
                                try {
                                    this.closeContext(context);
                                }
                                catch (Throwable throwable) {}
                            } else {
                                this.closeContext(context);
                            }
                        }
                    }
                }
                succeeded = true;
            }
            finally {
                if (!succeeded && !silent) {
                    this.closeAllContext(true);
                }
            }
        }
    }

    public long getFailoverTimeoutMillis(Context context) {
        if (((Context)context).localConfig.failoverTimeoutMillis >= 0L) {
            return ((Context)context).localConfig.failoverTimeoutMillis;
        }
        return this.config.failoverTimeoutMillis;
    }

    public void setStatementRetryMode(int statementRetryMode) {
        this.statementRetryMode = statementRetryMode;
    }

    public BasicBuffer createRequestBuffer() {
        return this.createRequestBuffer(INITIAL_BUFFER_SIZE);
    }

    public BasicBuffer createRequestBuffer(int minCapacity) {
        BasicBuffer buffer = new BasicBuffer(Math.max(this.requestHeadLength, minCapacity));
        NodeConnection.fillRequestHead(this.key.isIPV6Enabled(), buffer);
        return buffer;
    }

    public BasicBuffer createResponseBuffer() {
        return this.createResponseBuffer(INITIAL_BUFFER_SIZE);
    }

    public BasicBuffer createResponseBuffer(int minCapacity) {
        return new BasicBuffer(Math.max(this.requestHeadLength, minCapacity));
    }

    public void setupRequestBuffer(BasicBuffer buffer) {
        buffer.base().position(this.requestHeadLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanRemoteResources(Context context, Set<? extends Class<?>> targetClasses) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            Reference ref;
            while ((ref = context.remoteRefQueue.poll()) != null) {
                this.closeRemoteResource(context, (RemoteReference)ref, false);
            }
            block7: for (Class<?> clazz : targetClasses == null ? context.getReferenceTargetClasses() : targetClasses) {
                Set<RemoteReference<?>> set = context.getRemoteReferences(clazz);
                if (set.isEmpty()) continue;
                ArrayList pendingList = new ArrayList(MAX_REF_SCAN_COUNT);
                try {
                    Iterator<RemoteReference<?>> it = set.iterator();
                    while (it.hasNext()) {
                        RemoteReference<?> ref2 = it.next();
                        if (ref2.get() == null) {
                            this.closeRemoteResource(context, ref2, true);
                        } else {
                            pendingList.add(ref2);
                        }
                        it.remove();
                        if (pendingList.size() < MAX_REF_SCAN_COUNT) continue;
                        continue block7;
                    }
                }
                finally {
                    set.addAll(pendingList);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllRemoteResources(Context context, Set<Class<?>> targetClasses, int partitionId, long containerId, boolean silent) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            boolean succeeded = false;
            try {
                for (Class<?> clazz : targetClasses == null ? context.getReferenceTargetClasses() : targetClasses) {
                    Iterator<RemoteReference<?>> it = context.getRemoteReferences(clazz).iterator();
                    while (it.hasNext()) {
                        RemoteReference<?> ref = it.next();
                        if (targetClasses == null || ref.partitionId == partitionId && ref.containerId == containerId) {
                            if (silent) {
                                try {
                                    this.closeRemoteResource(context, ref, true);
                                }
                                catch (Throwable throwable) {}
                            } else {
                                this.closeRemoteResource(context, ref, true);
                            }
                        }
                        it.remove();
                    }
                }
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.closeAllRemoteResources(context, targetClasses, partitionId, containerId, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRemoteResource(Context context, RemoteReference<?> ref, boolean refMapRetained) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            try {
                ref.close(this, context);
            }
            finally {
                try {
                    if (!refMapRetained) {
                        context.removeRemoteReference(ref);
                    }
                }
                finally {
                    ref.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContext(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            try {
                this.closeAllRemoteResources(context, null, 0, 0L, false);
            }
            finally {
                context.partitionId = -1;
                context.lastConnection = null;
                context.closed = true;
                Iterator it = context.activeConnections.values().iterator();
                while (it.hasNext()) {
                    NodeConnection connection = (NodeConnection)it.next();
                    try {
                        if (connection != null) {
                            this.pool.add(connection);
                        }
                        connection = null;
                    }
                    finally {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastConnection(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            return context.lastConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkActiveConnection(Context context, int partitionId, Object connection) throws GSException {
        SocketAddress address = ((NodeConnection)connection).getRemoteSocketAddress();
        Context context2 = context;
        synchronized (context2) {
            NodeConnection activeConnection = (NodeConnection)context.activeConnections.get(address);
            if (activeConnection == null || activeConnection != connection) {
                throw GSErrorCode.newGSRecoverableException(145042, "", null);
            }
        }
    }

    private static boolean isConnectionDependentStatement(Statement.GeneralStatement statement) {
        return statement == Statement.CLOSE_ROW_SET.generalize() || statement == Statement.FETCH_ROW_SET.generalize();
    }

    public void executeStatement(Context context, Statement statement, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp) throws GSException {
        this.executeStatement(context, statement.generalize(), partitionId, statementId, req, resp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStatement(Context context, Statement.GeneralStatement statement, int partitionId, long statementId, BasicBuffer req, BasicBuffer resp, ContextMonitor contextMonitor) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            ContextMonitor localMonitor;
            if (context.closed) {
                throw new GSException(145040, "Already closed");
            }
            ContextMonitor contextMonitor2 = localMonitor = contextMonitor == null ? context.contextMonitor : contextMonitor;
            if (localMonitor != null && contextMonitor == null) {
                localMonitor.startStatement(statement, statementId, partitionId, null);
            }
            int reqLength = req.base().position();
            SocketAddress orgAddress = null;
            long failoverStartTime = 0L;
            long failoverTrialCount = 0L;
            long failoverReconnectedTrial = -1L;
            FailureHistory history = null;
            boolean firstTrial = true;
            while (true) {
                try {
                    if (statement == null) {
                        if (localMonitor != null) {
                            localMonitor.startStatementIO();
                        }
                        context.activeResolverExecutor.execute();
                    } else {
                        this.updateConnection(context, partitionId, firstTrial);
                        if (localMonitor != null) {
                            localMonitor.startStatementIO();
                        }
                        context.lastConnection.executeStatement(statement, context.partitionId, statementId, req, resp);
                    }
                    if (!firstTrial) {
                        if (failoverTrialCount > 0L) {
                            context.failoverCount++;
                        }
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info(failoverTrialCount > 0L ? "connection.failoverSucceeded" : "connection.retrySucceeded", ContextMonitor.getObjectId(context), statement, orgAddress, context.getLastRemoteAddress(), partitionId, statementId, failoverTrialCount);
                        }
                    }
                    if (localMonitor == null) break;
                    localMonitor.endStatementIO();
                    if (contextMonitor != null) break;
                    localMonitor.endStatement();
                    break;
                }
                catch (GSConnectionException e) {
                    long failoverTimeout;
                    long failureMillis;
                    try {
                        if (context.lastConnection != null) {
                            if (!firstTrial && context.lastHeartbeatCount != context.lastConnection.getHeartbeatReceiveCount()) {
                                failoverStartTime = 0L;
                                failoverReconnectedTrial = failoverTrialCount;
                            }
                            SocketAddress address = context.lastConnection.getRemoteSocketAddress();
                            context.activeConnections.remove(address);
                            try {
                                context.lastConnection.close();
                            }
                            catch (GSException gSException) {
                                // empty catch block
                            }
                            if (orgAddress != null) {
                                orgAddress = address;
                            }
                        }
                        context.lastConnection = null;
                    }
                    finally {
                        if (this.statementRetryMode == 0) {
                            this.invalidateMaster(context);
                        }
                    }
                    req.base().position(reqLength);
                    if (localMonitor != null) {
                        localMonitor.endStatementIO();
                    }
                    if (context.fixedAddress != null) {
                        throw e;
                    }
                    if (statement != null && GridStoreChannel.isConnectionDependentStatement(statement)) {
                        throw GSErrorCode.newGSRecoverableException(145042, null, e);
                    }
                    long curTime = System.currentTimeMillis();
                    if ((this.statementRetryMode == 0 || this.statementRetryMode == 2) && firstTrial && !(e instanceof GSWrongNodeException)) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("connection.retryStarted", ContextMonitor.getObjectId(context), statement, orgAddress, partitionId, statementId, failoverTrialCount, e);
                        }
                        history = FailureHistory.prepare(history);
                        history.add(e, curTime);
                    }
                    if (failoverStartTime == 0L) {
                        failoverStartTime = curTime;
                    }
                    if ((failureMillis = curTime - failoverStartTime) >= (failoverTimeout = this.getFailoverTimeoutMillis(context))) {
                        String errorMessage = GridStoreChannel.formatTimeoutError(failoverStartTime, failoverTrialCount, failoverReconnectedTrial, history, firstTrial, curTime, failoverTimeout, e);
                        throw new GSTimeoutException(e.getErrorCode(), errorMessage, e);
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("connection.failoverWorking", ContextMonitor.getObjectId(context), statement, orgAddress, partitionId, statementId, failoverTrialCount, failureMillis, failoverTimeout, e);
                    }
                    if (this.statementRetryMode == 2 && failoverTrialCount > 0L || this.statementRetryMode == 1 && e instanceof GSWrongNodeException) {
                        this.invalidateMaster(context);
                    }
                    try {
                        Thread.sleep(this.config.getFailoverRetryIntervalMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++failoverTrialCount;
                    history = FailureHistory.prepare(history);
                    history.add(e, curTime);
                }
                catch (GSStatementException e) {
                    if (!firstTrial && failoverTrialCount > 0L) {
                        context.failoverCount++;
                    }
                    if (!firstTrial && LOGGER.isInfoEnabled()) {
                        LOGGER.info("connection.statementErrorAfter" + (failoverTrialCount > 0L ? "Failover" : "Retry"), ContextMonitor.getObjectId(context), statement, orgAddress, context.getLastRemoteAddress(), partitionId, statementId, failoverTrialCount, e);
                    }
                    throw e;
                }
                firstTrial = false;
            }
        }
    }

    private static String formatTimeoutError(long failoverStartTime, long failoverTrialCount, long failoverReconnectedTrial, FailureHistory history, boolean firstTrial, long curTime, long failoverTimeout, GSException reason) {
        String reasonStr;
        long failureMillis = curTime - failoverStartTime;
        String string = reasonStr = reason.getMessage() == null ? "" : reason.getMessage();
        if (failoverTimeout > 0L) {
            StringBuilder builder = new StringBuilder();
            builder.append("Failover timed out (trialCount=");
            builder.append(failoverTrialCount);
            if (failoverReconnectedTrial >= 0L) {
                builder.append(", reconnectedTrial=");
                builder.append(failoverReconnectedTrial);
            }
            builder.append(", failureMillis=");
            builder.append(failureMillis);
            builder.append(", timeoutMillis=");
            builder.append(failoverTimeout);
            builder.append(", reason=");
            builder.append(reasonStr);
            if (history != null) {
                history.format(builder, failoverTrialCount, curTime);
            }
            builder.append(")");
            return builder.toString();
        }
        if (!firstTrial) {
            StringBuilder builder = new StringBuilder();
            builder.append("Retry failed (reason=");
            builder.append(reasonStr);
            builder.append(")");
            return builder.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeResolver(Context context, ResolverExecutor<T> executor) throws GSException {
        context.activeResolverExecutor = executor;
        try {
            this.executeStatement(context, null, 0, 0L, context.getRequestBuffer(), null, null);
            Object t = executor.result;
            return t;
        }
        finally {
            context.activeResolverExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnection(Context context, int partitionId, boolean preferConnectionPool) throws GSException {
        InetSocketAddress cachedAddress;
        InetSocketAddress address;
        NodeConnection lastConnection = context.lastConnection;
        if (lastConnection != null && context.partitionId == partitionId) {
            return;
        }
        if (context.fixedAddress != null) {
            address = context.fixedAddress;
        } else if (partitionId >= 0 && partitionId < context.addressCache.size() && (cachedAddress = (InetSocketAddress)context.addressCache.get(partitionId)) != null) {
            address = cachedAddress;
        } else {
            address = this.nodeResolver.getNodeAddress(context.clusterInfo, partitionId, !context.loginInfo.isOwnerMode(), (InetAddress)context.preferableHosts.get(partitionId));
            int partitionCount = this.nodeResolver.getPartitionCount(context.clusterInfo);
            if (partitionId >= 0 && partitionId < partitionCount) {
                while (partitionId >= context.addressCache.size()) {
                    context.addressCache.add(null);
                }
                context.addressCache.set(partitionId, address);
            }
        }
        if (lastConnection != null && address.equals(lastConnection.getRemoteSocketAddress())) {
            context.partitionId = partitionId;
            return;
        }
        context.lastConnection = (NodeConnection)context.activeConnections.get(address);
        if (context.lastConnection != null) {
            context.partitionId = partitionId;
            return;
        }
        BasicBuffer req = this.createRequestBuffer(64);
        BasicBuffer resp = this.createResponseBuffer(64);
        long[] databaseId = new long[1];
        NodeConnection newConnection = this.pool.resolve(address, req, resp, this.connectionConfig, context.loginInfo, databaseId, preferConnectionPool);
        this.nodeResolver.acceptDatabaseId(context.clusterInfo, databaseId[0], (InetSocketAddress)newConnection.getRemoteSocketAddress());
        boolean updated = false;
        try {
            context.activeConnections.put(address, newConnection);
            context.lastConnection = newConnection;
            context.lastHeartbeatCount = newConnection.getHeartbeatReceiveCount();
            context.partitionId = partitionId;
            updated = true;
        }
        finally {
            if (!updated) {
                context.lastConnection = null;
                context.partitionId = -1;
                try {
                    context.activeConnections.remove(address);
                }
                finally {
                    this.pool.add(newConnection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateMaster(Context context) {
        Context context2 = context;
        synchronized (context2) {
            context.addressCache.clear();
            this.nodeResolver.invalidateMaster(context.clusterInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkContextAvailable(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            if (context.closed) {
                throw new GSException(145040, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDatabaseId(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            final NodeResolver.ClusterInfo clusterInfo = context.clusterInfo;
            if (clusterInfo.getDatabaseId() == null) {
                this.executeResolver(context, new ResolverExecutor<Void>(){

                    @Override
                    public void execute() throws GSException {
                        GridStoreChannel.this.nodeResolver.getDatabaseId(clusterInfo);
                    }
                });
            }
            return clusterInfo.getDatabaseId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InetSocketAddress> getActiveNodeAddressSet(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            final NodeResolver.ClusterInfo clusterInfo = context.clusterInfo;
            return this.executeResolver(context, new ResolverExecutor<Set<InetSocketAddress>>(){

                @Override
                public void execute() throws GSException {
                    this.result = GridStoreChannel.this.nodeResolver.getActiveNodeAddressSet(clusterInfo);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress[] getNodeAddressList(Context context, final int partitionId) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            final NodeResolver.ClusterInfo clusterInfo = context.clusterInfo;
            return this.executeResolver(context, new ResolverExecutor<InetSocketAddress[]>(){

                @Override
                public void execute() throws GSException {
                    this.result = GridStoreChannel.this.nodeResolver.getNodeAddressList(clusterInfo, partitionId);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPartitionCount(Context context) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            final NodeResolver.ClusterInfo clusterInfo = context.clusterInfo;
            if (clusterInfo.getPartitionCount() == null) {
                this.executeResolver(context, new ResolverExecutor<Void>(){

                    @Override
                    public void execute() throws GSException {
                        GridStoreChannel.this.nodeResolver.getPartitionCount(clusterInfo);
                    }
                });
            }
            return clusterInfo.getPartitionCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resolvePartitionId(Context context, ContainerKeyConverter.ContainerKey containerKey, boolean internalMode) throws GSException {
        Context context2 = context;
        synchronized (context2) {
            String base;
            boolean withSubCount;
            NodeResolver.ContainerHashMode hashMode;
            Integer partitionCount;
            final NodeResolver.ClusterInfo clusterInfo = context.clusterInfo;
            while (true) {
                partitionCount = clusterInfo.getPartitionCount();
                hashMode = clusterInfo.getHashMode();
                if (partitionCount != null && hashMode != null) break;
                this.executeResolver(context, new ResolverExecutor<Void>(){

                    @Override
                    public void execute() throws GSException {
                        GridStoreChannel.this.nodeResolver.getPartitionCount(clusterInfo);
                        GridStoreChannel.this.nodeResolver.getContainerHashMode(clusterInfo);
                    }
                });
            }
            ContainerKeyConverter converter = context.getKeyConverter(true, false);
            ContainerKeyConverter.Components components = new ContainerKeyConverter.Components();
            converter.decompose(containerKey, components);
            String affinity = components.affinityStr == null ? null : RowMapper.normalizeSymbolUnchecked(components.affinityStr);
            boolean bl = withSubCount = components.subCount >= 0;
            if (components.affinityNum >= 0L) {
                return (int)(components.affinityNum % (long)partitionCount.intValue());
            }
            if (components.affinityStr != null && !withSubCount) {
                return GridStoreChannel.calculatePartitionId(affinity, hashMode, partitionCount);
            }
            String string = base = affinity == null ? RowMapper.normalizeSymbolUnchecked(components.base) : affinity;
            if (withSubCount) {
                int subCount = components.subCount;
                int subId = (int)components.largeId;
                if (partitionCount <= subCount) {
                    return subId % partitionCount;
                }
                int pbase = partitionCount / subCount;
                int pmod = partitionCount % subCount;
                int baseHash = GridStoreChannel.calculatePartitionId(base, hashMode, pbase);
                return pbase * subId + Math.min(pmod, subId) + baseHash;
            }
            int partitionId = GridStoreChannel.calculatePartitionId(base, hashMode, partitionCount);
            if (components.largeId >= 0L) {
                partitionId = (int)((long)partitionId + components.largeId) % partitionCount;
            }
            return partitionId;
        }
    }

    public static int calculatePartitionId(String normalizedString, NodeResolver.ContainerHashMode hashMode, int partitionCount) throws GSException {
        byte[] bytes = normalizedString.getBytes(BasicBuffer.DEFAULT_CHARSET);
        switch (hashMode) {
            case COMPATIBLE1: {
                CRC32 crc = new CRC32();
                crc.update(bytes);
                return (int)((crc.getValue() & 0xFFFFFFFFFFFFFFFFL) % (long)partitionCount);
            }
            case MD5: {
                MessageDigest md = NodeConnection.MessageDigestFactory.MD5.create();
                md.update(bytes);
                byte[] digest = md.digest();
                long hash = 0L;
                for (int i = 0; i < 4; ++i) {
                    hash = hash << 8 | (long)(digest[i] & 0xFF);
                }
                return (int)(hash % (long)partitionCount);
            }
        }
        throw new GSException(145000, "Unsupported hash mode");
    }

    public static boolean isMasterResolvableByConnection() {
        return NodeConnection.getProtocolVersion() >= 8;
    }

    public static NodeResolver.ContainerHashMode getDefaultContainerHashMode() {
        if (NodeConnection.getProtocolVersion() < 14 || v40ContainerHashCompatible) {
            return NodeResolver.ContainerHashMode.COMPATIBLE1;
        }
        return NodeResolver.ContainerHashMode.MD5;
    }

    public static int statementToNumber(Statement statement) {
        return NodeConnection.statementToNumber(statement.generalize());
    }

    @Override
    public void close() throws GSException {
        try {
            this.closeAllContext(false);
        }
        finally {
            try {
                this.nodeResolver.close();
            }
            finally {
                this.pool.close();
            }
        }
    }

    static ContextMonitor tryCreateGeneralContextMonitor() {
        if (STATEMENT_LOGGER.isDebugEnabled()) {
            return new ContextMonitor();
        }
        return null;
    }

    static ContextMonitor tryCreateContainerContextMonitor(Context context) {
        if (STATEMENT_LOGGER.isDebugEnabled() || context.getConfig().containerMonitoring) {
            return new ContextMonitor();
        }
        return null;
    }

    static /* synthetic */ int access$000() {
        return FAILOVER_TIMEOUT_DEFAULT;
    }

    static /* synthetic */ int access$100() {
        return FAILOVER_RETRY_INTERVAL;
    }

    static class ContextMonitor {
        ContainerKeyConverter.ContainerKey containerKey;
        String query;
        long statementStartTime;
        long statementIOStartTime;
        long statementIOTotalTime;
        long sessionStartTime;
        long transactionStartTime;
        boolean containerIdSpecified;
        boolean sessionSpecified;
        boolean transactionStarted;
        Statement.GeneralStatement lastStatement;
        long lastStatementId;
        int lastPartitionId;
        long lastContainerId;
        long lastSessionId;

        ContextMonitor() {
        }

        void setContainerKey(ContainerKeyConverter.ContainerKey containerKey) {
            this.containerKey = containerKey;
        }

        void setQuery(String query) {
            this.query = query;
        }

        void startStatement(Statement.GeneralStatement statement, long statementId, int partitionId, Long containerId) {
            this.statementStartTime = System.nanoTime();
            this.statementIOTotalTime = 0L;
            this.lastStatement = statement;
            this.lastStatementId = statementId;
            this.lastPartitionId = partitionId;
            if (containerId == null) {
                this.lastContainerId = 0L;
                this.containerIdSpecified = false;
            } else {
                this.lastContainerId = containerId;
                this.containerIdSpecified = true;
            }
            this.logStatement(true);
        }

        void endStatement() {
            this.logStatement(false);
        }

        private void logStatement(boolean start) {
            ArrayList<Object> args;
            String key;
            block9: {
                block8: {
                    block7: {
                        if (!STATEMENT_LOGGER.isDebugEnabled()) {
                            return;
                        }
                        key = "statementExec.";
                        key = key + (start ? "started" : "ended");
                        args = new ArrayList<Object>();
                        args.add(ContextMonitor.getObjectId(this));
                        args.add(this.lastStatement);
                        args.add(this.lastStatementId);
                        args.add(this.lastPartitionId);
                        args.add(this.lastSessionId);
                        if (this.containerKey == null) break block7;
                        args.add(this.containerKey);
                        break block8;
                    }
                    if (!this.containerIdSpecified) break block9;
                    args.add(this.lastContainerId);
                }
                if (this.query == null) {
                    key = key + "WithContainer";
                } else {
                    args.add(this.query);
                    key = key + "WithQuery";
                }
            }
            if (!start) {
                long totalTime = System.nanoTime() - this.statementStartTime;
                args.add(ContextMonitor.formatNanosAsMillis(this.statementIOTotalTime));
                args.add(ContextMonitor.formatNanosAsMillis(totalTime - this.statementIOTotalTime));
            }
            STATEMENT_LOGGER.debug(key, args.toArray());
        }

        void startStatementIO() {
            this.statementIOStartTime = System.nanoTime();
        }

        void endStatementIO() {
            this.statementIOTotalTime += System.nanoTime() - this.statementIOStartTime;
        }

        void startSession(long sessionId) {
            this.sessionStartTime = System.nanoTime();
            this.lastSessionId = sessionId;
            this.sessionSpecified = true;
        }

        void endSession() {
            this.sessionStartTime = 0L;
            this.lastSessionId = 0L;
            this.sessionSpecified = false;
        }

        void startTransaction() {
            this.transactionStartTime = System.nanoTime();
            this.transactionStarted = true;
        }

        void endTransaction() {
            this.transactionStartTime = 0L;
            this.transactionStarted = false;
        }

        static String getObjectId(Object obj) {
            return Long.toHexString(System.identityHashCode(obj));
        }

        GSStatementException analyzeStatementException(GSStatementException e, Context context, Object resource) {
            long curTime = System.nanoTime();
            StringBuilder message = new StringBuilder();
            Formatter formatter = new Formatter(message);
            message.append("reason=").append(e.getMessage());
            message.append(", localContext=").append(ContextMonitor.getObjectId(this));
            message.append(", context=").append(ContextMonitor.getObjectId(context));
            message.append(", resource=").append(ContextMonitor.getObjectId(resource));
            if (resource != null) {
                message.append(", resourceClass=");
                message.append(resource.getClass().getSimpleName());
            }
            if (this.lastStatement != null) {
                message.append(", statement=").append(this.lastStatement);
                message.append(", statementId=").append(this.lastStatementId);
                message.append(", statementMillis=");
                ContextMonitor.formatNanosAsMillis(formatter, curTime - this.statementStartTime);
                message.append(", partitionId=").append(this.lastPartitionId);
            }
            if (this.containerIdSpecified) {
                message.append(", containerId=").append(this.lastContainerId);
            }
            if (this.sessionSpecified) {
                message.append(", sessionId=").append(this.lastSessionId);
                message.append(", sessionMillis=");
                ContextMonitor.formatNanosAsMillis(formatter, curTime - this.sessionStartTime);
            }
            if (this.transactionStarted) {
                message.append(", transactionMillis=");
                ContextMonitor.formatNanosAsMillis(formatter, curTime - this.transactionStartTime);
            }
            return new GSStatementException(e.getErrorCode(), message.toString(), e);
        }

        private static void formatNanosAsMillis(Formatter formatter, long nanoTime) {
            formatter.format("%.3f", (double)nanoTime / 1000.0 / 1000.0);
        }

        private static String formatNanosAsMillis(long nanoTime) {
            return String.format("%.3f", (double)nanoTime / 1000.0 / 1000.0);
        }
    }

    static class FailureHistory {
        private static final int MAX_HISTORY_SIZE = 10;
        private final List<FailureEntry> entryList = new ArrayList<FailureEntry>(10);
        private long totalTrial;
        private long initialTimeMillis;
        private long lastTimeMillis;
        private boolean reduced;

        FailureHistory() {
        }

        static FailureHistory prepare(FailureHistory instance) {
            if (instance == null) {
                return new FailureHistory();
            }
            return instance;
        }

        void add(GSException reason, long curTimeMillis) {
            if (this.totalTrial == 0L) {
                this.initialTimeMillis = curTimeMillis;
                this.lastTimeMillis = curTimeMillis;
            }
            ++this.totalTrial;
            while (this.entryList.size() >= 10) {
                long minMillis = Long.MAX_VALUE;
                int minIndex = -1;
                for (int i = 0; i < this.entryList.size(); ++i) {
                    long millis = this.entryList.get((int)i).millisFromPrev;
                    if (millis >= minMillis) continue;
                    minMillis = millis;
                    minIndex = i;
                }
                if (minIndex < 0) break;
                this.entryList.remove(minIndex);
                this.reduced = true;
            }
            long millisFromInitial = curTimeMillis - this.initialTimeMillis;
            long millisFromPrev = curTimeMillis - this.lastTimeMillis;
            this.entryList.add(new FailureEntry(this.totalTrial, millisFromInitial, millisFromPrev, reason));
            this.lastTimeMillis = curTimeMillis;
        }

        void format(StringBuilder builder, long failureTrial, long curTimeMillis) {
            if (this.totalTrial != (long)this.entryList.size()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append("historySize=");
                builder.append(this.totalTrial);
            }
            if (!this.entryList.isEmpty()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append("history");
                if (this.reduced) {
                    builder.append("OfTop");
                    builder.append(this.entryList.size());
                }
                builder.append("(trial, millisFromInitial, millisFromPrev, reason)=");
                if (this.entryList.size() > 1) {
                    builder.append("[");
                }
                boolean first = true;
                for (FailureEntry entry : this.entryList) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append("(");
                    builder.append(entry.trialNumber);
                    builder.append(", ");
                    builder.append(entry.millisFromInitial);
                    builder.append(", ");
                    builder.append(entry.millisFromPrev);
                    builder.append(", ");
                    builder.append(entry.reason.getMessage());
                    builder.append(")");
                }
                if (this.entryList.size() > 1) {
                    builder.append("]");
                }
            }
        }

        static class FailureEntry {
            final long trialNumber;
            final long millisFromInitial;
            final long millisFromPrev;
            final GSException reason;

            private FailureEntry(long trialNumber, long millisFromInitial, long millisFromPrev, GSException reason) {
                this.trialNumber = trialNumber;
                this.millisFromInitial = millisFromInitial;
                this.millisFromPrev = millisFromPrev;
                this.reason = reason;
            }
        }
    }

    private static class PlainTransportProvider
    implements Extensibles.TransportProvider {
        private PlainTransportProvider() {
        }

        @Override
        public void filterProperties(Properties src, Properties transProps) throws GSException {
            for (String key : Extensibles.AsStoreFactory.getReservedTransportPropertyKeys()) {
                if (!src.containsKey(key)) continue;
                throw new GSException(145005, "Unacceptable property specified because of lack of extra library (key=" + key + ")");
            }
        }

        @Override
        public boolean isPlainSocketAllowed(Properties props) throws GSException {
            return true;
        }

        @Override
        public SSLSocketFactory createSecureSocketFactory(Properties props) throws GSException {
            return null;
        }
    }

    public static class DataAffinityPattern {
        private static final Pattern MATCH_PATTERN = Pattern.compile("([^%]+)|((?<!\\\\)%)");
        private static final Pattern WILDCARD_PATTERN = Pattern.compile("(?<!\\\\)%");
        private static final Pattern ENTRY_SEPARATOR_PATTERN = Pattern.compile("(?<!\\\\),");
        private static final Pattern PAIR_SEPARATOR_PATTERN = Pattern.compile("(?<!\\\\)=");
        private static final Pattern DUPLICATE_WILDCARD_PATTERN = Pattern.compile("(?<!\\\\)%%");
        private static final Pattern ESCAPED_CHAR_PATTERN = Pattern.compile("\\\\(.)");
        private static final Pattern ESCAPED_NODE_AFFINITY_SEPARATOR_PATTERN = Pattern.compile("\\\\@");
        private List<Entry> entryList = new ArrayList<Entry>();

        public DataAffinityPattern(String patternStr, ContainerKeyConverter keyConverter) throws GSException {
            if (patternStr == null || patternStr.isEmpty()) {
                return;
            }
            for (String entryStr : ENTRY_SEPARATOR_PATTERN.split(patternStr, -1)) {
                String[] pair = PAIR_SEPARATOR_PATTERN.split(entryStr);
                if (pair.length != 2) {
                    throw new GSException(145002, "Illegal data affinity pattern entry (entry=\"" + entryStr + "\", pattern=\"" + patternStr + "\")");
                }
                ContainerKeyConverter.Components components = new ContainerKeyConverter.Components();
                String keyPattern = pair[0];
                try {
                    String modKeyPattern = DataAffinityPattern.unescapeNodeAffinity(keyPattern);
                    keyConverter.parse(DataAffinityPattern.unescape(WILDCARD_PATTERN.matcher(modKeyPattern).replaceAll("_")), new ContainerKeyConverter.Components(), true);
                    keyConverter.parse(modKeyPattern, components, false);
                }
                catch (GSException e) {
                    throw new GSException(145002, "Illegal character found or empty key pattern found in data affinity pattern (keyPattern=\"" + keyPattern + "\", entry=\"" + entryStr + "\", pattern=\"" + patternStr + "\")");
                }
                if (DUPLICATE_WILDCARD_PATTERN.matcher(keyPattern).find()) {
                    throw new GSException(145002, "Duplicate wildcard found in data affinity pattern (keyPattern=\"" + keyPattern + "\", entry=\"" + entryStr + "\", pattern=\"" + patternStr + "\")");
                }
                String dataAffinity = DataAffinityPattern.unescape(pair[1]);
                try {
                    RowMapper.checkSymbol(dataAffinity, "data affinity");
                }
                catch (GSException e) {
                    throw new GSException(145002, "Illegal data affinity specified in data affinity pattern (affinity=\"" + dataAffinity + "\", entry=\"" + entryStr + "\", pattern=\"" + patternStr + "\", reason=" + e + ")", e);
                }
                boolean[] wildCardEnd = new boolean[1];
                Pattern basePattern = DataAffinityPattern.createPattern(components.base, keyConverter, wildCardEnd);
                boolean nodeAffinityFound = components.affinityStr != null || components.affinityNum >= 0L;
                Pattern nodeAffinityStrPattern = components.affinityStr == null ? null : DataAffinityPattern.createPattern(components.affinityStr, keyConverter, null);
                boolean nodeAffinityIgnorable = !nodeAffinityFound && wildCardEnd[0];
                this.entryList.add(new Entry(basePattern, nodeAffinityStrPattern, components.affinityNum, nodeAffinityIgnorable, dataAffinity));
            }
        }

        private static Pattern createPattern(String src, ContainerKeyConverter keyConverter, boolean[] wildCardEndRef) {
            Matcher matcher = MATCH_PATTERN.matcher(src);
            StringBuilder patternBuilder = new StringBuilder();
            patternBuilder.append("^");
            boolean wildCardEnd = false;
            while (matcher.find()) {
                if (matcher.group(2) == null) {
                    String elem = DataAffinityPattern.unescape(matcher.group(1));
                    try {
                        keyConverter.parse("_" + elem, false);
                    }
                    catch (GSException e) {
                        throw new Error(e);
                    }
                    patternBuilder.append(Pattern.quote(DataAffinityPattern.normalize(elem)));
                    wildCardEnd = false;
                    continue;
                }
                patternBuilder.append(".*");
                wildCardEnd = true;
            }
            patternBuilder.append("$");
            if (wildCardEndRef != null) {
                wildCardEndRef[0] = wildCardEnd;
            }
            return Pattern.compile(patternBuilder.toString());
        }

        public String match(ContainerKeyConverter.ContainerKey containerKey, String defaultAffinity, ContainerKeyConverter keyConverter) throws GSException {
            if (!this.entryList.isEmpty()) {
                ContainerKeyConverter.Components components = new ContainerKeyConverter.Components();
                keyConverter.decompose(containerKey, components);
                for (Entry entry : this.entryList) {
                    String nodeAffinityStr;
                    if (!entry.basePattern.matcher(DataAffinityPattern.normalize(components.base)).find()) continue;
                    if (entry.nodeAffinityIgnorable) {
                        return entry.affinity;
                    }
                    long nodeAffinityNum = components.affinityNum;
                    if (entry.nodeAffinityNum >= 0L && nodeAffinityNum == entry.nodeAffinityNum) {
                        return entry.affinity;
                    }
                    String string = nodeAffinityStr = nodeAffinityNum >= 0L ? Long.toString(nodeAffinityNum) : components.affinityStr;
                    if (entry.nodeAffinityStrPattern != null ? nodeAffinityStr == null || !entry.nodeAffinityStrPattern.matcher(DataAffinityPattern.normalize(nodeAffinityStr)).find() : nodeAffinityStr != null) continue;
                    return entry.affinity;
                }
            }
            return defaultAffinity;
        }

        private static String unescape(String src) {
            return ESCAPED_CHAR_PATTERN.matcher(src).replaceAll("$1");
        }

        private static String unescapeNodeAffinity(String src) {
            return ESCAPED_NODE_AFFINITY_SEPARATOR_PATTERN.matcher(src).replaceAll("@");
        }

        private static String normalize(String src) {
            return RowMapper.normalizeSymbolUnchecked(src);
        }

        private static class Entry {
            final Pattern basePattern;
            final Pattern nodeAffinityStrPattern;
            final long nodeAffinityNum;
            final boolean nodeAffinityIgnorable;
            final String affinity;

            private Entry(Pattern basePattern, Pattern nodeAffinityStrPattern, long nodeAffinityNum, boolean nodeAffinityIgnorable, String affinity) {
                this.basePattern = basePattern;
                this.nodeAffinityStrPattern = nodeAffinityStrPattern;
                this.nodeAffinityNum = nodeAffinityNum;
                this.nodeAffinityIgnorable = nodeAffinityIgnorable;
                this.affinity = affinity;
            }
        }
    }

    public static class SessionInfo {
        private final Key key;
        private final long sessionId;
        private final long lastStatementId;

        public SessionInfo(int partitionId, long containerId, long sessionId, long lastStatementId) {
            this.key = new Key(partitionId, containerId);
            this.sessionId = sessionId;
            this.lastStatementId = lastStatementId;
        }

        public int getPartitionId() {
            return this.key.partitionId;
        }

        public long getContainerId() {
            return this.key.containerId;
        }

        public long getSessionId() {
            return this.sessionId;
        }

        public long getLastStatementId() {
            return this.lastStatementId;
        }

        private static class Key {
            private final int partitionId;
            private final long containerId;

            public Key(int partitionId, long containerId) {
                this.partitionId = partitionId;
                this.containerId = containerId;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (int)(this.containerId ^ this.containerId >>> 32);
                result = 31 * result + this.partitionId;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                if (this.containerId != other.containerId) {
                    return false;
                }
                return this.partitionId == other.partitionId;
            }
        }
    }

    public static class LocatedSchema {
        private final RowMapper mapper;
        private final long containerId;
        private final int versionId;
        private final ContainerKeyConverter.ContainerKey containerKey;

        public LocatedSchema(RowMapper mapper, long containerId, int versionId, ContainerKeyConverter.ContainerKey containerKey) {
            this.mapper = mapper;
            this.containerId = containerId;
            this.versionId = versionId;
            this.containerKey = containerKey;
        }

        public RowMapper getMapper() {
            return this.mapper;
        }

        public long getContainerId() {
            return this.containerId;
        }

        public int getVersionId() {
            return this.versionId;
        }

        public ContainerKeyConverter.ContainerKey getContainerKey() {
            return this.containerKey;
        }
    }

    public static class ContainerCache {
        private final int cacheSize;
        private final Map<ContainerKeyConverter.ContainerKey, LocatedSchema> schemaCache = new LinkedHashMap<ContainerKeyConverter.ContainerKey, LocatedSchema>();
        private final Map<SessionInfo.Key, SessionInfo> sessionCache = new LinkedHashMap<SessionInfo.Key, SessionInfo>();

        public ContainerCache(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        public LocatedSchema findSchema(ContainerKeyConverter.ContainerKey normalizedContainerKey, Class<?> rowType, ContainerType containerType) {
            LocatedSchema schema = this.schemaCache.get(normalizedContainerKey);
            if (schema == null || rowType != null && rowType != schema.mapper.getRowType() || containerType != null && containerType != schema.mapper.getContainerType()) {
                return null;
            }
            return schema;
        }

        public void cacheSchema(ContainerKeyConverter.ContainerKey normalizedContainerKey, LocatedSchema schema) {
            this.schemaCache.put(normalizedContainerKey, schema);
            if (this.schemaCache.size() > this.cacheSize) {
                Iterator<LocatedSchema> it = this.schemaCache.values().iterator();
                it.next();
                it.remove();
            }
        }

        public void removeSchema(ContainerKeyConverter.ContainerKey normalizedContainerKey) {
            this.schemaCache.remove(normalizedContainerKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionInfo takeSession(Context context, int partitionId, long containerId) {
            Context context2 = context;
            synchronized (context2) {
                return this.sessionCache.remove(new SessionInfo.Key(partitionId, containerId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionInfo cacheSession(Context context, SessionInfo sessionInfo) {
            Context context2 = context;
            synchronized (context2) {
                SessionInfo old = this.sessionCache.put(sessionInfo.key, sessionInfo);
                if (old != null) {
                    return old;
                }
                if (this.sessionCache.size() > this.cacheSize) {
                    Iterator<SessionInfo> it = this.sessionCache.values().iterator();
                    SessionInfo earliest = it.next();
                    it.remove();
                    return earliest;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SessionInfo> takeAllSessions(Context context) {
            Context context2 = context;
            synchronized (context2) {
                ArrayList<SessionInfo> list = new ArrayList<SessionInfo>(this.sessionCache.values());
                this.sessionCache.clear();
                return list;
            }
        }
    }

    public static class ContextReference
    extends WeakReference<Object> {
        final Context context;

        ContextReference(Object target, Context context) {
            super(target);
            this.context = context;
        }
    }

    public static class Context {
        private final ContextMonitor contextMonitor = GridStoreChannel.tryCreateGeneralContextMonitor();
        private final LocalConfig localConfig;
        private int partitionId = -1;
        private NodeConnection lastConnection;
        private long lastHeartbeatCount;
        private final Map<SocketAddress, NodeConnection> activeConnections = new HashMap<SocketAddress, NodeConnection>();
        private final NodeConnection.LoginInfo loginInfo;
        private final NodeResolver.ClusterInfo clusterInfo;
        private boolean closed;
        private int failoverCount;
        private final BasicBuffer req;
        private BasicBuffer resp;
        private final BasicBuffer syncReq;
        private final BasicBuffer syncResp;
        private final NodeConnection.OptionalRequest optionalRequest = new NodeConnection.OptionalRequest();
        private final List<InetSocketAddress> addressCache = new ArrayList<InetSocketAddress>();
        private final UUID sessionUUID;
        private long lastSessionId;
        private final Map<Class<?>, Set<RemoteReference<?>>> remoteRefTable = new HashMap();
        private final ReferenceQueue<Object> remoteRefQueue = new ReferenceQueue();
        private final ContainerCache containerCache;
        private final Map<Integer, InetAddress> preferableHosts = new HashMap<Integer, InetAddress>();
        private final DataAffinityPattern dataAffinityPattern;
        private ResolverExecutor<?> activeResolverExecutor;
        private ContainerKeyConverter keyConverter;
        private ContainerKeyConverter systemKeyConverter;
        private ContainerKeyConverter internalKeyConverter;
        private InetSocketAddress fixedAddress;

        private Context(LocalConfig localConfig, NodeConnection.LoginInfo loginInfo, NodeResolver.ClusterInfo clusterInfo, BasicBuffer req, BasicBuffer resp, BasicBuffer syncReq, BasicBuffer syncResp, ContainerKeyConverter keyConverter, DataAffinityPattern dataAffinityPattern) {
            this.localConfig = localConfig;
            this.loginInfo = new NodeConnection.LoginInfo(loginInfo);
            this.loginInfo.setClientId(NodeConnection.ClientId.generate(0L));
            this.clusterInfo = clusterInfo;
            this.req = req;
            this.resp = resp;
            this.syncReq = syncReq;
            this.syncResp = syncResp;
            this.containerCache = localConfig.containerCacheSize > 0 ? new ContainerCache(localConfig.containerCacheSize) : null;
            this.sessionUUID = this.loginInfo.getClientId().getUUID();
            this.keyConverter = keyConverter;
            this.dataAffinityPattern = dataAffinityPattern;
        }

        public boolean isClosedAsync() {
            return this.closed;
        }

        public long getTransactionTimeoutMillis() {
            return this.localConfig.transactionTimeoutMillis;
        }

        public NodeConnection.OptionalRequestSource bindQueryOptions(final NodeConnection.OptionalRequestSource source) {
            final int fetchBytesSize = this.localConfig.fetchBytesSize;
            if (fetchBytesSize <= 0) {
                return source;
            }
            return new NodeConnection.OptionalRequestSource(){

                @Override
                public boolean hasOptions() {
                    return true;
                }

                @Override
                public void putOptions(NodeConnection.OptionalRequest optionalRequest) {
                    optionalRequest.put(NodeConnection.OptionalRequestType.FETCH_BYTES_SIZE, fetchBytesSize);
                    if (source != null) {
                        source.putOptions(optionalRequest);
                    }
                }
            };
        }

        public int getFailoverCount() {
            return this.failoverCount;
        }

        public SocketAddress getLastConnectionAddress() {
            if (this.lastConnection == null) {
                return null;
            }
            return this.lastConnection.getRemoteSocketAddress();
        }

        public BasicBuffer getRequestBuffer() {
            return this.req;
        }

        public BasicBuffer getResponseBuffer() {
            return this.resp;
        }

        public BasicBuffer replaceResponseBuffer(BasicBuffer newResp) {
            BasicBuffer orgResp = this.resp;
            this.resp = newResp;
            return orgResp;
        }

        public BasicBuffer getSynchronizedRequestBuffer() {
            return this.syncReq;
        }

        public BasicBuffer getSynchronizedResponseBuffer() {
            return this.syncResp;
        }

        public NodeConnection.OptionalRequest getOptionalRequest() {
            this.optionalRequest.clear();
            return this.optionalRequest;
        }

        public UUID getSessionUUID() {
            return this.sessionUUID;
        }

        public long generateSessionId() {
            long newId;
            for (newId = this.lastSessionId + 1L; newId == 0L; ++newId) {
            }
            this.lastSessionId = newId;
            return newId;
        }

        public NodeConnection.ClientId generateClientId() {
            return new NodeConnection.ClientId(this.loginInfo.getClientId().getUUID(), this.generateSessionId());
        }

        public Set<Class<?>> getReferenceTargetClasses() {
            return this.remoteRefTable.keySet();
        }

        public Set<RemoteReference<?>> getRemoteReferences(Class<?> targetClass) {
            Set<RemoteReference<?>> set = this.remoteRefTable.get(targetClass);
            return set == null ? Collections.emptySet() : set;
        }

        public void addRemoteReference(RemoteReference<?> reference) {
            Set<RemoteReference<?>> set = this.remoteRefTable.get(reference.targetClass);
            if (set == null) {
                set = new LinkedHashSet();
                this.remoteRefTable.put(reference.targetClass, set);
            }
            set.add(reference);
        }

        public void removeRemoteReference(RemoteReference<?> reference) {
            Set<RemoteReference<?>> set = this.remoteRefTable.get(reference.targetClass);
            if (set == null) {
                return;
            }
            try {
                set.remove(reference);
            }
            finally {
                reference.clear();
            }
        }

        public ContainerCache getContainerCache() {
            return this.containerCache;
        }

        public void setPreferableHost(int partitionId, InetAddress host) {
            if (host == null) {
                this.preferableHosts.remove(partitionId);
            } else {
                this.preferableHosts.put(partitionId, host);
            }
            if (!(partitionId < 0 || partitionId >= this.addressCache.size() || host != null && host.equals(this.addressCache.get(partitionId)))) {
                this.addressCache.set(partitionId, null);
            }
        }

        private SocketAddress getLastRemoteAddress() {
            if (this.lastConnection == null) {
                return null;
            }
            return this.lastConnection.getRemoteSocketAddress();
        }

        public DataAffinityPattern getDataAffinityPattern() {
            return this.dataAffinityPattern;
        }

        public String getUser() {
            return this.loginInfo.getUser();
        }

        public String getDatabaseName() {
            return this.loginInfo.getDatabase();
        }

        public boolean isVisible(ContainerProperties.ContainerVisibility visibility) {
            return this.localConfig.containerVisibility.contains((Object)visibility);
        }

        public ContainerKeyConverter getKeyConverter(boolean internalMode, boolean forModification) {
            boolean systemAllowed;
            boolean bl = systemAllowed = !forModification && (this.isVisible(ContainerProperties.ContainerVisibility.META) || this.isVisible(ContainerProperties.ContainerVisibility.INTERNAL_META) || this.isVisible(ContainerProperties.ContainerVisibility.SYSTEM_TOOL));
            ContainerKeyConverter converter = internalMode ? this.internalKeyConverter : (systemAllowed ? this.systemKeyConverter : this.keyConverter);
            if (converter == null) {
                converter = ContainerKeyConverter.getInstance(NodeConnection.getProtocolVersion(), internalMode, systemAllowed);
                if (internalMode) {
                    this.internalKeyConverter = converter;
                } else if (systemAllowed) {
                    this.systemKeyConverter = converter;
                } else {
                    this.keyConverter = converter;
                }
            }
            return converter;
        }

        public LocalConfig getConfig() {
            return this.localConfig;
        }

        public static class FixedAddressScope
        implements Closeable {
            private final Context context;

            public FixedAddressScope(Context context, InetSocketAddress address) {
                this.context = context;
                this.context.fixedAddress = address;
                this.context.lastConnection = null;
                this.context.partitionId = -1;
            }

            @Override
            public void close() {
                this.context.fixedAddress = null;
                this.context.lastConnection = null;
                this.context.partitionId = -1;
            }
        }
    }

    private static abstract class ResolverExecutor<T> {
        protected T result;

        private ResolverExecutor() {
        }

        public abstract void execute() throws GSException;
    }

    public static abstract class RemoteReference<T>
    extends WeakReference<T> {
        protected final Class<?> targetClass;
        protected final int partitionId;
        protected final long containerId;

        public RemoteReference(T target, Class<?> targetClass, Context context, int partitionId, long containerId) {
            super(target, context.remoteRefQueue);
            this.targetClass = targetClass;
            this.partitionId = partitionId;
            this.containerId = containerId;
        }

        public abstract void close(GridStoreChannel var1, Context var2) throws GSException;
    }

    public static class Key {
        private final boolean passive;
        private final InetSocketAddress address;
        private final InetAddress notificationInterfaceAddress;
        private final String clusterName;
        private final ServiceAddressResolver.Config sarConfig;
        private final List<InetSocketAddress> memberList;
        private final Properties transProps;

        public Key(boolean passive, InetSocketAddress address, InetAddress notificationInterfaceAddress, String clusterName, ServiceAddressResolver.Config sarConfig, List<InetSocketAddress> memberList, Properties transProps) {
            this.passive = passive;
            this.address = address;
            this.notificationInterfaceAddress = notificationInterfaceAddress;
            this.clusterName = clusterName;
            this.sarConfig = sarConfig == null ? null : new ServiceAddressResolver.Config(sarConfig);
            ArrayList<InetSocketAddress> arrayList = this.memberList = sarConfig == null ? Collections.emptyList() : new ArrayList<InetSocketAddress>(memberList);
            if (sarConfig != null) {
                Collections.sort(this.memberList, new ServiceAddressResolver.SocketAddressComparator());
            }
            this.transProps = transProps;
        }

        public boolean isIPV6Enabled() {
            if (this.address == null) {
                return this.sarConfig.isIPv6Expected();
            }
            return this.address.getAddress() instanceof Inet6Address;
        }

        public boolean isPassive() {
            return this.passive;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public InetAddress getNotificationInterfaceAddress() {
            return this.notificationInterfaceAddress;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
            result = 31 * result + (this.memberList == null ? 0 : this.memberList.hashCode());
            result = 31 * result + (this.notificationInterfaceAddress == null ? 0 : this.notificationInterfaceAddress.hashCode());
            result = 31 * result + (this.passive ? 1231 : 1237);
            result = 31 * result + (this.sarConfig == null ? 0 : this.sarConfig.hashCode());
            result = 31 * result + (this.transProps == null ? 0 : this.transProps.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
                return false;
            }
            if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
                return false;
            }
            if (this.memberList == null ? other.memberList != null : !this.memberList.equals(other.memberList)) {
                return false;
            }
            if (this.notificationInterfaceAddress == null ? other.notificationInterfaceAddress != null : !this.notificationInterfaceAddress.equals(other.notificationInterfaceAddress)) {
                return false;
            }
            if (this.passive != other.passive) {
                return false;
            }
            if (this.sarConfig == null ? other.sarConfig != null : !this.sarConfig.equals(other.sarConfig)) {
                return false;
            }
            return !(this.transProps == null ? other.transProps != null : !this.transProps.equals(other.transProps));
        }
    }

    public static class Source {
        private final Key key;
        private final Integer partitionCount;
        private final LocalConfig localConfig;
        private final NodeConnection.LoginInfo loginInfo;
        private final ContainerKeyConverter keyConverter;
        private final DataAffinityPattern dataAffinityPattern;

        public Source(PropertyUtils.WrappedProperties props, Config baseConfig) throws GSException {
            boolean backupPreferred;
            boolean[] passive = new boolean[1];
            ServiceAddressResolver.Config sarConfig = new ServiceAddressResolver.Config();
            ArrayList<InetSocketAddress> memberList = new ArrayList<InetSocketAddress>();
            InetAddress[] notificationInterfaceAddress = new InetAddress[1];
            InetSocketAddress address = NodeResolver.getAddressProperties(props, passive, sarConfig, memberList, null, notificationInterfaceAddress);
            if (address != null) {
                sarConfig = null;
                memberList = null;
            }
            String clusterName = props.getProperty("clusterName", "", false);
            String user = props.getProperty("user", "", false);
            String password = props.getProperty("password", "", false);
            String database = props.getProperty("database", null, false);
            if (!clusterName.isEmpty()) {
                RowMapper.checkSymbol(clusterName, "cluster name");
            }
            RowMapper.checkString(user, "user name");
            RowMapper.checkString(password, "password");
            if (database != null) {
                RowMapper.checkSymbol(database, "database name");
            }
            Properties transProps = Source.resolveTransportProperties(props, baseConfig.getTransportProvider());
            this.key = new Key(passive[0], address, notificationInterfaceAddress[0], clusterName, sarConfig, memberList, transProps);
            this.partitionCount = props.getIntProperty("partitionCount", true);
            String consistency = props.getProperty("consistency", false);
            if (consistency == null || consistency.equals("IMMEDIATE")) {
                backupPreferred = false;
            } else if (consistency.equals("EVENTUAL")) {
                backupPreferred = true;
            } else {
                throw new GSException(145002, "Unknown consistency type (consistency=" + consistency + ")");
            }
            this.localConfig = new LocalConfig(props);
            this.loginInfo = new NodeConnection.LoginInfo(user, password, !backupPreferred, database, clusterName, this.localConfig.transactionTimeoutMillis, Source.resolveApplicationName(props), Source.resolveStoreMemoryAgingSwapRate(props), Source.resolveTimeZoneOffset(props), Source.resolveAuthType(props), Source.resolveConnectionRoute(props));
            this.keyConverter = ContainerKeyConverter.getInstance(NodeConnection.getProtocolVersion(), false, false);
            this.dataAffinityPattern = new DataAffinityPattern(props.getProperty("dataAffinityPattern", false), this.keyConverter);
        }

        private static String resolveApplicationName(PropertyUtils.WrappedProperties props) throws GSException {
            String applicationName = props.getProperty("applicationName", null, false);
            if (applicationName != null) {
                RowMapper.checkSymbol(applicationName, "application name");
            }
            return applicationName;
        }

        private static double resolveStoreMemoryAgingSwapRate(PropertyUtils.WrappedProperties props) throws GSException {
            String name = "storeMemoryAgingSwapRate";
            Double value = props.getDoubleProperty("storeMemoryAgingSwapRate", false);
            if (value == null) {
                return -1.0;
            }
            if (!(0.0 <= value) || !(value <= 1.0)) {
                throw new GSException(145005, "Property value out of range (name=storeMemoryAgingSwapRate, value=" + value + ")");
            }
            return value;
        }

        private static SimpleTimeZone resolveTimeZoneOffset(PropertyUtils.WrappedProperties props) throws GSException {
            String zoneStr = props.getProperty("timeZone", null, false);
            if (zoneStr != null) {
                return PropertyUtils.parseTimeZoneOffset(zoneStr, true);
            }
            return null;
        }

        private static NodeConnection.AuthType resolveAuthType(PropertyUtils.WrappedProperties props) throws GSException {
            String typeStr = props.getProperty("authentication", null, false);
            if (typeStr != null) {
                return NodeConnection.LoginInfo.parseAuthType(typeStr);
            }
            return null;
        }

        private static NodeConnection.ConnectionRoute resolveConnectionRoute(PropertyUtils.WrappedProperties props) throws GSException {
            String routeStr = props.getProperty("connectionRoute", null, false);
            if (routeStr != null) {
                return NodeConnection.LoginInfo.parseConnectionRoute(routeStr);
            }
            return null;
        }

        private static Properties resolveTransportProperties(PropertyUtils.WrappedProperties props, Extensibles.TransportProvider transProvider) throws GSException {
            Properties transProps = new Properties();
            try {
                transProvider.filterProperties(props.getBase(), transProps);
            }
            catch (IOException e) {
                throw new GSException(e);
            }
            props.addVisitedNames(transProps.stringPropertyNames(), false);
            return transProps;
        }

        public NodeConnection.LoginInfo getLoginInfo() {
            return this.loginInfo;
        }

        public Key getKey() {
            return this.key;
        }

        public NodeResolver.ClusterInfo createClusterInfo() {
            NodeResolver.ClusterInfo clusterInfo = new NodeResolver.ClusterInfo(this.loginInfo);
            clusterInfo.setPartitionCount(this.partitionCount);
            return clusterInfo;
        }

        public Context createContext() {
            BasicBuffer req = this.createRequestBuffer();
            BasicBuffer resp = new BasicBuffer(INITIAL_BUFFER_SIZE);
            BasicBuffer syncReq = this.createRequestBuffer();
            BasicBuffer syncResp = new BasicBuffer(INITIAL_BUFFER_SIZE);
            return new Context(this.localConfig, this.loginInfo, this.createClusterInfo(), req, resp, syncReq, syncResp, this.keyConverter, this.dataAffinityPattern);
        }

        private BasicBuffer createRequestBuffer() {
            int requestHeadLength = NodeConnection.getRequestHeadLength(this.key.isIPV6Enabled());
            BasicBuffer req = new BasicBuffer(Math.max(requestHeadLength, INITIAL_BUFFER_SIZE));
            NodeConnection.fillRequestHead(this.key.isIPV6Enabled(), req);
            return req;
        }
    }

    static class LocalConfig {
        final long failoverTimeoutMillis;
        final long transactionTimeoutMillis;
        final int fetchBytesSize;
        final int containerCacheSize;
        final EnumSet<ContainerProperties.ContainerVisibility> containerVisibility;
        final ContainerProperties.MetaNamingType metaNamingType;
        boolean containerMonitoring;

        public LocalConfig(PropertyUtils.WrappedProperties props) throws GSException {
            this.failoverTimeoutMillis = props.getTimeoutProperty("failoverTimeout", -1L, false);
            this.transactionTimeoutMillis = props.getTimeoutProperty("transactionTimeout", -1L, false);
            Integer containerCacheSize = props.getIntProperty("containerCacheSize", false);
            if (containerCacheSize != null && containerCacheSize < 0) {
                throw new GSException(145002, "Negative container cache size (size=" + containerCacheSize + ")");
            }
            this.containerCacheSize = containerCacheSize == null ? 0 : containerCacheSize;
            Integer fetchBytesSize = props.getIntProperty("internal.fetchBytesSize", true);
            this.fetchBytesSize = fetchBytesSize == null ? 0 : fetchBytesSize;
            this.containerVisibility = EnumSet.noneOf(ContainerProperties.ContainerVisibility.class);
            this.setVisibility(props, "experimental.metaContainerVisible", ContainerProperties.ContainerVisibility.META);
            this.setVisibility(props, "internal.internalMetaContainerVisible", ContainerProperties.ContainerVisibility.INTERNAL_META);
            this.setVisibility(props, "internal.systemToolContainerEnabled", ContainerProperties.ContainerVisibility.SYSTEM_TOOL);
            String metaNaming = props.getProperty("experimental.metaNaming", false);
            if (metaNaming == null || metaNaming.equals(ContainerProperties.MetaNamingType.CONTAINER.name())) {
                this.metaNamingType = null;
            } else if (metaNaming.equals(ContainerProperties.MetaNamingType.TABLE.name())) {
                this.metaNamingType = ContainerProperties.MetaNamingType.TABLE;
            } else {
                throw new GSException(145002, "Unknown meta naming (type=" + metaNaming + ")");
            }
        }

        void setVisibility(PropertyUtils.WrappedProperties props, String name, ContainerProperties.ContainerVisibility visibility) throws GSException {
            if (props.getBooleanProperty(name, false, false).booleanValue()) {
                this.containerVisibility.add(visibility);
            }
        }
    }

    public static class Config {
        private NodeConnection.Config connectionConfig = new NodeConnection.Config();
        private long failoverTimeoutMillis = GridStoreChannel.access$000();
        private long failoverRetryIntervalMillis = GridStoreChannel.access$100();
        private long notificationReceiveTimeoutMillis = 10000L;
        private int maxConnectionPoolSize = -1;
        private Extensibles.TransportProvider transProvider = new PlainTransportProvider();

        public synchronized void set(Config config) {
            this.connectionConfig.set(config.connectionConfig, false);
            this.failoverTimeoutMillis = config.failoverTimeoutMillis;
            this.failoverRetryIntervalMillis = config.failoverRetryIntervalMillis;
            this.notificationReceiveTimeoutMillis = config.notificationReceiveTimeoutMillis;
            this.maxConnectionPoolSize = config.maxConnectionPoolSize;
        }

        public synchronized boolean set(PropertyUtils.WrappedProperties props) throws GSException {
            Integer maxConnectionPoolSize;
            long failoverTimeoutMillis = props.getTimeoutProperty("failoverTimeout", this.failoverTimeoutMillis, false);
            long failoverRetryIntervalMillis = props.getTimeoutProperty("failoverRetryInterval", this.failoverRetryIntervalMillis, true);
            long notificationReceiveTimeoutMillis = props.getTimeoutProperty("notificationReceiveTimeout", this.notificationReceiveTimeoutMillis, true);
            if (failoverTimeoutMillis < 0L || failoverRetryIntervalMillis < 0L || notificationReceiveTimeoutMillis < 0L) {
                throw new GSException(145005, "Negative timeout parameter");
            }
            boolean updated = this.connectionConfig.set(props);
            if (failoverTimeoutMillis != this.failoverTimeoutMillis || failoverRetryIntervalMillis != this.failoverRetryIntervalMillis || notificationReceiveTimeoutMillis != this.notificationReceiveTimeoutMillis) {
                this.failoverTimeoutMillis = failoverTimeoutMillis;
                this.failoverRetryIntervalMillis = failoverRetryIntervalMillis;
                this.notificationReceiveTimeoutMillis = notificationReceiveTimeoutMillis;
                updated = true;
            }
            if ((maxConnectionPoolSize = props.getIntProperty("maxConnectionPoolSize", false)) != null && maxConnectionPoolSize != this.maxConnectionPoolSize) {
                if (maxConnectionPoolSize < 0) {
                    throw new GSException(145005, "Negative connection pool size");
                }
                this.maxConnectionPoolSize = maxConnectionPoolSize;
                updated = true;
            }
            return updated;
        }

        public synchronized NodeConnection.Config createConnectionConfig(Properties transProps) throws GSException {
            NodeConnection.Config connectionConfig = new NodeConnection.Config();
            connectionConfig.set(this.connectionConfig, false);
            try {
                Config.applySocketConfig(connectionConfig, this.transProvider, transProps);
            }
            catch (IOException e) {
                throw new GSException(e);
            }
            return connectionConfig;
        }

        public synchronized long getFailoverTimeoutMillis() {
            return this.failoverTimeoutMillis;
        }

        public synchronized long getFailoverRetryIntervalMillis() {
            return this.failoverRetryIntervalMillis;
        }

        public synchronized long getNotificationReceiveTimeoutMillis() {
            return this.notificationReceiveTimeoutMillis;
        }

        public synchronized int getMaxConnectionPoolSize() {
            return this.maxConnectionPoolSize;
        }

        public synchronized Extensibles.TransportProvider getTransportProvider() {
            return this.transProvider;
        }

        public synchronized void setTransportProvider(Extensibles.TransportProvider provider) {
            this.transProvider = provider;
        }

        private static void applySocketConfig(NodeConnection.Config connectionConfig, Extensibles.TransportProvider transProvider, Properties transProps) throws IOException {
            EnumSet<NodeConnection.SocketType> socketTypes = EnumSet.noneOf(NodeConnection.SocketType.class);
            if (transProvider.isPlainSocketAllowed(transProps)) {
                socketTypes.add(NodeConnection.SocketType.PLAIN);
            }
            EnumMap<NodeConnection.SocketType, SocketFactory> socketFactories = new EnumMap<NodeConnection.SocketType, SocketFactory>(NodeConnection.SocketType.class);
            socketFactories.put(NodeConnection.SocketType.PLAIN, SocketFactory.getDefault());
            SSLSocketFactory secureFactory = transProvider.createSecureSocketFactory(transProps);
            if (secureFactory != null) {
                socketTypes.add(NodeConnection.SocketType.SECURE);
                socketFactories.put(NodeConnection.SocketType.SECURE, secureFactory);
            }
            connectionConfig.setSocketConfig(socketTypes, socketFactories);
        }
    }
}

