/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeConnectionPool
implements Closeable {
    private static final int DEFAULT_MAX_SIZE = 16;
    private Map<SocketAddress, List<NodeConnection>> connectionMap = new HashMap<SocketAddress, List<NodeConnection>>();
    private Set<NodeConnection> connectionSet = new LinkedHashSet<NodeConnection>();
    private List<NodeConnection> exceededConnectionList = Collections.synchronizedList(new ArrayList());
    private int maxSize = 16;

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int maxSize) {
        try {
            NodeConnectionPool nodeConnectionPool = this;
            synchronized (nodeConnectionPool) {
                if (this.connectionMap != null) {
                    this.adjustSize(maxSize);
                }
                this.maxSize = maxSize;
            }
        }
        finally {
            try {
                this.closeExceededConnections();
            }
            catch (GSException gSException) {}
        }
    }

    private void adjustSize(int maxSize) {
        while (this.connectionSet.size() > Math.max(maxSize, 0)) {
            NodeConnection oldest = this.connectionSet.iterator().next();
            if (oldest == null) continue;
            SocketAddress oldestKey = NodeConnectionPool.getKey(oldest);
            List<NodeConnection> oldestList = this.connectionMap.get(oldestKey);
            if (oldestList != null) {
                oldestList.remove(oldest);
            }
            if (oldestList.isEmpty()) {
                this.connectionMap.remove(oldestKey);
            }
            this.connectionSet.remove(oldest);
            this.exceededConnectionList.add(oldest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NodeConnection connection) {
        try {
            NodeConnectionPool nodeConnectionPool = this;
            synchronized (nodeConnectionPool) {
                if (this.connectionMap == null) {
                    this.exceededConnectionList.add(connection);
                    connection = null;
                } else if (this.connectionSet.add(connection)) {
                    SocketAddress key = NodeConnectionPool.getKey(connection);
                    List<NodeConnection> list = this.connectionMap.get(key);
                    if (list == null) {
                        list = new LinkedList<NodeConnection>();
                        this.connectionMap.put(key, list);
                    }
                    list.add(connection);
                    connection = null;
                    this.adjustSize(this.maxSize);
                }
            }
        }
        finally {
            try {
                try {
                    this.closeExceededConnections();
                }
                finally {
                    if (connection != null) {
                        connection.close();
                        this.connectionSet.remove(connection);
                    }
                }
            }
            catch (GSException gSException) {}
        }
    }

    public synchronized NodeConnection pull(SocketAddress address) {
        if (this.connectionMap == null) {
            return null;
        }
        List<NodeConnection> list = this.connectionMap.get(address);
        if (list == null || list.isEmpty()) {
            return null;
        }
        NodeConnection connection = list.remove(0);
        if (list.isEmpty()) {
            this.connectionMap.remove(address);
        }
        this.connectionSet.remove(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeConnection resolve(InetSocketAddress address, BasicBuffer req, BasicBuffer resp, NodeConnection.Config config, NodeConnection.LoginInfo loginInfo, long[] databaseId, boolean preferCache) throws GSException {
        NodeConnection connection;
        NodeConnection nodeConnection = connection = preferCache ? this.pull(address) : null;
        if (connection == null) {
            NodeConnection newConnection = new NodeConnection(address, config);
            try {
                newConnection.connect(req, resp);
                connection = newConnection;
            }
            finally {
                if (connection == null) {
                    newConnection.close();
                }
            }
        }
        boolean released = false;
        try {
            connection.login(req, resp, loginInfo, databaseId);
            released = true;
        }
        catch (GSStatementException e) {
            released = true;
            this.add(connection);
            throw e;
        }
        finally {
            if (!released) {
                connection.close();
            }
        }
        return connection;
    }

    private static SocketAddress getKey(NodeConnection connection) {
        return connection.getRemoteSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws GSException {
        try {
            NodeConnectionPool nodeConnectionPool = this;
            synchronized (nodeConnectionPool) {
                block11: {
                    if (this.connectionSet != null) break block11;
                    return;
                }
                try {
                    this.exceededConnectionList.addAll(this.connectionSet);
                }
                finally {
                    this.connectionMap = null;
                    this.connectionSet = null;
                }
            }
        }
        finally {
            this.closeExceededConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeExceededConnections() throws GSException {
        ArrayList<NodeConnection> connectionList;
        List<NodeConnection> list = this.exceededConnectionList;
        synchronized (list) {
            if (this.exceededConnectionList.isEmpty()) {
                return;
            }
            connectionList = new ArrayList<NodeConnection>();
            connectionList.addAll(this.exceededConnectionList);
            this.exceededConnectionList.clear();
        }
        NodeConnectionPool.closeConnections(connectionList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeConnections(List<NodeConnection> connectionList, boolean silent) throws GSException {
        if (connectionList == null || connectionList.isEmpty()) {
            return;
        }
        try {
            Iterator<NodeConnection> it = connectionList.iterator();
            while (it.hasNext()) {
                if (silent) {
                    try {
                        it.next().close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    it.next().close();
                }
                it.remove();
            }
        }
        finally {
            if (!connectionList.isEmpty() && !silent) {
                NodeConnectionPool.closeConnections(connectionList, true);
            }
        }
    }
}

