/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.Collection;
import com.toshiba.mwcloud.gs.ColumnInfo;
import com.toshiba.mwcloud.gs.CompressionMethod;
import com.toshiba.mwcloud.gs.Container;
import com.toshiba.mwcloud.gs.ContainerInfo;
import com.toshiba.mwcloud.gs.ContainerType;
import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GSType;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.IndexInfo;
import com.toshiba.mwcloud.gs.IndexType;
import com.toshiba.mwcloud.gs.Query;
import com.toshiba.mwcloud.gs.Row;
import com.toshiba.mwcloud.gs.RowKeyPredicate;
import com.toshiba.mwcloud.gs.TimeSeries;
import com.toshiba.mwcloud.gs.TimeSeriesProperties;
import com.toshiba.mwcloud.gs.TimeUnit;
import com.toshiba.mwcloud.gs.TriggerInfo;
import com.toshiba.mwcloud.gs.common.BasicBuffer;
import com.toshiba.mwcloud.gs.common.ContainerKeyConverter;
import com.toshiba.mwcloud.gs.common.ContainerKeyPredicate;
import com.toshiba.mwcloud.gs.common.ContainerProperties;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSConnectionException;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GSStatementException;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.RowMapper;
import com.toshiba.mwcloud.gs.common.Statement;
import com.toshiba.mwcloud.gs.experimental.ContainerAttribute;
import com.toshiba.mwcloud.gs.experimental.DatabaseInfo;
import com.toshiba.mwcloud.gs.experimental.Experimentals;
import com.toshiba.mwcloud.gs.experimental.PrivilegeInfo;
import com.toshiba.mwcloud.gs.experimental.UserInfo;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetCollection;
import com.toshiba.mwcloud.gs.subnet.SubnetContainer;
import com.toshiba.mwcloud.gs.subnet.SubnetPartitionController;
import com.toshiba.mwcloud.gs.subnet.SubnetQuery;
import com.toshiba.mwcloud.gs.subnet.SubnetTimeSeries;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class SubnetGridStore
implements GridStore,
Extensibles.AsStore,
Experimentals.AsStore,
Experimentals.StoreProvider {
    private static final boolean ENABLE_COMPRESSION_WINDOW_SIZE = true;
    private static boolean OLD_TIME_SERIES_PROPERTIES = false;
    static final boolean WORKAROUND_WRONG_API_TEST = false;
    private static final LoggingUtils.BaseGridStoreLogger LOGGER = LoggingUtils.getLogger("Transaction");
    private static final String ERROR_PARAM_CONTAINER = "container";
    private static boolean pathKeyOperationEnabled = false;
    private static boolean compositeIndexTypeUnified = false;
    private static final int SYSTEM_USER_PARTITION_ID = 0;
    private static final String ALL_PRIVILEGE = "ALL";
    private static final String READ_PRIVILEGE = "READ";
    private static final int MAX_PASSWORD_BYTES_LENGTH = 64;
    private static final IndexType[] INDEX_TYPE_CONSTANTS = IndexType.values();
    private static final byte INDEX_TYPE_DEFAULT_VALUE = -1;
    private static final RowMapper.Config DEFAULT_MAPPER_CONFIG = new RowMapper.Config(false, true, true, true);
    private static final RowMapper.Config COMPATIBLE_MAPPER_CONFIG_14 = new RowMapper.Config(false, true, false, false);
    private static final RowMapper.Config COMPATIBLE_MAPPER_CONFIG_13 = new RowMapper.Config(false, false, false, false);
    private static final RowMapper.Config ANY_MAPPER_CONFIG = new RowMapper.Config(true, true, true, true);
    private final GridStoreChannel channel;
    private final GridStoreChannel.Context context;
    private final GridStoreChannel.ContextReference contextRef;
    private final NamedContainerMap<SubnetContainer<?, ?>> containerMap;
    private final GridStoreChannel.ContextMonitor contextMonitor = GridStoreChannel.tryCreateGeneralContextMonitor();
    private static final ContainerKeyConverter.ContainerKey CONTEXT_CONTROLLER_KEY = SubnetGridStore.createSystemContainerKey("#_internal_context_controller");

    public SubnetGridStore(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
        this.channel = channel;
        this.context = context;
        this.contextRef = channel.registerContext(context, this);
        if (context.getContainerCache() != null) {
            context.addRemoteReference(new CacheReference(this, context));
        }
        this.containerMap = pathKeyOperationEnabled ? SubnetGridStore.makeContainerMap() : null;
    }

    private static NamedContainerMap<SubnetContainer<?, ?>> makeContainerMap() {
        return new NamedContainerMap<SubnetContainer<?, ?>>(){

            @Override
            protected Class<?> getRowType(SubnetContainer<?, ?> container) {
                return container.getRowMapper().getRowType();
            }
        };
    }

    static void setPathKeyOperationEnabled(boolean pathKeyOperationEnabled) {
        SubnetGridStore.pathKeyOperationEnabled = pathKeyOperationEnabled;
    }

    public GridStoreChannel getChannel() {
        return this.channel;
    }

    public GridStoreChannel.Context getContext() {
        return this.context;
    }

    @Override
    public void executeStatement(Statement.GeneralStatement statement, int partitionIndex, Extensibles.StatementHandler handler) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        handler.makeRequest(req);
        this.channel.executeStatement(this.context, statement, partitionIndex, 0L, req, resp, this.contextMonitor);
        handler.acceptResponse(resp);
    }

    private void executeStatement(Statement statement, int partitionId, BasicBuffer req, BasicBuffer resp, ContainerKeyConverter.ContainerKey key) throws GSException {
        this.beginComplexedStatement(statement, partitionId, key);
        this.channel.executeStatement(this.context, statement.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
        this.endComplexedStatement();
    }

    private void beginComplexedStatement(Statement statement, int partitionId, ContainerKeyConverter.ContainerKey key) {
        if (this.contextMonitor != null) {
            this.contextMonitor.setContainerKey(key);
            this.contextMonitor.startStatement(statement.generalize(), 0L, partitionId, null);
        }
    }

    private void endComplexedStatement() {
        if (this.contextMonitor != null) {
            this.contextMonitor.endStatement();
        }
    }

    private SubnetContainer<?, ?> resolveContainer(ContainerKeyConverter.ContainerKey containerKey, Class<?> rowType) throws GSException {
        if (this.containerMap == null) {
            throw new GSException(145003, "Path key operation is restricted");
        }
        SubnetContainer<?, ?> container = this.containerMap.get(containerKey, rowType);
        if (container == null) {
            throw new GSException(145034, "Related container not opened (name=" + containerKey + ", rowType=" + (rowType == null ? "" : rowType.getName()) + ")");
        }
        return this.duplicateContainer(container);
    }

    private <K, R> SubnetContainer<?, R> duplicateContainer(SubnetContainer<K, R> base) throws GSException {
        RowMapper mapper = base.getRowMapper();
        if (mapper.isForTimeSeries()) {
            return new SubnetTimeSeries<R>(this, this.channel, this.context, SubnetGridStore.rebindTimeSeriesType(base.getBindType()), mapper, base.getSchemaVersionId(), base.getPartitionId(), base.getContainerId(), null, null);
        }
        return new SubnetCollection<K, R>(this, this.channel, this.context, base.getBindType(), mapper, base.getSchemaVersionId(), base.getPartitionId(), base.getContainerId(), null, null);
    }

    void createReference(SubnetContainer<?, ?> container) throws GSException {
        if (this.containerMap == null) {
            return;
        }
        this.containerMap.add(container.getNormalizedContainerKey(), container);
    }

    void removeReference(SubnetContainer<?, ?> container) {
        if (this.containerMap == null) {
            return;
        }
        this.containerMap.remove(container.getNormalizedContainerKey(), container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean put(String pathKey, Object rowObject) throws GSException {
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<?, ?> container = this.resolveContainer(this.parseContainerKey(keyElements[0]), rowObject.getClass());
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            boolean bl = SubnetGridStore.putChecked(container, key, rowObject);
            return bl;
        }
        finally {
            container.close();
        }
    }

    private static <R> boolean putChecked(SubnetContainer<?, R> container, Object key, Object row) throws GSException {
        SubnetContainer<Object, R> typedContainer = SubnetGridStore.disguiseTypedContainer(container);
        Class<R> rowType = typedContainer.getRowType();
        return typedContainer.put(key, rowType.cast(row));
    }

    @Override
    @Deprecated
    public Object get(String pathKey) throws GSException {
        return this.getByPathKey(pathKey, null);
    }

    @Override
    @Deprecated
    public <R> R get(String pathKey, Class<R> rowType) throws GSException {
        return rowType.cast(this.getByPathKey(pathKey, rowType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getByPathKey(String pathKey, Class<?> rowType) throws GSException {
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<Object, ?> container = SubnetGridStore.disguiseTypedContainer(this.resolveContainer(this.parseContainerKey(keyElements[0]), rowType));
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            Object obj = container.get(key);
            return obj;
        }
        finally {
            container.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean remove(String pathKey) throws GSException {
        String[] keyElements = SubnetGridStore.splitPathKey(pathKey);
        SubnetContainer<Object, ?> container = SubnetGridStore.disguiseTypedContainer(this.resolveContainer(this.parseContainerKey(keyElements[0]), null));
        try {
            RowMapper mapper = container.getRowMapper();
            Object key = mapper.resolveKey(keyElements[1]);
            boolean bl = container.remove(key);
            return bl;
        }
        finally {
            container.close();
        }
    }

    private static String[] splitPathKey(String pathKey) throws GSException {
        String[] components = pathKey.split("/", 2);
        if (components.length != 2) {
            throw new GSException(145002, "Invalid path key (value=" + pathKey + ")");
        }
        return components;
    }

    @Override
    public long getDatabaseId() throws GSException {
        return this.channel.getDatabaseId(this.context);
    }

    @Override
    public ContainerKeyConverter getContainerKeyConverter(boolean internalMode, boolean forModification) throws GSException {
        return this.context.getKeyConverter(internalMode, forModification);
    }

    private ContainerKeyConverter.ContainerKey parseContainerKey(String name) throws GSException {
        return this.parseContainerKey(name, false, false);
    }

    private ContainerKeyConverter.ContainerKey parseContainerKey(String name, boolean internalMode, boolean forModification) throws GSException {
        boolean caseSensitive = false;
        return this.getContainerKeyConverter(internalMode, forModification).parse(name, false);
    }

    private void putContainerKey(BasicBuffer req, ContainerKeyConverter.ContainerKey key, ContainerKeyConverter keyConverter) throws GSException {
        long databaseId = this.channel.getDatabaseId(this.context);
        keyConverter.put(key, databaseId, req);
    }

    static void tryPutSystemOptionalRequest(BasicBuffer req, GridStoreChannel.Context context, boolean internalMode, boolean forCreationDDL, Integer containerAttribute) {
        SubnetGridStore.tryPutSystemOptionalRequest(req, context, internalMode, forCreationDDL, containerAttribute, null);
    }

    static void tryPutSystemOptionalRequest(BasicBuffer req, GridStoreChannel.Context context, boolean internalMode, boolean forCreationDDL, Integer containerAttribute, NodeConnection.OptionalRequestSource source) {
        boolean clientIdRequired;
        boolean bl = clientIdRequired = forCreationDDL && SubnetGridStore.isClientIdEnabled();
        if (!(internalMode || clientIdRequired || containerAttribute != null || source != null && source.hasOptions())) {
            NodeConnection.tryPutEmptyOptionalRequest(req);
            return;
        }
        NodeConnection.OptionalRequest optionalRequest = context.getOptionalRequest();
        if (internalMode) {
            optionalRequest.put(NodeConnection.OptionalRequestType.SYSTEM_MODE, internalMode);
        }
        if (containerAttribute != null) {
            optionalRequest.put(NodeConnection.OptionalRequestType.CONTAINER_ATTRIBUTE, containerAttribute);
        }
        if (clientIdRequired) {
            optionalRequest.put(NodeConnection.OptionalRequestType.CLIENT_ID, context.generateClientId());
        }
        if (source != null) {
            source.putOptions(optionalRequest);
        }
        optionalRequest.format(req);
    }

    private static void tryPutDatabaseOptionalRequest(BasicBuffer req, GridStoreChannel.Context context, NodeConnection.OptionalRequestSource source) {
        if (source == null || !source.hasOptions()) {
            NodeConnection.tryPutEmptyOptionalRequest(req);
            return;
        }
        NodeConnection.OptionalRequest optionalRequest = context.getOptionalRequest();
        source.putOptions(optionalRequest);
        optionalRequest.format(req);
    }

    @Override
    public ContainerInfo getContainerInfo(String name) throws GSException {
        return ContainerProperties.findInfo(this.getContainerProperties(this.parseContainerKey(name), null, null, false));
    }

    @Override
    public ContainerProperties getContainerProperties(ContainerKeyConverter.ContainerKey key, ContainerProperties.KeySet propKeySet, Integer attribute, boolean internalMode) throws GSException {
        return this.getAllContainerProperties(Collections.singletonList(key), propKeySet, attribute, internalMode).get(0);
    }

    @Override
    public List<ContainerProperties> getAllContainerProperties(List<ContainerKeyConverter.ContainerKey> keyList, ContainerProperties.KeySet propKeySet, Integer attribute, boolean internalMode) throws GSException {
        int keyCount = keyList.size();
        HashMap<Integer, ArrayList<Integer>> indexMap = new HashMap<Integer, ArrayList<Integer>>();
        for (int i = 0; i < keyCount; ++i) {
            int partitionId = this.channel.resolvePartitionId(this.context, keyList.get(i), internalMode);
            ArrayList<Integer> list = (ArrayList<Integer>)indexMap.get(partitionId);
            if (list == null) {
                list = new ArrayList<Integer>();
                indexMap.put(partitionId, list);
            }
            list.add(i);
        }
        ArrayList<ContainerProperties> propsList = new ArrayList<ContainerProperties>();
        for (int i = 0; i < keyCount; ++i) {
            propsList.add(null);
        }
        for (Map.Entry entry : indexMap.entrySet()) {
            int partitionId = (Integer)entry.getKey();
            List indexList = (List)entry.getValue();
            int indexCount = indexList.size();
            ArrayList<ContainerKeyConverter.ContainerKey> subKeyList = new ArrayList<ContainerKeyConverter.ContainerKey>();
            for (int i = 0; i < indexCount; ++i) {
                int index = (Integer)indexList.get(i);
                subKeyList.add(keyList.get(index));
            }
            List<ContainerProperties> subPropsList = this.getAllContainerProperties(partitionId, subKeyList, propKeySet, attribute, internalMode);
            for (int i = 0; i < indexCount; ++i) {
                int index = (Integer)indexList.get(i);
                propsList.set(index, subPropsList.get(i));
            }
        }
        return propsList;
    }

    private List<ContainerProperties> getAllContainerProperties(int partitionId, List<ContainerKeyConverter.ContainerKey> keyList, ContainerProperties.KeySet propKeySet, Integer attribute, boolean internalMode) throws GSException {
        if (keyList.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (propKeySet == null) {
            propKeySet = ContainerPropertyKeysConstants.resolveDefault();
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, internalMode, false, attribute, this.getContainerPropertyResuestSource());
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(internalMode, false);
        Integer[] rawPropKeys = propKeySet.getRawKeys();
        int keyCount = keyList.size();
        for (int i = 0; i < keyCount; ++i) {
            this.putContainerKey(req, keyList.get(i), keyConverter);
            if (i != 0) continue;
            req.putInt(rawPropKeys.length);
            Integer[] integerArray = rawPropKeys;
            int n = integerArray.length;
            for (int j = 0; j < n; ++j) {
                int propKey = integerArray[j];
                req.put((byte)propKey);
            }
            if (keyCount <= 1) continue;
            req.putInt(keyCount);
        }
        ContainerKeyConverter.ContainerKey singleKey = keyCount > 1 ? null : keyList.get(0);
        this.executeStatement(Statement.GET_CONTAINER_PROPERTIES, partitionId, req, resp, singleKey);
        ArrayList<ContainerProperties> propsList = new ArrayList<ContainerProperties>();
        for (int i = 0; i < keyCount; ++i) {
            int remaining;
            propsList.add(SubnetGridStore.importContainerPropertiesResult(resp, attribute, internalMode, keyConverter, rawPropKeys));
            if (i != 0 || keyCount <= 1 || (remaining = resp.base().getInt()) == keyCount - 1) continue;
            throw new GSConnectionException(145031, "Protocol error by illegal result count of properties");
        }
        return propsList;
    }

    private NodeConnection.OptionalRequestSource getContainerPropertyResuestSource() {
        final EnumSet<ContainerProperties.ContainerVisibility> visibilities = this.context.getConfig().containerVisibility;
        final ContainerProperties.MetaNamingType metaNamingType = this.context.getConfig().metaNamingType;
        return new NodeConnection.OptionalRequestSource(){

            @Override
            public void putOptions(NodeConnection.OptionalRequest optionalRequest) {
                if (!visibilities.isEmpty()) {
                    int flags = 0;
                    for (ContainerProperties.ContainerVisibility elem : visibilities) {
                        flags |= 1 << elem.ordinal();
                    }
                    optionalRequest.put(NodeConnection.OptionalRequestType.CONTAINER_VISIBILITY, flags);
                }
                if (metaNamingType != null) {
                    optionalRequest.put(NodeConnection.OptionalRequestType.META_NAMING_TYPE, (byte)metaNamingType.ordinal());
                }
                optionalRequest.putAcceptableFeatureVersion(NodeConnection.FeatureVersion.V4_3);
            }

            @Override
            public boolean hasOptions() {
                return true;
            }
        };
    }

    private static ContainerProperties importContainerPropertiesResult(BasicBuffer resp, Integer attribute, boolean internalMode, ContainerKeyConverter keyConverter, Integer[] rawPropKeys) throws GSException {
        boolean found = resp.getBoolean();
        if (!found) {
            return null;
        }
        int propertyCount = resp.base().getInt();
        if (propertyCount != rawPropKeys.length) {
            throw new GSConnectionException(145031, "Protocol error by illegal property count (expected=" + rawPropKeys.length + ", actual=" + propertyCount + ")");
        }
        ContainerInfo containerInfo = new ContainerInfo();
        ContainerProperties.ContainerIdInfo containerIdInfo = null;
        ArrayList<RowMapper.MutableColumnInfo> columnInfoList = null;
        ArrayList<IndexInfo> indexInfoList = null;
        Integer respAttribute = null;
        HashMap<Integer, byte[]> rawEntries = null;
        for (int i = 0; i < propertyCount; ++i) {
            byte rawPropertyKey = resp.base().get();
            int propertySize = BasicBuffer.BufferUtils.getIntSize(resp.base());
            ContainerProperties.Key propertyKey = ContainerProperties.tryResolveKey(rawPropertyKey);
            if (propertyKey == null) {
                byte[] rawProperty = new byte[propertySize];
                resp.base().get(rawProperty);
                if (rawEntries == null) {
                    rawEntries = new HashMap<Integer, byte[]>();
                }
                rawEntries.put(Integer.valueOf(rawPropertyKey), rawProperty);
                continue;
            }
            int curEnd = resp.base().position() + propertySize;
            switch (propertyKey) {
                case ID: {
                    containerIdInfo = SubnetGridStore.importIdProperty(resp, keyConverter, curEnd);
                    break;
                }
                case SCHEMA: {
                    columnInfoList = new ArrayList<RowMapper.MutableColumnInfo>();
                    SubnetGridStore.importSchemaProperty(resp, containerInfo, columnInfoList);
                    SubnetGridStore.importContainerProperties(resp, containerInfo, columnInfoList);
                    break;
                }
                case INDEX: {
                    SubnetGridStore.importIndexProperty(resp, columnInfoList);
                    break;
                }
                case EVENT_NOTIFICATION: {
                    SubnetGridStore.importEventNotificationProperty(resp, new ArrayList<URL>());
                    break;
                }
                case TRIGGER: {
                    SubnetGridStore.importTriggerProperty(resp, containerInfo, columnInfoList);
                    break;
                }
                case ATTRIBUTE: {
                    respAttribute = SubnetGridStore.importAttributeProperty(resp, attribute);
                    break;
                }
                case INDEX_DETAIL: {
                    indexInfoList = new ArrayList<IndexInfo>();
                    SubnetGridStore.importIndexDetailProperty(resp, indexInfoList);
                    break;
                }
                default: {
                    throw new GSConnectionException(145031, "Protocol error by illegal property type");
                }
            }
            if (resp.base().position() == curEnd) continue;
            throw new GSConnectionException(145031, "Protocol error by illegal property format");
        }
        if (containerIdInfo != null) {
            containerInfo.setName(containerIdInfo.remoteKey.toString());
        }
        if (indexInfoList != null) {
            if (columnInfoList != null) {
                SubnetGridStore.assignIndexColumnNames(columnInfoList, indexInfoList, respAttribute, internalMode);
            }
            containerInfo.setIndexInfoList(indexInfoList);
        }
        if (columnInfoList != null) {
            containerInfo.setColumnInfoList(new ArrayList<ColumnInfo>(columnInfoList));
        }
        ContainerProperties containerProps = new ContainerProperties();
        containerProps.setInfo(containerInfo);
        containerProps.setIdInfo(containerIdInfo);
        containerProps.setAttribute(respAttribute);
        containerProps.setRawEntries(rawEntries);
        return containerProps;
    }

    public <K, R> SubnetCollection<K, R> putCollection(String name, Class<R> rowType) throws GSException {
        return this.putCollection(name, (Class)rowType, false);
    }

    private static ContainerKeyConverter.ContainerKey normalizeFullContainerKey(ContainerKeyConverter.ContainerKey key, boolean internalMode) throws GSException {
        return key.toCaseSensitive(false);
    }

    private <K, R> SubnetContainer<K, R> findContainerByCache(GridStoreChannel.ContainerCache cache, ContainerKeyConverter.ContainerKey key, Container.BindType<K, R, ?> bindType, ContainerType containerType, boolean internalMode) throws GSException {
        ContainerKeyConverter.ContainerKey normalizedKey = SubnetGridStore.normalizeFullContainerKey(key, internalMode);
        GridStoreChannel.LocatedSchema schema = cache.findSchema(normalizedKey, bindType.getRowClass(), containerType);
        if (schema == null) {
            return null;
        }
        int partitionId = this.channel.resolvePartitionId(this.context, normalizedKey, internalMode);
        if (schema.getMapper().getContainerType() == ContainerType.COLLECTION) {
            return new SubnetCollection<K, R>(this, this.channel, this.context, bindType, schema.getMapper(), schema.getVersionId(), partitionId, schema.getContainerId(), normalizedKey, schema.getContainerKey());
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, SubnetGridStore.rebindTimeSeriesType(bindType), schema.getMapper(), schema.getVersionId(), partitionId, schema.getContainerId(), normalizedKey, schema.getContainerKey()));
    }

    @Override
    public void removeContainerCache(ContainerKeyConverter.ContainerKey key, boolean internalMode) throws GSException {
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null) {
            cache.removeSchema(key.toCaseSensitive(false));
        }
    }

    public static boolean isContainerStatementUnified() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    public static boolean isSessionUUIDSummarized() {
        return NodeConnection.getProtocolVersion() >= 3;
    }

    public static boolean isTSDivisionAndAffinityEnabled() {
        return NodeConnection.getProtocolVersion() >= 3 && !GridStoreChannel.v15TSPropsCompatible;
    }

    public static boolean isClientIdEnabled() {
        return NodeConnection.getProtocolVersion() >= 13;
    }

    public static boolean isIndexDetailEnabled() {
        return NodeConnection.getProtocolVersion() >= 13;
    }

    public static boolean isContainerAttributeUnified() {
        return NodeConnection.getProtocolVersion() >= 13;
    }

    public static boolean isAttributeVerifiable() {
        return NodeConnection.getProtocolVersion() >= 13;
    }

    public static boolean isNullableColumnAllowed(int protocolVersion) {
        return protocolVersion >= 13;
    }

    public static boolean isQueryOptionsExtensible() {
        return NodeConnection.getProtocolVersion() >= 14 && !GridStoreChannel.v40QueryCompatible;
    }

    public static RowMapper.Config getRowMapperConfig() {
        return SubnetGridStore.getRowMapperConfig(NodeConnection.getProtocolVersion());
    }

    public static RowMapper.Config getRowMapperConfig(int protocolVersion) {
        if (protocolVersion >= 14 && !GridStoreChannel.v40SchemaCompatible) {
            return DEFAULT_MAPPER_CONFIG;
        }
        if (SubnetGridStore.isNullableColumnAllowed(protocolVersion)) {
            return COMPATIBLE_MAPPER_CONFIG_14;
        }
        return COMPATIBLE_MAPPER_CONFIG_13;
    }

    private static Statement getContainerStatement(Statement statement, ContainerType containerType) {
        if (SubnetGridStore.isContainerStatementUnified()) {
            return statement;
        }
        if (containerType == ContainerType.TIME_SERIES) {
            switch (statement) {
                case PUT_CONTAINER: {
                    return Statement.PUT_TIME_SERIES;
                }
                case GET_CONTAINER: {
                    return Statement.GET_TIME_SERIES;
                }
                case DROP_CONTAINER: {
                    return Statement.DROP_TIME_SERIES;
                }
            }
            throw new Error("Internal error by invalid container statement (statement=" + (Object)((Object)statement) + ")");
        }
        if (containerType == ContainerType.COLLECTION) {
            if (statement == Statement.DROP_CONTAINER) {
                return Statement.DROP_COLLECTION;
            }
            return statement;
        }
        return statement;
    }

    private static void tryPutContainerType(BasicBuffer req, ContainerType containerType) {
        if (!SubnetGridStore.isContainerStatementUnified()) {
            return;
        }
        if (containerType == null) {
            req.put((byte)-1);
        } else {
            req.putByteEnum(containerType);
        }
    }

    public <K, R> SubnetContainer<K, R> putContainer(ContainerKeyConverter.ContainerKey key, Container.BindType<K, R, ?> bindType, ContainerProperties props, boolean modifiable, boolean internalMode) throws GSException {
        SubnetContainer<K, R> cachedContainer;
        if (bindType.getRowClass() == Row.class) {
            Container<K, Row> container = this.putContainerGeneral(key, RowMapper.BindingTool.rebindRow(Row.class, bindType), props, modifiable, internalMode);
            return (SubnetContainer)bindType.castContainer(container);
        }
        ContainerInfo info = SubnetGridStore.findContainerInfo(props);
        ContainerType containerType = SubnetGridStore.resolveContainerType(RowMapper.BindingTool.findContainerType(bindType), info);
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(internalMode, true);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !modifiable && info == null && (cachedContainer = this.findContainerByCache(cache, key, bindType, containerType, internalMode)) != null) {
            return cachedContainer;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        RowMapper orgMapper = RowMapper.getInstance(bindType, containerType, SubnetGridStore.getRowMapperConfig());
        NodeConnection.OptionalRequestSource propsOption = SubnetGridStore.containerPropertiesToOption(props, orgMapper);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, internalMode, true, null, propsOption);
        int partitionId = this.channel.resolvePartitionId(this.context, key, internalMode);
        this.putContainerKey(req, key, keyConverter);
        SubnetGridStore.tryPutContainerType(req, containerType);
        req.putBoolean(modifiable);
        orgMapper.exportSchema(req, SubnetGridStore.getRowMapperConfig());
        if (info != null && (info.getColumnCount() > 0 || !info.getRowKeyColumnList().isEmpty() || info.isColumnOrderIgnorable())) {
            throw new GSException(145023, "Schema can not be specified on ContainerInfo (columnCount=" + info.getColumnCount() + ", rowKeyColumnList=" + info.getRowKeyColumnList() + ", columnOrderIgnorable=" + info.isColumnOrderIgnorable() + ")");
        }
        this.exportContainerProperties(req, containerType, props, orgMapper, key, propsOption);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.PUT_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, key);
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        ContainerKeyConverter.ContainerKey[] acceptedKeys = this.acceptRemoteContainerKey(resp, keyConverter, key);
        ContainerKeyConverter.ContainerKey normalizedKey = acceptedKeys[0];
        ContainerKeyConverter.ContainerKey remoteKey = acceptedKeys[1];
        RowMapper mapper = orgMapper.reorderBySchema(resp, SubnetGridStore.getRowMapperConfig(), true);
        if (cache != null) {
            cache.cacheSchema(normalizedKey, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteKey));
        }
        if (mapper.isForTimeSeries()) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, SubnetGridStore.rebindTimeSeriesType(bindType), mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey));
        }
        return new SubnetCollection<K, R>(this, this.channel, this.context, bindType, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey);
    }

    public <K, R> SubnetCollection<K, R> putCollection(String name, Class<R> rowType, boolean modifiable) throws GSException {
        Container container = this.putContainer(this.parseContainerKey(name, false, true), RowMapper.BindingTool.createCollectionBindType(null, rowType), (ContainerProperties)null, modifiable, false);
        return (SubnetCollection)container;
    }

    public <R> SubnetTimeSeries<R> putTimeSeries(String name, Class<R> rowType) throws GSException {
        Container container = this.putContainer(this.parseContainerKey(name, false, true), RowMapper.BindingTool.createTimeSeriesBindType(rowType), (ContainerProperties)null, false, false);
        return (SubnetTimeSeries)container;
    }

    public <R> SubnetTimeSeries<R> putTimeSeries(String name, Class<R> rowType, TimeSeriesProperties props, boolean modifiable) throws GSException {
        ContainerInfo info = new ContainerInfo();
        info.setTimeSeriesProperties(props);
        Container container = this.putContainer(this.parseContainerKey(name, false, true), RowMapper.BindingTool.createTimeSeriesBindType(rowType), new ContainerProperties(info), modifiable, false);
        return (SubnetTimeSeries)container;
    }

    private ContainerKeyConverter.ContainerKey[] acceptRemoteContainerKey(BasicBuffer in, ContainerKeyConverter keyConverter, ContainerKeyConverter.ContainerKey localKey) throws GSException {
        ContainerKeyConverter.ContainerKey remoteKey = keyConverter.get(in, false, true);
        return this.filterRemoteContainerKey(remoteKey, localKey);
    }

    private ContainerKeyConverter.ContainerKey[] filterRemoteContainerKey(ContainerKeyConverter.ContainerKey remoteKey, ContainerKeyConverter.ContainerKey localKey) throws GSException {
        ContainerKeyConverter.ContainerKey normalizedLocalKey = localKey.toCaseSensitive(false);
        if (!remoteKey.equals(localKey) && !remoteKey.toCaseSensitive(false).equals(normalizedLocalKey)) {
            throw new GSConnectionException(145031, "Protocol error by inconsistent container name (localName=" + localKey + ", remoteName=" + remoteKey + ")");
        }
        return new ContainerKeyConverter.ContainerKey[]{!pathKeyOperationEnabled && this.context.getContainerCache() == null ? null : normalizedLocalKey, this.contextMonitor == null && !this.isContainerMonitoring() ? null : remoteKey};
    }

    private static NodeConnection.OptionalRequestSource containerPropertiesToOption(ContainerProperties props, RowMapper mapper) throws GSException {
        if (mapper.isDefaultValueSpecified()) {
            throw new GSException(145003, "Default value can not specified for container definition in the current version");
        }
        if (props == null || props.getReservedValue() == null && props.getSchemaOptions() == null) {
            return null;
        }
        NodeConnection.OptionalRequest request = new NodeConnection.OptionalRequest();
        request.putFeatureVersion(NodeConnection.FeatureVersion.V4_1);
        return request;
    }

    private void exportContainerProperties(BasicBuffer out, ContainerType type, ContainerProperties props, RowMapper mapper, ContainerKeyConverter.ContainerKey containerKey, NodeConnection.OptionalRequestSource source) throws GSException {
        this.exportBasicContainerProperties(out, type, SubnetGridStore.findContainerInfo(props), mapper, containerKey);
        if (source == null) {
            return;
        }
        Integer attribute = SubnetGridStore.findContainerAttribute(props);
        out.putInt(attribute == null ? ContainerAttribute.SINGLE.flag() : attribute.intValue());
        Long reservedValue = props.getReservedValue();
        out.putLong(reservedValue == null ? 0L : reservedValue);
        Map<Integer, byte[]> schemaOptions = props.getSchemaOptions();
        if (schemaOptions != null) {
            for (Map.Entry<Integer, byte[]> entry : schemaOptions.entrySet()) {
                byte[] value = entry.getValue();
                out.putInt(entry.getKey());
                out.putInt(value.length);
                out.prepare(value.length);
                out.base().put(value);
            }
        }
        out.putInt(-1);
    }

    private void exportBasicContainerProperties(BasicBuffer out, ContainerType type, ContainerInfo info, RowMapper mapper, ContainerKeyConverter.ContainerKey containerKey) throws GSException {
        TimeSeriesProperties tsProps;
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled() && !GridStoreChannel.v20AffinityCompatible) {
            String dataAffinity = info == null ? null : info.getDataAffinity();
            out.putString(dataAffinity == null ? this.context.getDataAffinityPattern().match(containerKey, "", this.getContainerKeyConverter(true, false)) : dataAffinity);
        }
        TimeSeriesProperties timeSeriesProperties = tsProps = info == null ? null : info.getTimeSeriesProperties();
        if (type != ContainerType.TIME_SERIES) {
            if (tsProps != null) {
                throw new GSException(145023, "TimeSeriesProperties used except for TimeSeries (containerType=" + (Object)((Object)type) + ")");
            }
            return;
        }
        if (OLD_TIME_SERIES_PROPERTIES) {
            out.putInt(-1);
            out.putByteEnum(TimeUnit.DAY);
            out.putInt(-1);
            out.putByteEnum(TimeUnit.DAY);
            out.putInt(0);
            return;
        }
        if (tsProps == null) {
            out.putBoolean(false);
        } else {
            out.putBoolean(true);
            out.putInt(tsProps.getRowExpirationTime());
            TimeUnit timeUnit = tsProps.getRowExpirationTimeUnit();
            if (timeUnit == null) {
                out.putByteEnum(TimeUnit.DAY);
            } else {
                out.putByteEnum(timeUnit);
            }
            if (SubnetGridStore.isTSDivisionAndAffinityEnabled()) {
                out.putInt(tsProps.getExpirationDivisionCount());
                if (GridStoreChannel.v20AffinityCompatible) {
                    out.putString("");
                }
            }
            out.putInt(tsProps.getCompressionWindowSize());
            timeUnit = tsProps.getCompressionWindowSizeUnit();
            if (timeUnit == null) {
                out.putByteEnum(TimeUnit.DAY);
            } else {
                out.putByteEnum(timeUnit);
            }
            out.putByteEnum(tsProps.getCompressionMethod());
            Set<String> columnNameSet = tsProps.getSpecifiedColumns();
            out.putInt(columnNameSet.size());
            for (String columnName : columnNameSet) {
                out.putInt(mapper.resolveColumnId(columnName));
                boolean relative = tsProps.isCompressionRelative(columnName);
                out.putBoolean(relative);
                if (relative) {
                    out.putDouble(tsProps.getCompressionRate(columnName));
                    out.putDouble(tsProps.getCompressionSpan(columnName));
                    continue;
                }
                out.putDouble(tsProps.getCompressionWidth(columnName));
            }
        }
    }

    private static void importContainerProperties(BasicBuffer in, ContainerInfo containerInfo, List<? extends ColumnInfo> columnInfoList) throws GSException {
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled() && !GridStoreChannel.v20AffinityCompatible) {
            String dataAffinity = in.getString();
            containerInfo.setDataAffinity(dataAffinity.isEmpty() ? null : dataAffinity);
        }
        if (containerInfo.getType() != ContainerType.TIME_SERIES) {
            return;
        }
        boolean exists = in.getBoolean();
        if (!exists) {
            return;
        }
        TimeSeriesProperties props = new TimeSeriesProperties();
        int rowExpirationTime = in.base().getInt();
        TimeUnit timeUnit = in.getByteEnum(TimeUnit.class);
        if (rowExpirationTime > 0) {
            props.setRowExpiration(rowExpirationTime, timeUnit);
        }
        if (SubnetGridStore.isTSDivisionAndAffinityEnabled()) {
            int count = in.base().getInt();
            if (count > 0) {
                props.setExpirationDivisionCount(count);
            }
            if (GridStoreChannel.v20AffinityCompatible) {
                in.getString();
            }
        }
        int compressionWindowSize = in.base().getInt();
        timeUnit = in.getByteEnum(TimeUnit.class);
        if (compressionWindowSize > 0) {
            props.setCompressionWindowSize(compressionWindowSize, timeUnit);
        }
        CompressionMethod compressionMethod = in.getByteEnum(CompressionMethod.class);
        props.setCompressionMethod(compressionMethod);
        int entryCount = BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
        if (entryCount > 0 && compressionMethod != CompressionMethod.HI) {
            throw new GSException(145031, "Protocol error by unexpected compression entry (entryCount=" + entryCount + ", compressionMethod=" + (Object)((Object)compressionMethod) + ")");
        }
        if (entryCount < 0) {
            throw new GSException(145031, "Protocol error by negative entry count (entryCount=" + entryCount + ")");
        }
        for (int i = 0; i < entryCount; ++i) {
            int columnId = in.base().getInt();
            if (columnId < 0 || columnId >= columnInfoList.size()) {
                throw new GSException(145031, "Protocol error by illegal column ID (columnId=" + columnId + ", columnCount=" + columnInfoList.size() + ")");
            }
            String columnName = columnInfoList.get(columnId).getName();
            boolean relative = in.getBoolean();
            if (relative) {
                double rate = in.base().getDouble();
                double span = in.base().getDouble();
                props.setRelativeHiCompression(columnName, rate, span);
                continue;
            }
            double width = in.base().getDouble();
            props.setAbsoluteHiCompression(columnName, width);
        }
        containerInfo.setTimeSeriesProperties(props);
    }

    public <K, R> SubnetContainer<K, R> getContainer(ContainerKeyConverter.ContainerKey key, Container.BindType<K, R, ?> bindType, Integer attribute, boolean internalMode) throws GSException {
        SubnetContainer<K, R> cachedContainer;
        if (bindType.getRowClass() == Row.class) {
            SubnetContainer<K, Row> container = this.getContainerGeneral(key, RowMapper.BindingTool.rebindRow(Row.class, bindType), attribute, internalMode);
            return (SubnetContainer)bindType.castContainer(container);
        }
        ContainerType containerType = RowMapper.BindingTool.findContainerType(bindType);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !internalMode && (cachedContainer = this.findContainerByCache(cache, key, bindType, containerType, internalMode)) != null) {
            return cachedContainer;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, internalMode, false, attribute);
        RowMapper orgMapper = RowMapper.getInstance(bindType, containerType, SubnetGridStore.getRowMapperConfig());
        int partitionId = this.channel.resolvePartitionId(this.context, key, internalMode);
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(internalMode, false);
        this.putContainerKey(req, key, keyConverter);
        SubnetGridStore.tryPutContainerType(req, containerType);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.GET_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, key);
        boolean found = resp.getBoolean();
        if (!found) {
            return null;
        }
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        ContainerKeyConverter.ContainerKey[] acceptedKeys = this.acceptRemoteContainerKey(resp, keyConverter, key);
        ContainerKeyConverter.ContainerKey normalizedKey = acceptedKeys[0];
        ContainerKeyConverter.ContainerKey remoteKey = acceptedKeys[1];
        RowMapper mapper = orgMapper.reorderBySchema(resp, SubnetGridStore.getRowMapperConfig(), true);
        if (cache != null && !internalMode) {
            cache.cacheSchema(normalizedKey, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteKey));
        }
        if (mapper.isForTimeSeries()) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<R>(this, this.channel, this.context, SubnetGridStore.rebindTimeSeriesType(bindType), mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey));
        }
        return new SubnetCollection<K, R>(this, this.channel, this.context, bindType, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey);
    }

    public <K, R> SubnetCollection<K, R> getCollection(String name, Class<R> rowType) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), RowMapper.BindingTool.createCollectionBindType(null, rowType), (Integer)null, false);
        return (SubnetCollection)container;
    }

    public <R> SubnetTimeSeries<R> getTimeSeries(String name, Class<R> rowType) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), RowMapper.BindingTool.createTimeSeriesBindType(rowType), (Integer)null, false);
        return (SubnetTimeSeries)container;
    }

    @Override
    public void dropCollection(String name) throws GSException {
        this.dropContainer(this.parseContainerKey(name, false, true), ContainerType.COLLECTION, false);
    }

    @Override
    public void dropTimeSeries(String name) throws GSException {
        this.dropContainer(this.parseContainerKey(name, false, true), ContainerType.TIME_SERIES, false);
    }

    @Override
    public void close() throws GSException {
        try {
            this.channel.closeContext(this.context);
        }
        finally {
            this.channel.unregisterContext(this.contextRef);
        }
    }

    private static ContainerProperties.ContainerIdInfo importIdProperty(BasicBuffer in, ContainerKeyConverter keyConverter, int endPos) throws GSException {
        int versionId = in.base().getInt();
        long containerId = in.base().getLong();
        ContainerKeyConverter.ContainerKey remoteKey = keyConverter.get(in, false, true);
        ContainerProperties.MetaDistributionType metaDistType = ContainerProperties.MetaDistributionType.NONE;
        long metaContainerId = -1L;
        ContainerProperties.MetaNamingType metaNamingType = null;
        if (in.base().position() < endPos) {
            metaDistType = in.getByteEnum(ContainerProperties.MetaDistributionType.class);
            int size = BasicBuffer.BufferUtils.checkSize(in.base(), in.base().getInt());
            int orgLimit = BasicBuffer.BufferUtils.limitForward(in.base(), size);
            metaContainerId = in.base().getLong();
            metaNamingType = in.getByteEnum(ContainerProperties.MetaNamingType.class);
            BasicBuffer.BufferUtils.restoreLimitExact(in.base(), orgLimit);
        }
        return new ContainerProperties.ContainerIdInfo(versionId, containerId, remoteKey, metaDistType, metaContainerId, metaNamingType);
    }

    private static void importSchemaProperty(BasicBuffer in, ContainerInfo containerInfo, List<RowMapper.MutableColumnInfo> columnInfoList) throws GSException {
        columnInfoList.clear();
        RowMapper.Config config = SubnetGridStore.getRowMapperConfig();
        containerInfo.setType(in.getByteEnum(ContainerType.class));
        int columnCount = RowMapper.importColumnCount(in);
        List<Integer> keyList = RowMapper.importKeyListBegin(in, config, columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnInfoList.add(RowMapper.importColumnSchema(in, config));
        }
        keyList = RowMapper.importKeyListEnd(in, config, columnCount, keyList);
        containerInfo.setRowKeyColumnList(keyList);
    }

    private static void importIndexProperty(BasicBuffer in, List<RowMapper.MutableColumnInfo> columnInfoList) throws GSException {
        int i;
        ArrayList<Set<Object>> indexTypesList = new ArrayList<Set<Object>>();
        int columnCount = columnInfoList == null ? -1 : columnInfoList.size();
        for (int i2 = 0; i2 < columnCount; ++i2) {
            indexTypesList.add(Collections.emptySet());
        }
        int entryCount = BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
        for (i = 0; i < entryCount; ++i) {
            IndexType indexType;
            int columnId = in.base().getInt();
            if (columnId < 0 || columnId >= columnCount && columnCount >= 0) {
                throw new GSException(145031, "Protocol error by illegal column ID (entryCount=" + columnId + ", columnCount=" + columnCount + ")");
            }
            EnumSet<IndexType> indexTypeSet = (EnumSet<IndexType>)indexTypesList.get(columnId);
            if (indexTypeSet.isEmpty()) {
                indexTypeSet = EnumSet.noneOf(IndexType.class);
                indexTypesList.set(columnId, indexTypeSet);
            }
            if ((indexType = in.getByteEnum(IndexType.class)) == IndexType.DEFAULT) {
                throw new GSException(145031, "Protocol error by illegal index type");
            }
            indexTypeSet.add(indexType);
        }
        for (i = 0; i < columnCount; ++i) {
            columnInfoList.get(i).setIndexTypes((Set)indexTypesList.get(i));
        }
    }

    private static void importEventNotificationProperty(BasicBuffer in, List<URL> eventNotificationInfoList) throws GSException {
        eventNotificationInfoList.clear();
        int entryCount = in.base().getInt();
        if (entryCount < 0) {
            return;
        }
        for (int i = 0; i < entryCount; ++i) {
            String urlString = in.getString();
            try {
                eventNotificationInfoList.add(new URL(urlString));
                continue;
            }
            catch (MalformedURLException e) {
                throw new GSConnectionException(145031, "Protocol error by malformed URL (urlString=\"" + urlString + "\", reason=" + e.getMessage() + ")", e);
            }
        }
    }

    private static void importTriggerProperty(BasicBuffer in, ContainerInfo containerInfo, List<? extends ColumnInfo> columnInfoList) throws GSException {
        ArrayList<TriggerInfo> triggerInfoList = new ArrayList<TriggerInfo>();
        int entryCount = in.base().getInt();
        if (entryCount < 0) {
            containerInfo.setTriggerInfoList(triggerInfoList);
            return;
        }
        int schemaColumnCount = columnInfoList == null ? -1 : columnInfoList.size();
        for (int i = 0; i < entryCount; ++i) {
            String name = in.getString();
            TriggerInfo.Type type = in.getByteEnum(TriggerInfo.Type.class);
            String uriString = in.getString();
            int eventTypeFlag = in.base().getInt();
            EnumSet<TriggerInfo.EventType> eventSet = EnumSet.noneOf(TriggerInfo.EventType.class);
            EnumSet<TriggerInfo.EventType> allEventSet = EnumSet.allOf(TriggerInfo.EventType.class);
            for (TriggerInfo.EventType e : allEventSet) {
                if ((eventTypeFlag & 1 << e.ordinal()) == 0) continue;
                eventSet.add(e);
            }
            HashSet<String> columnSet = new HashSet<String>();
            int columnCount = in.base().getInt();
            for (int j = 0; j < columnCount; ++j) {
                int columnId = in.base().getInt();
                if (schemaColumnCount < 0) continue;
                if (columnId < 0 || columnId >= schemaColumnCount && schemaColumnCount >= 0) {
                    throw new GSException(145031, "Protocol error by illegal column ID (entryCount=" + columnId + ", columnCount=" + schemaColumnCount + ")");
                }
                String columnName = columnInfoList.get(columnId).getName();
                columnSet.add(columnName);
            }
            in.getString();
            String jmsDestinationType = in.getString();
            String jmsDestinationName = in.getString();
            String jmsUser = in.getString();
            String jmsPassword = in.getString();
            TriggerInfo info = new TriggerInfo();
            info.setName(name);
            info.setType(type);
            try {
                info.setURI(new URI(uriString));
            }
            catch (URISyntaxException e) {
                throw new GSConnectionException(145031, "Protocol error by malformed URI (uriString=\"" + uriString + "\", reason=" + e.getMessage() + ")", e);
            }
            info.setTargetEvents(eventSet);
            info.setTargetColumns(columnSet);
            info.setJMSDestinationType(jmsDestinationType);
            info.setJMSDestinationName(jmsDestinationName);
            info.setUser(jmsUser);
            info.setPassword(jmsPassword);
            triggerInfoList.add(info);
        }
        containerInfo.setTriggerInfoList(triggerInfoList);
    }

    private static int importAttributeProperty(BasicBuffer in, Integer expectedAttribute) throws GSException {
        int attribute = in.base().getInt();
        if (expectedAttribute != null && attribute != expectedAttribute) {
            if (!SubnetGridStore.isAttributeVerifiable()) {
                throw new Error();
            }
            throw new GSConnectionException(145031, "Protocol error by unexpected container attribute (expected=" + expectedAttribute + ", actual=" + attribute + ")");
        }
        return attribute;
    }

    private static void importIndexDetailProperty(BasicBuffer in, List<IndexInfo> indexInfoList) throws GSException {
        indexInfoList.clear();
        int entryCount = BasicBuffer.BufferUtils.getIntSize(in.base());
        for (int i = 0; i < entryCount; ++i) {
            IndexInfo indexInfo = new IndexInfo();
            SubnetGridStore.importIndexInfo(in, indexInfo, false, false);
            indexInfoList.add(indexInfo);
        }
    }

    private static void assignIndexColumnNames(List<RowMapper.MutableColumnInfo> columnInfoList, List<IndexInfo> indexInfoList, Integer attribute, boolean internalMode) throws GSException {
        if (internalMode && (attribute == null || attribute != ContainerKeyPredicate.ATTRIBUTE_BASE && attribute != ContainerKeyPredicate.ATTRIBUTE_SINGLE)) {
            return;
        }
        for (IndexInfo indexInfo : indexInfoList) {
            IndexType type = indexInfo.getType();
            List<Integer> columnList = indexInfo.getColumnList();
            ArrayList<String> columnNameList = new ArrayList<String>(columnList.size());
            for (Integer column : columnList) {
                RowMapper.MutableColumnInfo columnInfo;
                try {
                    columnInfo = columnInfoList.get(column);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new GSConnectionException(145031, "Protocol error by illegal index column", e);
                }
                columnNameList.add(columnInfo.getName());
                Set<IndexType> typeSet = columnInfo.getIndexTypes();
                if (typeSet == null || typeSet.contains((Object)type)) continue;
                if (columnList.size() == 1) {
                    throw new GSConnectionException(145031, "Protocol error by inconsistent index type (type=" + (Object)((Object)type) + ")");
                }
                if (!compositeIndexTypeUnified) continue;
                EnumSet<IndexType> modTypeSet = EnumSet.noneOf(IndexType.class);
                modTypeSet.addAll(typeSet);
                modTypeSet.add(type);
                columnInfo.setIndexTypes(modTypeSet);
            }
            indexInfo.setColumnNameList(columnNameList);
        }
    }

    public static void importIndexInfo(BasicBuffer in, IndexInfo indexInfo, boolean withMatchOptions, boolean defaultTypeAllowed) throws GSException {
        IndexType type;
        int infoSize = in.base().getInt();
        int orgLimit = BasicBuffer.BufferUtils.limitForward(in.base(), infoSize);
        String name = in.getString();
        if (!name.isEmpty()) {
            indexInfo.setName(name);
        }
        int columnCount = BasicBuffer.BufferUtils.getNonNegativeInt(in.base());
        ArrayList<Integer> columnList = new ArrayList<Integer>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            int column = in.base().getInt();
            columnList.add(column);
        }
        indexInfo.setColumnList(columnList);
        byte rawType = in.base().get();
        if (rawType == -1) {
            type = IndexType.DEFAULT;
        } else {
            try {
                type = INDEX_TYPE_CONSTANTS[rawType & 0xFF];
            }
            catch (IndexOutOfBoundsException e) {
                throw new GSException(145031, "Protocol error by illegal index type (reason=" + e.getMessage() + ")", e);
            }
        }
        if (type == IndexType.DEFAULT && !defaultTypeAllowed) {
            throw new GSException(145031, "Protocol error by illegal index type");
        }
        indexInfo.setType(type);
        BasicBuffer.BufferUtils.restoreLimit(in.base(), orgLimit);
        if (withMatchOptions) {
            boolean anyNameMatches = in.getBoolean();
            boolean anyTypeMatches = in.getBoolean();
            if (anyNameMatches) {
                indexInfo.setName(null);
            }
            if (anyTypeMatches) {
                indexInfo.setType(null);
            }
        }
    }

    public static void exportIndexInfo(BasicBuffer out, IndexInfo indexInfo, boolean withMatchOptions) {
        int headPos = out.base().position();
        out.putInt(0);
        int startPos = out.base().position();
        String name = indexInfo.getName();
        out.putString(name == null ? "" : name);
        List<Integer> columnList = indexInfo.getColumnList();
        int columnCount = columnList.size();
        out.putInt(columnCount);
        for (Integer column : columnList) {
            out.putInt(column);
        }
        IndexType type = indexInfo.getType();
        if (type == null || type == IndexType.DEFAULT) {
            out.put((byte)-1);
        } else {
            out.putByteEnum(type);
        }
        int endPos = out.base().position();
        out.base().position(headPos);
        out.putInt(endPos - startPos);
        out.base().position(endPos);
        if (withMatchOptions) {
            boolean anyNameMatches = indexInfo.getName() == null;
            boolean anyTypeMatches = indexInfo.getType() == null;
            out.putBoolean(anyNameMatches);
            out.putBoolean(anyTypeMatches);
        }
    }

    private static <K, R> SubnetContainer<K, R> disguiseTypedContainer(SubnetContainer<?, R> container) {
        return container;
    }

    private static <R> Container.BindType<Date, R, ? extends Container<?, ?>> rebindTimeSeriesType(Container.BindType<?, R, ? extends Container<?, ?>> src) throws GSException {
        return RowMapper.BindingTool.rebindKey(Date.class, src);
    }

    private ContainerKeyConverter.ContainerKey resolveContainerKey(ContainerKeyConverter.ContainerKey key, ContainerInfo info, ContainerKeyConverter keyConverter) throws GSException {
        boolean caseSensitive = true;
        String anotherName = info.getName();
        ContainerKeyConverter.ContainerKey specifiedKey = key == null ? null : key.toCaseSensitive(true);
        ContainerKeyConverter.ContainerKey anotherKey = anotherName == null ? null : keyConverter.parse(anotherName, true);
        return SubnetGridStore.resolveName(specifiedKey, anotherKey, "container name");
    }

    private static <T> T resolveName(T name, T anotherName, String objectName) throws GSException {
        T another;
        T t = another = anotherName == null ? null : (T)anotherName;
        if (name == null) {
            if (another == null) {
                throw new GSException(145001, "Non-specified" + objectName);
            }
            return another;
        }
        if (another != null && !name.equals(another)) {
            throw new GSException(145002, "Inconsistent " + objectName + " (specifiedName=" + name + ", nameOnInfo=" + another + ")");
        }
        return (T)name;
    }

    private static ContainerType resolveContainerType(ContainerType type, ContainerInfo info) throws GSException {
        ContainerType another;
        ContainerType containerType = another = info == null ? null : info.getType();
        if (type == null) {
            if (another == null) {
                throw new GSException(145001, "Container type not specified");
            }
            return another;
        }
        if (another != null && another != type) {
            throw new GSException(145023, "Inconsistent container type (specifiedType=" + (Object)((Object)type) + ", typeOnInfo=" + (Object)((Object)another) + ")");
        }
        return type;
    }

    private static ContainerInfo findContainerInfo(ContainerProperties props) {
        if (props == null) {
            return null;
        }
        return props.getInfo();
    }

    private static Integer findContainerAttribute(ContainerProperties props) {
        if (props == null) {
            return null;
        }
        return props.getAttribute();
    }

    private <K> SubnetContainer<K, Row> getContainerGeneral(ContainerKeyConverter.ContainerKey key, Container.BindType<K, Row, ?> bindType, Integer attribute, boolean internalMode) throws GSException {
        SubnetContainer<K, Row> cachedContainer;
        SubnetCollection<K, Row> container;
        ContainerType expectedType = RowMapper.BindingTool.findContainerType(bindType);
        if (CONTEXT_CONTROLLER_KEY.equals(key) && (container = this.getContextControllerCollection(expectedType)) != null) {
            return container;
        }
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && (cachedContainer = this.findContainerByCache(cache, key, bindType, expectedType, internalMode)) != null) {
            return cachedContainer;
        }
        ContainerProperties containerProps = this.getContainerProperties(key, ContainerPropertyKeysConstants.FOR_OBJECT, attribute, internalMode);
        if (containerProps == null) {
            return null;
        }
        ContainerInfo containerInfo = containerProps.getInfo();
        ContainerProperties.ContainerIdInfo idInfo = containerProps.getIdInfo();
        ContainerType resolvedType = SubnetGridStore.resolveContainerType(expectedType, containerInfo);
        int partitionId = this.channel.resolvePartitionId(this.context, key, internalMode);
        RowMapper mapper = RowMapper.getInstance(bindType, resolvedType, containerInfo, SubnetGridStore.getRowMapperConfig());
        ContainerKeyConverter.ContainerKey[] acceptedKeys = this.filterRemoteContainerKey(idInfo.remoteKey, key);
        ContainerKeyConverter.ContainerKey normalizedKey = acceptedKeys[0];
        ContainerKeyConverter.ContainerKey remoteKey = acceptedKeys[1];
        if (idInfo.metaDistType != ContainerProperties.MetaDistributionType.NONE) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetCollection.MetaCollection<K, Row>(this, this.channel, this.context, bindType, mapper, idInfo.versionId, partitionId, idInfo.metaDistType, idInfo.metaContainerId, idInfo.metaNamingType, normalizedKey, idInfo.remoteKey));
        }
        if (cache != null) {
            cache.cacheSchema(normalizedKey, new GridStoreChannel.LocatedSchema(mapper, idInfo.containerId, idInfo.versionId, remoteKey));
        }
        if (mapper.isForTimeSeries()) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<Row>(this, this.channel, this.context, SubnetGridStore.rebindTimeSeriesType(bindType), mapper, idInfo.versionId, partitionId, idInfo.containerId, normalizedKey, remoteKey));
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetCollection<K, Row>(this, this.channel, this.context, bindType, mapper, idInfo.versionId, partitionId, idInfo.containerId, normalizedKey, remoteKey));
    }

    @Override
    public <K> Container<K, Row> getContainer(String name) throws GSException {
        return this.getContainer(this.parseContainerKey(name), RowMapper.BindingTool.createBindType(null, Row.class, Container.class), (Integer)null, false);
    }

    @Override
    public <K> Collection<K, Row> getCollection(String name) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), RowMapper.BindingTool.createCollectionBindType(null, Row.class), (Integer)null, false);
        return (Collection)((Object)container);
    }

    @Override
    public TimeSeries<Row> getTimeSeries(String name) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), RowMapper.BindingTool.createTimeSeriesBindType(Row.class), (Integer)null, false);
        return (TimeSeries)((Object)container);
    }

    private <K> Container<K, Row> putContainerGeneral(ContainerKeyConverter.ContainerKey key, Container.BindType<K, Row, ?> bindType, ContainerProperties props, boolean modifiable, boolean internalMode) throws GSException {
        SubnetContainer<K, Row> container;
        ContainerType containerType = RowMapper.BindingTool.findContainerType(bindType);
        ContainerInfo containerInfo = SubnetGridStore.findContainerInfo(props);
        Integer containerAttribute = SubnetGridStore.findContainerAttribute(props);
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(internalMode, true);
        key = this.resolveContainerKey(key, containerInfo, keyConverter);
        containerType = SubnetGridStore.resolveContainerType(containerType, containerInfo);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null && !modifiable && !internalMode && containerInfo.getTimeSeriesProperties() != null && (container = this.findContainerByCache(cache, key, bindType, containerType, internalMode)) != null) {
            return container;
        }
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        RowMapper orgMapper = RowMapper.getInstance(bindType, containerType, containerInfo, SubnetGridStore.getRowMapperConfig());
        NodeConnection.OptionalRequestSource propsOption = SubnetGridStore.containerPropertiesToOption(props, orgMapper);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, internalMode, true, containerAttribute, propsOption);
        int partitionId = this.channel.resolvePartitionId(this.context, key, internalMode);
        this.putContainerKey(req, key, keyConverter);
        SubnetGridStore.tryPutContainerType(req, containerType);
        req.putBoolean(modifiable);
        orgMapper.exportSchema(req, SubnetGridStore.getRowMapperConfig());
        this.exportContainerProperties(req, containerType, props, orgMapper, key, propsOption);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.PUT_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, key);
        int schemaVerId = resp.base().getInt();
        long containerId = resp.base().getLong();
        ContainerKeyConverter.ContainerKey[] acceptedKeys = this.acceptRemoteContainerKey(resp, keyConverter, key);
        ContainerKeyConverter.ContainerKey normalizedKey = acceptedKeys[0];
        ContainerKeyConverter.ContainerKey remoteKey = acceptedKeys[1];
        RowMapper.Config config = SubnetGridStore.getRowMapperConfig();
        RowMapper mapper = orgMapper.reorderBySchema(resp, config, containerInfo.isColumnOrderIgnorable());
        if (cache != null && !internalMode) {
            cache.cacheSchema(normalizedKey, new GridStoreChannel.LocatedSchema(mapper, containerId, schemaVerId, remoteKey));
        }
        if (mapper.isForTimeSeries()) {
            return SubnetGridStore.disguiseTypedContainer(new SubnetTimeSeries<Row>(this, this.channel, this.context, SubnetGridStore.rebindTimeSeriesType(bindType), mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey));
        }
        return SubnetGridStore.disguiseTypedContainer(new SubnetCollection<K, Row>(this, this.channel, this.context, bindType, mapper, schemaVerId, partitionId, containerId, normalizedKey, remoteKey));
    }

    @Override
    public <K> Container<K, Row> putContainer(String name, ContainerInfo info, boolean modifiable) throws GSException {
        ContainerKeyConverter.ContainerKey key = name == null ? null : this.parseContainerKey(name, false, true);
        return this.putContainer(key, RowMapper.BindingTool.createBindType(null, Row.class, Container.class), new ContainerProperties(info), modifiable, false);
    }

    @Override
    public <K> Collection<K, Row> putCollection(String name, ContainerInfo info, boolean modifiable) throws GSException {
        ContainerKeyConverter.ContainerKey key = name == null ? null : this.parseContainerKey(name, false, true);
        Container container = this.putContainer(key, RowMapper.BindingTool.createCollectionBindType(null, Row.class), new ContainerProperties(info), modifiable, false);
        return (Collection)container;
    }

    @Override
    public TimeSeries<Row> putTimeSeries(String name, ContainerInfo info, boolean modifiable) throws GSException {
        ContainerKeyConverter.ContainerKey key = name == null ? null : this.parseContainerKey(name, false, true);
        Container container = this.putContainer(key, RowMapper.BindingTool.createTimeSeriesBindType(Row.class), new ContainerProperties(info), modifiable, false);
        return (TimeSeries)container;
    }

    @Override
    public void dropContainer(ContainerKeyConverter.ContainerKey key, ContainerType containerType, boolean internalMode) throws GSException {
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(internalMode, true);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        SubnetGridStore.tryPutSystemOptionalRequest(req, this.context, internalMode, false, null);
        this.putContainerKey(req, key, keyConverter);
        SubnetGridStore.tryPutContainerType(req, containerType);
        int partitionId = this.channel.resolvePartitionId(this.context, key, internalMode);
        Statement statement = SubnetGridStore.getContainerStatement(Statement.DROP_CONTAINER, containerType);
        this.executeStatement(statement, partitionId, req, resp, key);
        GridStoreChannel.ContainerCache cache = this.context.getContainerCache();
        if (cache != null) {
            cache.removeSchema(key.toCaseSensitive(false));
        }
    }

    @Override
    public void dropContainer(String name) throws GSException {
        this.dropContainer(this.parseContainerKey(name, false, true), null, false);
    }

    @Override
    public <K, R, C extends Container<K, R>> C getContainer(String name, Container.BindType<K, R, C> bindType) throws GSException {
        Extensibles.AsContainer container = this.getContainer(this.parseContainerKey(name), (Container.BindType)bindType, (Integer)null, false);
        return bindType.castContainer(container);
    }

    @Override
    public <K, R, C extends Container<K, R>> C putContainer(String name, Container.BindType<K, R, C> bindType) throws GSException {
        return this.putContainer(name, bindType, null, false);
    }

    @Override
    public <K, R, C extends Container<K, R>> C putContainer(String name, Container.BindType<K, R, C> bindType, ContainerInfo info, boolean modifiable) throws GSException {
        Container container = this.putContainer(this.parseContainerKey(name, false, true), (Container.BindType)bindType, new ContainerProperties(info), modifiable, false);
        return bindType.castContainer(container);
    }

    @Override
    public Row createRow(ContainerInfo info) throws GSException {
        this.channel.checkContextAvailable(this.context);
        RowMapper mapper = RowMapper.getInstance(info.getType(), info, SubnetGridStore.getRowMapperConfig());
        return mapper.createGeneralRow();
    }

    @Override
    public Row.Key createRowKey(ContainerInfo info) throws GSException {
        this.channel.checkContextAvailable(this.context);
        RowMapper mapper = RowMapper.getInstance(info.getType(), info, SubnetGridStore.getRowMapperConfig());
        return mapper.createGeneralRowKey();
    }

    @Override
    public void fetchAll(List<? extends Query<?>> queryList) throws GSException {
        this.fetchAll(new UnnamedMultiOperationContext(queryList));
    }

    @Override
    public void fetchAll(Extensibles.MultiOperationContext<Integer, Query<?>, Query<?>> multiContext) throws GSException {
        boolean internalMode = false;
        this.executeAllMulti(Statement.EXECUTE_MULTIPLE_QUERIES, MultiQueryStatement.newFactory(multiContext, this), false);
    }

    @Override
    public void multiPut(Map<String, List<Row>> containerRowsMap) throws GSException {
        this.multiPut(new NamedMultiOperationContext<List<Row>, Void>(containerRowsMap, this.getContainerKeyConverter(false, true)), false);
    }

    @Override
    public void multiPut(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, List<Row>, Void> multiContext, boolean internalMode) throws GSException {
        this.executeAllMulti(Statement.PUT_MULTIPLE_CONTAINER_ROWS, MultiPutStatement.newFactory(multiContext), internalMode);
    }

    private <K, T, V, R> void executeAllMulti(Statement statement, MultiOperationStatement.Factory<K, T, V, R> factory, boolean internalMode) throws GSException {
        Extensibles.MultiOperationContext<K, V, R> multiContext = factory.getMultiContext();
        HashMap requestMap = new HashMap();
        Extensibles.MultiTargetConsumer<K, V> consumer = factory.createConsumer(requestMap, this.channel, this.context, internalMode);
        this.beginComplexedStatement(statement, 0, null);
        int lastIncompleteCount = -1;
        int noProgressCount = 0;
        int trialCount = 0;
        while (true) {
            multiContext.listTarget(consumer);
            HashSet<Integer> incompleteSet = null;
            Iterator it = requestMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int partitionId = (Integer)entry.getKey();
                MultiOperationStatement multiStatement = (MultiOperationStatement)entry.getValue();
                try {
                    this.executeMulti(partitionId, statement, multiStatement, internalMode);
                }
                catch (GSStatementException e) {
                    if (multiContext.acceptException(e)) {
                        incompleteSet = new HashSet<Integer>();
                        incompleteSet.add(partitionId);
                        while (it.hasNext()) {
                            incompleteSet.add((Integer)it.next().getKey());
                        }
                        if (lastIncompleteCount != incompleteSet.size()) {
                            noProgressCount = -1;
                        }
                        boolean maxNoProgressCount = true;
                        if (++noProgressCount <= 1) {
                            lastIncompleteCount = incompleteSet.size();
                            LOGGER.info("transaction.repairingMultiOperation", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, lastIncompleteCount, e});
                            break;
                        }
                    }
                    Map<String, String> filteredParams = this.filterMultiOperationParamters(e.getParameters());
                    throw new GSStatementException(0, null, this.formatMultiOperationDescription(e, filteredParams), filteredParams, e);
                }
                noProgressCount = 0;
            }
            if (incompleteSet == null) {
                if (!multiContext.isRemaining()) break;
                requestMap.clear();
                lastIncompleteCount = -1;
                noProgressCount = 0;
            } else {
                for (Map.Entry entry : requestMap.entrySet()) {
                    if (incompleteSet.contains(entry.getKey())) continue;
                    ((MultiOperationStatement)entry.getValue()).repairOperation(multiContext);
                }
                requestMap.clear();
            }
            ++trialCount;
        }
        this.endComplexedStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMulti(int partitionId, Statement statement, MultiOperationStatement<?, ?> multiStatement, boolean internalMode) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        boolean succeeded = false;
        try {
            int trialCount = 0;
            while (true) {
                int sessionTrial = 0;
                while (true) {
                    block23: {
                        this.channel.setupRequestBuffer(req);
                        if (!multiStatement.makeCreateSessionRequest(req, this.channel, this.context, internalMode)) break;
                        try {
                            this.channel.executeStatement(this.context, Statement.CREATE_MULTIPLE_SESSIONS.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
                        }
                        catch (GSStatementException e) {
                            if (!SubnetContainer.isNewSessionConflicted(e)) {
                                throw e;
                            }
                            if (sessionTrial >= 2) {
                                throw new GSStatementException(e.getErrorCode(), "Failed to create session (totalTrialCount=" + trialCount + ", sessionTrialCount=" + sessionTrial + ", reason=" + e.getMessage() + ")", e);
                            }
                            if (!LOGGER.isInfoEnabled()) break block23;
                            LOGGER.info("transaction.regeneratingMultiSession", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, sessionTrial, e});
                            break block23;
                        }
                        multiStatement.acceptCreateSessionResponse(resp);
                        if (trialCount <= 0 && sessionTrial <= 0 || !LOGGER.isInfoEnabled()) break;
                        LOGGER.info("transaction.sessionRepaired", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, sessionTrial});
                        break;
                    }
                    ++sessionTrial;
                }
                try {
                    Object targetConnection;
                    this.channel.setupRequestBuffer(req);
                    if (!multiStatement.makeMainRequest(req, this.channel, this.context, internalMode)) {
                        break;
                    }
                    GridStoreChannel.Context context = this.context;
                    synchronized (context) {
                        this.channel.executeStatement(this.context, statement.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
                        targetConnection = this.channel.getLastConnection(this.context);
                    }
                    multiStatement.acceptMainResponse(resp, targetConnection);
                    succeeded = true;
                }
                catch (GSStatementException e) {
                    if (!multiStatement.acceptStatementErrorForSession(e)) {
                        throw e;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("transaction.repairingMultiSession", new Object[]{GridStoreChannel.ContextMonitor.getObjectId(this.context), statement, trialCount, e});
                    }
                    if (trialCount >= 2) {
                        throw new GSStatementException(e.getErrorCode(), "Failed to repair session (trialCount=" + trialCount + ", reason=" + e.getMessage() + ")");
                    }
                    ++trialCount;
                    continue;
                }
                break;
            }
        }
        finally {
            block25: {
                try {
                    this.channel.setupRequestBuffer(req);
                    if (multiStatement.makeCloseSessionRequest(req, this.context)) {
                        this.channel.executeStatement(this.context, Statement.CLOSE_MULTIPLE_SESSIONS.generalize(), partitionId, 0L, req, resp, this.contextMonitor);
                        multiStatement.acceptSessionClosed();
                    }
                }
                catch (GSException e) {
                    if (!succeeded) break block25;
                    throw e;
                }
            }
        }
    }

    private String formatMultiOperationDescription(GSException e, Map<String, String> filteredParams) {
        String description = GSErrorCode.getDescription(e);
        String containerName = filteredParams.get(ERROR_PARAM_CONTAINER);
        StringBuilder sb = new StringBuilder();
        if (description != null) {
            sb.append(description);
            sb.append(" ");
        }
        sb.append("(containerName=");
        if (containerName == null) {
            sb.append("(unidentified)");
        } else {
            sb.append(containerName);
        }
        sb.append(")");
        return sb.toString();
    }

    private Map<String, String> filterMultiOperationParamters(Map<String, String> src) {
        String orgContainerName = src.get(ERROR_PARAM_CONTAINER);
        if (orgContainerName == null) {
            return src;
        }
        try {
            ContainerKeyConverter keyConverter = this.getContainerKeyConverter(true, false);
            ContainerKeyConverter.Components components = new ContainerKeyConverter.Components();
            keyConverter.decompose(keyConverter.parse(orgContainerName, true), components);
            if (components.largeId == -1L && components.subCount == -1) {
                return src;
            }
            components.largeId = -1L;
            components.subCount = -1;
            components.affinityNum = -1L;
            components.affinityStr = null;
            String filteredContainerName = keyConverter.compose(components, true).toString();
            Map<String, String> dest = GSErrorCode.newParameters(src);
            dest.put(ERROR_PARAM_CONTAINER, filteredContainerName);
            return dest;
        }
        catch (GSException gSException) {
            return src;
        }
    }

    @Override
    public Map<String, List<Row>> multiGet(Map<String, ? extends RowKeyPredicate<?>> containerPredicateMap) throws GSException {
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(false, false);
        ListingMultiOperationContext<RowKeyPredicate<?>, Row> multiContext = ListingMultiOperationContext.create(containerPredicateMap, keyConverter);
        this.multiGet(multiContext, false);
        return multiContext.getAllResult();
    }

    @Override
    public void multiGet(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, ? extends RowKeyPredicate<?>, List<Row>> multiContext, boolean internalMode) throws GSException {
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(internalMode, false);
        this.executeAllMulti(Statement.GET_MULTIPLE_CONTAINER_ROWS, MultiGetRequest.newFactory(multiContext, keyConverter), internalMode);
    }

    @Override
    public void setContainerMonitoring(boolean monitoring) {
        this.context.getConfig().containerMonitoring = monitoring;
    }

    @Override
    public boolean isContainerMonitoring() {
        return this.context.getConfig().containerMonitoring;
    }

    @Override
    public SubnetPartitionController getPartitionController() throws GSException {
        this.channel.checkContextAvailable(this.context);
        return new SubnetPartitionController(this.channel, this.context);
    }

    private static ContainerKeyConverter.ContainerKey createSystemContainerKey(String name) {
        ContainerKeyConverter keyConverter = ContainerKeyConverter.getInstance(0, true, true);
        try {
            return keyConverter.parse(name, false);
        }
        catch (GSException e) {
            throw new Error(e);
        }
    }

    private <K> SubnetCollection<K, Row> getContextControllerCollection(ContainerType expectedType) throws GSException {
        if (expectedType != null && expectedType != ContainerType.COLLECTION) {
            return null;
        }
        RowMapper mapper = RowMapper.getInstance(null, new ContainerInfo(null, null, Arrays.asList(new ColumnInfo("name", GSType.STRING), new ColumnInfo("value", GSType.STRING)), true), SubnetGridStore.getRowMapperConfig());
        Container.BindType bindType = RowMapper.BindingTool.createCollectionBindType(null, Row.class);
        return new SubnetCollection<K, Row>(this, this.channel, this.context, bindType, mapper, -1, -1, -1L, CONTEXT_CONTROLLER_KEY, null){

            @Override
            public Row get(K key, boolean forUpdate) throws GSException {
                if (!(key instanceof String)) {
                    throw new GSException(145002, "Type of key for context controller must be string");
                }
                Row row = this.mapper.createGeneralRow();
                if ("failoverCount".equals(key)) {
                    row.setString(1, Integer.toString(this.context.getFailoverCount()));
                    row.setValue(0, key);
                    return row;
                }
                throw new GSException(145002, "Unknown key");
            }

            @Override
            public boolean put(K key, Row value) throws GSException {
                if ("invalidateMaster".equals(key) && value.getString(1).equals(Boolean.TRUE.toString())) {
                    this.channel.invalidateMaster(this.context);
                    return true;
                }
                throw new GSException(145002, "Unknown key");
            }
        };
    }

    @Override
    public <K, R> Container<K, R> putContainer(String name, Class<R> rowType, ContainerInfo info, boolean modifiable) throws GSException {
        ContainerKeyConverter keyConverter = this.getContainerKeyConverter(false, true);
        return this.putContainer(this.resolveContainerKey(keyConverter.parse(name, false), info, keyConverter), RowMapper.BindingTool.createBindType(null, rowType, Container.class), new ContainerProperties(info), modifiable, false);
    }

    private void setUserInfoRequest(BasicBuffer req, String userName) throws GSException {
        RowMapper.checkSymbol(userName, "user name");
        req.putString(userName);
    }

    private void setUserInfoRequest(BasicBuffer req, String userName, byte prop, String hashPassword) throws GSException {
        this.setUserInfoRequest(req, userName);
        req.put(prop);
        if (hashPassword != null) {
            if (hashPassword.isEmpty()) {
                throw new GSException(145001, "Empty hash password");
            }
            req.putBoolean(true);
            req.putString(hashPassword);
        } else {
            req.putBoolean(false);
        }
    }

    private Map<String, UserInfo> getUserInfoMap(BasicBuffer resp) throws GSException {
        int i;
        HashMap<String, UserInfo> map = new HashMap<String, UserInfo>();
        int userInfoCount = resp.base().getInt();
        if (userInfoCount == 0) {
            return map;
        }
        LinkedList<UserInfo> list = new LinkedList<UserInfo>();
        for (i = 0; i < userInfoCount; ++i) {
            String userName = resp.getString();
            Byte property = resp.base().get();
            Boolean passwordExist = resp.getBoolean();
            String tmp = resp.getString();
            String hashPassword = "";
            if (passwordExist.booleanValue()) {
                hashPassword = tmp;
            }
            list.add(new UserInfo(userName, hashPassword, property != 0, false, ""));
        }
        for (i = 0; i < userInfoCount; ++i) {
            Boolean isGroupMapping = resp.getBoolean();
            String roleName = resp.getString();
            if (((UserInfo)list.get(i)).getName().length() > 0) {
                map.put(((UserInfo)list.get(i)).getName(), new UserInfo(((UserInfo)list.get(i)).getName(), ((UserInfo)list.get(i)).getHashPassword(), ((UserInfo)list.get(i)).isSuperUser(), isGroupMapping, roleName));
                continue;
            }
            map.put(roleName, new UserInfo(((UserInfo)list.get(i)).getName(), ((UserInfo)list.get(i)).getHashPassword(), ((UserInfo)list.get(i)).isSuperUser(), isGroupMapping, roleName));
        }
        return map;
    }

    @Override
    public void putUser(String name, UserInfo userInfo, boolean modifiable, boolean isRole) throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.OptionalRequest opt = new NodeConnection.OptionalRequest();
        if (isRole) {
            opt.putFeatureVersion(NodeConnection.FeatureVersion.V4_5);
        }
        opt.format(req);
        boolean partitionId = false;
        if (isRole) {
            this.setUserInfoRequest(req, name, (byte)0, null);
        } else {
            GSErrorCode.checkNullParameter(userInfo, "userInfo", null);
            name = SubnetGridStore.resolveName(name, userInfo.getName(), "user name");
            String password = userInfo.getPassword();
            String hashPassword = userInfo.getHashPassword();
            if (password != null && hashPassword == null) {
                RowMapper.checkString(password, "password");
                int bytesLength = password.getBytes(BasicBuffer.DEFAULT_CHARSET).length;
                if (bytesLength > 64) {
                    throw new GSException(145002, "The length of password string bytes exceeded (max=64)");
                }
                this.setUserInfoRequest(req, name, (byte)0, NodeConnection.getDigest(password));
            } else if (password == null && hashPassword != null) {
                this.setUserInfoRequest(req, name, (byte)0, hashPassword);
            } else {
                if (password == null) {
                    throw new GSException(145001, "Password and hash password not specified");
                }
                throw new GSException(145002, "Both password and hash password specified");
            }
        }
        req.putBoolean(modifiable);
        this.executeStatement(Statement.PUT_USER, 0, req, resp, null);
    }

    @Override
    public void dropUser(String name) throws GSException {
        GSErrorCode.checkNullParameter(name, "name", null);
        name = SubnetGridStore.resolveName(name, null, "user name");
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setUserInfoRequest(req, name);
        this.executeStatement(Statement.DROP_USER, 0, req, resp, null);
    }

    @Override
    public Map<String, UserInfo> getUsers() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.OptionalRequest opt = new NodeConnection.OptionalRequest();
        opt.putAcceptableFeatureVersion(NodeConnection.FeatureVersion.V4_5);
        opt.format(req);
        boolean partitionId = false;
        req.putBoolean(false);
        req.put((byte)0);
        this.executeStatement(Statement.GET_USERS, 0, req, resp, null);
        Map<String, UserInfo> map = this.getUserInfoMap(resp);
        return map;
    }

    @Override
    public UserInfo getCurrentUser() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.OptionalRequest opt = new NodeConnection.OptionalRequest();
        opt.putAcceptableFeatureVersion(NodeConnection.FeatureVersion.V4_5);
        opt.format(req);
        boolean partitionId = false;
        req.putBoolean(true);
        req.putString(this.context.getUser());
        req.put((byte)0);
        this.executeStatement(Statement.GET_USERS, 0, req, resp, null);
        Map<String, UserInfo> map = this.getUserInfoMap(resp);
        if (map.size() != 1) {
            throw new GSConnectionException(145031, "Protocol error by illegal user info count (expected=1, actual=" + map.size() + ")");
        }
        UserInfo userInfo = map.get(this.context.getUser());
        if (userInfo == null) {
            throw new GSConnectionException(145031, "Protocol error by illegal user name (expected=" + this.context.getUser() + ")");
        }
        return userInfo;
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName) throws GSException {
        RowMapper.checkSymbol(dbName, "database name");
        req.putString(dbName);
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName, byte prop, Map<String, PrivilegeInfo> privileges) throws GSException {
        this.setDatabaseInfoRequest(req, dbName);
        req.put(prop);
        if (privileges != null) {
            req.putInt(privileges.size());
            for (Map.Entry<String, PrivilegeInfo> privilegeEntry : privileges.entrySet()) {
                RowMapper.checkSymbol(privilegeEntry.getKey(), "privilege name");
                req.putString(privilegeEntry.getKey());
                PrivilegeInfo privilegeInfo = privilegeEntry.getValue();
                if (privilegeInfo == null) {
                    throw new GSException(145001, "Privilege info not specified");
                }
                PrivilegeInfo.RoleType role = privilegeInfo.getRole();
                if (role == PrivilegeInfo.RoleType.ALL) {
                    req.putString(ALL_PRIVILEGE);
                    continue;
                }
                req.putString(READ_PRIVILEGE);
            }
        } else {
            req.putInt(0);
        }
    }

    private void setDatabaseInfoRequest(BasicBuffer req, String dbName, byte prop, String userName, PrivilegeInfo info) throws GSException {
        RowMapper.checkSymbol(userName, "user name");
        HashMap<String, PrivilegeInfo> map = new HashMap<String, PrivilegeInfo>();
        map.put(userName, info);
        this.setDatabaseInfoRequest(req, dbName, (byte)0, map);
    }

    private Map<String, DatabaseInfo> getDatabaseInfoMap(BasicBuffer resp) throws GSException {
        HashMap<String, DatabaseInfo> map = new HashMap<String, DatabaseInfo>();
        int databaseInfoCount = resp.base().getInt();
        if (databaseInfoCount == 0) {
            return map;
        }
        for (int i = 0; i < databaseInfoCount; ++i) {
            String databaseName = resp.getString();
            resp.base().get();
            int privilegeInfoCount = resp.base().getInt();
            HashMap<String, PrivilegeInfo> privilegeInfoMap = new HashMap<String, PrivilegeInfo>();
            for (int j = 0; j < privilegeInfoCount; ++j) {
                String userName = resp.getString();
                String privilegeData = resp.getString();
                PrivilegeInfo privilege = new PrivilegeInfo();
                if (privilegeData.equals(ALL_PRIVILEGE)) {
                    privilege.setRole(PrivilegeInfo.RoleType.ALL);
                }
                privilegeInfoMap.put(userName, privilege);
            }
            map.put(databaseName, new DatabaseInfo(databaseName, privilegeInfoMap));
        }
        return map;
    }

    @Override
    public void putDatabase(String name, DatabaseInfo info, boolean modifiable) throws GSException {
        GSErrorCode.checkNullParameter(info, "info", null);
        name = SubnetGridStore.resolveName(name, info.getName(), "database name");
        modifiable = false;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setDatabaseInfoRequest(req, name, (byte)0, null);
        req.putBoolean(modifiable);
        this.executeStatement(Statement.PUT_DATABASE, 0, req, resp, null);
    }

    @Override
    public void dropDatabase(String name) throws GSException {
        GSErrorCode.checkNullParameter(name, "name", null);
        DatabaseInfo info = this.getCurrentDatabase();
        if (!RowMapper.normalizeSymbolUnchecked(info.getName()).equals(RowMapper.normalizeSymbolUnchecked(name))) {
            throw new GSException(145002, "Only connected database can be dropped (connected=" + info.getName() + ", specified=" + name + ")");
        }
        SubnetPartitionController partitionController = this.getPartitionController();
        int partitionCount = partitionController.getPartitionCount();
        EnumSet<ContainerAttribute> attributeSet = EnumSet.of(ContainerAttribute.BASE, ContainerAttribute.SINGLE_SYSTEM, ContainerAttribute.SINGLE, ContainerAttribute.LARGE, ContainerAttribute.SUB);
        if (SubnetGridStore.isContainerAttributeUnified()) {
            attributeSet.remove((Object)ContainerAttribute.BASE);
        }
        ContainerKeyPredicate pred = new ContainerKeyPredicate(attributeSet);
        for (int partitionIndex = 0; partitionIndex < partitionCount; ++partitionIndex) {
            long containerCount = partitionController.getContainerCount(partitionIndex, pred, true);
            if (0L >= containerCount) continue;
            throw new GSException(145045, "Non-empty database cannot be dropped");
        }
        name = SubnetGridStore.resolveName(name, null, "database name");
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setDatabaseInfoRequest(req, name);
        this.executeStatement(Statement.DROP_DATABASE, 0, req, resp, null);
    }

    @Override
    public Map<String, DatabaseInfo> getDatabases() throws GSException {
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.OptionalRequest opt = new NodeConnection.OptionalRequest();
        opt.putAcceptableFeatureVersion(NodeConnection.FeatureVersion.V4_5);
        opt.format(req);
        boolean partitionId = false;
        req.putBoolean(false);
        req.put((byte)0);
        this.executeStatement(Statement.GET_DATABASES, 0, req, resp, null);
        Map<String, DatabaseInfo> map = this.getDatabaseInfoMap(resp);
        return map;
    }

    @Override
    public DatabaseInfo getCurrentDatabase() throws GSException {
        DatabaseInfo info;
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.OptionalRequest opt = new NodeConnection.OptionalRequest();
        opt.putAcceptableFeatureVersion(NodeConnection.FeatureVersion.V4_5);
        opt.format(req);
        boolean partitionId = false;
        String dbName = this.context.getDatabaseName();
        req.putBoolean(true);
        req.putString(dbName == null ? "" : dbName);
        req.put((byte)0);
        this.executeStatement(Statement.GET_DATABASES, 0, req, resp, null);
        Map<String, DatabaseInfo> map = this.getDatabaseInfoMap(resp);
        if (map.size() == 1) {
            info = dbName == null ? map.values().iterator().next() : map.get(dbName);
            if (info == null) {
                throw new GSConnectionException(145031, "Protocol error by illegal database name (expected=" + dbName + ")");
            }
        } else {
            throw new GSConnectionException(145031, "Protocol error by illegal database info count (expected=1, actual=" + map.size() + ")");
        }
        return info;
    }

    @Override
    public void putPrivilege(String dbName, String userName, PrivilegeInfo info) throws GSException {
        GSErrorCode.checkNullParameter(dbName, "dbName", null);
        GSErrorCode.checkNullParameter(userName, "userName", null);
        GSErrorCode.checkNullParameter(info, "info", null);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.OptionalRequest opt = new NodeConnection.OptionalRequest();
        if (info.getRole() == PrivilegeInfo.RoleType.READ) {
            opt.putFeatureVersion(NodeConnection.FeatureVersion.V4_3);
        }
        opt.format(req);
        boolean partitionId = false;
        this.setDatabaseInfoRequest(req, dbName, (byte)0, userName, info);
        this.executeStatement(Statement.PUT_PRIVILEGE, 0, req, resp, null);
    }

    @Override
    public void dropPrivilege(String dbName, String userName, PrivilegeInfo info) throws GSException {
        GSErrorCode.checkNullParameter(dbName, "dbName", null);
        GSErrorCode.checkNullParameter(userName, "userName", null);
        GSErrorCode.checkNullParameter(info, "info", null);
        BasicBuffer req = this.context.getRequestBuffer();
        BasicBuffer resp = this.context.getResponseBuffer();
        this.channel.setupRequestBuffer(req);
        NodeConnection.tryPutEmptyOptionalRequest(req);
        boolean partitionId = false;
        this.setDatabaseInfoRequest(req, dbName, (byte)0, userName, info);
        this.executeStatement(Statement.DROP_PRIVILEGE, 0, req, resp, null);
    }

    @Override
    public Experimentals.AsStore getExperimentalStore() {
        return this;
    }

    private static class MultiGetRequest<V extends RowKeyPredicate<?>>
    extends MultiOperationStatement<ContainerKeyConverter.ContainerKey, V> {
        final Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, List<Row>> multiContext;
        final List<RowKeyPredicate<?>> predicateList = new ArrayList();
        final List<SubEntry> entryList = new ArrayList<SubEntry>();
        final ContainerKeyConverter keyConverter;

        MultiGetRequest(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, List<Row>> multiContext, ContainerKeyConverter keyConverter) {
            this.multiContext = multiContext;
            this.keyConverter = keyConverter;
        }

        static <V extends RowKeyPredicate<?>> MultiOperationStatement.BasicFactory<V, List<Row>> newFactory(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, List<Row>> multiContext, ContainerKeyConverter keyConverter) {
            return new MultiOperationStatement.BasicFactory<V, List<Row>>((Extensibles.MultiOperationContext)multiContext, keyConverter){

                public MultiGetRequest<V> create() {
                    return new MultiGetRequest(this.getMultiContext(), this.getKeyConverter());
                }
            };
        }

        @Override
        void addRequestValue(ContainerKeyConverter.ContainerKey key, V value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
            SubEntry entry = new SubEntry();
            entry.containerKey = key;
            entry.predicateIndex = this.predicateList.indexOf(value);
            if (entry.predicateIndex < 0) {
                entry.predicateIndex = this.predicateList.size();
                this.predicateList.add((RowKeyPredicate<?>)value);
            }
            entry.attribute = attribute;
            entry.source = source;
            this.entryList.add(entry);
        }

        @Override
        boolean makeMainRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) throws GSException {
            if (this.entryList.isEmpty()) {
                return false;
            }
            if (SubnetGridStore.isSessionUUIDSummarized()) {
                req.putUUID(context.getSessionUUID());
            }
            SubnetGridStore.tryPutSystemOptionalRequest(req, context, internalMode, false, null);
            RowMapper.MappingMode mappingMode = SubnetContainer.getRowMappingMode();
            req.putInt(this.predicateList.size());
            for (RowKeyPredicate<?> predicate : this.predicateList) {
                RowMapper mapper = RowMapper.getInstance(predicate, ANY_MAPPER_CONFIG);
                boolean composite = mapper.getKeyCategory() == RowMapper.KeyCategory.COMPOSITE;
                mapper.exportKeySchemaSingle(req);
                java.util.Collection<?> distinctKeys = predicate.getDistinctKeys();
                Object startKey = predicate.getStart();
                Object finishKey = predicate.getFinish();
                java.util.Collection<?> keys = null;
                if (distinctKeys == null) {
                    req.putByteEnum(PredicateType.RANGE);
                    mapper.exportKeySchemaComposite(req);
                    ArrayList rangeKeys = null;
                    if (composite) {
                        rangeKeys = new ArrayList();
                    }
                    req.putBoolean(startKey != null);
                    if (startKey != null) {
                        if (composite) {
                            rangeKeys.add(startKey);
                        } else {
                            mapper.encodeKey(req, startKey, mappingMode);
                        }
                    }
                    req.putBoolean(finishKey != null);
                    if (finishKey != null) {
                        if (composite) {
                            rangeKeys.add(finishKey);
                        } else {
                            mapper.encodeKey(req, finishKey, mappingMode);
                        }
                    }
                    keys = rangeKeys;
                } else {
                    req.putByteEnum(PredicateType.DISTINCT);
                    mapper.exportKeySchemaComposite(req);
                    if (composite) {
                        keys = distinctKeys;
                    } else {
                        req.putInt(distinctKeys.size());
                        for (Object key : distinctKeys) {
                            mapper.encodeKey(req, key, mappingMode);
                        }
                    }
                }
                if (keys == null) continue;
                mapper.encodeKey(req, keys, mappingMode, true, true);
            }
            long databaseId = channel.getDatabaseId(context);
            req.putInt(this.entryList.size());
            for (SubEntry entry : this.entryList) {
                if (SubnetGridStore.isAttributeVerifiable()) {
                    SubnetGridStore.tryPutSystemOptionalRequest(req, context, false, false, entry.attribute, entry.source);
                }
                this.keyConverter.put(entry.containerKey, databaseId, req);
                req.putInt(entry.predicateIndex);
            }
            return true;
        }

        @Override
        void acceptMainResponse(BasicBuffer resp, Object targetConnection) throws GSException {
            int headCount = resp.base().getInt();
            ArrayList<RowMapper> mapperList = new ArrayList<RowMapper>();
            for (int i = 0; i < headCount; ++i) {
                ContainerType containerType = resp.getByteEnum(ContainerType.class);
                mapperList.add(RowMapper.getInstance(resp, containerType, SubnetGridStore.getRowMapperConfig()));
            }
            ArrayList<Row> rowList = new ArrayList<Row>();
            int bodyCount = resp.base().getInt();
            for (int i = 0; i < bodyCount; ++i) {
                ContainerKeyConverter.ContainerKey containerKey = this.keyConverter.get(resp, false, true);
                int mapperIndex = resp.base().getInt();
                RowMapper mapper = (RowMapper)mapperList.get(mapperIndex);
                boolean rowIdIncluded = !mapper.isForTimeSeries();
                int rowCount = (int)resp.base().getLong();
                RowMapper.Cursor cursor = mapper.createCursor(resp, SubnetContainer.getRowMappingMode(), rowCount, rowIdIncluded, RowMapper.getDirectBlobFactory());
                for (int j = 0; j < rowCount; ++j) {
                    rowList.add((Row)mapper.decode(cursor));
                }
                this.multiContext.acceptCompletion(containerKey, rowList);
                rowList.clear();
            }
        }

        private static class SubEntry {
            ContainerKeyConverter.ContainerKey containerKey;
            Integer attribute;
            NodeConnection.OptionalRequestSource source;
            int predicateIndex;

            private SubEntry() {
            }
        }
    }

    private static enum PredicateType {
        RANGE,
        DISTINCT;

    }

    private static class MultiPutStatement
    extends MultiOperationStatement<ContainerKeyConverter.ContainerKey, List<Row>> {
        final List<RowMapper> mapperList = new ArrayList<RowMapper>();
        final List<ContainerKeyConverter.ContainerKey> containerKeyList = new ArrayList<ContainerKeyConverter.ContainerKey>();
        final Map<ContainerKeyConverter.ContainerKey, SubEntry> subEntryMap = new HashMap<ContainerKeyConverter.ContainerKey, SubEntry>();
        UUID sessionUUID;

        private MultiPutStatement() {
        }

        static MultiOperationStatement.BasicFactory<List<Row>, Void> newFactory(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, List<Row>, Void> multiContext) {
            return new MultiOperationStatement.BasicFactory<List<Row>, Void>(multiContext, null){

                public MultiPutStatement create() {
                    return new MultiPutStatement();
                }
            };
        }

        @Override
        void addRequestValue(ContainerKeyConverter.ContainerKey key, List<Row> value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
            if (value.isEmpty()) {
                return;
            }
            ContainerKeyConverter.ContainerKey normalizedKey = key.toCaseSensitive(false);
            SubEntry entry = this.subEntryMap.get(normalizedKey);
            RowMapper mapper = null;
            for (Row row : value) {
                if (mapper == null) {
                    Row lastRow = entry == null ? row : entry.rowList.get(0);
                    mapper = RowMapper.getInstance(lastRow, SubnetGridStore.getRowMapperConfig());
                    continue;
                }
                mapper.checkSchemaMatched(RowMapper.getInstance(row, SubnetGridStore.getRowMapperConfig()));
            }
            if (entry == null) {
                entry = new SubEntry();
                entry.rowList = value;
                entry.attribute = attribute;
                this.subEntryMap.put(normalizedKey, entry);
                this.containerKeyList.add(normalizedKey);
                entry.mapperIndex = this.indexOf(mapper);
                if (entry.mapperIndex < 0) {
                    entry.mapperIndex = this.mapperList.size();
                    this.mapperList.add(mapper);
                }
            } else {
                if (!entry.listMerged) {
                    entry.rowList = new ArrayList<Row>(entry.rowList);
                    entry.listMerged = true;
                }
                entry.rowList.addAll(value);
            }
        }

        @Override
        boolean makeCreateSessionRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) throws GSException {
            this.sessionUUID = context.getSessionUUID();
            if (this.containerKeyList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutSystemOptionalRequest(req, context, internalMode, false, null);
            ContainerKeyConverter keyConverter = context.getKeyConverter(internalMode, true);
            long databaseId = channel.getDatabaseId(context);
            boolean withId = false;
            req.putBoolean(withId);
            req.putInt(this.containerKeyList.size());
            for (ContainerKeyConverter.ContainerKey containerKey : this.containerKeyList) {
                SubEntry entry;
                if (SubnetGridStore.isAttributeVerifiable()) {
                    entry = this.subEntryMap.get(containerKey);
                    SubnetGridStore.tryPutSystemOptionalRequest(req, context, false, false, entry.attribute);
                }
                keyConverter.put(containerKey, databaseId, req);
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    entry = this.subEntryMap.get(containerKey);
                    entry.sessionId = context.generateSessionId();
                    req.putLong(entry.sessionId);
                    continue;
                }
                SubnetContainer.putNewSessionProperties(req, channel, context);
            }
            return true;
        }

        @Override
        void acceptCreateSessionResponse(BasicBuffer resp) throws GSException {
            int sessionCount = resp.base().getInt();
            if (this.subEntryMap.size() != sessionCount) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent session count");
            }
            for (ContainerKeyConverter.ContainerKey containerKey : this.containerKeyList) {
                SubEntry entry = this.subEntryMap.get(containerKey);
                entry.containerId = resp.base().getLong();
                if (SubnetContainer.isSessionIdGeneratorEnabled()) continue;
                entry.sessionId = resp.base().getLong();
                if (entry.sessionId != 0L) continue;
                throw new GSConnectionException(145031, "Protocol error by empty session ID");
            }
        }

        @Override
        boolean makeMainRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) throws GSException {
            if (this.containerKeyList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context, null);
            req.putInt(this.mapperList.size());
            for (RowMapper mapper : this.mapperList) {
                req.putByteEnum(mapper.isForTimeSeries() ? ContainerType.TIME_SERIES : ContainerType.COLLECTION);
                mapper.exportSchema(req, SubnetGridStore.getRowMapperConfig());
            }
            req.putInt(this.containerKeyList.size());
            for (ContainerKeyConverter.ContainerKey containerKey : this.containerKeyList) {
                SubEntry entry = this.subEntryMap.get(containerKey);
                NodeConnection.putStatementId(req, 1L);
                req.putLong(entry.containerId);
                req.putLong(entry.sessionId);
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    req.putByteEnum(SubnetContainer.SessionMode.GET);
                    req.putByteEnum(SubnetContainer.TransactionMode.AUTO);
                }
                SubnetGridStore.tryPutSystemOptionalRequest(req, context, false, false, entry.attribute);
                req.putInt(entry.mapperIndex);
                int listBytesSize = 0;
                req.putInt(listBytesSize);
                int listStartPos = req.base().position();
                req.putLong(entry.rowList.size());
                RowMapper mapper = this.mapperList.get(entry.mapperIndex);
                RowMapper.Cursor cursor = mapper.createCursor(req, SubnetContainer.getRowMappingMode(), entry.rowList.size(), false, null);
                for (Row row : entry.rowList) {
                    mapper.encode(cursor, null, row);
                }
                int listEndPos = req.base().position();
                req.base().position(listStartPos - 4);
                req.putInt(listEndPos - listStartPos);
                req.base().position(listEndPos);
            }
            return true;
        }

        @Override
        void acceptMainResponse(BasicBuffer resp, Object targetConnection) {
        }

        @Override
        boolean makeCloseSessionRequest(BasicBuffer req, GridStoreChannel.Context context) {
            if (this.containerKeyList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context, null);
            req.putInt(this.containerKeyList.size());
            for (ContainerKeyConverter.ContainerKey containerKey : this.containerKeyList) {
                SubEntry entry = this.subEntryMap.get(containerKey);
                NodeConnection.putStatementId(req, 2L);
                req.putLong(entry.containerId);
                req.putLong(entry.sessionId);
                if (summarized) continue;
                req.putUUID(this.sessionUUID);
            }
            return true;
        }

        @Override
        void acceptSessionClosed() {
        }

        @Override
        boolean acceptStatementErrorForSession(GSStatementException cause) throws GSException {
            return SubnetContainer.isInitialSessionLost(Statement.CREATE_MULTIPLE_SESSIONS, 1L, false, cause);
        }

        @Override
        <R> void repairOperation(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, ?, R> multiContext) throws GSException {
            for (ContainerKeyConverter.ContainerKey key : this.subEntryMap.keySet()) {
                multiContext.acceptCompletion(key, null);
            }
        }

        int indexOf(RowMapper mapper) {
            for (int i = 0; i < this.mapperList.size(); ++i) {
                if (this.mapperList.get(i) != mapper) continue;
                return i;
            }
            return -1;
        }

        private static class SubEntry {
            List<Row> rowList;
            int mapperIndex;
            long containerId;
            long sessionId;
            boolean listMerged;
            Integer attribute;

            private SubEntry() {
            }
        }
    }

    private static class MultiQueryStatement
    extends MultiOperationStatement<Integer, SubnetQuery<?>> {
        private final Extensibles.MultiOperationContext<Integer, ?, Query<?>> multiContext;
        private final List<Integer> keyList = new ArrayList<Integer>();
        private final List<SubnetQuery<?>> queryList = new ArrayList();
        private List<SubnetQuery<?>> optionalQueryList;
        boolean updateQueryFound;
        UUID sessionUUID;

        private MultiQueryStatement(Extensibles.MultiOperationContext<Integer, ?, Query<?>> multiContext) {
            this.multiContext = multiContext;
        }

        static <V extends Query<?>> MultiQueryFactory<V> newFactory(Extensibles.MultiOperationContext<Integer, V, Query<?>> multiContext, SubnetGridStore store) {
            return new MultiQueryFactory<V>(multiContext, store);
        }

        static SubnetQuery<?> check(Query<?> query, SubnetGridStore store) throws GSException {
            SubnetQuery subnetQuery;
            Query<Object> baseQuery;
            if (!(query instanceof SubnetQuery)) {
                if (query == null) {
                    throw new GSException(145001, "Empty query object");
                }
                if (!(query instanceof Extensibles.AsQuery) || !((baseQuery = ((Extensibles.AsQuery)query).getBaseQuery()) instanceof SubnetQuery)) {
                    throw new GSException(145002, "Query type not matched (class=" + query.getClass() + ")");
                }
            } else {
                baseQuery = query;
            }
            if (((SubnetContainer)(subnetQuery = (SubnetQuery)baseQuery).getContainer()).getStore() != store) {
                throw new GSException(145002, "Derived GridStore instance not matched");
            }
            return subnetQuery;
        }

        @Override
        void addRequestValue(Integer key, SubnetQuery<?> value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
            ((SubnetContainer)value.getContainer()).clearBlob(false);
            this.updateQueryFound |= value.isForUpdate();
            this.keyList.add(key);
            this.queryList.add(value);
        }

        @Override
        boolean makeCreateSessionRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) throws GSException {
            this.sessionUUID = context.getSessionUUID();
            if (!this.updateQueryFound || this.queryList.isEmpty()) {
                return false;
            }
            if (this.optionalQueryList == null) {
                this.optionalQueryList = new ArrayList();
            }
            this.optionalQueryList.clear();
            for (SubnetQuery<?> query : this.queryList) {
                if (!query.isForUpdate() || ((SubnetContainer)query.getContainer()).getSessionIdDirect() != 0L) continue;
                this.optionalQueryList.add(query);
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context, null);
            boolean withId = true;
            req.putBoolean(withId);
            req.putInt(this.optionalQueryList.size());
            for (SubnetQuery<?> query : this.optionalQueryList) {
                Extensibles.AsContainer container = query.getContainer();
                req.putLong(((SubnetContainer)container).getContainerId());
                if (!summarized) {
                    req.putUUID(this.sessionUUID);
                }
                if (SubnetContainer.isSessionIdGeneratorEnabled()) {
                    long sessionId = context.generateSessionId();
                    ((SubnetContainer)container).setSessionIdDirect(sessionId, false);
                    req.putLong(sessionId);
                    continue;
                }
                SubnetContainer.putNewSessionProperties(req, channel, context);
            }
            return true;
        }

        @Override
        void acceptCreateSessionResponse(BasicBuffer resp) throws GSException {
            int sessionCount = resp.base().getInt();
            if (this.optionalQueryList.size() != sessionCount) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent session count");
            }
            if (!SubnetContainer.isSessionIdGeneratorEnabled()) {
                for (int i = 0; i < sessionCount; ++i) {
                    Extensibles.AsContainer container = this.optionalQueryList.get(i).getContainer();
                    long containerId = resp.base().getLong();
                    if (containerId != ((SubnetContainer)container).getContainerId()) {
                        throw new GSConnectionException(145031, "Protocol error by inconsistent container ID");
                    }
                    long sessionId = resp.base().getLong();
                    if (sessionId == 0L) {
                        throw new GSConnectionException(145031, "Protocol error by empty session ID");
                    }
                    ((SubnetContainer)container).setSessionIdDirect(sessionId, true);
                }
            }
            this.optionalQueryList.clear();
        }

        @Override
        boolean makeMainRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) throws GSException {
            if (this.queryList.isEmpty()) {
                return false;
            }
            boolean summarized = SubnetGridStore.isSessionUUIDSummarized();
            if (summarized) {
                req.putUUID(this.sessionUUID);
            }
            SubnetGridStore.tryPutDatabaseOptionalRequest(req, context, context.bindQueryOptions(null));
            req.putInt(this.queryList.size());
            for (SubnetQuery<?> query : this.queryList) {
                Extensibles.AsContainer container = query.getContainer();
                long statementId = ((SubnetContainer)container).isAutoCommit() || ((SubnetContainer)container).getSessionIdDirect() == 0L ? 0L : ((SubnetContainer)container).updateStatementIdDirect();
                req.putInt(GridStoreChannel.statementToNumber(query.getStatement()));
                NodeConnection.putStatementId(req, statementId);
                query.makeRequest(req, summarized);
            }
            return true;
        }

        @Override
        void acceptMainResponse(BasicBuffer resp, Object targetConnection) throws GSException {
            int count = resp.base().getInt();
            if (this.queryList.size() != count) {
                throw new GSConnectionException(145031, "Protocol error by inconsistent query count");
            }
            int totalEndPos = resp.base().limit();
            for (int i = 0; i < count; ++i) {
                int size = (int)BasicBuffer.BufferUtils.getLongSize(resp.base());
                BasicBuffer.BufferUtils.limitForward(resp.base(), size);
                SubnetQuery<?> query = this.queryList.get(i);
                query.acceptResponse(resp, targetConnection, false);
                this.multiContext.acceptCompletion(this.keyList.get(i), query);
                BasicBuffer.BufferUtils.restoreLimit(resp.base(), totalEndPos);
            }
        }

        @Override
        boolean makeCloseSessionRequest(BasicBuffer req, GridStoreChannel.Context context) throws GSException {
            return false;
        }

        @Override
        void acceptSessionClosed() throws GSException {
        }

        @Override
        boolean acceptStatementErrorForSession(GSStatementException cause) throws GSException {
            if (!this.updateQueryFound) {
                return false;
            }
            boolean initialSessionLost = false;
            for (SubnetQuery<?> query : this.queryList) {
                Extensibles.AsContainer container = query.getContainer();
                if (SubnetCollection.isInitialSessionLost(Statement.EXECUTE_MULTIPLE_QUERIES, ((SubnetContainer)container).getStatementIdDirect(), ((SubnetContainer)container).isTransactionStarted(), cause)) {
                    initialSessionLost = true;
                    ((SubnetContainer)container).setSessionIdDirect(0L, true);
                    continue;
                }
                ((SubnetContainer)container).disableCache();
            }
            return initialSessionLost;
        }

        static class MultiQueryFactory<V extends Query<?>>
        extends MultiOperationStatement.Factory<Integer, SubnetQuery<?>, V, Query<?>> {
            private final SubnetGridStore store;

            MultiQueryFactory(Extensibles.MultiOperationContext<Integer, V, Query<?>> multiContext, SubnetGridStore store) {
                super(multiContext, null);
                this.store = store;
            }

            MultiQueryStatement create() {
                return new MultiQueryStatement(this.getMultiContext());
            }

            @Override
            Extensibles.MultiTargetConsumer<Integer, V> createConsumer(final Map<Integer, MultiOperationStatement<Integer, SubnetQuery<?>>> requestMap, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) {
                return new Extensibles.MultiTargetConsumer<Integer, V>(){

                    @Override
                    public void consume(Integer key, V value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
                        SubnetQuery<?> query = MultiQueryStatement.check(value, MultiQueryFactory.this.store);
                        int partitionId = ((SubnetContainer)query.getContainer()).getPartitionId();
                        MultiQueryFactory.this.resolveMultiStatement(requestMap, partitionId).addRequestValue(key, query, attribute, source);
                    }
                };
            }
        }
    }

    private static abstract class MultiOperationStatement<K, T> {
        private MultiOperationStatement() {
        }

        abstract void addRequestValue(K var1, T var2, Integer var3, NodeConnection.OptionalRequestSource var4) throws GSException;

        boolean makeCreateSessionRequest(BasicBuffer req, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) throws GSException {
            return false;
        }

        void acceptCreateSessionResponse(BasicBuffer resp) throws GSException {
        }

        abstract boolean makeMainRequest(BasicBuffer var1, GridStoreChannel var2, GridStoreChannel.Context var3, boolean var4) throws GSException;

        abstract void acceptMainResponse(BasicBuffer var1, Object var2) throws GSException;

        boolean makeCloseSessionRequest(BasicBuffer req, GridStoreChannel.Context context) throws GSException {
            return false;
        }

        void acceptSessionClosed() throws GSException {
        }

        boolean acceptStatementErrorForSession(GSStatementException cause) throws GSException {
            return false;
        }

        <R> void repairOperation(Extensibles.MultiOperationContext<K, ?, R> multiContext) throws GSException {
        }

        static class BasicConsumer<V, R>
        implements Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> {
            private final BasicFactory<V, R> factory;
            private final Map<Integer, MultiOperationStatement<ContainerKeyConverter.ContainerKey, V>> requestMap;
            private final GridStoreChannel channel;
            private final GridStoreChannel.Context context;
            private final boolean internalMode;

            private BasicConsumer(BasicFactory<V, R> factory, Map<Integer, MultiOperationStatement<ContainerKeyConverter.ContainerKey, V>> requestMap, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) {
                this.factory = factory;
                this.requestMap = requestMap;
                this.channel = channel;
                this.context = context;
                this.internalMode = internalMode;
            }

            @Override
            public void consume(ContainerKeyConverter.ContainerKey key, V value, Integer attribute, NodeConnection.OptionalRequestSource source) throws GSException {
                int partitionId = this.channel.resolvePartitionId(this.context, key, this.internalMode);
                MultiOperationStatement<ContainerKeyConverter.ContainerKey, V> multiStatement = this.factory.resolveMultiStatement(this.requestMap, partitionId);
                multiStatement.addRequestValue(key, value, attribute, source);
            }
        }

        static abstract class BasicFactory<V, R>
        extends Factory<ContainerKeyConverter.ContainerKey, V, V, R> {
            private BasicFactory(Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, R> multiContext, ContainerKeyConverter keyConverter) {
                super(multiContext, keyConverter);
            }

            @Override
            Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> createConsumer(Map<Integer, MultiOperationStatement<ContainerKeyConverter.ContainerKey, V>> requestMap, GridStoreChannel channel, GridStoreChannel.Context context, boolean internalMode) {
                return new BasicConsumer(this, requestMap, channel, context, internalMode);
            }
        }

        static abstract class Factory<K, T, V, R> {
            private final Extensibles.MultiOperationContext<K, V, R> multiContext;
            private final ContainerKeyConverter keyConverter;

            Factory(Extensibles.MultiOperationContext<K, V, R> multiContext, ContainerKeyConverter keyConverter) {
                this.multiContext = multiContext;
                this.keyConverter = keyConverter;
            }

            abstract MultiOperationStatement<K, T> create();

            MultiOperationStatement<K, T> resolveMultiStatement(Map<Integer, MultiOperationStatement<K, T>> requestMap, int partitionId) {
                MultiOperationStatement<K, T> multiStatement = requestMap.get(partitionId);
                if (multiStatement == null) {
                    multiStatement = this.create();
                    requestMap.put(partitionId, multiStatement);
                }
                return multiStatement;
            }

            Extensibles.MultiOperationContext<K, V, R> getMultiContext() {
                return this.multiContext;
            }

            ContainerKeyConverter getKeyConverter() {
                return this.keyConverter;
            }

            abstract Extensibles.MultiTargetConsumer<K, V> createConsumer(Map<Integer, MultiOperationStatement<K, T>> var1, GridStoreChannel var2, GridStoreChannel.Context var3, boolean var4);
        }
    }

    private static class ListingMultiOperationContext<V, E>
    extends NamedMultiOperationContext<V, List<E>> {
        private final Map<String, List<E>> resultMap = new HashMap<String, List<E>>();

        public ListingMultiOperationContext(Map<String, V> targetMap, ContainerKeyConverter keyConverter) {
            super(targetMap, keyConverter);
        }

        @Override
        public void acceptCompletion(ContainerKeyConverter.ContainerKey containerKey, List<E> result) {
            String name = containerKey.toString();
            List<E> list = this.resultMap.get(name);
            if (list == null) {
                list = new ArrayList();
                this.resultMap.put(name, list);
            }
            list.addAll(result);
        }

        public Map<String, List<E>> getAllResult() {
            return this.resultMap;
        }

        public static <V, E> ListingMultiOperationContext<V, E> create(Map<String, V> targetMap, ContainerKeyConverter keyConverter) {
            return new ListingMultiOperationContext<V, E>(targetMap, keyConverter);
        }
    }

    private static class NamedMultiOperationContext<V, R>
    implements Extensibles.MultiOperationContext<ContainerKeyConverter.ContainerKey, V, R> {
        private final Map<String, V> targetMap;
        private final ContainerKeyConverter keyConverter;

        public NamedMultiOperationContext(Map<String, V> targetMap, ContainerKeyConverter keyConverter) {
            this.targetMap = targetMap;
            this.keyConverter = keyConverter;
        }

        @Override
        public void listTarget(Extensibles.MultiTargetConsumer<ContainerKeyConverter.ContainerKey, V> consumer) throws GSException {
            for (Map.Entry<String, V> entry : this.targetMap.entrySet()) {
                consumer.consume(this.keyConverter.parse(entry.getKey(), false), entry.getValue(), null, null);
            }
        }

        @Override
        public boolean acceptException(GSException exception) {
            return false;
        }

        @Override
        public void acceptCompletion(ContainerKeyConverter.ContainerKey key, R result) {
        }

        @Override
        public boolean isRemaining() throws GSException {
            return false;
        }
    }

    private static class UnnamedMultiOperationContext<K, V, R>
    implements Extensibles.MultiOperationContext<K, V, R> {
        private final Iterable<? extends V> iterable;

        private UnnamedMultiOperationContext(Iterable<? extends V> iterable) {
            this.iterable = iterable;
        }

        @Override
        public void listTarget(Extensibles.MultiTargetConsumer<K, V> consumer) throws GSException {
            for (V value : this.iterable) {
                consumer.consume(null, value, null, null);
            }
        }

        @Override
        public boolean acceptException(GSException exception) throws GSException {
            return false;
        }

        @Override
        public void acceptCompletion(K key, R result) throws GSException {
        }

        @Override
        public boolean isRemaining() throws GSException {
            return false;
        }
    }

    private static class ContainerPropertyKeysConstants {
        static final ContainerProperties.KeySet DEFAULT = ContainerPropertyKeysConstants.create(new ContainerProperties.Key[0]);
        static final ContainerProperties.KeySet COMPATIBLE_TRIGGER = ContainerPropertyKeysConstants.create(ContainerProperties.Key.TRIGGER, ContainerProperties.Key.INDEX_DETAIL);
        static final ContainerProperties.KeySet COMPATIBLE_INDEX = ContainerPropertyKeysConstants.create(ContainerProperties.Key.INDEX_DETAIL);
        static final ContainerProperties.KeySet FOR_OBJECT = new ContainerProperties.KeySet(EnumSet.of(ContainerProperties.Key.ID, ContainerProperties.Key.SCHEMA, ContainerProperties.Key.ATTRIBUTE), new Integer[0]);

        private ContainerPropertyKeysConstants() {
        }

        private static ContainerProperties.KeySet create(ContainerProperties.Key ... exclusiveKeys) {
            EnumSet<ContainerProperties.Key> keySet = EnumSet.allOf(ContainerProperties.Key.class);
            for (ContainerProperties.Key key : exclusiveKeys) {
                keySet.remove((Object)key);
            }
            return new ContainerProperties.KeySet(keySet, new Integer[0]);
        }

        private static ContainerProperties.KeySet resolveDefault() {
            if (SubnetGridStore.isIndexDetailEnabled()) {
                return DEFAULT;
            }
            if (NodeConnection.getProtocolVersion() < 2 || GridStoreChannel.v1ProtocolCompatible_1_1_103x) {
                return COMPATIBLE_TRIGGER;
            }
            return COMPATIBLE_INDEX;
        }
    }

    private static class CacheReference
    extends GridStoreChannel.RemoteReference<SubnetGridStore> {
        public CacheReference(SubnetGridStore target, GridStoreChannel.Context context) {
            super(target, SubnetGridStore.class, context, 0, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(GridStoreChannel channel, GridStoreChannel.Context context) throws GSException {
            GridStoreChannel.Context context2 = context;
            synchronized (context2) {
                GridStoreChannel.ContainerCache cache = context.getContainerCache();
                if (cache != null) {
                    BasicBuffer req = context.getSynchronizedRequestBuffer();
                    BasicBuffer resp = context.getSynchronizedResponseBuffer();
                    SubnetContainer.closeAllSessions(channel, context, req, resp, cache.takeAllSessions(context));
                }
            }
        }
    }

    public static abstract class NamedContainerMap<C extends Container<?, ?>> {
        private final Map<ContainerKeyConverter.ContainerKey, List<WeakReference<C>>> base = new HashMap<ContainerKeyConverter.ContainerKey, List<WeakReference<C>>>();

        public synchronized C get(ContainerKeyConverter.ContainerKey key, Class<?> rowType) throws GSException {
            List<WeakReference<C>> list = this.base.get(key.toCaseSensitive(false));
            if (list != null) {
                do {
                    for (WeakReference<C> containerRef : list) {
                        Container container = (Container)containerRef.get();
                        if (container == null || rowType != null && rowType != this.getRowType(container)) continue;
                        return (C)container;
                    }
                } while ((rowType = rowType.getSuperclass()) != null);
            }
            return null;
        }

        public synchronized void add(ContainerKeyConverter.ContainerKey normalizedKey, C container) {
            List<WeakReference<C>> list = this.base.get(normalizedKey);
            if (list == null) {
                list = new LinkedList<WeakReference<C>>();
                this.base.put(normalizedKey, list);
            }
            list.add(new WeakReference<C>(container));
        }

        public synchronized void remove(ContainerKeyConverter.ContainerKey normalizedKey, C container) {
            List<WeakReference<C>> list = this.base.get(normalizedKey);
            if (list == null) {
                return;
            }
            Iterator<WeakReference<C>> it = list.iterator();
            while (it.hasNext()) {
                Container candidate = (Container)it.next().get();
                if (candidate != null && candidate != container) continue;
                it.remove();
            }
            if (list.isEmpty()) {
                this.base.remove(normalizedKey);
            }
        }

        protected abstract Class<?> getRowType(C var1);
    }
}

