/*
 * Decompiled with CFR 0.152.
 */
package com.toshiba.mwcloud.gs.subnet;

import com.toshiba.mwcloud.gs.GSException;
import com.toshiba.mwcloud.gs.GridStore;
import com.toshiba.mwcloud.gs.GridStoreFactory;
import com.toshiba.mwcloud.gs.common.Extensibles;
import com.toshiba.mwcloud.gs.common.GSErrorCode;
import com.toshiba.mwcloud.gs.common.GridStoreFactoryProvider;
import com.toshiba.mwcloud.gs.common.LoggingUtils;
import com.toshiba.mwcloud.gs.common.PropertyUtils;
import com.toshiba.mwcloud.gs.subnet.GridStoreChannel;
import com.toshiba.mwcloud.gs.subnet.NodeConnection;
import com.toshiba.mwcloud.gs.subnet.SubnetGridStore;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SubnetGridStoreFactory
extends GridStoreFactory {
    private Map<GridStoreChannel.Key, GridStoreChannel> channelMap = new HashMap<GridStoreChannel.Key, GridStoreChannel>();
    private final GridStoreChannel.Config channelConfig = new GridStoreChannel.Config();

    public SubnetGridStoreFactory() {
        this(true);
    }

    public SubnetGridStoreFactory(Set<Class<?>> chainProviderClasses) {
        this(!SubnetGridStoreFactory.isConfigurableProviderChained(chainProviderClasses));
    }

    private SubnetGridStoreFactory(boolean configured) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SubnetGridStoreFactory.this.close();
                }
                catch (GSException gSException) {
                    // empty catch block
                }
            }
        }));
        ConfigUtils.checkNewFactory(configured);
    }

    private static boolean isConfigurableProviderChained(Set<Class<?>> chainProviderClasses) {
        for (Class<?> c : chainProviderClasses) {
            if (!Extensibles.ConfigProvidable.class.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized SubnetGridStore getGridStore(Properties properties) throws GSException {
        if (this.channelMap == null) {
            throw new GSException(145040, "Already closed");
        }
        GSErrorCode.checkNullParameter(properties, "properties", null);
        PropertyUtils.WrappedProperties wrapped = new PropertyUtils.WrappedProperties(properties);
        GridStoreChannel.Source source = new GridStoreChannel.Source(wrapped, this.channelConfig);
        ConfigUtils.checkProperties(wrapped, "store");
        GridStoreChannel channel = this.channelMap.get(source.getKey());
        if (channel == null) {
            channel = new GridStoreChannel(this.channelConfig, source);
            this.channelMap.put(source.getKey(), channel);
        } else {
            channel.apply(this.channelConfig);
        }
        SubnetGridStore store = new SubnetGridStore(channel, source.createContext());
        return store;
    }

    @Override
    public synchronized void setProperties(Properties properties) throws GSException {
        String pathKeyOptionStr;
        String transactionProtocolVersionStr;
        if (this.channelMap == null) {
            throw new GSException(145040, "Already closed");
        }
        if (properties == null) {
            throw GSErrorCode.checkNullParameter(properties, "properties", null);
        }
        PropertyUtils.WrappedProperties wrapped = new PropertyUtils.WrappedProperties(properties);
        String messageOptionStr = wrapped.getProperty("detailErrorMessageEnabled", true);
        if (messageOptionStr != null) {
            NodeConnection.setDetailErrorMessageEnabled(Boolean.parseBoolean(messageOptionStr));
        }
        if ((transactionProtocolVersionStr = wrapped.getProperty("transactionProtocolVersion", true)) != null) {
            NodeConnection.setProtocolVersion(Integer.parseInt(transactionProtocolVersionStr));
        }
        if ((pathKeyOptionStr = wrapped.getProperty("pathKeyOperationEnabled", true)) != null) {
            SubnetGridStore.setPathKeyOperationEnabled(Boolean.parseBoolean(pathKeyOptionStr));
        }
        if (this.channelConfig.set(wrapped)) {
            for (GridStoreChannel channel : this.channelMap.values()) {
                channel.apply(this.channelConfig);
            }
        }
        ConfigUtils.checkProperties(wrapped, "factory");
    }

    @Override
    public synchronized void close() throws GSException {
        if (this.channelMap == null) {
            return;
        }
        try {
            this.closeResources(this.channelMap.values(), false);
        }
        finally {
            this.channelMap = null;
        }
    }

    private <T extends Closeable> void closeResources(Iterable<T> iterable, boolean silent) throws GSException {
        try {
            Iterator<T> it = iterable.iterator();
            while (it.hasNext()) {
                Closeable resource = (Closeable)it.next();
                if (silent) {
                    try {
                        resource.close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    resource.close();
                }
                it.remove();
            }
        }
        catch (IOException e) {
            throw new GSException(e);
        }
        finally {
            if (!silent) {
                this.closeResources(iterable, true);
            }
        }
    }

    private void setTransportProvider(Extensibles.TransportProvider provider) {
        this.channelConfig.setTransportProvider(provider);
    }

    private static class ConfigUtils {
        private static final String CONFIG_FILE_NAME = "gs_client.properties";
        private static final LoggingUtils.BaseGridStoreLogger LOGGER = LoggingUtils.getLogger("Config");

        private ConfigUtils() {
        }

        static void checkNewFactory(boolean configured) {
            if (configured) {
                try {
                    ArrayList<URL> urlList = Collections.list(ConfigUtils.class.getClassLoader().getResources(CONFIG_FILE_NAME));
                    if (!urlList.isEmpty()) {
                        LOGGER.warn("config.unexpectedConfigFile", urlList);
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
                LOGGER.debug("config.notLoaded", new Object[0]);
            }
        }

        static void checkProperties(PropertyUtils.WrappedProperties props, String type) {
            Set<String> names = props.getUnknownNames();
            if (!names.isEmpty()) {
                LOGGER.warn("config.unknownProperty", type, names);
            }
            if (!(names = props.getDeprecatedNames()).isEmpty()) {
                LOGGER.warn("config.deprecatedProperty", type, names);
            }
        }

        static GSException loadConfig(GridStoreFactory factory, Properties storeProperties) {
            Properties factoryProperties = new Properties();
            GSException lastException = null;
            try {
                URL url = ConfigUtils.loadConfig(factoryProperties, storeProperties);
                factory.setProperties(factoryProperties);
                LOGGER.debug("config.loaded", url);
            }
            catch (GSException e) {
                lastException = e;
            }
            catch (IOException e) {
                lastException = new GSException(e);
            }
            if (lastException != null) {
                LOGGER.debug("config.loadFailed", lastException);
            }
            return lastException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static URL loadConfig(Properties factoryProperties, Properties storeProperties) throws IOException {
            ArrayList<URL> urlList = Collections.list(ConfigUtils.class.getClassLoader().getResources(CONFIG_FILE_NAME));
            if (urlList.isEmpty()) {
                throw new GSException(145044, "Config file not found in classpath (fileName=gs_client.properties)");
            }
            if (urlList.size() != 1) {
                throw new GSException(145044, "Multiple config files found in classpath (urlList=" + urlList + ")");
            }
            URL url = (URL)urlList.get(0);
            Properties properties = new Properties();
            InputStream in = url.openStream();
            try {
                properties.load(in);
            }
            finally {
                in.close();
            }
            for (String key : properties.stringPropertyNames()) {
                Properties target;
                if (key.startsWith("store.")) {
                    target = storeProperties;
                } else if (key.startsWith("factory.")) {
                    target = factoryProperties;
                } else {
                    throw new GSException(145044, "Illegal property key (key=" + key + ", url=" + url);
                }
                String subKey = key.substring(key.indexOf(".") + 1);
                if (subKey.isEmpty()) {
                    throw new GSException(145044, "Illegal property key (key=" + key + ", url=" + url);
                }
                target.setProperty(subKey, properties.getProperty(key));
            }
            return url;
        }
    }

    public static class ConfigurableFactory
    extends GridStoreFactory {
        private final GridStoreFactory base;
        private final Properties storeProperties = new Properties();
        private final GSException lastException;

        public ConfigurableFactory(Set<Class<?>> chainProviderClasses, Set<Class<?>> visitedProviderClasses) {
            GridStoreFactoryProvider.ChainProvidable provider = GridStoreFactoryProvider.getProvider(GridStoreFactoryProvider.ChainProvidable.class, ConfigurableFactory.class, chainProviderClasses);
            this.base = provider.getFactory(chainProviderClasses, visitedProviderClasses);
            this.lastException = ConfigUtils.loadConfig(this.base, this.storeProperties);
        }

        @Override
        public GridStore getGridStore(Properties properties) throws GSException {
            this.checkConfig();
            Properties mergedProperties = new Properties();
            mergedProperties.putAll((Map<?, ?>)this.storeProperties);
            mergedProperties.putAll((Map<?, ?>)properties);
            return this.base.getGridStore(mergedProperties);
        }

        @Override
        public void setProperties(Properties properties) throws GSException {
            this.checkConfig();
            this.base.setProperties(properties);
        }

        @Override
        public void close() throws GSException {
            this.base.close();
        }

        private void checkConfig() throws GSException {
            if (this.lastException != null) {
                throw new GSException(this.lastException);
            }
        }
    }

    public static interface ConfigProvidable
    extends Extensibles.ConfigProvidable {
    }

    public static class ExtensibleFactory
    extends Extensibles.AsStoreFactory {
        private static final String ACCEPTABLE_VERSION = "8";
        private final SubnetGridStoreFactory base;

        public ExtensibleFactory(Set<Class<?>> chainProviderClasses) {
            this.base = new SubnetGridStoreFactory(chainProviderClasses);
        }

        @Override
        public Extensibles.AsStore getExtensibleStore(Properties properties, Properties extProperties) throws GSException {
            String version = extProperties.getProperty("version", "");
            if (!version.equals(ACCEPTABLE_VERSION)) {
                throw new GSException(145044, "Library version unmatched (required=" + version + ", acceptable=" + ACCEPTABLE_VERSION + ")");
            }
            return this.base.getGridStore(properties);
        }

        @Override
        public GridStoreFactory getBaseFactory() {
            return this.base;
        }

        @Override
        public void setTransportProvider(Extensibles.TransportProvider provider) {
            this.base.setTransportProvider(provider);
        }
    }
}

