/*******************************************************************************
 * Copyright (c) 2007 JCraft, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     JCraft, Inc. - initial API and implementation
 *******************************************************************************/

package com.jcraft.eclipse.jsch.ui;

import java.net.URL;
import java.util.Hashtable;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.jcraft.eclipse.jsch.core.IUserAuthenticator;
import com.jcraft.eclipse.jsch.ui.internal.authenticator.WorkbenchUserAuthenticator;

public class JSchUIPlugin extends AbstractUIPlugin{
  public static final String ID="com.jcraft.eclipse.jsch.ui"; //$NON-NLS-1$
  public static final String DECORATOR_ID="com.jcraft.eclipse.jsch.ui.decorator"; //$NON-NLS-1$

  private static Hashtable imageDescriptors=new Hashtable(20);
  /**
   * The singleton plug-in instance
   */
  private static JSchUIPlugin plugin;

  public JSchUIPlugin(){
    super();
    plugin=this;
  }

  /**
   * Returns the singleton plug-in instance.
   * 
   * @return the plugin instance
   */
  public static JSchUIPlugin getPlugin(){
    return plugin;
  }

  /**
   * Returns the image descriptor for the given image ID.
   * Returns null if there is no such image.
   */
  public static ImageDescriptor getImageDescriptor(String id){
    return (ImageDescriptor)imageDescriptors.get(id);
  }

  /**
   * Creates an image and places it in the image registry.
   */
  protected void createImageDescriptor(String id){
    URL url=FileLocator.find(JSchUIPlugin.getPlugin().getBundle(), new Path(
        IUIConstants.ICON_PATH+id), null);
    ImageDescriptor desc=ImageDescriptor.createFromURL(url);
    imageDescriptors.put(id, desc);
  }

  /**
   * Returns the standard display to be used. The method first checks, if
   * the thread calling this method has an associated display. If so, this
   * display is returned. Otherwise the method returns the default display.
   */
  public static Display getStandardDisplay(){
    Display display=Display.getCurrent();
    if(display==null){
      display=Display.getDefault();
    }
    return display;
  }

  /**
   * Convenience method to get an image descriptor for an extension
   * 
   * @param extension  the extension declaring the image
   * @param subdirectoryAndFilename  the path to the image
   * @return the image
   */
  public static ImageDescriptor getImageDescriptorFromExtension(IExtension extension, String subdirectoryAndFilename) {
    URL fullPathString = FileLocator.find(Platform.getBundle(extension.getNamespaceIdentifier()), new Path(subdirectoryAndFilename), null);
    return ImageDescriptor.createFromURL(fullPathString);
  }

  /**
   * Initializes the table of images used in this plugin.
   */
  private void initializeImages() {
    createImageDescriptor(IUIConstants.IMG_KEY_LOCK);
  }
  
  /**
   * @see Plugin#start(BundleContext)
   */
  public void start(BundleContext context) throws Exception {
    super.start(context);
    
    initializeImages();
/*
    IPreferenceStore store = getPreferenceStore();
    if (store.getBoolean(IUIConstants.PREF_FIRST_STARTUP)) {
      store.setValue(IUIConstants.PREF_FIRST_STARTUP, false);
    }
*/
  }
  
  /**
   * @see Plugin#stop(BundleContext)
   */
  public void stop(BundleContext context) throws Exception {
    try {

    } finally {
      super.stop(context);
    }
  }
  
  public IUserAuthenticator getUserAuthenticator(){
    return new WorkbenchUserAuthenticator();
  }

}
