#!/bin/bash

`dirname $0`/stop_mysql.sh

echo "Starting MySQL..."

ssh griddb1 sudo systemctl start mariadb

echo "CREATE TABLE METERS (
	id BIGINT NOT NULL,
	contact_name TEXT,
	email TEXT,
	number TEXT,
	description TEXT,
	address TEXT,
	city TEXT,
	state_province TEXT,
	last_reading DATETIME,
	latitude FLOAT,
	longitude FLOAT,
	PRIMARY KEY (id)
)" | ssh griddb1 mysql --user=root --password=testpw testdb

echo "CREATE TABLE METER_READS (
	timestamp DATETIME, 
	usage_since_read DOUBLE, 
	usage_this_hour DOUBLE, 
	usage_this_day DOUBLE, 
	usage_this_week DOUBLE,
	usage_this_month DOUBLE, 
	usage_this_year DOUBLE, 
	all_time_usage DOUBLE, 
	error_code_1 BIGINT, 
	error_code_2 BIGINT, 
	meter_id BIGINT NOT NULL,
	FOREIGN KEY (meter_id) REFERENCES METERS(id)
)" | ssh griddb1 mysql --user=root --password=testpw testdb

