package MeterBenchmark;
//import MeterBenchmark.Client;

import java.util.Calendar;
import java.util.Date;
import java.util.Random;

class Ingest implements Runnable {
	Client c;
    int id;
    int iterations;
    int interval;
    boolean nowait;
    //
    boolean finished = false;
    Date endTime;

    Calendar last_reading;
    //
    Date timestamp;
    double usage_since_read = 0;
    double usage_this_hour = 0;
    double usage_this_day = 0;
    double usage_this_week = 0;
    double usage_this_month = 0;
    double usage_this_year = 0;
    double all_time_usage = 0;
    double counter=0;
    long meter_id = 0;
    //

    public Ingest(Client client, int ident, int iter, int interv, boolean nwait) {
	c = client;
	id = ident;
	iterations = iter;
	interval = interv;
	nowait = nwait;
	if(nowait)
		timestamp  = new Date(118, 0, 1, 0, 0, 0);
	else
		timestamp = new Date();
    }
    
	public void updateAndWrite() {

		Date now;
		Random random = new Random();
		random.setSeed(meter_id + System.nanoTime() + (new Date()).getTime());
		double usage = 42;

		if(usage < 0 ) 
			usage = 0-usage;

		Calendar thisRead = Calendar.getInstance();
		Calendar lastRead = Calendar.getInstance();


		lastRead.setTime(timestamp);
		if(nowait) {
			timestamp = new Date(timestamp.getTime()+interval*1000);
			thisRead.setTime(timestamp);
		} else {
			now = new Date();
			thisRead.setTime(now);
		}

	    if(thisRead.get(Calendar.HOUR_OF_DAY) != lastRead.get(Calendar.HOUR_OF_DAY)) {
		    usage_this_hour = usage;
	    } else {
		    usage_this_hour += usage;
	    }
	    if(thisRead.get(Calendar.DAY_OF_YEAR) != lastRead.get(Calendar.DAY_OF_YEAR)) {
		    //daily = 0;
		    //lastDate = currentDay;
		    usage_this_day = usage;
	    } else {
		    usage_this_day += usage;
	    }
	    if((lastRead.get(Calendar.WEEK_OF_YEAR) != thisRead.get(Calendar.WEEK_OF_YEAR))) {
		    usage_this_week = usage;
	    } else {
		    usage_this_week += usage;
	    }
	    if((thisRead.get(Calendar.MONTH) - lastRead.get(Calendar.MONTH)) > 0) {
		    usage_this_month = usage;
	    } else {
		    usage_this_month += usage;
	    }
	    if((thisRead.get(Calendar.YEAR) - lastRead.get(Calendar.YEAR)) > 0) {
		    usage_this_year = usage;
	    } else {
		    usage_this_year += usage;
	    }

	    all_time_usage += usage;
	    usage_since_read = usage;


	    
	    last_reading = lastRead;

//	    if(counter++ % 100 == 0)
//		System.out.println(id +"@"+ timestamp+": "+usage_since_read + " " +  usage_this_hour + " " + usage_this_week  + " " + usage_this_month +" "+ usage_this_year + " " + all_time_usage);

	    c.writeUsage(timestamp, usage_since_read, usage_this_hour, usage_this_day, usage_this_week, usage_this_month, usage_this_year, all_time_usage, id);
    }
    
    public void run() {
	counter=0;
    	for(int i = 0; i < iterations; i++) {
    		updateAndWrite();
    		if(!nowait) {
	    		try {
					Thread.sleep((interval * 1000));
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
    		}
    	}
    	endTime = new Date();
    	finished = true;
    	//c.write();
    }

}